/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.exitpoint;

import com.goide.GoTypes;
import com.goide.highlighting.exitpoint.GoBreakAndContinueStatementsExitPointHandler;
import com.goide.highlighting.exitpoint.GoFunctionExitPointHandler;
import com.goide.highlighting.exitpoint.GoReturnParametersHandler;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoHighlightExitPointsHandlerFactory
implements HighlightUsagesHandlerFactory {
    private static final TokenSet BREAK_HIGHLIGHTING_TOKENS = TokenSet.create((IElementType[])new IElementType[]{GoTypes.CONTINUE, GoTypes.BREAK, GoTypes.SWITCH, GoTypes.FOR, GoTypes.SELECT});

    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiElement target;
        if (editor == null) {
            GoHighlightExitPointsHandlerFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoHighlightExitPointsHandlerFactory.$$$reportNull$$$0(1);
        }
        if ((target = file.findElementAt(offset = GoHighlightExitPointsHandlerFactory.adjustOffset(editor.getDocument(), editor.getCaretModel().getOffset()))) == null) {
            return null;
        }
        return GoHighlightExitPointsHandlerFactory.createHighlightUsagesHandler(editor, file, target);
    }

    private static int adjustOffset(Document document, int offset) {
        CharSequence text = document.getCharsSequence();
        int correctedOffset = offset;
        int textLength = document.getTextLength();
        if (offset >= textLength) {
            correctedOffset = textLength - 1;
        } else if (!GoHighlightExitPointsHandlerFactory.isIdentifierPart(text, offset)) {
            --correctedOffset;
        }
        if (correctedOffset < 0 || !GoHighlightExitPointsHandlerFactory.isIdentifierPart(text, correctedOffset)) {
            return offset;
        }
        return correctedOffset;
    }

    private static boolean isIdentifierPart(CharSequence text, int offset) {
        char ch = text.charAt(offset);
        return Character.isJavaIdentifierPart(ch) || ch == '\"' || ch == '`' || ch == '\'';
    }

    @Nullable
    private static HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        if (editor == null) {
            GoHighlightExitPointsHandlerFactory.$$$reportNull$$$0(2);
        }
        if (file == null) {
            GoHighlightExitPointsHandlerFactory.$$$reportNull$$$0(3);
        }
        if (target == null) {
            GoHighlightExitPointsHandlerFactory.$$$reportNull$$$0(4);
        }
        if (target instanceof LeafPsiElement) {
            IElementType elementType = ((LeafPsiElement)target).getElementType();
            if (elementType == GoTypes.RETURN || elementType == GoTypes.FUNC || GoHighlightExitPointsHandlerFactory.isPanicCall(target)) {
                return GoFunctionExitPointHandler.createForElement(editor, file, target);
            }
            if (BREAK_HIGHLIGHTING_TOKENS.contains(elementType)) {
                return GoBreakAndContinueStatementsExitPointHandler.createForElement(editor, file, target);
            }
            return GoReturnParametersHandler.createForElement(editor, file, target);
        }
        return null;
    }

    private static boolean isPanicCall(@NotNull PsiElement e) {
        PsiElement grandPa;
        PsiElement parent;
        if (e == null) {
            GoHighlightExitPointsHandlerFactory.$$$reportNull$$$0(5);
        }
        if ((parent = e.getParent()) instanceof GoReferenceExpression && (grandPa = parent.getParent()) instanceof GoCallExpr) {
            return GoPsiImplUtil.isPanic((GoCallExpr)grandPa);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/exitpoint/GoHighlightExitPointsHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightUsagesHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isPanicCall";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

