/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.GoAnnotationHolderAdapter;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.legacyErrorInspections.GoDuplicateInspection;
import com.goide.highlighting.legacyErrorInspections.GoRecursiveTypeInspection;
import com.goide.highlighting.legacyErrorInspections.GoTypeCheckingUtil;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoFile;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.generics.GoGenericsUtilKt;
import com.goide.psi.impl.generics.GoTypeSet;
import com.goide.psi.impl.generics.GoTypeSetKt;
import com.goide.quickfix.GoDeleteQuickFix;
import com.goide.sdk.GoSdkService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoInterfaceTypeSpecChecker
extends GoSpecCheckerBase {
    private static final int CONSTRAINT_ELEMENT_DISPLAY_LIMIT = 3;

    public GoInterfaceTypeSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitGoFile(@NotNull GoFile file) {
        if (file == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(1);
        }
        if (GoSdkService.getInstance(file.getProject()).getSdk(null).reportsAnonymousInterfaceCycles()) {
            Collection interfaces = PsiTreeUtil.collectElementsOfType((PsiElement)file, (Class[])new Class[]{GoInterfaceType.class});
            for (GoInterfaceType interfaceType : interfaces) {
                this.checkCyclicReferences(interfaceType);
            }
        }
    }

    @Override
    public void visitInterfaceType(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(2);
        }
        this.checkMethods(interfaceType);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(interfaceType);
        GoDuplicateInspection.processDuplicates(interfaceType, new GoDuplicatesSearch.InterfaceScopeSearch(), new GoAnnotationHolderAdapter(this.myHolder), context);
        if (!GoInterfaceTypeSpecChecker.isTypeConstraintAllowedHere(interfaceType, context)) {
            this.checkIsNotConstraint(interfaceType, interfaceType, context);
        }
    }

    private void checkMethods(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(3);
        }
        for (GoMethodSpec method : interfaceType.getMethodSpecList()) {
            GoSignature signature;
            GoTypeParameters typeParams;
            GoInspectionMessageWithI18n message;
            GoTypeReferenceExpression embedded = method.getTypeReferenceExpression();
            if (embedded != null) {
                if (!(embedded.resolve() instanceof GoTypeParamDefinition)) continue;
                message = GoInspectionMessageWithI18n.message("go.error.annotator.cannot.embed.type.parameter");
                this.myHolder.newErrorAnnotation(embedded, (GoInspectionMessage)message).create();
                continue;
            }
            if (method.isBlank()) {
                message = GoInspectionMessageWithI18n.message("go.error.annotator.method.name.in.interface.cannot.be.blank");
                this.myHolder.newErrorAnnotation(Objects.requireNonNull(method.getIdentifier()), (GoInspectionMessage)message).create();
            }
            if ((typeParams = (signature = method.getSignature()) != null ? signature.getTypeParameters() : null) == null) continue;
            GoInspectionMessageWithI18n message2 = GoInspectionMessageWithI18n.message("go.error.annotator.interface.method.must.have.no.type.parameters");
            GoInterfaceTypeSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(typeParams, (GoInspectionMessage)message2), GoDeleteQuickFix.Fixes.DELETE_TYPE_PARAMETERS_FIX, typeParams, message2).create();
        }
    }

    @Override
    public void visitTypeSpec(@NotNull GoTypeSpec interfaceTypeSpec) {
        GoType type;
        if (interfaceTypeSpec == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(4);
        }
        if ((type = interfaceTypeSpec.getSpecType().getType()) instanceof GoInterfaceType) {
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(interfaceTypeSpec);
            GoRecursiveTypeInspection.checkHasRecursiveReference(interfaceTypeSpec, new GoAnnotationHolderAdapter(this.myHolder), context);
        }
    }

    @Override
    public void visitTypeReferenceExpression(@NotNull GoTypeReferenceExpression ref) {
        if (ref == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(5);
        }
        super.visitTypeReferenceExpression(ref);
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(ref);
        this.checkIsNotConstraint(ref, context);
    }

    @Override
    public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr o) {
        if (o == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(6);
        }
        super.visitIndexOrSliceExpr(o);
        PsiElement typeArgument = GoPsiUtil.getTypeArgument(o);
        if (typeArgument instanceof GoReferenceExpression) {
            GoReferenceExpression ref = (GoReferenceExpression)typeArgument;
            PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(ref);
            this.checkIsNotConstraint(ref, context);
        }
    }

    private void checkIsNotConstraint(@NotNull GoResolvable ref, @NotNull PsiElement context) {
        ResolveState state;
        GoType underlyingType;
        PsiElement parent;
        if (ref == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(8);
        }
        if ((parent = ref.getParent()) instanceof GoMethodSpec || parent instanceof GoType && GoInterfaceTypeSpecChecker.isTypeConstraintAllowedHere((GoType)parent, context)) {
            return;
        }
        PsiElement type = ref.resolve();
        if (type instanceof GoTypeSpec && (underlyingType = ((GoTypeSpec)type).getGoUnderlyingType(state = GoPsiImplUtil.createContextOnElement(context))) != null) {
            this.checkIsNotConstraint(ref, underlyingType, context);
        }
    }

    private void checkIsNotConstraint(@NotNull PsiElement elementToReport, @NotNull GoType underlyingType, @NotNull PsiElement context) {
        if (elementToReport == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(9);
        }
        if (underlyingType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(11);
        }
        if (GoInterfaceTypeSpecChecker.isConstraint(underlyingType, context)) {
            this.myHolder.newErrorAnnotation(elementToReport, (GoInspectionMessage)GoInterfaceTypeSpecChecker.getConstraintUsedAsNormalInterfaceErrorMessage(underlyingType, context)).create();
        }
    }

    private static boolean isTypeConstraintAllowedHere(@NotNull GoType type, PsiElement context) {
        PsiElement parent;
        if (type == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(12);
        }
        return (parent = type.getParent()) instanceof GoSpecType || parent instanceof GoMethodSpec || parent instanceof GoConstraintTerm || GoTypeUtil.isTypeParameter(type, context);
    }

    private void checkCyclicReferences(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(13);
        }
        if (interfaceType.isAnonymous()) {
            return;
        }
        GoSpecType interfaceSpecType = interfaceType.getSpecType();
        if (interfaceSpecType == null) {
            return;
        }
        for (PsiElement child : SequencesKt.asIterable(GoGenericsUtilKt.traverseSafe(interfaceSpecType))) {
            GoInterfaceType childInterfaceType;
            if (!(child instanceof GoInterfaceType) || !(childInterfaceType = (GoInterfaceType)child).isAnonymous()) continue;
            this.checkReferencedInType(interfaceSpecType, childInterfaceType);
        }
    }

    private void checkReferencedInType(@NotNull GoSpecType interfaceSpecType, @Nullable GoType otherType) {
        if (interfaceSpecType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(14);
        }
        if (otherType == null) {
            return;
        }
        if ((otherType = GoTypeUtil.unwrapAlias(otherType, interfaceSpecType)) instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)otherType;
            otherType = specType.getType();
        }
        if (otherType instanceof GoInterfaceType) {
            GoInterfaceType otherInterfaceType = (GoInterfaceType)otherType;
            List<GoTypeReferenceExpression> baseTypesReferences = otherInterfaceType.getBaseTypesReferences();
            for (GoTypeReferenceExpression baseTypeReference : baseTypesReferences) {
                PsiElement resolve = baseTypeReference.resolve();
                if (!(resolve instanceof GoTypeSpec)) continue;
                GoTypeSpec baseTypeSpec = (GoTypeSpec)resolve;
                GoSpecType baseSpecType = baseTypeSpec.getSpecType();
                if (GoTypeUtil.equalTypes(interfaceSpecType, baseSpecType, interfaceSpecType, true)) {
                    this.myHolder.newErrorAnnotation(otherType, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.anonymous.interface.cycle")).create();
                    return;
                }
                RecursionManager.doPreventingRecursion((Object)Pair.create((Object)interfaceSpecType, (Object)baseSpecType), (boolean)false, () -> {
                    GoType baseType = baseSpecType.getType();
                    if (baseType != null) {
                        this.checkReferencedInType(interfaceSpecType, baseType);
                    }
                    return null;
                });
            }
        }
    }

    @NotNull
    private static GoInspectionMessageWithI18n getConstraintUsedAsNormalInterfaceErrorMessage(@NotNull GoType type, @NotNull PsiElement context) {
        GoTypeSet typeSet;
        if (type == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(16);
        }
        if ((typeSet = GoTypeSetKt.computeTypeSet(type, GoPsiImplUtil.createContextOnElement(context))) == GoTypeSet.Comparable.INSTANCE) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.comparable.outside.of.type.parameter");
            if (goInspectionMessageWithI18n == null) {
                GoInterfaceTypeSpecChecker.$$$reportNull$$$0(17);
            }
            return goInspectionMessageWithI18n;
        }
        if (!(typeSet instanceof GoTypeSet.Terms)) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.constraint.outside.of.type.parameter");
            if (goInspectionMessageWithI18n == null) {
                GoInterfaceTypeSpecChecker.$$$reportNull$$$0(18);
            }
            return goInspectionMessageWithI18n;
        }
        GoTypeSet.Terms terms = (GoTypeSet.Terms)typeSet;
        List constraintElements = StreamEx.of(terms.getTerms()).map(term -> (StubBasedPsiElement)ObjectUtils.chooseNotNull((Object)term.getConstraintTerm(), (Object)term.getTypeReferenceExpression())).nonNull().toImmutableList();
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = constraintElements.isEmpty() ? GoInspectionMessageWithI18n.message("go.error.annotator.constraint.outside.of.type.parameter") : GoInspectionMessageWithI18n.message("go.error.annotator.constraint.elements.outside.of.type.parameter", constraintElements.size(), GoTypeCheckingUtil.joinShortened(constraintElements, GoSpecCheckerBase::code, ", ", 3));
        if (goInspectionMessageWithI18n == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(19);
        }
        return goInspectionMessageWithI18n;
    }

    private static boolean isConstraint(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(20);
        }
        return GoTypeUtil.findFirstMatchedInterfaceDfs(type, t -> !GoTypeUtil.isBasicInterface(t, context)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceTypeSpec";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReport";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceSpecType";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/errors/GoInterfaceTypeSpecChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/errors/GoInterfaceTypeSpecChecker";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintUsedAsNormalInterfaceErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitGoFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitInterfaceType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkMethods";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeSpec";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeReferenceExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitIndexOrSliceExpr";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkIsNotConstraint";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isTypeConstraintAllowedHere";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkCyclicReferences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkReferencedInType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getConstraintUsedAsNormalInterfaceErrorMessage";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isConstraint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19 -> new IllegalStateException(string);
        };
    }
}

