/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoExpressionStatementSpecChecker;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.GoDeferGoInspection;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoStatement;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoUnwrapParensQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationBuilder;
import org.jetbrains.annotations.NotNull;

public class GoDeferGoStatementSpecChecker
extends GoSpecCheckerBase {
    public GoDeferGoStatementSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoDeferGoStatementSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitGoStatement(@NotNull GoGoStatement o) {
        if (o == null) {
            GoDeferGoStatementSpecChecker.$$$reportNull$$$0(1);
        }
        this.check(o);
    }

    @Override
    public void visitDeferStatement(@NotNull GoDeferStatement o) {
        if (o == null) {
            GoDeferGoStatementSpecChecker.$$$reportNull$$$0(2);
        }
        this.check(o);
    }

    private void check(@NotNull GoStatement statement) {
        GoExpression expression;
        if (statement == null) {
            GoDeferGoStatementSpecChecker.$$$reportNull$$$0(3);
        }
        assert (statement instanceof GoGoStatement || statement instanceof GoDeferStatement);
        String statementType = statement instanceof GoGoStatement ? "go" : "defer";
        GoExpression goExpression = expression = statement instanceof GoGoStatement ? ((GoGoStatement)statement).getExpression() : ((GoDeferStatement)statement).getExpression();
        if (expression == null) {
            return;
        }
        if (expression instanceof GoCallExpr || expression instanceof GoBuiltinCallExpr) {
            if (GoPsiUtil.isConversionExpression(expression)) {
                this.myHolder.newErrorAnnotation(expression, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.conversion.in.defer.or.go", statementType)).create();
            } else if (!GoExpressionStatementSpecChecker.isPermittedAsStatement(expression)) {
                this.myHolder.newErrorAnnotation(expression, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.function.not.permitted.in.defer.or.go", statementType)).create();
            }
            return;
        }
        if (expression instanceof GoParenthesesExpr) {
            this.myHolder.newErrorAnnotation(expression, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.parenthesized.expression.in.defer.or.go", statementType)).withFix((IntentionAction)new GoUnwrapParensQuickFix(expression)).create();
        }
        GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.defer.or.go.requires.function.call", statementType);
        AnnotationBuilder annotation = this.myHolder.newErrorAnnotation(expression, (GoInspectionMessage)message);
        if (expression.getGoType(null) instanceof GoFunctionType) {
            annotation = GoDeferGoStatementSpecChecker.withQuickFix(annotation, new GoDeferGoInspection.GoAddParensQuickFix(), expression, message);
        }
        annotation.create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoDeferGoStatementSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitGoStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDeferStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

