/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.errors.GoSpecCheckerUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoAssignOp;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import org.jetbrains.annotations.NotNull;

public class GoAssignmentStatementSpecChecker
extends GoSpecCheckerBase {
    public GoAssignmentStatementSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoAssignmentStatementSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitAssignmentStatement(@NotNull GoAssignmentStatement assignmentStatement) {
        if (assignmentStatement == null) {
            GoAssignmentStatementSpecChecker.$$$reportNull$$$0(1);
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(assignmentStatement);
        if (!GoSpecCheckerUtil.checkLeftHandSideOfAssignment(assignmentStatement.getLeftHandExprList().getExpressionList(), this.myHolder, context)) {
            return;
        }
        if (!this.checkAssignOperation(assignmentStatement)) {
            return;
        }
        ResolveState state = GoPsiImplUtil.createContextOnElement(context);
        GoSpecCheckerUtil.checkAssignmentCountMismatch(assignmentStatement, assignmentStatement.getLeftHandExprList().getExpressionList(), assignmentStatement.getExpressionList(), this.myHolder, state);
    }

    private boolean checkAssignOperation(@NotNull GoAssignmentStatement assignmentStatement) {
        GoAssignOp assignOp;
        if (assignmentStatement == null) {
            GoAssignmentStatementSpecChecker.$$$reportNull$$$0(2);
        }
        if ((assignOp = assignmentStatement.getAssignOp()).getAssign() == null && assignmentStatement.getLeftHandExprList().getExpressionList().size() > 1) {
            this.myHolder.newErrorAnnotation(assignOp, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.unexpected.assign.operator", assignOp.getText())).create();
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoAssignmentStatementSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

