/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter.service;

import com.goide.GoFileType;
import com.goide.GoNotifications;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.goide.util.GoUtil;
import com.intellij.application.options.CodeStyle;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoFmtFormattingService
extends AsyncDocumentFormattingService {
    private static final Logger LOG = Logger.getInstance(GoFmtFormattingService.class);
    @NlsSafe
    private static final String GO_FMT = "Go fmt";
    public static final String GOFMT_EXECUTABLE_NAME = "gofmt";
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.noneOf(FormattingService.Feature.class);

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(final @NotNull AsyncFormattingRequest request) {
        ProgressIndicatorBase indicator;
        Task.Backgroundable task2;
        if (request == null) {
            GoFmtFormattingService.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        FormattingContext context = request.getContext();
        PsiFile file = context.getContainingFile();
        if (!((GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, GoCodeStyleSettings.class)).RUN_GO_FMT_ON_REFORMAT) {
            return null;
        }
        final VirtualFile virtualFile = file.getVirtualFile();
        VirtualFile directory = (VirtualFile)ObjectUtils.doIfNotNull((Object)virtualFile, VirtualFile::getParent);
        Project project = context.getProject();
        Module module = GoUtil.module((PsiElement)file);
        if (directory == null) {
            return null;
        }
        String gofmt = GoFmtFormattingService.getExePath(project, module);
        if (gofmt == null) {
            LOG.info("Skipped gofmt as Go SDK isn't configured or doesn't contain the binary");
            return null;
        }
        final String documentText = request.getDocumentText();
        GoHistoryProcessListener output2 = new GoHistoryProcessListener();
        GoExecutor executor = GoExecutor.in(project, module).withPtyEnabled(false).withExePath(GoCommandLineParameter.path(gofmt)).withWorkDirectory(GoCommandLineParameter.path(directory.getPath())).withPresentableName(GO_FMT).withProcessListener((ProcessListener)output2).withProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProcessHandler processHandler = event.getProcessHandler();
                try (OutputStream os = processHandler.getProcessInput();){
                    if (os == null) {
                        LOG.warn("Couldn't start gofmt");
                        return;
                    }
                    byte[] text = documentText.getBytes(StandardCharsets.UTF_8);
                    new ByteArrayInputStream(text).transferTo(os);
                }
                catch (IOException e) {
                    String fileName = virtualFile.getName();
                    request.onError(GoBundle.message((String)"go.fmt.formatting.service.error.title", (Object[])new Object[]{fileName}), e.getLocalizedMessage());
                    LOG.warn("Can't copy document to gofmt", (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/formatter/service/GoFmtFormattingService$1", "startNotified"));
            }
        });
        if (ScratchUtil.isScratch((VirtualFile)virtualFile)) {
            executor.withExtraEnvironment(Collections.singletonMap("GO111MODULE", "off"));
        }
        return (task2 = executor.createTask(true, false, null, null, (ProgressIndicatorEx)(indicator = new ProgressIndicatorBase()), result -> {
            if (indicator.isCanceled()) {
                return;
            }
            if (result.status == GoExecutor.ExecutionResult.Status.SUCCEEDED) {
                String goFmtText = StringUtil.join(output2.getStdout(), (String)"");
                request.onTextReady(goFmtText);
                request.getContext();
            } else if (result.status != GoExecutor.ExecutionResult.Status.CANCELLED) {
                String fileName = virtualFile.getName();
                List<String> stderr = output2.getStderr();
                String cause = StringUtil.escapeXmlEntities((String)StringUtil.notNullize((String)StringUtil.trim((String)((String)ContainerUtil.getFirstItem(stderr)))));
                request.onError(GoBundle.message((String)"go.fmt.formatting.service.error.title", (Object[])new Object[]{fileName}), StringUtil.notNullize((String)result.message, (String)cause));
                LOG.warn("Failed to run gofmt on " + virtualFile.getPath());
                LOG.warn(StringUtil.join(stderr, (String)"").trim());
            }
        })) == null ? null : new AsyncDocumentFormattingService.FormattingTask(){

            public void run() {
                ProgressManagerImpl progressManager = (ProgressManagerImpl)ProgressManager.getInstance();
                ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
                ModalityState modalityState = progressIndicator != null ? progressIndicator.getModalityState() : ModalityState.defaultModalityState();
                progressManager.runProcessWithProgressInCurrentThread((Task)task2, (ProgressIndicator)new EmptyProgressIndicator(modalityState), modalityState);
            }

            public boolean cancel() {
                indicator.cancel();
                return true;
            }

            public boolean isRunUnderProgress() {
                return true;
            }
        };
    }

    @Nullable
    private static String getExePath(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoFmtFormattingService.$$$reportNull$$$0(1);
        }
        String goRoot = VfsUtilCore.urlToPath((String)GoSdkService.getInstance(project).getSdk(module).getHomeUrl());
        VirtualFile executable = GoSdkUtil.getSdkExecutable(LocalFileSystem.getInstance().findFileByPath(goRoot), GOFMT_EXECUTABLE_NAME);
        return executable != null ? executable.getPath() : null;
    }

    public static boolean conflictWithGoFmt(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            GoFmtFormattingService.$$$reportNull$$$0(2);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = codeStyleSettings.getIndentOptions((FileType)GoFileType.INSTANCE);
        GoCodeStyleSettings settings = (GoCodeStyleSettings)codeStyleSettings.getCustomSettings(GoCodeStyleSettings.class);
        return !indentOptions.USE_TAB_CHARACTER || indentOptions.KEEP_INDENTS_ON_EMPTY_LINES || settings.USE_BACK_QUOTES_FOR_IMPORTS || settings.IMPORT_SORTING == GoCodeStyleSettings.ImportSorting.NONE;
    }

    @NotNull
    protected String getNotificationGroupId() {
        String string = GoNotifications.getToolsIntegrationGroup().getDisplayId();
        if (string == null) {
            GoFmtFormattingService.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected String getName() {
        return GO_FMT;
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set = FEATURES;
        if (set == null) {
            GoFmtFormattingService.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean canFormat(@NotNull PsiFile file) {
        if (file == null) {
            GoFmtFormattingService.$$$reportNull$$$0(5);
        }
        return file instanceof GoFile;
    }

    @Nullable
    public Class<? extends FormattingService> runAfter() {
        return CoreFormattingService.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/service/GoFmtFormattingService";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/service/GoFmtFormattingService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroupId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingTask";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getExePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "conflictWithGoFmt";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

