/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.formatter.GoFormattingRules;
import org.jetbrains.annotations.NotNull;

abstract class LengthThreshold {
    LengthThreshold() {
    }

    abstract void reset();

    abstract void addLength(int var1);

    abstract boolean isBigLengthChange(int var1, int var2);

    @NotNull
    static LengthThreshold create(@NotNull GoFormattingRules rules) {
        if (rules == null) {
            LengthThreshold.$$$reportNull$$$0(0);
        }
        return rules.useGeoMeanLengthThreshold() ? new GeoMeanThreshold() : new RatioThreshold();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rules", "com/goide/formatter/LengthThreshold", "create"));
    }

    private static class GeoMeanThreshold
    extends LengthThreshold {
        private static final int SMALL = 40;
        private static final double THRESHOLD = 2.5;
        private double myLnSum;
        private int myCount;

        private GeoMeanThreshold() {
        }

        @Override
        public void reset() {
            this.myLnSum = 0.0;
            this.myCount = 0;
        }

        @Override
        public void addLength(int length) {
            this.myLnSum += Math.log(length);
            ++this.myCount;
        }

        @Override
        public boolean isBigLengthChange(int prevLength, int length) {
            if (this.myCount == 0 || prevLength <= 40 && length <= 40) {
                return false;
            }
            double geoMean = Math.exp(this.myLnSum / (double)this.myCount);
            double ratio = (double)length / geoMean;
            return 2.5 * ratio <= 1.0 || 2.5 <= ratio;
        }
    }

    private static class RatioThreshold
    extends LengthThreshold {
        private static final int SMALL = 20;
        private static final double THRESHOLD = 4.0;

        private RatioThreshold() {
        }

        @Override
        public boolean isBigLengthChange(int prevLength, int curLen) {
            if (prevLength <= 20 && curLen <= 20) {
                return false;
            }
            double ratio = (double)prevLength / (double)curLen;
            return ratio <= 0.25 || 4.0 <= ratio;
        }

        @Override
        public void reset() {
        }

        @Override
        public void addLength(int length) {
        }
    }
}

