/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.formatter.GoFormatterUtil;
import com.goide.formatter.GoFormattingRules;
import com.intellij.formatting.Alignment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoRowBlock {
    private final GoFormattingRules myRules;
    private final List<Row> myRows;
    private final Map<PsiElement, Row> myElementRows;
    private final List<Alignment> myBorders;
    private int myCellIndex;
    private int myMaxCellCount;

    GoRowBlock(@NotNull GoFormattingRules rules) {
        if (rules == null) {
            GoRowBlock.$$$reportNull$$$0(0);
        }
        this.myRows = new ArrayList<Row>();
        this.myElementRows = new HashMap<PsiElement, Row>();
        this.myBorders = new ArrayList<Alignment>();
        this.myCellIndex = -1;
        this.myMaxCellCount = 0;
        this.myRules = rules;
    }

    void startNewRow(@NotNull PsiElement element) {
        if (element == null) {
            GoRowBlock.$$$reportNull$$$0(1);
        }
        this.resetSubsequentColumns(this.myCellIndex);
        Row row = new Row();
        this.myElementRows.put(element, row);
        this.myRows.add(row);
        this.myCellIndex = -1;
    }

    void startCell(@Nullable PsiElement firstCellElement) {
        this.startCell(firstCellElement, firstCellElement);
    }

    void startCell(@Nullable PsiElement firstCellElement, @Nullable PsiElement lastElement) {
        if (firstCellElement == null && lastElement != null) {
            throw new IllegalArgumentException();
        }
        Row row = (Row)ContainerUtil.getLastItem(this.myRows);
        Cell cell = new Cell();
        cell.firstElement = firstCellElement;
        cell.lastElement = lastElement;
        if (this.myCellIndex >= 0) {
            Cell previousCell = row.cells.get(this.myCellIndex);
            previousCell.rightBorder = this.getNextBorder();
        }
        row.cells.add(cell);
        this.myMaxCellCount = Math.max(this.myMaxCellCount, row.cells.size());
        ++this.myCellIndex;
        this.resetColumnsIfMultiline(row, this.myCellIndex);
    }

    void setComment(@NotNull PsiComment comment) {
        if (comment == null) {
            GoRowBlock.$$$reportNull$$$0(2);
        }
        if (this.myCellIndex < 0) {
            throw new IllegalStateException("Cell is not started");
        }
        Row row = (Row)ContainerUtil.getLastItem(this.myRows);
        Cell cell = row.cells.get(this.myCellIndex);
        if (cell.firstElement == null) {
            cell.firstElement = comment;
            this.resetColumnsIfMultiline(row, this.myCellIndex);
        } else {
            this.startCell((PsiElement)comment);
        }
    }

    @Nullable
    Row getRow(@NotNull PsiElement element) {
        if (element == null) {
            GoRowBlock.$$$reportNull$$$0(3);
        }
        return this.myElementRows.get(element);
    }

    void resetColumns() {
        this.myBorders.clear();
    }

    private void resetSubsequentColumns(int startIndex) {
        if (startIndex >= 0) {
            this.myBorders.subList(startIndex, this.myBorders.size()).clear();
        }
    }

    void collapseEmptyColumns() {
        for (int cellIndex = 0; cellIndex < this.myMaxCellCount; ++cellIndex) {
            int rowIndex = 0;
            while (rowIndex < this.myRows.size()) {
                Alignment border;
                Row row = this.myRows.get(rowIndex);
                Cell cell = (Cell)ContainerUtil.getOrElse(row.cells, (int)cellIndex, null);
                Alignment alignment = border = cell != null ? cell.rightBorder : null;
                if (cell != null && border != null) {
                    int columnEnd;
                    boolean canBeCollapsed = cell.firstElement == null;
                    int columnStart = rowIndex;
                    for (columnEnd = rowIndex + 1; columnEnd < this.myRows.size(); ++columnEnd) {
                        Row nextRow = this.myRows.get(columnEnd);
                        Cell nextCell = (Cell)ContainerUtil.getOrElse(nextRow.cells, (int)cellIndex, null);
                        if (nextCell == null || nextCell.rightBorder != border) break;
                        canBeCollapsed &= nextCell.firstElement == null;
                    }
                    if (canBeCollapsed) {
                        this.collapseColumn(columnStart, columnEnd, cellIndex);
                        continue;
                    }
                    rowIndex = columnEnd;
                    continue;
                }
                ++rowIndex;
            }
        }
    }

    private void collapseColumn(int columnStartRow, int columnEndRow, int cellIndex) {
        for (int i = columnStartRow; i < columnEndRow; ++i) {
            GoRowBlock.collapseCell(this.myRows.get(i), cellIndex);
        }
    }

    private static void collapseCell(@NotNull Row row, int cellIndex) {
        if (row == null) {
            GoRowBlock.$$$reportNull$$$0(4);
        }
        for (int i = cellIndex; i < row.cells.size() - 1; ++i) {
            Cell cell = row.cells.get(i);
            Cell nextCell = row.cells.get(i + 1);
            cell.firstElement = nextCell.firstElement;
        }
        row.cells.remove(row.cells.size() - 1);
        row.cells.get((int)(row.cells.size() - 1)).rightBorder = null;
    }

    private void resetColumnsIfMultiline(@NotNull Row row, int cellIndex) {
        PsiElement last;
        PsiElement prev;
        int prevCellIdx;
        if (row == null) {
            GoRowBlock.$$$reportNull$$$0(5);
        }
        if ((prevCellIdx = row.findLastNonEmptyCellBefore(cellIndex)) >= 0 && this.hasNewlines(prev = row.cells.get((int)prevCellIdx).firstElement, last = row.cells.get((int)cellIndex).firstElement)) {
            this.resetSubsequentColumns(prevCellIdx);
            for (int i = prevCellIdx; i < row.cells.size(); ++i) {
                row.cells.get((int)i).rightBorder = this.getNextBorder();
            }
        }
    }

    private boolean hasNewlines(@Nullable PsiElement prev, @Nullable PsiElement next) {
        if (prev == null || next == null) {
            return false;
        }
        for (PsiElement element = prev; element != null && element != next; element = element.getNextSibling()) {
            if (!GoFormatterUtil.isMultiline(element, this.myRules)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private Alignment getNextBorder() {
        if (this.myCellIndex < this.myBorders.size()) {
            Alignment alignment = this.myBorders.get(this.myCellIndex);
            if (alignment == null) {
                GoRowBlock.$$$reportNull$$$0(6);
            }
            return alignment;
        }
        Alignment border = Alignment.createAlignment((boolean)true);
        this.myBorders.add(border);
        Alignment alignment = border;
        if (alignment == null) {
            GoRowBlock.$$$reportNull$$$0(7);
        }
        return alignment;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoRowBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoRowBlock";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startNewRow";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setComment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collapseCell";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resetColumnsIfMultiline";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }

    static class Row {
        private final List<Cell> cells = new ArrayList<Cell>();

        Row() {
        }

        int getColumn(@NotNull PsiElement firstCellElement) {
            if (firstCellElement == null) {
                Row.$$$reportNull$$$0(0);
            }
            for (int i = 0; i < this.cells.size(); ++i) {
                if (this.cells.get((int)i).firstElement != firstCellElement) continue;
                return i;
            }
            throw new IllegalArgumentException("Cannot find column for " + firstCellElement);
        }

        Alignment getAlignment(int column) {
            return column > 0 ? this.cells.get((int)(column - 1)).rightBorder : null;
        }

        @Nullable
        PsiElement findLastElementBefore(int column) {
            for (int i = column - 1; i >= 0; --i) {
                Cell cell = this.cells.get(i);
                if (cell.lastElement != null) {
                    return cell.lastElement;
                }
                if (cell.firstElement == null) continue;
                return cell.firstElement;
            }
            return null;
        }

        private int findLastNonEmptyCellBefore(int cellIndex) {
            for (int i = cellIndex - 1; i >= 0; --i) {
                if (this.cells.get((int)i).firstElement == null) continue;
                return i;
            }
            return -1;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (Cell cell : this.cells) {
                result.append(cell.toString());
                result.append(" ");
            }
            return result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "firstCellElement", "com/goide/formatter/GoRowBlock$Row", "getColumn"));
        }
    }

    private static class Cell {
        private PsiElement firstElement;
        private PsiElement lastElement;
        private Alignment rightBorder;

        private Cell() {
        }

        public String toString() {
            Object contentStr = "null";
            if (this.firstElement != null) {
                contentStr = this.firstElement.getText();
                if (this.lastElement != null) {
                    contentStr = (String)contentStr + "..." + this.lastElement.getText();
                }
            }
            return (String)contentStr + (String)(this.rightBorder != null ? " [" + this.rightBorder + "]" : "");
        }
    }
}

