/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.GoTypes;
import com.goide.formatter.GoFormatterUtil;
import com.goide.formatter.GoFormattingBlock;
import com.goide.formatter.GoFormattingRules;
import com.goide.formatter.GoRowBlock;
import com.goide.formatter.LengthThreshold;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoElement;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoKey;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoTag;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstSpec;
import com.intellij.formatting.Alignment;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoChildrenAlignment {
    private static final TokenSet LEFT_BRACES_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GoTypes.LBRACE, GoTypes.LBRACK, GoTypes.LPAREN});

    GoChildrenAlignment() {
    }

    @Nullable
    public Alignment getAlignment(@NotNull PsiElement e) {
        if (e == null) {
            GoChildrenAlignment.$$$reportNull$$$0(0);
        }
        return null;
    }

    @Nullable
    public Alignment getVoidBlockAlignmentBefore(@NotNull PsiElement element) {
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public Alignment getVoidBlockAlignmentAfter(@NotNull PsiElement element) {
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(2);
        }
        return null;
    }

    @NotNull
    public static GoChildrenAlignment buildCommentAlignment(@NotNull GoFormattingBlock parentBlock, @NotNull PsiElement element, @NotNull GoFormattingRules formattingRules, @NotNull Map<PsiElement, GoChildrenAlignment> childrenAlignmentMap) {
        PsiComment[] comments;
        if (parentBlock == null) {
            GoChildrenAlignment.$$$reportNull$$$0(3);
        }
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(4);
        }
        if (formattingRules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(5);
        }
        if (childrenAlignmentMap == null) {
            GoChildrenAlignment.$$$reportNull$$$0(6);
        }
        if ((comments = (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)element, PsiComment.class)) == null || comments.length == 0) {
            return new GoChildrenAlignment();
        }
        if (element instanceof GoLiteralValue) {
            return GoChildrenAlignment.buildLiteralCommentAlignment(element, parentBlock, comments, formattingRules);
        }
        if (element instanceof GoFieldDeclaration) {
            return new GoChildrenAlignment();
        }
        GoCommentsAlignment result = new GoCommentsAlignment(formattingRules);
        Alignment alignment = null;
        PsiComment prev = null;
        boolean prevAfterBlockRBrace = false;
        for (PsiComment c : comments) {
            if (GoFormatterUtil.isFirstElementOnLine((PsiElement)c)) {
                prev = null;
                continue;
            }
            boolean afterBlockRBRace = GoChildrenAlignment.isAfterBlockStatementRBrace((PsiElement)c);
            if (prevAfterBlockRBrace || afterBlockRBRace || GoFormatterUtil.isFirstElementOnLine(prev) || GoChildrenAlignment.leafsSeparatedWithFewLines(prev, (PsiElement)c) || GoChildrenAlignment.isAfterBracket(prev) || GoFormatterUtil.isMultiline((PsiElement)prev, formattingRules) || GoChildrenAlignment.isResettingCommentInCaseClause((PsiElement)prev) || GoChildrenAlignment.isResettingCommentInArgList((PsiElement)prev) || GoChildrenAlignment.isResettingCommentInStruct((PsiElement)prev) || GoChildrenAlignment.isAfterMultilineVarOrConstSpec((PsiElement)prev, formattingRules) || GoChildrenAlignment.isResettingCommentInFile((PsiElement)prev)) {
                alignment = GoChildrenAlignment.getAlignmentForFirstCommentInGroup(parentBlock, c, childrenAlignmentMap);
            }
            result.addAlignment(c, alignment);
            prev = c;
            prevAfterBlockRBrace = afterBlockRBRace;
        }
        GoCommentsAlignment goCommentsAlignment = result;
        if (goCommentsAlignment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(7);
        }
        return goCommentsAlignment;
    }

    @NotNull
    private static Alignment getAlignmentForFirstCommentInGroup(@NotNull GoFormattingBlock parentBlock, @NotNull PsiComment comment, @NotNull Map<PsiElement, GoChildrenAlignment> childrenAlignmentMap) {
        GoTopLevelDeclaration decl;
        GoChildrenAlignment goChildrenAlignment;
        GoFieldDeclaration field;
        GoChildrenAlignment prevCommentAlignment;
        PsiComment prevComment;
        PsiElement prevSibling;
        GoVarOrConstSpec valueSpec;
        if (parentBlock == null) {
            GoChildrenAlignment.$$$reportNull$$$0(8);
        }
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(9);
        }
        if (childrenAlignmentMap == null) {
            GoChildrenAlignment.$$$reportNull$$$0(10);
        }
        if ((valueSpec = (GoVarOrConstSpec)ObjectUtils.tryCast((Object)(prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)comment, (Class[])new Class[]{PsiWhiteSpace.class})), GoVarOrConstSpec.class)) != null && GoFormatterUtil.countNewLinesBetween(valueSpec, (PsiElement)comment) == 0) {
            Alignment alignment;
            GoChildrenAlignment goChildrenAlignment2 = childrenAlignmentMap.get(valueSpec);
            if (goChildrenAlignment2 instanceof GoVarOrConstSpecAlignment) {
                GoVarOrConstSpecAlignment spec = (GoVarOrConstSpecAlignment)goChildrenAlignment2;
                v0 = spec.myCommentAlignment;
            } else {
                v0 = alignment = null;
            }
            if (alignment != null) {
                Alignment alignment2 = alignment;
                if (alignment2 == null) {
                    GoChildrenAlignment.$$$reportNull$$$0(11);
                }
                return alignment2;
            }
        }
        PsiElement blockElement = GoChildrenAlignment.getBlockElementStartingOnSameLine((PsiElement)comment);
        PsiElement nextSibling = comment.getNextSibling();
        if (blockElement != null && (nextSibling == null || nextSibling instanceof PsiWhiteSpace && nextSibling.textContains('\n')) && (prevComment = (PsiComment)ObjectUtils.tryCast((Object)PsiTreeUtil.prevVisibleLeaf((PsiElement)blockElement), PsiComment.class)) != null && GoFormatterUtil.countNewLinesBetween((PsiElement)prevComment, blockElement) == 1 && GoChildrenAlignment.getBlockElementStartingOnSameLine((PsiElement)prevComment) == null && !GoChildrenAlignment.isResettingCommentInCaseClause((PsiElement)prevComment)) {
            GoFormattingBlock statementBlock = parentBlock.findParentBlock(blockElement);
            GoFormattingBlock statementHolderBlock = statementBlock != null ? statementBlock.getParent() : null;
            GoFormattingBlock prevCommentBlock = statementHolderBlock != null ? statementHolderBlock.findChildBlock((PsiElement)prevComment) : null;
            Object object = prevCommentAlignment = prevCommentBlock != null ? prevCommentBlock.getAlignment() : null;
            if (prevCommentAlignment != null) {
                GoChildrenAlignment goChildrenAlignment3 = prevCommentAlignment;
                if (goChildrenAlignment3 == null) {
                    GoChildrenAlignment.$$$reportNull$$$0(12);
                }
                return goChildrenAlignment3;
            }
        }
        if ((field = (GoFieldDeclaration)ObjectUtils.tryCast((Object)prevSibling, GoFieldDeclaration.class)) != null && field.getTag() == null && !GoChildrenAlignment.separatedWithFewLines(field, (PsiElement)comment)) {
            GoFieldDeclaration prevField = (GoFieldDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)field, GoFieldDeclaration.class);
            if (prevField != null && prevField.getTag() != null && GoFormatterUtil.countNewLinesBetween(prevField, field) == 1) {
                Alignment tagAlignment;
                prevCommentAlignment = childrenAlignmentMap.get(prevField);
                if (prevCommentAlignment instanceof GoStructFieldAlignment) {
                    GoStructFieldAlignment f = (GoStructFieldAlignment)prevCommentAlignment;
                    v4 = f.myTagAlignment;
                } else {
                    v4 = tagAlignment = null;
                }
                if (tagAlignment != null) {
                    Alignment alignment = tagAlignment;
                    if (alignment == null) {
                        GoChildrenAlignment.$$$reportNull$$$0(13);
                    }
                    return alignment;
                }
            }
            GoFieldDeclaration nextField = (GoFieldDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, GoFieldDeclaration.class);
            while (nextField != null && !GoChildrenAlignment.separatedWithFewLines(field, nextField)) {
                if (nextField.getTag() != null) {
                    Alignment tagAlignment;
                    goChildrenAlignment = childrenAlignmentMap.get(nextField);
                    if (goChildrenAlignment instanceof GoStructFieldAlignment) {
                        GoStructFieldAlignment f = (GoStructFieldAlignment)goChildrenAlignment;
                        v6 = f.myTagAlignment;
                    } else {
                        v6 = tagAlignment = null;
                    }
                    if (tagAlignment == null || nextField.getType() == null) break;
                    Alignment alignment = tagAlignment;
                    if (alignment == null) {
                        GoChildrenAlignment.$$$reportNull$$$0(14);
                    }
                    return alignment;
                }
                PsiComment commentAfterNextField = (PsiComment)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)nextField), PsiComment.class);
                if (commentAfterNextField == null || GoChildrenAlignment.separatedWithFewLines(nextField, (PsiElement)commentAfterNextField)) break;
                field = nextField;
                nextField = (GoFieldDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, GoFieldDeclaration.class);
            }
        }
        if (comment.getParent() instanceof GoFile && (decl = (GoTopLevelDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)comment, GoTopLevelDeclaration.class)) != null && !(decl instanceof GoFunctionOrMethodDeclaration) && GoFormatterUtil.countNewLinesBetween(decl, (PsiElement)comment) == 0) {
            GoFunctionOrMethodDeclaration prevDecl = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)decl, GoFunctionOrMethodDeclaration.class);
            if (prevDecl != null && GoFormatterUtil.countNewLinesBetween(prevDecl, decl) == 1) {
                Alignment blockAlignment;
                goChildrenAlignment = childrenAlignmentMap.get(prevDecl);
                if (goChildrenAlignment instanceof GoBlockAlignment) {
                    GoBlockAlignment block = (GoBlockAlignment)goChildrenAlignment;
                    v8 = block.myAlignment;
                } else {
                    v8 = blockAlignment = null;
                }
                if (blockAlignment != null) {
                    Alignment alignment = blockAlignment;
                    if (alignment == null) {
                        GoChildrenAlignment.$$$reportNull$$$0(15);
                    }
                    return alignment;
                }
            }
            GoTopLevelDeclaration nextDecl = (GoTopLevelDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)decl, GoTopLevelDeclaration.class);
            while (nextDecl != null && !GoChildrenAlignment.separatedWithFewLines(decl, nextDecl)) {
                if (nextDecl instanceof GoFunctionOrMethodDeclaration) {
                    Alignment blockAlignment;
                    GoChildrenAlignment goChildrenAlignment4 = childrenAlignmentMap.get(nextDecl);
                    if (goChildrenAlignment4 instanceof GoBlockAlignment) {
                        GoBlockAlignment block = (GoBlockAlignment)goChildrenAlignment4;
                        v10 = block.myAlignment;
                    } else {
                        v10 = blockAlignment = null;
                    }
                    if (blockAlignment == null) break;
                    Alignment alignment = blockAlignment;
                    if (alignment == null) {
                        GoChildrenAlignment.$$$reportNull$$$0(16);
                    }
                    return alignment;
                }
                PsiComment commentAfterNextDecl = (PsiComment)ObjectUtils.tryCast((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)nextDecl), PsiComment.class);
                if (commentAfterNextDecl == null || GoFormatterUtil.countNewLinesBetween(nextDecl, (PsiElement)commentAfterNextDecl) != 0) break;
                decl = nextDecl;
                nextDecl = (GoTopLevelDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)decl, GoTopLevelDeclaration.class);
            }
        }
        Alignment alignment = Alignment.createAlignment((boolean)true);
        if (alignment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(17);
        }
        return alignment;
    }

    @Nullable
    private static PsiElement getBlockElementStartingOnSameLine(@NotNull PsiElement comment) {
        PsiElement keyword;
        PsiElement blockElement;
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(18);
        }
        if ((blockElement = PsiTreeUtil.findFirstParent((PsiElement)comment, it -> GoChildrenAlignment.isBlockStatement(it) || GoChildrenAlignment.isDeclaration(it))) != null && GoFormatterUtil.countNewLinesBetweenLeafs(keyword = blockElement.getFirstChild(), comment) == 0) {
            return GoChildrenAlignment.isDeclaration(blockElement) && blockElement.getParent() instanceof GoStatement ? blockElement.getParent() : blockElement;
        }
        return null;
    }

    private static boolean isBlockStatement(@NotNull PsiElement element) {
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(19);
        }
        return element instanceof GoIfStatement || element instanceof GoSwitchStatement || element instanceof GoSelectStatement || element instanceof GoForStatement;
    }

    private static boolean isDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(20);
        }
        return element instanceof GoVarDeclaration || element instanceof GoConstDeclaration || element instanceof GoTypeDeclaration;
    }

    @NotNull
    private static GoChildrenAlignment buildLiteralCommentAlignment(@NotNull PsiElement parent, @NotNull GoFormattingBlock parentBlock, PsiComment @NotNull [] comments, @NotNull GoFormattingRules formattingRules) {
        if (parent == null) {
            GoChildrenAlignment.$$$reportNull$$$0(21);
        }
        if (parentBlock == null) {
            GoChildrenAlignment.$$$reportNull$$$0(22);
        }
        if (formattingRules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(23);
        }
        if (comments == null) {
            GoChildrenAlignment.$$$reportNull$$$0(24);
        }
        GoCommentsAlignment result = new GoCommentsAlignment(formattingRules);
        Alignment alignment = null;
        PsiComment prev = null;
        PsiElement prevLengthElement = null;
        HashMap<PsiElement, Boolean> bigLengthChange = new HashMap<PsiElement, Boolean>();
        LengthThreshold threshold = LengthThreshold.create(formattingRules);
        for (PsiElement child : SyntaxTraverser.psiTraverser().children((Object)parent)) {
            PsiElement lengthElement;
            if (child instanceof PsiComment) {
                PsiComment c = (PsiComment)child;
                if (GoFormatterUtil.isFirstElementOnLine((PsiElement)c)) {
                    prev = null;
                    if (!(c.getNextSibling() instanceof PsiWhiteSpace) || !c.getNextSibling().textContains('\n')) continue;
                    threshold.reset();
                    continue;
                }
                lengthElement = GoChildrenAlignment.getCommentLineLengthElement(c);
                if (GoFormatterUtil.isFirstElementOnLine(prev) || GoChildrenAlignment.separatedWithFewLines(prev, (PsiElement)c) || GoChildrenAlignment.isAfterBracket(prev) || GoFormatterUtil.isMultiline(prev, formattingRules) || bigLengthChange.getOrDefault(lengthElement, false).booleanValue() || GoChildrenAlignment.isOnLineWithSeveralElements(prev) || GoChildrenAlignment.isAfterMultilineElement(c) || prev == comments[0] && GoChildrenAlignment.isOnLiteralValueStartLine(prev)) {
                    alignment = GoChildrenAlignment.getAlignmentForFirstCommentInGroup(parentBlock, c, Collections.emptyMap());
                }
                result.addAlignment(c, alignment);
                prev = c;
                continue;
            }
            if (child instanceof GoElement) {
                lengthElement = GoChildrenAlignment.getLineLengthElement((GoElement)child);
                if (lengthElement != null) {
                    if (GoChildrenAlignment.isBigLengthChange(prevLengthElement, lengthElement, threshold)) {
                        threshold.reset();
                        bigLengthChange.put(lengthElement, true);
                    }
                    threshold.addLength(lengthElement.getTextLength());
                }
                prevLengthElement = lengthElement;
                continue;
            }
            if (!(child instanceof PsiWhiteSpace) || StringUtil.countNewLines((CharSequence)child.getText()) <= 1) continue;
            threshold.reset();
        }
        GoCommentsAlignment goCommentsAlignment = result;
        if (goCommentsAlignment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(25);
        }
        return goCommentsAlignment;
    }

    private static boolean isBigLengthChange(@Nullable PsiElement prevLengthElement, @NotNull PsiElement currentLengthElement, @NotNull LengthThreshold threshold) {
        if (currentLengthElement == null) {
            GoChildrenAlignment.$$$reportNull$$$0(26);
        }
        if (threshold == null) {
            GoChildrenAlignment.$$$reportNull$$$0(27);
        }
        if (prevLengthElement == null) {
            return true;
        }
        return prevLengthElement.getClass() != currentLengthElement.getClass() || !GoChildrenAlignment.isSmallLengthChange(prevLengthElement, currentLengthElement, threshold);
    }

    @Nullable
    private static PsiElement getCommentLineLengthElement(@Nullable PsiComment comment) {
        return GoChildrenAlignment.getLineLengthElement(GoChildrenAlignment.findElementBefore(comment));
    }

    @Nullable
    private static PsiElement getLineLengthElement(@Nullable GoElement element) {
        if (element == null) {
            return null;
        }
        GoKey key = element.getKey();
        return key != null ? key : element.getValue();
    }

    @Nullable
    private static GoElement findElementBefore(@Nullable PsiComment element) {
        if (GoFormatterUtil.isFirstElementOnLine((PsiElement)element)) {
            return null;
        }
        PsiElement prevElement = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
        if (GoTypes.COMMA.equals(prevElement != null ? prevElement.getNode().getElementType() : null)) {
            return (GoElement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipSiblingsBackward((PsiElement)prevElement, (Class[])new Class[]{PsiWhiteSpace.class}), GoElement.class);
        }
        return null;
    }

    @NotNull
    public static Map<PsiElement, GoChildrenAlignment> buildChildrenAlignmentMap(@NotNull PsiElement e, @NotNull GoFormattingRules formattingRules, @Nullable GoChildrenAlignment ownAlignment) {
        if (e == null) {
            GoChildrenAlignment.$$$reportNull$$$0(28);
        }
        if (formattingRules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(29);
        }
        if (!GoChildrenAlignment.needAlignmentForGrandChildren(e)) {
            Map<PsiElement, GoChildrenAlignment> map = Collections.emptyMap();
            if (map == null) {
                GoChildrenAlignment.$$$reportNull$$$0(30);
            }
            return map;
        }
        if (e instanceof GoVarOrConstDeclaration) {
            return GoChildrenAlignment.buildVarOrConstAlignment((GoVarOrConstDeclaration)e, formattingRules);
        }
        if (e instanceof GoStructType) {
            return GoChildrenAlignment.buildStructTypeAlignment((GoStructType)e, formattingRules);
        }
        if (e instanceof GoLiteralValue) {
            return GoChildrenAlignment.buildLiteralValueAlignment((GoLiteralValue)e, formattingRules);
        }
        if (e instanceof GoFile) {
            return GoChildrenAlignment.buildFileAlignment((GoFile)e, formattingRules);
        }
        if (e instanceof GoTypeDeclaration) {
            return GoChildrenAlignment.buildTypeDeclarationAlignment((GoTypeDeclaration)e, formattingRules);
        }
        if (e instanceof GoTypeSpec) {
            return GoChildrenAlignment.buildTypeSpecAlignment((GoTypeSpec)e, ownAlignment);
        }
        Map<PsiElement, GoChildrenAlignment> map = Collections.emptyMap();
        if (map == null) {
            GoChildrenAlignment.$$$reportNull$$$0(31);
        }
        return map;
    }

    @NotNull
    private static Map<PsiElement, GoChildrenAlignment> buildTypeDeclarationAlignment(@NotNull GoTypeDeclaration typeDeclaration, @NotNull GoFormattingRules rules) {
        if (typeDeclaration == null) {
            GoChildrenAlignment.$$$reportNull$$$0(32);
        }
        if (rules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(33);
        }
        HashMap<PsiElement, GoChildrenAlignment> result = new HashMap<PsiElement, GoChildrenAlignment>();
        GoTypeSpec prev = null;
        Alignment alignment = Alignment.createAlignment((boolean)true);
        for (GoTypeSpec spec : typeDeclaration.getTypeSpecList()) {
            PsiElement element;
            boolean multiline = GoFormatterUtil.isMultiline(spec, rules);
            boolean separatedWithFewLines = GoChildrenAlignment.separatedWithFewLines(prev, spec);
            if (separatedWithFewLines) {
                alignment = Alignment.createAlignment((boolean)true);
            }
            GoSpecType specType = spec.getSpecType();
            PsiElement assign = specType.getAssign();
            GoType type = specType.getType();
            Object object = element = assign != null ? assign : type;
            if (element != null) {
                result.put(spec, new GoSpecTypeAlignment(alignment, element, multiline));
            }
            prev = multiline ? null : spec;
        }
        HashMap<PsiElement, GoChildrenAlignment> hashMap = result;
        if (hashMap == null) {
            GoChildrenAlignment.$$$reportNull$$$0(34);
        }
        return hashMap;
    }

    @NotNull
    private static Map<PsiElement, GoChildrenAlignment> buildTypeSpecAlignment(@NotNull GoTypeSpec typeSpec, @Nullable GoChildrenAlignment typeSpecAlignment) {
        if (typeSpec == null) {
            GoChildrenAlignment.$$$reportNull$$$0(35);
        }
        HashMap<PsiElement, GoChildrenAlignment> result = new HashMap<PsiElement, GoChildrenAlignment>();
        result.put(typeSpec.getSpecType(), typeSpecAlignment);
        HashMap<PsiElement, GoChildrenAlignment> hashMap = result;
        if (hashMap == null) {
            GoChildrenAlignment.$$$reportNull$$$0(36);
        }
        return hashMap;
    }

    @NotNull
    private static Map<PsiElement, GoChildrenAlignment> buildFileAlignment(@NotNull GoFile e, @NotNull GoFormattingRules rules) {
        if (e == null) {
            GoChildrenAlignment.$$$reportNull$$$0(37);
        }
        if (rules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(38);
        }
        Ref alignment = Ref.create();
        return GoChildrenAlignment.processChildren((PsiElement)e, GoTopLevelDeclaration.class, rules, (child, multiline, prevChild, separatedWithSeveralLines) -> {
            if (separatedWithSeveralLines) {
                alignment.set((Object)Alignment.createAlignment((boolean)true));
            }
            if (child instanceof GoFunctionOrMethodDeclaration) {
                if (multiline || GoFormatterUtil.isLongOneLineFunctionBlock(((GoFunctionOrMethodDeclaration)child).getBlock())) {
                    return null;
                }
                return new GoBlockAlignment((Alignment)alignment.get());
            }
            if (!GoChildrenAlignment.hasCommentOnSameLine(child, rules)) {
                alignment.set((Object)Alignment.createAlignment((boolean)true));
            }
            return null;
        });
    }

    @NotNull
    private static Map<PsiElement, GoChildrenAlignment> buildLiteralValueAlignment(@NotNull GoLiteralValue e, @NotNull GoFormattingRules rules) {
        if (e == null) {
            GoChildrenAlignment.$$$reportNull$$$0(39);
        }
        if (rules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(40);
        }
        Ref alignment = Ref.create();
        LengthThreshold threshold = LengthThreshold.create(rules);
        PsiElement lbrace = e.getLbrace();
        return GoChildrenAlignment.processChildren(e, GoElement.class, rules, (child, multiline, prevChild, separatedWithSeveralLines) -> {
            Alignment prevAlignment = (Alignment)alignment.get();
            GoKey currentKey = child.getKey();
            boolean prevChildOnSameLine = false;
            if (separatedWithSeveralLines || prevChild == null) {
                alignment.set((Object)Alignment.createAlignment((boolean)true));
            } else if (GoFormatterUtil.countNewLinesBetween(prevChild, child) == 0) {
                alignment.set((Object)Alignment.createAlignment((boolean)true));
                prevChildOnSameLine = true;
            } else {
                GoKey prevKey = prevChild.getKey();
                if (!GoChildrenAlignment.isSmallLengthChange(prevKey, currentKey, threshold) || lbrace != null && GoFormatterUtil.countNewLinesBetween(lbrace, prevChild) == 0) {
                    alignment.set((Object)Alignment.createAlignment((boolean)true));
                }
            }
            if (multiline || prevChildOnSameLine) {
                threshold.reset();
                return null;
            }
            if (alignment.get() != prevAlignment) {
                threshold.reset();
            }
            if (currentKey != null) {
                threshold.addLength(currentKey.getTextLength());
            }
            return new GoValueAlignment((Alignment)alignment.get());
        });
    }

    @NotNull
    private static Map<PsiElement, GoChildrenAlignment> buildStructTypeAlignment(@NotNull GoStructType e, @NotNull GoFormattingRules rules) {
        if (e == null) {
            GoChildrenAlignment.$$$reportNull$$$0(41);
        }
        if (rules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(42);
        }
        Ref typeAlignment = Ref.create();
        Ref tagAlignment = Ref.create();
        return GoChildrenAlignment.processChildren(e, GoFieldDeclaration.class, rules, (child, multiline, prevChild, separatedWithSeveralLines) -> {
            Alignment tagAlignmentToUse;
            boolean resetTypeAlignment;
            boolean prevEmbeddedStruct = GoChildrenAlignment.embeddedStruct(prevChild);
            boolean prevFieldNoTag = prevChild != null && prevChild.getTag() == null;
            boolean prevHasComment = GoChildrenAlignment.hasCommentOnSameLine(prevChild, rules);
            boolean bl = resetTypeAlignment = prevEmbeddedStruct && prevFieldNoTag && !prevHasComment;
            if (separatedWithSeveralLines || resetTypeAlignment) {
                typeAlignment.set((Object)Alignment.createAlignment((boolean)true));
            }
            if (separatedWithSeveralLines || (prevEmbeddedStruct || prevFieldNoTag) && !prevHasComment) {
                tagAlignment.set((Object)Alignment.createAlignment((boolean)true));
            }
            boolean voidBlockAfterType = child.getAnonymousFieldDefinition() != null && GoChildrenAlignment.hasCommentOnSameLine(child, rules);
            Alignment alignment = tagAlignmentToUse = GoChildrenAlignment.embeddedStruct(child) ? (Alignment)typeAlignment.get() : (Alignment)tagAlignment.get();
            if (!multiline) {
                return new GoStructFieldAlignment((Alignment)typeAlignment.get(), tagAlignmentToUse, false, voidBlockAfterType);
            }
            if (GoFormatterUtil.isMultiline(child.getType(), rules)) {
                return new GoStructFieldAlignment((Alignment)typeAlignment.get(), tagAlignmentToUse, true, false);
            }
            return null;
        });
    }

    @NotNull
    private static Map<PsiElement, GoChildrenAlignment> buildVarOrConstAlignment(@NotNull GoVarOrConstDeclaration<GoVarOrConstSpec<?>> e, @NotNull GoFormattingRules rules) {
        if (e == null) {
            GoChildrenAlignment.$$$reportNull$$$0(43);
        }
        if (rules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(44);
        }
        Map<GoVarOrConstSpec<?>, Boolean> keepTypeColumn = GoChildrenAlignment.keepTypeColumn(e);
        HashMap comments = new HashMap();
        GoRowBlock rowBlock = new GoRowBlock(rules);
        ArrayList specs = new ArrayList();
        GoChildrenAlignment.processChildren(e, GoVarOrConstSpec.class, rules, (child, multiline, prevChild, separatedWithSeveralLines) -> {
            PsiComment comment;
            List definitions;
            if (prevChild != null && GoFormatterUtil.countNewLinesBetween(prevChild, child) == 0) {
                return null;
            }
            rowBlock.startNewRow(child);
            if (separatedWithSeveralLines) {
                rowBlock.resetColumns();
            }
            if ((definitions = child.getDefinitionList()).isEmpty()) {
                return null;
            }
            rowBlock.startCell((PsiElement)ContainerUtil.getFirstItem(definitions), (PsiElement)ContainerUtil.getLastItem(definitions));
            int extraTabs = 3;
            if (child.getType() != null || keepTypeColumn.getOrDefault(child, false).booleanValue()) {
                rowBlock.startCell(child.getType());
                --extraTabs;
            }
            if (child.getAssign() != null) {
                rowBlock.startCell(child.getAssign(), (PsiElement)ContainerUtil.getLastItem(child.getExpressionList()));
                --extraTabs;
            }
            if ((comment = GoChildrenAlignment.getCommentOnSameLine(child, rules)) != null) {
                while (extraTabs > 0) {
                    rowBlock.startCell(null);
                    --extraTabs;
                }
                rowBlock.setComment(comment);
                comments.put(child, comment);
            }
            specs.add(child);
            return null;
        });
        rowBlock.collapseEmptyColumns();
        HashMap<PsiElement, GoChildrenAlignment> result = new HashMap<PsiElement, GoChildrenAlignment>();
        for (GoVarOrConstSpec spec : specs) {
            PsiComment comment;
            GoRowBlock.Row row = rowBlock.getRow(spec);
            if (row == null) continue;
            int column = 1;
            HashMap<PsiElement, Alignment> voidBlockPredecessors = new HashMap<PsiElement, Alignment>();
            Alignment typeAlignment = null;
            Alignment assignAlignment = null;
            Alignment commentAlignment = null;
            GoType type = spec.getType();
            if (type != null) {
                int typeColumn = row.getColumn(type);
                if (GoFormatterUtil.isMultiline(type, rules)) {
                    voidBlockPredecessors.put(row.findLastElementBefore(typeColumn), row.getAlignment(typeColumn));
                } else {
                    typeAlignment = row.getAlignment(typeColumn);
                }
                ++column;
            }
            if (spec.getAssign() != null) {
                int assignColumn = row.getColumn(spec.getAssign());
                if (assignColumn > column) {
                    voidBlockPredecessors.put(row.findLastElementBefore(column), row.getAlignment(column));
                    ++column;
                }
                assignAlignment = row.getAlignment(assignColumn);
                ++column;
            }
            if ((comment = (PsiComment)comments.get(spec)) != null) {
                int commentColumn = row.getColumn((PsiElement)comment);
                if (commentColumn > column) {
                    voidBlockPredecessors.put(row.findLastElementBefore(column), row.getAlignment(column));
                }
                commentAlignment = row.getAlignment(commentColumn);
            }
            result.put(spec, new GoVarOrConstSpecAlignment(typeAlignment, assignAlignment, commentAlignment, voidBlockPredecessors));
        }
        HashMap<PsiElement, GoChildrenAlignment> hashMap = result;
        if (hashMap == null) {
            GoChildrenAlignment.$$$reportNull$$$0(45);
        }
        return hashMap;
    }

    @NotNull
    private static Map<GoVarOrConstSpec<?>, Boolean> keepTypeColumn(@NotNull GoVarOrConstDeclaration<GoVarOrConstSpec<?>> declaration) {
        if (declaration == null) {
            GoChildrenAlignment.$$$reportNull$$$0(46);
        }
        HashMap keepTypeColumn = new HashMap();
        HashSet run = new HashSet();
        boolean keepType = false;
        for (GoVarOrConstSpec<?> goVarOrConstSpec : declaration.getSpecList()) {
            if (!goVarOrConstSpec.getExpressionList().isEmpty()) {
                if (run.isEmpty()) {
                    keepType = false;
                }
                run.add(goVarOrConstSpec);
            } else if (!run.isEmpty()) {
                for (GoVarOrConstSpec goVarOrConstSpec2 : run) {
                    keepTypeColumn.put(goVarOrConstSpec2, keepType);
                }
                run.clear();
            }
            if (goVarOrConstSpec.getType() == null) continue;
            keepType = true;
        }
        for (GoVarOrConstSpec<Object> goVarOrConstSpec : run) {
            keepTypeColumn.put(goVarOrConstSpec, keepType);
        }
        HashMap hashMap = keepTypeColumn;
        if (hashMap == null) {
            GoChildrenAlignment.$$$reportNull$$$0(47);
        }
        return hashMap;
    }

    private static boolean hasCommentOnSameLine(@Nullable PsiElement element, @NotNull GoFormattingRules formattingRules) {
        if (formattingRules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(48);
        }
        return GoChildrenAlignment.getCommentOnSameLine(element, formattingRules) != null;
    }

    @Nullable
    private static PsiComment getCommentOnSameLine(@Nullable PsiElement element, @NotNull GoFormattingRules formattingRules) {
        PsiElement next;
        if (formattingRules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(49);
        }
        PsiElement psiElement = next = element != null ? element.getNextSibling() : null;
        while (next != null) {
            if (GoFormatterUtil.isMultiline(next, formattingRules)) {
                return null;
            }
            if (next instanceof PsiComment) {
                return (PsiComment)next;
            }
            next = next.getNextSibling();
        }
        return null;
    }

    private static boolean embeddedStruct(@Nullable PsiElement e) {
        return e instanceof GoFieldDeclaration && ((GoFieldDeclaration)e).getType() == null;
    }

    private static boolean leafsSeparatedWithFewLines(@Nullable PsiElement prevChild, @NotNull PsiElement child) {
        if (child == null) {
            GoChildrenAlignment.$$$reportNull$$$0(50);
        }
        return prevChild == null || GoFormatterUtil.countNewLinesBetweenLeafs(prevChild, child) > 1;
    }

    private static boolean separatedWithFewLines(@Nullable PsiElement prevChild, @NotNull PsiElement child) {
        if (child == null) {
            GoChildrenAlignment.$$$reportNull$$$0(51);
        }
        return prevChild == null || GoFormatterUtil.countNewLinesBetween(prevChild, child) > 1;
    }

    private static boolean isAfterBracket(@NotNull PsiElement element) {
        ASTNode prev;
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(52);
        }
        return (prev = FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)element.getNode())) != null && LEFT_BRACES_TOKEN_SET.contains(prev.getElementType());
    }

    private static boolean isAfterBlockStatementRBrace(@NotNull PsiElement element) {
        GoStatement prev;
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(53);
        }
        GoBlock block = (prev = (GoStatement)ObjectUtils.tryCast((Object)PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class}), GoStatement.class)) != null ? prev.getBlock() : null;
        PsiElement rbrace = block != null ? block.getRbrace() : null;
        return rbrace != null && PsiTreeUtil.prevVisibleLeaf((PsiElement)element) == rbrace && GoFormatterUtil.countNewLinesBetween(rbrace, element) == 0;
    }

    private static boolean isAfterMultilineVarOrConstSpec(@NotNull PsiElement comment, @NotNull GoFormattingRules rules) {
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(54);
        }
        if (rules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(55);
        }
        if (comment.getParent() instanceof GoVarOrConstDeclaration) {
            GoVarOrConstSpec spec = (GoVarOrConstSpec)PsiTreeUtil.getPrevSiblingOfType((PsiElement)comment, GoVarOrConstSpec.class);
            return spec != null && !GoChildrenAlignment.separatedWithFewLines(spec, comment) && GoFormatterUtil.isMultiline(spec, rules);
        }
        return false;
    }

    private static boolean isResettingCommentInStruct(@NotNull PsiElement comment) {
        GoFieldDeclaration field;
        GoStructType structType;
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(56);
        }
        if ((structType = (GoStructType)ObjectUtils.tryCast((Object)comment.getParent(), GoStructType.class)) != null && (field = (GoFieldDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)comment, GoFieldDeclaration.class)) != null && field.getType() != null && !GoChildrenAlignment.separatedWithFewLines(field, comment)) {
            GoFieldDeclaration nextField = (GoFieldDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, GoFieldDeclaration.class);
            return nextField != null && field.getTag() != null ^ nextField.getTag() != null && nextField.getType() != null;
        }
        return false;
    }

    private static boolean isResettingCommentInFile(@NotNull PsiElement comment) {
        GoTopLevelDeclaration nextDecl;
        GoTopLevelDeclaration prevDecl;
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(57);
        }
        if (comment.getParent() instanceof GoFile && (prevDecl = (GoTopLevelDeclaration)PsiTreeUtil.getPrevSiblingOfType((PsiElement)comment, GoTopLevelDeclaration.class)) != null && GoFormatterUtil.countNewLinesBetween(prevDecl, comment) == 0 && (nextDecl = (GoTopLevelDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, GoTopLevelDeclaration.class)) != null && GoFormatterUtil.countNewLinesBetween(comment, nextDecl) == 1) {
            return prevDecl instanceof GoFunctionOrMethodDeclaration ^ nextDecl instanceof GoFunctionOrMethodDeclaration;
        }
        return false;
    }

    private static boolean isResettingCommentInArgList(@NotNull PsiElement comment) {
        GoArgumentList argList;
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(58);
        }
        if ((argList = (GoArgumentList)ObjectUtils.tryCast((Object)comment.getParent(), GoArgumentList.class)) != null) {
            int commaCount = 0;
            for (PsiElement element = comment.getPrevSibling(); element != null; element = element.getPrevSibling()) {
                IElementType elementType = element.getNode().getElementType();
                if (elementType == GoTypes.LPAREN) {
                    return true;
                }
                if (elementType == GoTypes.COMMA) {
                    ++commaCount;
                }
                if (commaCount > 1) {
                    return true;
                }
                if (StringUtil.countNewLines((CharSequence)element.getText()) <= 0) continue;
                return false;
            }
        }
        return false;
    }

    private static boolean isResettingCommentInCaseClause(@NotNull PsiElement element) {
        GoCaseClause caseClause;
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(59);
        }
        if ((caseClause = (GoCaseClause)ObjectUtils.tryCast((Object)element.getParent(), GoCaseClause.class)) != null) {
            PsiElement firstChild;
            IElementType firstChildType;
            PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)element);
            if (prev != null) {
                PsiElement prevComma;
                if (prev.textMatches((CharSequence)":") && GoFormatterUtil.countNewLinesBetween(prev, element) == 0) {
                    return true;
                }
                if (prev.textMatches((CharSequence)",") && GoFormatterUtil.countNewLinesBetween(prev, element) == 0 && (prevComma = GoChildrenAlignment.findPreviousCommaSibling(prev)) != null && GoFormatterUtil.countNewLinesBetween(prevComma, prev) == 0) {
                    return true;
                }
            }
            IElementType iElementType = firstChildType = (firstChild = caseClause.getFirstChild()) != null ? firstChild.getNode().getElementType() : null;
            if ((firstChildType == GoTypes.CASE || firstChildType == GoTypes.DEFAULT) && GoFormatterUtil.countNewLinesBetween(firstChild, element) == 0) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement findPreviousCommaSibling(@NotNull PsiElement start) {
        if (start == null) {
            GoChildrenAlignment.$$$reportNull$$$0(60);
        }
        for (PsiElement element = start.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            if (!element.textMatches((CharSequence)",")) continue;
            return element;
        }
        return null;
    }

    private static boolean isOnLineWithSeveralElements(@NotNull PsiComment comment) {
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(61);
        }
        int elementCount = 0;
        for (PsiElement e = comment.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if ((e instanceof PsiWhiteSpace || e instanceof PsiComment) && StringUtil.countNewLines((CharSequence)e.getText()) > 0) {
                return false;
            }
            if (!(e instanceof GoElement) || ++elementCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isAfterMultilineElement(@NotNull PsiComment comment) {
        PsiElement prev;
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(62);
        }
        if ((prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)comment)) != null && prev.textMatches((CharSequence)",")) {
            GoElement element = (GoElement)ObjectUtils.tryCast((Object)prev.getPrevSibling(), GoElement.class);
            return element != null && element.textContains('\n');
        }
        return false;
    }

    private static boolean isOnLiteralValueStartLine(@NotNull PsiComment comment) {
        GoLiteralValue literalValue;
        if (comment == null) {
            GoChildrenAlignment.$$$reportNull$$$0(63);
        }
        PsiElement lbrace = (literalValue = (GoLiteralValue)ObjectUtils.tryCast((Object)comment.getParent(), GoLiteralValue.class)) != null ? literalValue.getLbrace() : null;
        return lbrace != null && GoFormatterUtil.countNewLinesBetween(lbrace, (PsiElement)comment) == 0;
    }

    private static boolean needAlignmentForGrandChildren(@NotNull PsiElement e) {
        if (e == null) {
            GoChildrenAlignment.$$$reportNull$$$0(64);
        }
        return e instanceof GoTopLevelDeclaration && !(e instanceof GoFunctionOrMethodDeclaration) || e instanceof GoLiteralValue || e instanceof GoFile || e instanceof GoStructType || e instanceof GoTypeSpec;
    }

    @NotNull
    private static <T extends PsiElement> Map<PsiElement, GoChildrenAlignment> processChildren(@NotNull PsiElement element, @NotNull Class<T> childClass, @NotNull GoFormattingRules formattingRules, @NotNull ChildProcessor<T> processor2) {
        if (element == null) {
            GoChildrenAlignment.$$$reportNull$$$0(65);
        }
        if (childClass == null) {
            GoChildrenAlignment.$$$reportNull$$$0(66);
        }
        if (formattingRules == null) {
            GoChildrenAlignment.$$$reportNull$$$0(67);
        }
        if (processor2 == null) {
            GoChildrenAlignment.$$$reportNull$$$0(68);
        }
        HashMap<PsiElement, GoChildrenAlignment> result = new HashMap<PsiElement, GoChildrenAlignment>();
        PsiElement prev = null;
        for (PsiElement child : element.getChildren()) {
            if (!childClass.isInstance(child)) continue;
            boolean separatedWithFewLines = GoChildrenAlignment.separatedWithFewLines(prev, child);
            boolean multiline = GoFormatterUtil.isMultiline(child, formattingRules);
            GoChildrenAlignment alignment = processor2.accept((PsiElement)childClass.cast(child), multiline, prev, separatedWithFewLines);
            ContainerUtil.putIfNotNull((Object)child, (Object)alignment, result);
            prev = multiline ? null : (PsiElement)childClass.cast(child);
        }
        HashMap<PsiElement, GoChildrenAlignment> hashMap = result;
        if (hashMap == null) {
            GoChildrenAlignment.$$$reportNull$$$0(69);
        }
        return hashMap;
    }

    private static boolean isSmallLengthChange(@Nullable PsiElement element1, @Nullable PsiElement element2, @NotNull LengthThreshold threshold) {
        if (threshold == null) {
            GoChildrenAlignment.$$$reportNull$$$0(70);
        }
        return element1 != null && element2 != null && !threshold.isBigLengthChange(element1.getTextLength(), element2.getTextLength());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 11, 12, 13, 14, 15, 16, 17, 25, 30, 31, 34, 36, 45, 47, 69 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 19: 
            case 20: 
            case 52: 
            case 53: 
            case 59: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
            case 5: 
            case 23: 
            case 29: 
            case 48: 
            case 49: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRules";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenAlignmentMap";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 45: 
            case 47: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoChildrenAlignment";
                break;
            }
            case 9: 
            case 18: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 61: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLengthElement";
                break;
            }
            case 27: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threshold";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 33: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childClass";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoChildrenAlignment";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommentAlignment";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignmentForFirstCommentInGroup";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLiteralCommentAlignment";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildrenAlignmentMap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeDeclarationAlignment";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTypeSpecAlignment";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVarOrConstAlignment";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "keepTypeColumn";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "processChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAlignment";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVoidBlockAlignmentBefore";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVoidBlockAlignmentAfter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildCommentAlignment";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 45: 
            case 47: 
            case 69: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAlignmentForFirstCommentInGroup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBlockElementStartingOnSameLine";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBlockStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaration";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildLiteralCommentAlignment";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isBigLengthChange";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildChildrenAlignmentMap";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeDeclarationAlignment";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeSpecAlignment";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildFileAlignment";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "buildLiteralValueAlignment";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "buildStructTypeAlignment";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "buildVarOrConstAlignment";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "keepTypeColumn";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasCommentOnSameLine";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCommentOnSameLine";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "leafsSeparatedWithFewLines";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "separatedWithFewLines";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isAfterBracket";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isAfterBlockStatementRBrace";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isAfterMultilineVarOrConstSpec";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isResettingCommentInStruct";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isResettingCommentInFile";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isResettingCommentInArgList";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isResettingCommentInCaseClause";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findPreviousCommaSibling";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isOnLineWithSeveralElements";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isAfterMultilineElement";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isOnLiteralValueStartLine";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "needAlignmentForGrandChildren";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "processChildren";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isSmallLengthChange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 11, 12, 13, 14, 15, 16, 17, 25, 30, 31, 34, 36, 45, 47, 69 -> new IllegalStateException(string);
        };
    }

    static class GoCommentsAlignment
    extends GoChildrenAlignment {
        private final GoFormattingRules myFormattingRules;
        private final Map<PsiElement, Alignment> myAlignments;
        private final Map<PsiElement, Alignment> myVoidBlockBeforeAlignments;

        GoCommentsAlignment(@NotNull GoFormattingRules formattingRules) {
            if (formattingRules == null) {
                GoCommentsAlignment.$$$reportNull$$$0(0);
            }
            this.myAlignments = new HashMap<PsiElement, Alignment>();
            this.myVoidBlockBeforeAlignments = new HashMap<PsiElement, Alignment>();
            this.myFormattingRules = formattingRules;
        }

        @Override
        @Nullable
        public Alignment getAlignment(@NotNull PsiElement e) {
            if (e == null) {
                GoCommentsAlignment.$$$reportNull$$$0(1);
            }
            return this.myAlignments.get(e);
        }

        @Override
        @Nullable
        public Alignment getVoidBlockAlignmentBefore(@NotNull PsiElement element) {
            if (element == null) {
                GoCommentsAlignment.$$$reportNull$$$0(2);
            }
            return this.myVoidBlockBeforeAlignments.get(element);
        }

        void addAlignment(@NotNull PsiComment comment, @Nullable Alignment alignment) {
            if (comment == null) {
                GoCommentsAlignment.$$$reportNull$$$0(3);
            }
            if (GoFormatterUtil.isMultiline((PsiElement)comment, this.myFormattingRules)) {
                this.myVoidBlockBeforeAlignments.put((PsiElement)comment, alignment);
            } else {
                this.myAlignments.put((PsiElement)comment, alignment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formattingRules";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            objectArray2[1] = "com/goide/formatter/GoChildrenAlignment$GoCommentsAlignment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAlignment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVoidBlockAlignmentBefore";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAlignment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GoVarOrConstSpecAlignment
    extends GoChildrenAlignment {
        private final Alignment myTypeAlignment;
        private final Alignment myAssignAlignment;
        private final Alignment myCommentAlignment;
        private final Map<PsiElement, Alignment> myVoidBlockPredecessors;

        GoVarOrConstSpecAlignment(@Nullable Alignment typeAlignment, @Nullable Alignment assignAlignment, @Nullable Alignment commentAlignment, @NotNull Map<PsiElement, Alignment> voidBlockPredecessors) {
            if (voidBlockPredecessors == null) {
                GoVarOrConstSpecAlignment.$$$reportNull$$$0(0);
            }
            this.myTypeAlignment = typeAlignment;
            this.myAssignAlignment = assignAlignment;
            this.myCommentAlignment = commentAlignment;
            this.myVoidBlockPredecessors = voidBlockPredecessors;
        }

        @Override
        @Nullable
        public Alignment getAlignment(@NotNull PsiElement e) {
            if (e == null) {
                GoVarOrConstSpecAlignment.$$$reportNull$$$0(1);
            }
            if (e instanceof GoType) {
                return this.myTypeAlignment;
            }
            return GoVarOrConstSpecAlignment.isAssign(e) ? this.myAssignAlignment : null;
        }

        @Override
        @Nullable
        public Alignment getVoidBlockAlignmentAfter(@NotNull PsiElement element) {
            if (element == null) {
                GoVarOrConstSpecAlignment.$$$reportNull$$$0(2);
            }
            return this.myVoidBlockPredecessors.get(element);
        }

        private static boolean isAssign(@NotNull PsiElement e) {
            ASTNode node;
            if (e == null) {
                GoVarOrConstSpecAlignment.$$$reportNull$$$0(3);
            }
            IElementType type = (node = e.getNode()) == null ? null : node.getElementType();
            return type == GoTypes.ASSIGN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "voidBlockPredecessors";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/goide/formatter/GoChildrenAlignment$GoVarOrConstSpecAlignment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAlignment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVoidBlockAlignmentAfter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAssign";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GoStructFieldAlignment
    extends GoChildrenAlignment {
        private final Alignment myTypeAlignment;
        private final Alignment myTagAlignment;
        private final boolean myMultilineType;
        private final boolean myInsertVoidBlockAfterAnonymousField;

        GoStructFieldAlignment(@Nullable Alignment typeAlignment, @Nullable Alignment tagAlignment, boolean multilineType, boolean insertVoidBlockAfterAnonymousField) {
            this.myTypeAlignment = typeAlignment;
            this.myTagAlignment = tagAlignment;
            this.myMultilineType = multilineType;
            this.myInsertVoidBlockAfterAnonymousField = insertVoidBlockAfterAnonymousField;
        }

        @Override
        @Nullable
        public Alignment getAlignment(@NotNull PsiElement e) {
            if (e == null) {
                GoStructFieldAlignment.$$$reportNull$$$0(0);
            }
            if (this.myMultilineType) {
                return null;
            }
            if (e instanceof GoType) {
                return this.myTypeAlignment;
            }
            if (e instanceof GoTag) {
                return this.myTagAlignment;
            }
            return null;
        }

        @Override
        @Nullable
        public Alignment getVoidBlockAlignmentBefore(@NotNull PsiElement element) {
            if (element == null) {
                GoStructFieldAlignment.$$$reportNull$$$0(1);
            }
            return this.myMultilineType && element instanceof GoType ? this.myTypeAlignment : null;
        }

        @Override
        @Nullable
        public Alignment getVoidBlockAlignmentAfter(@NotNull PsiElement element) {
            if (element == null) {
                GoStructFieldAlignment.$$$reportNull$$$0(2);
            }
            return this.myInsertVoidBlockAfterAnonymousField && element instanceof GoAnonymousFieldDefinition ? this.myTypeAlignment : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/goide/formatter/GoChildrenAlignment$GoStructFieldAlignment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAlignment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVoidBlockAlignmentBefore";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVoidBlockAlignmentAfter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GoBlockAlignment
    extends GoChildrenAlignment {
        private final Alignment myAlignment;

        GoBlockAlignment(@Nullable Alignment alignment) {
            this.myAlignment = alignment;
        }

        @Override
        @Nullable
        public Alignment getVoidBlockAlignmentBefore(@NotNull PsiElement element) {
            if (element == null) {
                GoBlockAlignment.$$$reportNull$$$0(0);
            }
            return element instanceof GoBlock ? this.myAlignment : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/formatter/GoChildrenAlignment$GoBlockAlignment", "getVoidBlockAlignmentBefore"));
        }
    }

    static class GoSpecTypeAlignment
    extends GoChildrenAlignment {
        private final Alignment myAlignment;
        private final PsiElement myElement;
        private final boolean myMultiline;

        GoSpecTypeAlignment(@Nullable Alignment alignment, @NotNull PsiElement element, boolean multiline) {
            if (element == null) {
                GoSpecTypeAlignment.$$$reportNull$$$0(0);
            }
            this.myAlignment = alignment;
            this.myElement = element;
            this.myMultiline = multiline;
        }

        @Override
        @Nullable
        public Alignment getAlignment(@NotNull PsiElement element) {
            if (element == null) {
                GoSpecTypeAlignment.$$$reportNull$$$0(1);
            }
            return element == this.myElement && !this.myMultiline ? this.myAlignment : null;
        }

        @Override
        @Nullable
        public Alignment getVoidBlockAlignmentBefore(@NotNull PsiElement element) {
            if (element == null) {
                GoSpecTypeAlignment.$$$reportNull$$$0(2);
            }
            return this.myMultiline && element == this.myElement ? this.myAlignment : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/goide/formatter/GoChildrenAlignment$GoSpecTypeAlignment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAlignment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getVoidBlockAlignmentBefore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface ChildProcessor<T extends PsiElement> {
        @Nullable
        public GoChildrenAlignment accept(@NotNull T var1, boolean var2, @Nullable T var3, boolean var4);
    }

    static class GoValueAlignment
    extends GoSingleColumnAlignment<GoValue> {
        GoValueAlignment(@Nullable Alignment alignment) {
            super(GoValue.class, alignment);
        }
    }

    static class GoSingleColumnAlignment<T extends PsiElement>
    extends GoChildrenAlignment {
        private final Class<T> myClass;
        final Alignment myAlignment;

        GoSingleColumnAlignment(@NotNull Class<T> elementClass, @Nullable Alignment alignment) {
            if (elementClass == null) {
                GoSingleColumnAlignment.$$$reportNull$$$0(0);
            }
            this.myClass = elementClass;
            this.myAlignment = alignment;
        }

        @Override
        @Nullable
        public Alignment getAlignment(@NotNull PsiElement e) {
            if (e == null) {
                GoSingleColumnAlignment.$$$reportNull$$$0(1);
            }
            return this.myClass.isInstance(e) ? this.myAlignment : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/goide/formatter/GoChildrenAlignment$GoSingleColumnAlignment";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAlignment";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

