/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.GoParserDefinition;
import com.goide.inspections.GoBuildTagInspection;
import com.goide.inspections.buildTag.GoBaseBuildLexer;
import com.goide.inspections.buildTag.GoBuildAndElement;
import com.goide.inspections.buildTag.GoBuildDirectiveOptions;
import com.goide.inspections.buildTag.GoBuildElement;
import com.goide.inspections.buildTag.GoBuildNotElement;
import com.goide.inspections.buildTag.GoBuildOrElement;
import com.goide.inspections.buildTag.GoBuildParElement;
import com.goide.inspections.buildTag.GoBuildTagElement;
import com.goide.inspections.buildTag.GoBuildTagUtil;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildAndElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildNotElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildOrElement;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildTagElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.GoUtil;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBuildDirectivePostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(1);
        }
        this.processText(source.getContainingFile(), source.getTextRange(), settings);
        PsiElement psiElement = source;
        if (psiElement == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile file, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (file == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(5);
        }
        if (!(file instanceof GoFile) || !rangeToReformat.equals((Object)file.getTextRange())) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        Project project = file.getProject();
        GoSdk sdk = GoSdkService.getInstance(project).getSdk(GoUtil.module((PsiElement)file));
        GoBuildDirectiveOptions options = sdk.getGoBuildDirectiveOptions();
        if (!options.isFormatGoBuildDirectives()) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        TextRange textRange = GoBuildDirectivePostFormatProcessor.canonicalize(project, settings, file, GoBuildDirectivePostFormatProcessor.shouldGeneratePlusBuildComments(file, options), null) ? file.getTextRange() : rangeToReformat;
        if (textRange == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    public static void canonicalize(@NotNull PsiComment goBuildDirective) {
        if (goBuildDirective == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(9);
        }
        PsiFile file = goBuildDirective.getContainingFile();
        GoBuildDirectivePostFormatProcessor.canonicalize(goBuildDirective.getProject(), CodeStyle.getSettings((PsiFile)file), file, true, goBuildDirective);
    }

    private static boolean canonicalize(@NotNull Project project, @NotNull CodeStyleSettings settings, @NotNull PsiFile file, boolean generateMissingPlusBuildComments, @Nullable PsiComment goBuildSourceOfTruth) {
        GoBuildElement sourceOfTruth;
        if (project == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(11);
        }
        if (file == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(12);
        }
        ArrayList<PsiComment> plusBuildComments = new ArrayList<PsiComment>();
        ArrayList<PsiComment> goBuildComments = new ArrayList<PsiComment>();
        GoBuildDirectivePostFormatProcessor.collectBuildCommentsInFile(file, plusBuildComments, goBuildComments);
        if (plusBuildComments.isEmpty() && goBuildComments.isEmpty()) {
            return false;
        }
        PsiElement anchor = GoBuildDirectivePostFormatProcessor.findAnchor(file, plusBuildComments, goBuildComments);
        if (anchor == null) {
            return false;
        }
        GoBuildElement goBuildElement = sourceOfTruth = goBuildSourceOfTruth != null && goBuildComments.contains(goBuildSourceOfTruth) ? GoBuildDirectivePostFormatProcessor.findSourceOfTruth(project, plusBuildComments, Collections.singletonList(goBuildSourceOfTruth)) : GoBuildDirectivePostFormatProcessor.findSourceOfTruth(project, plusBuildComments, goBuildComments);
        if (sourceOfTruth == null) {
            GoBuildDirectivePostFormatProcessor.copyCommentsBeforeAnchor(plusBuildComments, goBuildComments, anchor);
        } else {
            String formattedGoBuild = GoBuildDirectivePostFormatProcessor.formatGoBuildDirective(sourceOfTruth);
            if (formattedGoBuild == null) {
                return false;
            }
            GoPsiUtil.addLineCommentBefore(formattedGoBuild, anchor);
            if (!plusBuildComments.isEmpty() || generateMissingPlusBuildComments) {
                GoBuildDirectivePostFormatProcessor.generatePlusBuildComments(settings, sourceOfTruth, anchor);
            }
        }
        if (!(anchor instanceof PsiWhiteSpace)) {
            anchor.getParent().addBefore(GoElementFactory.createNewLine(project, 2), anchor);
        }
        goBuildComments.forEach(it -> GoBuildTagInspection.deleteCommentAndNextWhitespace((PsiElement)it));
        plusBuildComments.forEach(it -> GoBuildTagInspection.deleteCommentAndNextWhitespace((PsiElement)it));
        return true;
    }

    @Nullable
    private static GoBuildElement findSourceOfTruth(@NotNull Project project, @NotNull List<PsiComment> plusBuildComments, @NotNull List<PsiComment> goBuildComments) {
        if (project == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(13);
        }
        if (plusBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(14);
        }
        if (goBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(15);
        }
        if (goBuildComments.isEmpty()) {
            String goBuildExpression = GoBuildDirectivePostFormatProcessor.convertToGoBuildExpression(project, plusBuildComments);
            return goBuildExpression != null ? GoBuildTagUtil.parseGoBuildElement(project, goBuildExpression) : null;
        }
        if (goBuildComments.size() == 1) {
            return GoBuildTagUtil.parseGoBuildElement((PsiElement)goBuildComments.get(0));
        }
        return null;
    }

    private static void generatePlusBuildComments(@NotNull CodeStyleSettings settings, @NotNull GoBuildElement sourceOfTruth, @NotNull PsiElement anchor) {
        List<String> generated;
        if (settings == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(16);
        }
        if (sourceOfTruth == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(17);
        }
        if (anchor == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(18);
        }
        if ((generated = GoBuildTagUtil.getPlusBuildConstraintsForGoBuildDirective(sourceOfTruth)).isEmpty()) {
            generated = Collections.singletonList("error: expression too complex for // +build lines");
        }
        for (String plusBuild : generated) {
            GoPsiUtil.addLineCommentBefore(" +build " + plusBuild, anchor);
        }
    }

    private static void copyCommentsBeforeAnchor(@NotNull List<PsiComment> plusBuildComments, @NotNull List<PsiComment> goBuildComments, @NotNull PsiElement anchor) {
        if (plusBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(19);
        }
        if (goBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(20);
        }
        if (anchor == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(21);
        }
        for (PsiComment comment : goBuildComments) {
            GoPsiUtil.addLineCommentBefore(StringUtil.trimStart((String)comment.getText(), (String)"//"), anchor);
        }
        for (PsiComment comment : plusBuildComments) {
            GoPsiUtil.addLineCommentBefore(StringUtil.trimStart((String)comment.getText(), (String)"//"), anchor);
        }
    }

    public static boolean generateGoBuildDirective(@NotNull List<PsiComment> plusBuildComments) {
        if (plusBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(22);
        }
        if (plusBuildComments.isEmpty()) {
            return false;
        }
        String goBuildExpression = GoBuildDirectivePostFormatProcessor.convertToGoBuildExpression(plusBuildComments.get(0).getProject(), plusBuildComments);
        if (goBuildExpression != null) {
            GoPsiUtil.addLineCommentBefore("go:build " + goBuildExpression, (PsiElement)plusBuildComments.get(0));
            return true;
        }
        return false;
    }

    public static void collectBuildComments(@NotNull GoFile file, @NotNull List<PsiComment> plusBuildComments, @NotNull List<PsiComment> goBuildComments) {
        GoPackageClause pkg;
        if (file == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(23);
        }
        if (plusBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(24);
        }
        if (goBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(25);
        }
        if ((pkg = file.getPackage()) == null) {
            return;
        }
        for (PsiElement element : file.getChildren()) {
            if (element.getTextRange().getStartOffset() > pkg.getTextRange().getEndOffset()) break;
            if (!(element instanceof PsiComment)) continue;
            if (GoPsiUtil.isBuildTagComment(element)) {
                plusBuildComments.add((PsiComment)element);
                continue;
            }
            if (!GoPsiUtil.isGoBuildDirective(element)) continue;
            goBuildComments.add((PsiComment)element);
        }
    }

    private static void collectBuildCommentsInFile(@NotNull PsiFile file, @NotNull List<PsiComment> plusBuildComments, @NotNull List<PsiComment> goBuildComments) {
        if (file == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(26);
        }
        if (plusBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(27);
        }
        if (goBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(28);
        }
        for (PsiComment comment : SyntaxTraverser.psiTraverser((PsiElement)file).filter(PsiComment.class)) {
            if (GoPsiUtil.isBuildTagComment((PsiElement)comment)) {
                plusBuildComments.add(comment);
                continue;
            }
            if (!GoPsiUtil.isGoBuildDirective((PsiElement)comment)) continue;
            goBuildComments.add(comment);
        }
    }

    @Nullable
    public static String convertToGoBuildExpression(@NotNull Project project, @NotNull List<PsiComment> plusBuildComments) {
        if (project == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(29);
        }
        if (plusBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(30);
        }
        ArrayList<Object> converted = new ArrayList<Object>();
        for (PsiComment comment : plusBuildComments) {
            GoPlusBuildElement element = GoBuildDirectivePostFormatProcessor.parsePlusBuild(project, comment);
            String goBuildExpression = GoBuildDirectivePostFormatProcessor.convertToGoBuildExpression((PsiElement)element);
            if (goBuildExpression == null) {
                return null;
            }
            if (element instanceof GoPlusBuildOrElement && (element.getChildren().length == 1 || plusBuildComments.size() == 1)) {
                converted.add(goBuildExpression);
                continue;
            }
            converted.add("(" + goBuildExpression + ")");
        }
        return GoBuildDirectivePostFormatProcessor.formatGoBuildElement((PsiElement)GoBuildTagUtil.parseGoBuildElement(project, StringUtil.join(converted, (String)" && ")));
    }

    @Nullable
    private static GoPlusBuildElement parsePlusBuild(@NotNull Project project, PsiComment comment) {
        String text;
        String expression;
        GoPlusBuildElement result;
        if (project == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(31);
        }
        return (result = GoBuildTagUtil.parsePlusBuildElement(project, expression = StringUtil.trim((String)(text = StringUtil.trimLeading((String)StringUtil.trimStart((String)comment.getText(), (String)"//"))).substring("+build".length())))) != null ? result : GoBuildTagUtil.parsePlusBuildElement(project, GoBuildDirectivePostFormatProcessor.replaceErrorsWithIgnore(expression));
    }

    @NotNull
    private static String replaceErrorsWithIgnore(@NotNull String plusBuildExpression) {
        if (plusBuildExpression == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(32);
        }
        ArrayList<String> fixedParts = new ArrayList<String>();
        for (String part : StringUtil.split((String)plusBuildExpression, (String)" ")) {
            ArrayList<String> leaves = new ArrayList<String>();
            for (String term : StringUtil.split((String)part, (String)",")) {
                if (!GoBaseBuildLexer.isValidTag(StringUtil.trimStart((String)term, (String)"!"))) {
                    leaves.add("ignore");
                    continue;
                }
                leaves.add(term);
            }
            fixedParts.add(StringUtil.join(leaves, (String)","));
        }
        String string = StringUtil.join(fixedParts, (String)" ");
        if (string == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Nullable
    private static String convertToGoBuildExpression(@Nullable PsiElement e) {
        if (e instanceof GoPlusBuildTagElement) {
            GoPlusBuildTagElement tagElement = (GoPlusBuildTagElement)e;
            return tagElement.getTagText();
        }
        if (e instanceof GoPlusBuildNotElement) {
            String converted = GoBuildDirectivePostFormatProcessor.convertToGoBuildExpression(GoBuildDirectivePostFormatProcessor.getOnlyItem(e.getChildren()));
            return converted != null ? "!" + converted : null;
        }
        if (e instanceof GoPlusBuildAndElement) {
            PsiElement[] children = e.getChildren();
            List<String> converted = Arrays.stream(children).map(it -> GoBuildDirectivePostFormatProcessor.convertToGoBuildExpression(it)).filter(Objects::nonNull).toList();
            return converted.size() == children.length ? StringUtil.join(converted, (String)" && ") : null;
        }
        if (e instanceof GoPlusBuildOrElement) {
            PsiElement[] children = e.getChildren();
            List<String> converted = Arrays.stream(children).map(it -> GoBuildDirectivePostFormatProcessor.convertToGoBuildExpression(it)).filter(Objects::nonNull).toList();
            return converted.size() == children.length ? StringUtil.join(converted, (String)" || ") : null;
        }
        return null;
    }

    @Nullable
    private static String formatGoBuildDirective(@Nullable GoBuildElement e) {
        if (e == null || GoBuildDirectivePostFormatProcessor.containsErrors((PsiElement)e)) {
            return null;
        }
        String formatted = GoBuildDirectivePostFormatProcessor.formatGoBuildElement((PsiElement)e);
        return formatted != null ? "go:build " + formatted : null;
    }

    private static boolean containsErrors(@NotNull PsiElement element) {
        if (element == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(34);
        }
        return PsiTreeUtil.findChildOfType((PsiElement)element, PsiErrorElement.class) != null;
    }

    @Nullable
    public static String formatGoBuildElement(@Nullable PsiElement e) {
        if (e instanceof GoBuildTagElement) {
            return e.getText();
        }
        if (e instanceof GoBuildNotElement) {
            PsiElement loneChild = GoBuildDirectivePostFormatProcessor.unwrapParens(GoBuildDirectivePostFormatProcessor.getOnlyItem(e.getChildren()));
            String formattedChild = GoBuildDirectivePostFormatProcessor.formatGoBuildElement(loneChild);
            if (formattedChild == null) {
                return null;
            }
            return loneChild instanceof GoBuildTagElement ? "!" + formattedChild : "!(" + formattedChild + ")";
        }
        if (e instanceof GoBuildAndElement) {
            List<String> formattedChildren = GoBuildDirectivePostFormatProcessor.formatChildren(e, GoBuildOrElement.class);
            return formattedChildren != null ? StringUtil.join(formattedChildren, (String)" && ") : null;
        }
        if (e instanceof GoBuildOrElement) {
            List<String> formattedChildren = GoBuildDirectivePostFormatProcessor.formatChildren(e, GoBuildAndElement.class);
            return formattedChildren != null ? StringUtil.join(formattedChildren, (String)" || ") : null;
        }
        if (e instanceof GoBuildParElement) {
            return GoBuildDirectivePostFormatProcessor.formatGoBuildElement(GoBuildDirectivePostFormatProcessor.unwrapParens(e));
        }
        return null;
    }

    @Nullable
    private static PsiElement unwrapParens(@Nullable PsiElement e) {
        if (!(e instanceof GoBuildParElement)) {
            return e;
        }
        PsiElement result = GoBuildDirectivePostFormatProcessor.getOnlyItem(e.getChildren());
        while (result instanceof GoBuildParElement) {
            result = GoBuildDirectivePostFormatProcessor.getOnlyItem(result.getChildren());
        }
        return result;
    }

    @Nullable
    private static List<String> formatChildren(@NotNull PsiElement e, @NotNull Class<? extends GoBuildElement> needParens) {
        if (e == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(35);
        }
        if (needParens == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(36);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (PsiElement child : e.getChildren()) {
            String formatted = GoBuildDirectivePostFormatProcessor.formatGoBuildElement(child = GoBuildDirectivePostFormatProcessor.unwrapParens(child));
            if (formatted == null) {
                return null;
            }
            result.add((String)(needParens.isInstance(child) ? "(" + formatted + ")" : formatted));
        }
        return result;
    }

    @Nullable
    private static PsiElement getOnlyItem(PsiElement @NotNull [] array) {
        if (array == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(37);
        }
        return array.length == 1 ? array[0] : null;
    }

    @Nullable
    private static PsiElement findAnchor(@NotNull PsiFile file, @NotNull List<PsiComment> plusBuildComments, @NotNull List<PsiComment> goBuildComments) {
        if (file == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(38);
        }
        if (plusBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(39);
        }
        if (goBuildComments == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(40);
        }
        PsiElement result = null;
        for (PsiElement child : file.getChildren()) {
            if (child instanceof PsiWhiteSpace) {
                if (StringUtil.countChars((CharSequence)child.getText(), (char)'\n') <= 1) continue;
                PsiElement next = child.getNextSibling();
                result = next != null ? next : result;
                continue;
            }
            if (result == null) {
                result = child;
            }
            if (!GoBuildDirectivePostFormatProcessor.isLineComment(child)) break;
        }
        if (result == null) {
            return null;
        }
        if (!plusBuildComments.isEmpty() && plusBuildComments.get(0).getTextRange().getStartOffset() < result.getTextRange().getStartOffset()) {
            result = (PsiElement)plusBuildComments.get(0);
        }
        if (!goBuildComments.isEmpty() && goBuildComments.get(0).getTextRange().getStartOffset() < result.getTextRange().getStartOffset()) {
            result = (PsiElement)goBuildComments.get(0);
        }
        return result;
    }

    private static boolean isLineComment(@NotNull PsiElement e) {
        if (e == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(41);
        }
        return e instanceof PsiComment && ((PsiComment)e).getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT;
    }

    private static boolean shouldGeneratePlusBuildComments(@NotNull PsiFile file, @NotNull GoBuildDirectiveOptions options) {
        if (file == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(42);
        }
        if (options == null) {
            GoBuildDirectivePostFormatProcessor.$$$reportNull$$$0(43);
        }
        return options.isReportMissingPlusBuildTags(GoTargetSdkVersionProvider.getTargetGoSdkVersion((PsiElement)file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoBuildDirectivePostFormatProcessor";
                break;
            }
            case 3: 
            case 12: 
            case 23: 
            case 26: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goBuildDirective";
                break;
            }
            case 10: 
            case 13: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plusBuildComments";
                break;
            }
            case 15: 
            case 20: 
            case 25: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goBuildComments";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceOfTruth";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plusBuildExpression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needParens";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoBuildDirectivePostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceErrorsWithIgnore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 33: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "canonicalize";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSourceOfTruth";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "generatePlusBuildComments";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "copyCommentsBeforeAnchor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateGoBuildDirective";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectBuildComments";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectBuildCommentsInFile";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "convertToGoBuildExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parsePlusBuild";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "replaceErrorsWithIgnore";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "containsErrors";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "formatChildren";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyItem";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isLineComment";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "shouldGeneratePlusBuildComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 8, 33 -> new IllegalStateException(string);
        };
    }
}

