/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.table;

import com.goide.execution.GoRunUtil;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.execution.testing.table.GoTableTestDataEntry;
import com.goide.execution.testing.table.GoTableTestFunctionInfo;
import com.goide.execution.testing.table.GoTableTestRunInfo;
import com.goide.execution.testing.table.Opt;
import com.goide.inspections.fmtstring.GoFmtStringUtil;
import com.goide.inspections.fmtstring.parser.GoFmtStringParser;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringEscapedPercent;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringTextParsed;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoKey;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMapType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoExpressionEvaluator;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.util.GoCacheUtilKt;
import com.goide.util.GoStdlibUtil;
import com.goide.util.Value;
import com.goide.utils.GoStringUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.indexing.DumbModeAccessType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoTableTestUtil {
    @Nullable
    public static String getTableTestName(@NotNull GoFunctionOrMethodDeclaration func, @Nullable PsiElement element) {
        String funcName;
        if (func == null) {
            GoTableTestUtil.$$$reportNull$$$0(0);
        }
        if ((funcName = func.getName()) == null) {
            return null;
        }
        GoTableTestFunctionInfo tableTestInfo = null;
        GoValue goValue = (GoValue)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{GoValue.class});
        while (goValue != null) {
            String subtestName;
            if (tableTestInfo == null) {
                tableTestInfo = GoTableTestUtil.getTableTestInfo(func);
            }
            if ((subtestName = tableTestInfo.getFullTestNameByTestDataElement(goValue)) != null) {
                return subtestName;
            }
            goValue = (GoValue)PsiTreeUtil.getParentOfType((PsiElement)goValue, GoValue.class);
        }
        return null;
    }

    @NotNull
    public static GoTableTestFunctionInfo getTableTestInfo(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoTableTestUtil.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"go.evaluate.table.test.names")) {
            return new GoTableTestFunctionInfo();
        }
        GoTableTestFunctionInfo goTableTestFunctionInfo = (GoTableTestFunctionInfo)CachedValuesManager.getCachedValue((PsiElement)function, () -> GoCacheUtilKt.createStubIndexDependentResult(function.getProject(), (GoTableTestFunctionInfo)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> GoTableTestUtil.getTableTestInfoInner(function)), function));
        if (goTableTestFunctionInfo == null) {
            GoTableTestUtil.$$$reportNull$$$0(2);
        }
        return goTableTestFunctionInfo;
    }

    @VisibleForTesting
    @NotNull
    public static GoTableTestFunctionInfo getTableTestInfoInner(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoTableTestUtil.$$$reportNull$$$0(3);
        }
        GoTableTestFunctionInfo goTableTestFunctionInfo = (GoTableTestFunctionInfo)ProgressManager.getInstance().runProcess(() -> {
            GoTableTestFunctionInfo result = new GoTableTestFunctionInfo();
            if (!GoTableTestUtil.isTestFunc(function)) {
                return result;
            }
            for (GoCallExpr testRunCall : GoTableTestUtil.getTestRunCalls(function)) {
                ProgressManager.checkCanceled();
                result.addTestRun(testRunCall, GoTableTestUtil.getTableTestRunInfo(function, testRunCall));
            }
            return result;
        }, (ProgressIndicator)new EmptyProgressIndicator());
        if (goTableTestFunctionInfo == null) {
            GoTableTestUtil.$$$reportNull$$$0(4);
        }
        return goTableTestFunctionInfo;
    }

    @NotNull
    private static Opt<GoTableTestRunInfo> getTableTestRunInfo(@NotNull GoFunctionOrMethodDeclaration testFunction, @NotNull GoCallExpr testRunCall) {
        GoForStatement forStmt;
        String testFunctionName;
        if (testFunction == null) {
            GoTableTestUtil.$$$reportNull$$$0(5);
        }
        if (testRunCall == null) {
            GoTableTestUtil.$$$reportNull$$$0(6);
        }
        if ((testFunctionName = testFunction.getName()) == null) {
            Opt<GoTableTestRunInfo> opt = Opt.failure("Empty test function name");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(7);
            }
            return opt;
        }
        if (!testFunction.equals(PsiTreeUtil.getParentOfType((PsiElement)testRunCall, GoSignatureOwner.class))) {
            Opt<GoTableTestRunInfo> opt = Opt.failure("t.Run is not inside specified test function");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(8);
            }
            return opt;
        }
        GoExpression testNameExpression = (GoExpression)ContainerUtil.getFirstItem(testRunCall.getArgumentList().getExpressionList());
        if (testNameExpression == null) {
            Opt<GoTableTestRunInfo> opt = Opt.failure("Test run call has no test name expression");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(9);
            }
            return opt;
        }
        GoLeftHandExprList lhs = (GoLeftHandExprList)ObjectUtils.tryCast((Object)testRunCall.getParent(), GoLeftHandExprList.class);
        GoSimpleStatement testRunStmt = lhs != null ? (GoSimpleStatement)ObjectUtils.tryCast((Object)lhs.getParent(), GoSimpleStatement.class) : null;
        GoBlock block = testRunStmt != null ? (GoBlock)ObjectUtils.tryCast((Object)testRunStmt.getParent(), GoBlock.class) : null;
        GoForStatement goForStatement = forStmt = block != null ? (GoForStatement)ObjectUtils.tryCast((Object)block.getParent(), GoForStatement.class) : null;
        if (forStmt == null) {
            Opt<GoTableTestRunInfo> opt = Opt.failure("t.Run is not inside for loop");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(10);
            }
            return opt;
        }
        GoRangeClause rangeClause = forStmt.getRangeClause();
        if (rangeClause == null) {
            Opt<GoTableTestRunInfo> opt = Opt.failure("t.Run is not inside for range loop");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(11);
            }
            return opt;
        }
        ProgressManager.checkCanceled();
        Opt<CompLitVal> testData = GoTableTestUtil.getTestDataLiteral(testFunction, forStmt, rangeClause);
        if (testData.isFailed()) {
            Opt<GoTableTestRunInfo> opt = Opt.failure(testData.getFailureReason());
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(12);
            }
            return opt;
        }
        ProgressManager.checkCanceled();
        ArrayList<String> keyVarNames = new ArrayList<String>();
        ArrayList<String> valueVarNames = new ArrayList<String>();
        String failureReason = GoTableTestUtil.fillRangeVarNames(block, rangeClause, testRunCall, keyVarNames, valueVarNames);
        if (failureReason != null) {
            Opt<GoTableTestRunInfo> opt = Opt.failure(failureReason);
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(13);
            }
            return opt;
        }
        ProgressManager.checkCanceled();
        if (PsiTreeUtil.hasErrorElements((PsiElement)testNameExpression)) {
            Opt<GoTableTestRunInfo> opt = Opt.failure("Test name expression with parse errors");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(14);
            }
            return opt;
        }
        ExpandPlan plan = GoTableTestUtil.buildExpandPlan(testNameExpression, ContainerUtil.union(keyVarNames, valueVarNames));
        if (plan.isEmpty()) {
            Opt<GoTableTestRunInfo> opt = Opt.failure("Cannot evaluate test name expression");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(15);
            }
            return opt;
        }
        GoTableTestRunInfo testRunInfo = new GoTableTestRunInfo();
        CompLitVal testDataLiteral = testData.getValue();
        Object2IntOpenHashMap testNameCount = new Object2IntOpenHashMap();
        HashSet<String> uniqueTestNames = new HashSet<String>();
        HashSet<String> duplicateTestNames = new HashSet<String>();
        ArrayList testDataEntries = new ArrayList();
        for (IndexedCompLitEntry indexedCompLitEntry : testDataLiteral.getIndexedEntries()) {
            ProgressManager.checkCanceled();
            HashMap<String, Val> env = new HashMap<String, Val>();
            keyVarNames.forEach(name -> env.put((String)name, indexedCompLitEntry.getKey()));
            valueVarNames.forEach(name -> env.put((String)name, indexedCompLitEntry.getValue()));
            String testName = GoTableTestUtil.evalTableTestName(plan, testRunCall, env);
            GoValue value = indexedCompLitEntry.getElement().getValue();
            if (testName != null && value != null) {
                String sanitizedName = GoRunUtil.sanitizeTestName(testName);
                String fullName = GoRunUtil.uniqueTestName(sanitizedName, testFunctionName, (Object2IntMap<String>)testNameCount);
                if (!testDataLiteral.isStableEntriesOrder()) {
                    if (!uniqueTestNames.add(fullName)) {
                        duplicateTestNames.add(fullName);
                    }
                    testNameCount.clear();
                }
                testDataEntries.add(Opt.success(new GoTableTestDataEntry(sanitizedName, fullName, value)));
                continue;
            }
            if (testName == null) {
                testDataEntries.add(Opt.failure("Cannot evaluate test name expression"));
                continue;
            }
            testDataEntries.add(Opt.failure("Cannot find test data element"));
        }
        for (Opt opt : testDataEntries) {
            if (!opt.isFailed() && duplicateTestNames.contains(((GoTableTestDataEntry)opt.getValue()).getTestFullName())) {
                testRunInfo.addTestData(Opt.failure("Cannot compute unique test name"));
                continue;
            }
            testRunInfo.addTestData(opt);
        }
        Opt<GoTableTestRunInfo> opt = Opt.success(testRunInfo);
        if (opt == null) {
            GoTableTestUtil.$$$reportNull$$$0(16);
        }
        return opt;
    }

    private static String fillRangeVarNames(@NotNull GoBlock forStmtBlock, @NotNull GoRangeClause rangeClause, @NotNull GoCallExpr testRunCall, @NotNull List<String> keyVarNames, @NotNull List<String> valueVarNames) {
        if (forStmtBlock == null) {
            GoTableTestUtil.$$$reportNull$$$0(17);
        }
        if (rangeClause == null) {
            GoTableTestUtil.$$$reportNull$$$0(18);
        }
        if (testRunCall == null) {
            GoTableTestUtil.$$$reportNull$$$0(19);
        }
        if (keyVarNames == null) {
            GoTableTestUtil.$$$reportNull$$$0(20);
        }
        if (valueVarNames == null) {
            GoTableTestUtil.$$$reportNull$$$0(21);
        }
        TextRange rangeBeforeTestRunCall = TextRange.create((int)forStmtBlock.getTextRange().getStartOffset(), (int)testRunCall.getTextRange().getStartOffset());
        List<GoVarDefinition> rangeVars = rangeClause.getVarDefinitionList();
        for (int i = 0; i < rangeVars.size() && i < 2; ++i) {
            GoVarDefinition rangeVar = rangeVars.get(i);
            List<String> names = i == 0 ? keyVarNames : valueVarNames;
            String rangeVarName = rangeVar.getName();
            if (rangeVar.isBlank() || rangeVarName == null) continue;
            names.add(rangeVarName);
            Collection usages = GoReferencesSearch.search(rangeVar, (SearchScope)new LocalSearchScope((PsiElement)forStmtBlock)).filtering(it -> rangeBeforeTestRunCall.contains(it.getElement().getTextRange().getStartOffset())).findAll();
            HashSet<GoVarDefinition> reassigns = new HashSet<GoVarDefinition>();
            for (PsiReference usage : usages) {
                if (GoTableTestUtil.isAssignToBlank(usage)) continue;
                GoVarDefinition reassign = GoTableTestUtil.getReassign(usage);
                if (reassign != null) {
                    reassigns.add(reassign);
                    if (reassign.isBlank()) continue;
                    if (GoTableTestUtil.hasUsages((SearchScope)new LocalSearchScope((PsiElement)forStmtBlock), reassign, rangeBeforeTestRunCall)) {
                        return "Loop var usage before t.Run call";
                    }
                    String name = reassign.getName();
                    if (name == null) continue;
                    names.add(name);
                    continue;
                }
                return "Loop var usage before t.Run call";
            }
            JBIterable definitions = SyntaxTraverser.psiTraverser((PsiElement)forStmtBlock).onRange(rangeBeforeTestRunCall).filter(GoVarDefinition.class);
            for (GoVarDefinition definition : definitions) {
                if (definition.isBlank() || !rangeVarName.equals(definition.getName()) || reassigns.contains(definition)) continue;
                return "Loop var redefinition";
            }
        }
        return null;
    }

    private static boolean isAssignToBlank(@NotNull PsiReference usage) {
        PsiElement usageElement;
        if (usage == null) {
            GoTableTestUtil.$$$reportNull$$$0(22);
        }
        if (!((usageElement = usage.getElement()) instanceof GoExpression)) {
            return false;
        }
        GoAssignmentStatement assignStmt = (GoAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)usageElement, GoAssignmentStatement.class);
        if (assignStmt == null) {
            return false;
        }
        GoExpression expr = GoPsiUtil.getCorrespondingLeftExpr((GoExpression)usageElement, assignStmt.getExpressionList(), assignStmt.getLeftHandExprList().getExpressionList());
        return GoExpressionUtil.isBlankGoReferenceExpression(expr);
    }

    @Nullable
    private static GoVarDefinition getReassign(@NotNull PsiReference usage) {
        PsiElement usageElement;
        GoVarSpec spec;
        if (usage == null) {
            GoTableTestUtil.$$$reportNull$$$0(23);
        }
        if ((spec = (GoVarSpec)PsiTreeUtil.getParentOfType((PsiElement)(usageElement = usage.getElement()), GoVarSpec.class)) == null || !(usageElement instanceof GoExpression)) {
            return null;
        }
        return GoPsiUtil.getCorrespondingLeftExpr((GoExpression)usageElement, spec.getExpressionList(), spec.getDefinitionList());
    }

    @NotNull
    private static Opt<CompLitVal> getTestDataLiteral(@NotNull GoFunctionOrMethodDeclaration testFunction, @NotNull GoForStatement forStmt, @NotNull GoRangeClause rangeClause) {
        GoCompositeLit testDataLiteral;
        GoExpression rangeExpr;
        if (testFunction == null) {
            GoTableTestUtil.$$$reportNull$$$0(24);
        }
        if (forStmt == null) {
            GoTableTestUtil.$$$reportNull$$$0(25);
        }
        if (rangeClause == null) {
            GoTableTestUtil.$$$reportNull$$$0(26);
        }
        if ((rangeExpr = rangeClause.getRangeExpression()) instanceof GoCompositeLit) {
            testDataLiteral = (GoCompositeLit)rangeExpr;
        } else if (rangeExpr instanceof GoReferenceExpression) {
            GoVarDefinition testDataVar = (GoVarDefinition)ObjectUtils.tryCast((Object)((GoReferenceExpression)rangeExpr).getReference().resolve(), GoVarDefinition.class);
            if (testDataVar == null) {
                Opt<CompLitVal> opt = Opt.failure("Cannot resolve loop range expression to composite literal var");
                if (opt == null) {
                    GoTableTestUtil.$$$reportNull$$$0(27);
                }
                return opt;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)testDataVar, GoFunctionOrMethodDeclaration.class) != testFunction) {
                Opt<CompLitVal> opt = Opt.failure("Test data var is not in the test function");
                if (opt == null) {
                    GoTableTestUtil.$$$reportNull$$$0(28);
                }
                return opt;
            }
            GoExpression varExpr = testDataVar.findExpression();
            if (varExpr == null) {
                Opt<CompLitVal> opt = Opt.failure("Test data var is not initialized during definition");
                if (opt == null) {
                    GoTableTestUtil.$$$reportNull$$$0(29);
                }
                return opt;
            }
            if (!(varExpr instanceof GoCompositeLit)) {
                Opt<CompLitVal> opt = Opt.failure("Test data var expression is not a composite literal");
                if (opt == null) {
                    GoTableTestUtil.$$$reportNull$$$0(30);
                }
                return opt;
            }
            TextRange betweenVarAndLoop = TextRange.create((int)varExpr.getTextRange().getEndOffset(), (int)forStmt.getTextRange().getStartOffset());
            if (GoTableTestUtil.hasUsages((SearchScope)new LocalSearchScope((PsiElement)testFunction), testDataVar, betweenVarAndLoop)) {
                Opt<CompLitVal> opt = Opt.failure("Test data var usage before for loop");
                if (opt == null) {
                    GoTableTestUtil.$$$reportNull$$$0(31);
                }
                return opt;
            }
            testDataLiteral = (GoCompositeLit)varExpr;
        } else {
            Opt<CompLitVal> opt = Opt.failure("Cannot resolve loop range expression to composite literal");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(32);
            }
            return opt;
        }
        CompLitVal val = GoTableTestUtil.getValue(testDataLiteral.getLiteralValue(), testDataLiteral.getType());
        if (val == null) {
            Opt<CompLitVal> opt = Opt.failure("Failed to evaluate test data composite literal");
            if (opt == null) {
                GoTableTestUtil.$$$reportNull$$$0(33);
            }
            return opt;
        }
        Opt<CompLitVal> opt = Opt.success(val);
        if (opt == null) {
            GoTableTestUtil.$$$reportNull$$$0(34);
        }
        return opt;
    }

    private static boolean hasUsages(@NotNull SearchScope scope, @NotNull GoVarDefinition var, @NotNull TextRange range) {
        if (scope == null) {
            GoTableTestUtil.$$$reportNull$$$0(35);
        }
        if (var == null) {
            GoTableTestUtil.$$$reportNull$$$0(36);
        }
        if (range == null) {
            GoTableTestUtil.$$$reportNull$$$0(37);
        }
        return GoReferencesSearch.search(var, scope).filtering(it -> range.contains(it.getElement().getTextRange().getStartOffset())).findFirst() != null;
    }

    @Nullable
    private static String evalTableTestName(@NotNull ExpandPlan plan, @NotNull GoCallExpr testRunCall, @NotNull Map<String, Val> env) {
        if (plan == null) {
            GoTableTestUtil.$$$reportNull$$$0(38);
        }
        if (testRunCall == null) {
            GoTableTestUtil.$$$reportNull$$$0(39);
        }
        if (env == null) {
            GoTableTestUtil.$$$reportNull$$$0(40);
        }
        String expandedText = plan.expand(env);
        GoExpression updatedExpr = GoElementFactory.createExpression(testRunCall.getProject(), expandedText, testRunCall);
        Value<?> testNameValue = GoExpressionEvaluator.evaluateExpression(updatedExpr);
        if (testNameValue != null) {
            return testNameValue.getString();
        }
        return null;
    }

    @Nullable
    private static Val getValue(@Nullable GoExpression expr) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof GoCompositeLit) {
            return GoTableTestUtil.getValue(((GoCompositeLit)expr).getLiteralValue(), ((GoCompositeLit)expr).getType());
        }
        Value value = expr.getValue();
        return value != null ? new EvaluatedExpr(expr, value) : null;
    }

    @Nullable
    private static CompLitVal getValue(@Nullable GoLiteralValue compLitValue, @Nullable GoType type) {
        GoType underlyingType;
        GoType goType = underlyingType = compLitValue != null && type != null ? type.getUnderlyingType(compLitValue) : null;
        if (underlyingType == null) {
            return null;
        }
        if (underlyingType instanceof GoArrayOrSliceType) {
            return GoTableTestUtil.getSliceLiteral(compLitValue, (GoArrayOrSliceType)underlyingType);
        }
        if (underlyingType instanceof GoMapType) {
            return GoTableTestUtil.getMapLiteral(compLitValue, (GoMapType)underlyingType);
        }
        if (underlyingType instanceof GoStructType) {
            return GoTableTestUtil.getStructLiteral(compLitValue, (GoStructType)underlyingType);
        }
        return null;
    }

    @NotNull
    private static CompLitVal getSliceLiteral(@NotNull GoLiteralValue compLitValue, @NotNull GoArrayOrSliceType type) {
        if (compLitValue == null) {
            GoTableTestUtil.$$$reportNull$$$0(41);
        }
        if (type == null) {
            GoTableTestUtil.$$$reportNull$$$0(42);
        }
        CompLitVal result = new CompLitVal(true);
        GoType elementType = type.getType();
        List<GoElement> elements = compLitValue.getElementList();
        for (int i = 0; i < elements.size(); ++i) {
            Val elementVal;
            GoElement element = elements.get(i);
            GoValue elementValue = element.getValue();
            if (elementValue == null) continue;
            GoLiteralValue literalValue = elementValue.getLiteralValue();
            Val val = elementVal = literalValue != null ? GoTableTestUtil.getValue(literalValue, elementType) : GoTableTestUtil.getValue(elementValue.getExpression());
            if (elementVal == null) continue;
            GoKey key = element.getKey();
            if (key != null) {
                GoExpression keyExpr = key.getExpression();
                Value keyValue = key.getValue();
                if (keyExpr == null || keyValue == null) continue;
                result.addKeyVal(element, new EvaluatedExpr(keyExpr, keyValue), elementVal);
                continue;
            }
            result.addKeyVal(element, new EvaluatedExpr(i), elementVal);
        }
        CompLitVal compLitVal = result;
        if (compLitVal == null) {
            GoTableTestUtil.$$$reportNull$$$0(43);
        }
        return compLitVal;
    }

    @NotNull
    private static CompLitVal getMapLiteral(@NotNull GoLiteralValue compLitValue, @NotNull GoMapType type) {
        if (compLitValue == null) {
            GoTableTestUtil.$$$reportNull$$$0(44);
        }
        if (type == null) {
            GoTableTestUtil.$$$reportNull$$$0(45);
        }
        CompLitVal result = new CompLitVal();
        for (GoElement element : compLitValue.getElementList()) {
            GoKey key;
            GoValue elementValue = element.getValue();
            if (elementValue == null) continue;
            GoType valueType = type.getValueType();
            GoLiteralValue literalValue = elementValue.getLiteralValue();
            Val elementVal = literalValue != null ? GoTableTestUtil.getValue(literalValue, valueType) : GoTableTestUtil.getValue(elementValue.getExpression());
            if (elementVal == null || (key = element.getKey()) == null) continue;
            GoExpression keyExpr = key.getExpression();
            Value keyValue = key.getValue();
            if (keyValue == null || keyExpr == null) continue;
            result.addKeyVal(element, new EvaluatedExpr(keyExpr, keyValue), elementVal);
        }
        CompLitVal compLitVal = result;
        if (compLitVal == null) {
            GoTableTestUtil.$$$reportNull$$$0(46);
        }
        return compLitVal;
    }

    @NotNull
    private static CompLitVal getStructLiteral(@NotNull GoLiteralValue compLitValue, @NotNull GoStructType type) {
        if (compLitValue == null) {
            GoTableTestUtil.$$$reportNull$$$0(47);
        }
        if (type == null) {
            GoTableTestUtil.$$$reportNull$$$0(48);
        }
        CompLitVal result = new CompLitVal();
        List<GoNamedElement> fields = type.getFieldDefinitions();
        List<GoElement> elements = compLitValue.getElementList();
        for (int i = 0; i < elements.size(); ++i) {
            Val elementVal;
            GoExpression expression;
            GoElement element = elements.get(i);
            GoValue elementValue = element.getValue();
            if (elementValue == null) continue;
            GoNamedElement field = null;
            GoKey key = element.getKey();
            if (key != null) {
                GoFieldName fieldName = key.getFieldName();
                if (fieldName != null) {
                    field = (GoNamedElement)ObjectUtils.tryCast((Object)fieldName.getReference().resolve(), GoFieldDefinition.class);
                }
            } else {
                GoNamedElement goNamedElement = field = i < fields.size() ? fields.get(i) : null;
            }
            if (field == null) continue;
            GoLiteralValue literalValue = elementValue.getLiteralValue();
            if (literalValue == null && (expression = elementValue.getExpression()) instanceof GoCompositeLit) {
                literalValue = ((GoCompositeLit)expression).getLiteralValue();
            }
            Val val = elementVal = literalValue != null ? GoTableTestUtil.getValue(literalValue, field.getGoType(ResolveState.initial())) : GoTableTestUtil.getValue(elementValue.getExpression());
            if (elementVal == null) continue;
            result.addFieldVal(field.getName(), elementVal, element);
        }
        CompLitVal compLitVal = result;
        if (compLitVal == null) {
            GoTableTestUtil.$$$reportNull$$$0(49);
        }
        return compLitVal;
    }

    private static boolean isTestFunc(@Nullable GoFunctionOrMethodDeclaration func) {
        return func != null && GoTestFinder.isTestFile((PsiFile)func.getContainingFile()) && GoTestFunctionType.fromName(func.getName()) == GoTestFunctionType.TEST;
    }

    @NotNull
    private static List<GoCallExpr> getTestRunCalls(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoTableTestUtil.$$$reportNull$$$0(50);
        }
        List list = ((SyntaxTraverser)((SyntaxTraverser)GoPsiTreeUtil.goTraverser().regard(GoRunUtil::isRunTestCall)).withRoot((Object)function)).traverse(TreeTraversal.PRE_ORDER_DFS).filter(GoCallExpr.class).toList();
        if (list == null) {
            GoTableTestUtil.$$$reportNull$$$0(51);
        }
        return list;
    }

    @NotNull
    private static ExpandPlan buildExpandPlan(@NotNull GoExpression expression, @NotNull Set<String> env) {
        if (expression == null) {
            GoTableTestUtil.$$$reportNull$$$0(52);
        }
        if (env == null) {
            GoTableTestUtil.$$$reportNull$$$0(53);
        }
        ExpandPlan result = new ExpandPlan();
        ArrayList<Pair> varAccesses = new ArrayList<Pair>();
        for (GoExpression e : SyntaxTraverser.psiTraverser((PsiElement)expression).bfsTraversal().filter(GoExpression.class)) {
            ExpandPlanEntry varAccess;
            TextRange range = e.getTextRange();
            if (ContainerUtil.find(varAccesses, it -> ((TextRange)it.first).contains(range)) != null || (varAccess = GoTableTestUtil.getAccessPath(e, env)) == null) continue;
            varAccesses.add(Pair.create((Object)range, (Object)varAccess));
        }
        Collections.sort(varAccesses, Comparator.comparingInt(it -> ((TextRange)it.first).getStartOffset()));
        TextRange expressionRange = expression.getTextRange();
        int prevEnd = 0;
        String expressionText = expression.getText();
        for (Pair access : varAccesses) {
            TextRange range = ((TextRange)access.first).shiftLeft(expressionRange.getStartOffset());
            if (range.getStartOffset() > prevEnd) {
                result.addEntry(new ExpandPlanEntryVerbatim(expressionText.substring(prevEnd, range.getStartOffset())));
            }
            result.addEntry((ExpandPlanEntry)access.second);
            prevEnd = range.getEndOffset();
        }
        if (prevEnd < expressionRange.getLength()) {
            result.addEntry(new ExpandPlanEntryVerbatim(expressionText.substring(prevEnd, expressionRange.getLength())));
        }
        ExpandPlan expandPlan = result;
        if (expandPlan == null) {
            GoTableTestUtil.$$$reportNull$$$0(54);
        }
        return expandPlan;
    }

    @Nullable
    private static ExpandPlanEntry getAccessPath(@NotNull GoExpression e, @NotNull Set<String> env) {
        if (e == null) {
            GoTableTestUtil.$$$reportNull$$$0(55);
        }
        if (env == null) {
            GoTableTestUtil.$$$reportNull$$$0(56);
        }
        if (e instanceof GoCallExpr) {
            return GoStdlibUtil.isStdLibCall((GoCallExpr)e, "fmt", "Sprintf") ? GoTableTestUtil.buildSprintfExpandPlan((GoCallExpr)e, env) : null;
        }
        if (e instanceof GoReferenceExpression || e instanceof GoIndexOrSliceExpr) {
            PsiElement identifier;
            ArrayList<Access> accessPathReversed;
            block9: {
                block10: {
                    accessPathReversed = new ArrayList<Access>();
                    GoQualifier elem = e;
                    while (true) {
                        if (elem instanceof GoReferenceExpression) {
                            identifier = ((GoReferenceExpression)elem).getIdentifier();
                            GoQualifier qualifier = ((GoReferenceExpression)elem).getQualifier();
                            if (qualifier != null) {
                                accessPathReversed.add(new AccessField(identifier.getText()));
                                elem = qualifier;
                                continue;
                            }
                            break block9;
                        }
                        if (!(elem instanceof GoIndexOrSliceExpr)) break block10;
                        Trinity<GoExpression, GoExpression, GoExpression> indices = ((GoIndexOrSliceExpr)elem).getIndices();
                        Value<?> value = null;
                        if (indices.first != null && indices.second == null && indices.third == null) {
                            value = GoExpressionEvaluator.evaluateExpression((GoExpression)indices.first);
                        }
                        if (value == null) break;
                        accessPathReversed.add(new AccessKey(new EvaluatedExpr((GoExpression)indices.first, value)));
                        elem = ((GoIndexOrSliceExpr)elem).getExpression();
                    }
                    return null;
                }
                return null;
            }
            String leftMostIdentifier = identifier.getText();
            if (env.contains(leftMostIdentifier)) {
                Collections.reverse(accessPathReversed);
                return new ExpandPlanEntryAccessPath(e.getText(), leftMostIdentifier, accessPathReversed);
            }
        }
        return null;
    }

    @Nullable
    private static ExpandPlanEntrySprintf buildSprintfExpandPlan(@NotNull GoCallExpr sprintfCall, @NotNull Set<String> env) {
        String format;
        if (sprintfCall == null) {
            GoTableTestUtil.$$$reportNull$$$0(57);
        }
        if (env == null) {
            GoTableTestUtil.$$$reportNull$$$0(58);
        }
        Project project = sprintfCall.getProject();
        List<GoExpression> arguments = sprintfCall.getArgumentList().getExpressionList();
        GoExpression formatArg = (GoExpression)ContainerUtil.getFirstItem(arguments);
        String string = format = formatArg != null ? GoFmtStringUtil.getStringValue(formatArg) : null;
        if (format == null) {
            return null;
        }
        ExpandPlanEntrySprintf result = new ExpandPlanEntrySprintf(sprintfCall.getText());
        List<GoFmtStringToken> tokens = GoFmtStringParser.parse(format, true);
        int argIndex = 1;
        for (GoFmtStringToken token : tokens) {
            if (token instanceof GoFmtStringEscapedPercent || token instanceof GoFmtStringTextParsed) {
                result.addTextFragment(token.getText());
                continue;
            }
            if (token instanceof GoFmtStringPlaceholder) {
                boolean isSupported;
                GoExpression arg;
                GoFmtStringPlaceholder placeholder = (GoFmtStringPlaceholder)token;
                if ((arg = GoTableTestUtil.getNth(arguments, argIndex++)) == null) {
                    return null;
                }
                ExpandPlan argPlan = GoTableTestUtil.buildExpandPlan(arg, env);
                char verb = placeholder.getVerb();
                boolean bl = isSupported = placeholder.getWidth() == null && placeholder.getPrecision() == null && placeholder.getVerbIndex() == null && (verb == 'd' || verb == 's');
                if (isSupported) {
                    result.addPlaceholderFragment(project, argPlan, verb);
                    continue;
                }
                return null;
            }
            return null;
        }
        return result;
    }

    @Nullable
    private static <T> T getNth(@NotNull List<T> list, int n) {
        if (list == null) {
            GoTableTestUtil.$$$reportNull$$$0(59);
        }
        return n < list.size() ? (T)list.get(n) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 27, 28, 29, 30, 31, 32, 33, 34, 43, 46, 49, 51, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 1: 
            case 3: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 46: 
            case 49: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/table/GoTableTestUtil";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFunction";
                break;
            }
            case 6: 
            case 19: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunCall";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStmtBlock";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeClause";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyVarNames";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueVarNames";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStmt";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
            case 40: 
            case 53: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 41: 
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compLitValue";
                break;
            }
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sprintfCall";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableTestInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableTestInfoInner";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableTestRunInfo";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataLiteral";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getSliceLiteral";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapLiteral";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getStructLiteral";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRunCalls";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExpandPlan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTableTestName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTableTestInfo";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 43: 
            case 46: 
            case 49: 
            case 51: 
            case 54: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTableTestInfoInner";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTableTestRunInfo";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fillRangeVarNames";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isAssignToBlank";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getReassign";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTestDataLiteral";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "hasUsages";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "evalTableTestName";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSliceLiteral";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getMapLiteral";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getStructLiteral";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTestRunCalls";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "buildExpandPlan";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getAccessPath";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "buildSprintfExpandPlan";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getNth";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 27, 28, 29, 30, 31, 32, 33, 34, 43, 46, 49, 51, 54 -> new IllegalStateException(string);
        };
    }

    private static class ExpandPlan {
        private final List<ExpandPlanEntry> myEntries = new ArrayList<ExpandPlanEntry>();

        private ExpandPlan() {
        }

        void addEntry(@NotNull ExpandPlanEntry entry) {
            if (entry == null) {
                ExpandPlan.$$$reportNull$$$0(0);
            }
            this.myEntries.add(entry);
        }

        @NotNull
        String expand(@NotNull Map<String, Val> env) {
            if (env == null) {
                ExpandPlan.$$$reportNull$$$0(1);
            }
            StringBuilder result = new StringBuilder();
            for (ExpandPlanEntry entry : this.myEntries) {
                String expanded = entry.expand(env);
                result.append(expanded != null ? expanded : entry.getOriginalText());
            }
            String string = result.toString();
            if (string == null) {
                ExpandPlan.$$$reportNull$$$0(2);
            }
            return string;
        }

        boolean isEmpty() {
            return ContainerUtil.find(this.myEntries, it -> !(it instanceof ExpandPlanEntryVerbatim)) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/testing/table/GoTableTestUtil$ExpandPlan";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$ExpandPlan";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "expand";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class CompLitVal
    extends Val {
        private final boolean myStableEntriesOrder;
        private final Map<Value<?>, IndexedCompLitEntry> myKeyVals = new LinkedHashMap();
        private final Map<String, Pair<Val, GoElement>> myFields = new HashMap<String, Pair<Val, GoElement>>();

        private CompLitVal() {
            this(false);
        }

        private CompLitVal(boolean stableEntriesOrder) {
            this.myStableEntriesOrder = stableEntriesOrder;
        }

        private boolean isStableEntriesOrder() {
            return this.myStableEntriesOrder;
        }

        void addKeyVal(@NotNull GoElement element, @NotNull EvaluatedExpr key, @NotNull Val value) {
            if (element == null) {
                CompLitVal.$$$reportNull$$$0(0);
            }
            if (key == null) {
                CompLitVal.$$$reportNull$$$0(1);
            }
            if (value == null) {
                CompLitVal.$$$reportNull$$$0(2);
            }
            this.myKeyVals.put(key.getValue(), new IndexedCompLitEntry(element, key, value));
        }

        @Nullable
        Val getKeyVal(@Nullable Value<?> keyValue) {
            if (keyValue == null) {
                return null;
            }
            IndexedCompLitEntry entry = this.myKeyVals.get(keyValue);
            return entry != null ? entry.getValue() : null;
        }

        @NotNull
        private Collection<IndexedCompLitEntry> getIndexedEntries() {
            Collection<IndexedCompLitEntry> collection = this.myKeyVals.values();
            if (collection == null) {
                CompLitVal.$$$reportNull$$$0(3);
            }
            return collection;
        }

        void addFieldVal(@Nullable String fieldName, @NotNull Val val, @NotNull GoElement element) {
            if (val == null) {
                CompLitVal.$$$reportNull$$$0(4);
            }
            if (element == null) {
                CompLitVal.$$$reportNull$$$0(5);
            }
            if (fieldName != null) {
                this.myFields.put(fieldName, (Pair<Val, GoElement>)Pair.create((Object)val, (Object)element));
            }
        }

        @Nullable
        Val getFieldVal(@NotNull String fieldName) {
            Pair<Val, GoElement> pair;
            if (fieldName == null) {
                CompLitVal.$$$reportNull$$$0(6);
            }
            return (pair = this.myFields.get(fieldName)) != null ? (Val)pair.first : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/testing/table/GoTableTestUtil$CompLitVal";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$CompLitVal";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexedEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addKeyVal";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addFieldVal";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFieldVal";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class IndexedCompLitEntry {
        private final GoElement myElement;
        private final EvaluatedExpr myKey;
        private final Val myValue;

        private IndexedCompLitEntry(@NotNull GoElement element, @NotNull EvaluatedExpr key, @NotNull Val value) {
            if (element == null) {
                IndexedCompLitEntry.$$$reportNull$$$0(0);
            }
            if (key == null) {
                IndexedCompLitEntry.$$$reportNull$$$0(1);
            }
            if (value == null) {
                IndexedCompLitEntry.$$$reportNull$$$0(2);
            }
            this.myElement = element;
            this.myKey = key;
            this.myValue = value;
        }

        private GoElement getElement() {
            return this.myElement;
        }

        private EvaluatedExpr getKey() {
            return this.myKey;
        }

        private Val getValue() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/table/GoTableTestUtil$IndexedCompLitEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EvaluatedExpr
    extends Val {
        private final GoExpression myExpr;
        private final Value<?> myValue;
        private final int myIntVal;

        private EvaluatedExpr(@NotNull GoExpression expr, @NotNull Value<?> value) {
            if (expr == null) {
                EvaluatedExpr.$$$reportNull$$$0(0);
            }
            if (value == null) {
                EvaluatedExpr.$$$reportNull$$$0(1);
            }
            this.myExpr = expr;
            this.myValue = value;
            this.myIntVal = 0;
        }

        private EvaluatedExpr(int val) {
            this.myExpr = null;
            this.myValue = null;
            this.myIntVal = val;
        }

        @Override
        @NotNull
        Value<?> getValue() {
            Value<Object> value = this.myValue != null ? this.myValue : Value.of(this.myIntVal);
            if (value == null) {
                EvaluatedExpr.$$$reportNull$$$0(2);
            }
            return value;
        }

        @NotNull
        String getGoExprText() {
            if (this.myExpr != null) {
                assert (this.myValue != null);
                String s = this.myValue.getString();
                if (s != null && !s.contains("`")) {
                    String string = "`" + s + "`";
                    if (string == null) {
                        EvaluatedExpr.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                Boolean b = this.myValue.getBool();
                if (b != null) {
                    String string = String.valueOf(b);
                    if (string == null) {
                        EvaluatedExpr.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String string = "(" + this.myExpr.getText() + ")";
                if (string == null) {
                    EvaluatedExpr.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = String.valueOf(this.myIntVal);
            if (string == null) {
                EvaluatedExpr.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/testing/table/GoTableTestUtil$EvaluatedExpr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$EvaluatedExpr";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGoExprText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class Val {
        private Val() {
        }

        @Nullable
        Value<?> getValue() {
            return null;
        }
    }

    private static class ExpandPlanEntry {
        private final String myOriginalText;

        private ExpandPlanEntry(@NotNull String originalText) {
            if (originalText == null) {
                ExpandPlanEntry.$$$reportNull$$$0(0);
            }
            this.myOriginalText = originalText;
        }

        @NotNull
        String getOriginalText() {
            String string = this.myOriginalText;
            if (string == null) {
                ExpandPlanEntry.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        String expand(@NotNull Map<String, Val> env) {
            if (env == null) {
                ExpandPlanEntry.$$$reportNull$$$0(2);
            }
            return this.myOriginalText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/testing/table/GoTableTestUtil$ExpandPlanEntry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$ExpandPlanEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "expand";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ExpandPlanEntryVerbatim
    extends ExpandPlanEntry {
        private ExpandPlanEntryVerbatim(@NotNull String originalText) {
            if (originalText == null) {
                ExpandPlanEntryVerbatim.$$$reportNull$$$0(0);
            }
            super(originalText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalText", "com/goide/execution/testing/table/GoTableTestUtil$ExpandPlanEntryVerbatim", "<init>"));
        }
    }

    private static class ExpandPlanEntrySprintf
    extends ExpandPlanEntry {
        private final List<SprintfFragment> myFragments;

        private ExpandPlanEntrySprintf(@NotNull String originalText) {
            if (originalText == null) {
                ExpandPlanEntrySprintf.$$$reportNull$$$0(0);
            }
            super(originalText);
            this.myFragments = new ArrayList<SprintfFragment>();
        }

        void addTextFragment(@NotNull String text) {
            if (text == null) {
                ExpandPlanEntrySprintf.$$$reportNull$$$0(1);
            }
            this.myFragments.add(new SprintfFragmentText(text));
        }

        void addPlaceholderFragment(@NotNull Project project, @NotNull ExpandPlan entry, char verb) {
            if (project == null) {
                ExpandPlanEntrySprintf.$$$reportNull$$$0(2);
            }
            if (entry == null) {
                ExpandPlanEntrySprintf.$$$reportNull$$$0(3);
            }
            this.myFragments.add(new SprintfFragmentPlaceholder(project, entry, verb));
        }

        @Override
        @Nullable
        String expand(@NotNull Map<String, Val> env) {
            if (env == null) {
                ExpandPlanEntrySprintf.$$$reportNull$$$0(4);
            }
            if (this.myFragments.isEmpty()) {
                return this.getOriginalText();
            }
            StringBuilder result = new StringBuilder();
            boolean first = true;
            result.append("(");
            for (SprintfFragment fragment : this.myFragments) {
                String str = fragment.getStringLiteral(env);
                if (str == null) {
                    return this.getOriginalText();
                }
                if (!first) {
                    result.append(" + ");
                }
                result.append(str);
                first = false;
            }
            result.append(")");
            return result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$ExpandPlanEntrySprintf";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addTextFragment";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPlaceholderFragment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expand";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AccessField
    extends Access {
        private final String myFieldName;

        private AccessField(@NotNull String fieldName) {
            if (fieldName == null) {
                AccessField.$$$reportNull$$$0(0);
            }
            this.myFieldName = fieldName;
        }

        @Override
        @Nullable
        Val perform(@Nullable Val val, @NotNull Map<String, Val> env) {
            if (env == null) {
                AccessField.$$$reportNull$$$0(1);
            }
            if (val instanceof CompLitVal) {
                return ((CompLitVal)val).getFieldVal(this.myFieldName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$AccessField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AccessKey
    extends Access {
        private final Val myKeyVal;

        private AccessKey(@NotNull Val keyVal) {
            if (keyVal == null) {
                AccessKey.$$$reportNull$$$0(0);
            }
            this.myKeyVal = keyVal;
        }

        @Override
        @Nullable
        Val perform(@Nullable Val val, @NotNull Map<String, Val> env) {
            if (env == null) {
                AccessKey.$$$reportNull$$$0(1);
            }
            if (val instanceof CompLitVal) {
                return ((CompLitVal)val).getKeyVal(this.myKeyVal.getValue());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyVal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$AccessKey";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ExpandPlanEntryAccessPath
    extends ExpandPlanEntry {
        private final String myVarName;
        private final List<Access> myAccessPath;

        private ExpandPlanEntryAccessPath(@NotNull String originalText, @NotNull String varName, @NotNull List<Access> accessPath) {
            if (originalText == null) {
                ExpandPlanEntryAccessPath.$$$reportNull$$$0(0);
            }
            if (varName == null) {
                ExpandPlanEntryAccessPath.$$$reportNull$$$0(1);
            }
            if (accessPath == null) {
                ExpandPlanEntryAccessPath.$$$reportNull$$$0(2);
            }
            super(originalText);
            this.myVarName = varName;
            this.myAccessPath = accessPath;
        }

        @Override
        @Nullable
        String expand(@NotNull Map<String, Val> env) {
            Access access;
            if (env == null) {
                ExpandPlanEntryAccessPath.$$$reportNull$$$0(3);
            }
            Val result = env.get(this.myVarName);
            Iterator<Access> iterator = this.myAccessPath.iterator();
            while (iterator.hasNext() && (result = (access = iterator.next()).perform(result, env)) != null) {
            }
            if (result instanceof EvaluatedExpr) {
                return ((EvaluatedExpr)result).getGoExprText();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessPath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$ExpandPlanEntryAccessPath";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expand";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SprintfFragmentPlaceholder
    extends SprintfFragment {
        private final Project myProject;
        private final ExpandPlan myArgExpandPlan;
        private final char myVerb;

        private SprintfFragmentPlaceholder(@NotNull Project project, @NotNull ExpandPlan argExpandPlan, char verb) {
            if (project == null) {
                SprintfFragmentPlaceholder.$$$reportNull$$$0(0);
            }
            if (argExpandPlan == null) {
                SprintfFragmentPlaceholder.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myArgExpandPlan = argExpandPlan;
            this.myVerb = verb;
        }

        @Override
        @Nullable
        String getStringLiteral(@NotNull Map<String, Val> env) {
            String expanded;
            GoExpression expandedExpr;
            Value<?> value;
            Object v;
            if (env == null) {
                SprintfFragmentPlaceholder.$$$reportNull$$$0(2);
            }
            Object v0 = v = (value = GoExpressionEvaluator.evaluateExpression(expandedExpr = GoElementFactory.createExpression(this.myProject, expanded = this.myArgExpandPlan.expand(env)))) != null ? value.getValue() : null;
            if (this.myVerb == 's') {
                return v instanceof String ? GoStringUtil.createSingleLineString(v) : null;
            }
            if (this.myVerb == 'd') {
                return v instanceof Long ? GoStringUtil.createSingleLineString(((Long)v).toString()) : null;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argExpandPlan";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$SprintfFragmentPlaceholder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStringLiteral";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SprintfFragmentText
    extends SprintfFragment {
        private final String myText;

        private SprintfFragmentText(@NotNull String text) {
            if (text == null) {
                SprintfFragmentText.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Override
        @Nullable
        String getStringLiteral(@NotNull Map<String, Val> env) {
            if (env == null) {
                SprintfFragmentText.$$$reportNull$$$0(1);
            }
            return GoStringUtil.createSingleLineString(this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/testing/table/GoTableTestUtil$SprintfFragmentText";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getStringLiteral";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class SprintfFragment {
        private SprintfFragment() {
        }

        @Nullable
        abstract String getStringLiteral(@NotNull Map<String, Val> var1);
    }

    private static abstract class Access {
        private Access() {
        }

        @Nullable
        abstract Val perform(@Nullable Val var1, @NotNull Map<String, Val> var2);
    }
}

