/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.GoTypes;
import com.goide.execution.GoRunConfigurationProducerBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.testing.GoTestFinder;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.execution.testing.frameworks.gocheck.GocheckFramework;
import com.goide.execution.testing.frameworks.testify.GoTestifySupport;
import com.goide.execution.testing.table.GoTableTestFunctionInfo;
import com.goide.execution.testing.table.GoTableTestUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoValue;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoUtil;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestRunLineMarkerProvider
extends RunLineMarkerContributor
implements DumbAware {
    private static final Function<PsiElement, String> TOOLTIP_PROVIDER = element -> GoBundle.message((String)"go.test.run.test.tooltip", (Object[])new Object[0]);

    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement e) {
        GoLiteralValue literalValue;
        GoValue value;
        String subtestName;
        if (e == null) {
            GoTestRunLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (e.getNode().getElementType() == GoTypes.LBRACE && (subtestName = GoTestRunLineMarkerProvider.getSubtestName(value = (literalValue = (GoLiteralValue)ObjectUtils.tryCast((Object)e.getParent(), GoLiteralValue.class)) != null ? (GoValue)ObjectUtils.tryCast((Object)literalValue.getParent(), GoValue.class) : null)) != null) {
            return GoTestRunLineMarkerProvider.getInfo(e.getContainingFile(), "gotest", subtestName);
        }
        if (e.getNode().getElementType() == GoTypes.IDENTIFIER) {
            GoSpecType specType;
            PsiElement parent = e.getParent();
            PsiFile file = e.getContainingFile();
            if (!GoTestFinder.isTestFile(file) || !GoUtil.isInProject(file) || InjectedLanguageManager.getInstance((Project)e.getProject()).isInjectedFragment(file)) {
                return null;
            }
            if (GoRunConfigurationProducerBase.isPackageContext(e)) {
                return new RunLineMarkerContributor.Info(AllIcons.RunConfigurations.TestState.Run_run, ExecutorAction.getActions((int)0), TOOLTIP_PROVIDER);
            }
            if (parent instanceof GoFunctionOrMethodDeclaration) {
                String name = ((GoFunctionOrMethodDeclaration)parent).getName();
                GoTestFunctionType functionType = GoTestFunctionType.fromName(name);
                if (functionType != null && e.textMatches((CharSequence)StringUtil.notNullize((String)name)) && functionType != GoTestFunctionType.TEST_MAIN) {
                    if (parent instanceof GoFunctionDeclaration) {
                        if (functionType == GoTestFunctionType.EXAMPLE && !GoTestRunLineMarkerProvider.hasOutputComments((GoFunctionOrMethodDeclaration)parent)) {
                            return null;
                        }
                        if (functionType == GoTestFunctionType.FUZZ && !GoSdkService.getInstance(e.getProject()).getSdk(GoUtil.module(e)).supportsFuzzing()) {
                            return null;
                        }
                        return GoTestRunLineMarkerProvider.getInfo(file, "gotest", ((GoFunctionDeclaration)parent).getName());
                    }
                    if (parent instanceof GoMethodDeclaration && (GoTestRunLineMarkerProvider.isGocheckMethod((GoFunctionOrMethodDeclaration)parent) || GoTestifySupport.isRunnableTestifyMethod((GoMethodDeclaration)parent))) {
                        GoReceiver receiver = ((GoMethodDeclaration)parent).getReceiver();
                        String receiverName = (String)ObjectUtils.doIfNotNull((Object)receiver, NavigationItem::getName);
                        Object receiverText = StringUtil.isNotEmpty((String)receiverName) ? receiverName + "." : "";
                        return GoTestRunLineMarkerProvider.getInfo(file, "gotest", (String)receiverText + ((GoMethodDeclaration)parent).getName());
                    }
                }
            } else if (parent instanceof GoSpecType && GoTestifySupport.isTestifySuite(specType = (GoSpecType)parent)) {
                GoTypeSpec typeSpec = specType.getTypeSpec();
                if (typeSpec != null && GoTestifySupport.hasTestFunctionUsages(typeSpec)) {
                    return GoTestRunLineMarkerProvider.getInfo(file, "gosuite", typeSpec.getName());
                }
            } else if (parent instanceof GoReferenceExpression) {
                Map<GoCallExpr, String> tests;
                String subTestName;
                GoCallExpr callExpr = (GoCallExpr)ObjectUtils.tryCast((Object)parent.getParent(), GoCallExpr.class);
                GoFunctionOrMethodDeclaration function = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)parent, GoFunctionOrMethodDeclaration.class);
                if ((function instanceof GoFunctionDeclaration || GoTestifySupport.isRunnableTestifyMethod((GoMethodDeclaration)ObjectUtils.tryCast((Object)function, GoMethodDeclaration.class))) && (subTestName = (tests = GoRunUtil.getSubTests(function)).get(callExpr)) != null) {
                    return GoTestRunLineMarkerProvider.getInfo(file, "gotest", subTestName);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String getSubtestName(@Nullable GoValue e) {
        GoFunctionOrMethodDeclaration func = (GoFunctionOrMethodDeclaration)PsiTreeUtil.getParentOfType((PsiElement)e, GoFunctionOrMethodDeclaration.class);
        if (func == null) {
            return null;
        }
        if (func instanceof GoMethodDeclaration && !GoTestifySupport.isRunnableTestifyMethod((GoMethodDeclaration)func)) {
            return null;
        }
        GoTableTestFunctionInfo info = GoTableTestUtil.getTableTestInfo(func);
        return info.getFullTestNameByTestDataElement(e);
    }

    private static boolean isGocheckMethod(@NotNull GoFunctionOrMethodDeclaration method) {
        if (method == null) {
            GoTestRunLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return GocheckFramework.INSTANCE.isAvailableOnFile((PsiFile)method.getContainingFile()) && GocheckFramework.INSTANCE.isAvailableOnFunction(method);
    }

    private static boolean hasOutputComments(@NotNull GoFunctionOrMethodDeclaration fun) {
        if (fun == null) {
            GoTestRunLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return fun instanceof GoFunctionDeclaration && ((GoFunctionDeclaration)fun).getExampleOutput() != null;
    }

    @NotNull
    private static RunLineMarkerContributor.Info getInfo(@NotNull PsiFile file, @NotNull String protocol, @Nullable String name) {
        if (file == null) {
            GoTestRunLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (protocol == null) {
            GoTestRunLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return new RunLineMarkerContributor.Info(GoTestRunLineMarkerProvider.getTestStateIcon((TestStateStorage.Record)GoTestRunLineMarkerProvider.getTestState(file, protocol, name), (boolean)false), ExecutorAction.getActions((int)0), TOOLTIP_PROVIDER);
    }

    @Nullable
    private static TestStateStorage.Record getTestState(@NotNull PsiFile file, @NotNull String protocol, @Nullable String name) {
        TestStateStorage.Record state;
        TestStateStorage.Record state2;
        String importPath;
        if (file == null) {
            GoTestRunLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (protocol == null) {
            GoTestRunLineMarkerProvider.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        TestStateStorage stateStorage = TestStateStorage.getInstance((Project)file.getProject());
        String string = importPath = file instanceof GoFile ? ((GoFile)file).getImportPath(false) : null;
        if (StringUtil.isNotEmpty((String)importPath) && (state2 = stateStorage.getState(protocol + "://" + importPath + "#" + name)) != null) {
            return state2;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (state = stateStorage.getState(protocol + "://" + virtualFile.getPath() + "#" + name)) != null) {
            return state;
        }
        return stateStorage.getState(protocol + "://#" + name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
        }
        objectArray2[1] = "com/goide/execution/testing/GoTestRunLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isGocheckMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasOutputComments";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

