/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing;

import com.goide.i18n.GoBundle;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.util.GoUtil;
import com.intellij.DynamicBundle;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GoTestFunctionType {
    TEST("Test", "T", "go.test.generate.test.text"),
    TEST_MAIN("Test", "M", "go.test.generate.test.main.text"),
    BENCHMARK("Benchmark", "B", "go.test.generate.benchmark.text"),
    EXAMPLE("Example", null, "go.test.generate.example.text"),
    FUZZ("Fuzz", "F", "go.test.generate.fuzz.text");

    private final String myPrefix;
    private final String myParamType;
    private final String myPresentationTextProperty;

    private GoTestFunctionType(@NotNull String prefix, String paramType, String presentationTextProperty) {
        if (presentationTextProperty == null) {
            GoTestFunctionType.$$$reportNull$$$0(0);
        }
        this.myPrefix = prefix;
        this.myParamType = paramType;
        this.myPresentationTextProperty = presentationTextProperty;
    }

    @Nullable
    public String getParamType() {
        return this.myParamType;
    }

    @NotNull
    public String getPrefix() {
        String string = this.myPrefix;
        if (string == null) {
            GoTestFunctionType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getPresentationText() {
        String string = GoBundle.message((String)this.myPresentationTextProperty, (Object[])new Object[0]);
        if (string == null) {
            GoTestFunctionType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getQualifiedParamType(@Nullable String testingQualifier) {
        return this.myParamType != null ? "*" + GoPsiImplUtil.getFqn(testingQualifier, this.myParamType) : "";
    }

    @NotNull
    public String getSignature(@Nullable String testingQualifier) {
        if (this.myParamType == null) {
            return "";
        }
        String string = this.getParamName() + " " + this.getQualifiedParamType(testingQualifier);
        if (string == null) {
            GoTestFunctionType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getParamName() {
        return this.myParamType != null ? this.myParamType.toLowerCase(DynamicBundle.getLocale()) : "";
    }

    @Nullable
    @Contract(value="null -> null")
    public static GoTestFunctionType fromName(@Nullable String functionName) {
        if (StringUtil.isEmpty((String)functionName)) {
            return null;
        }
        if ("TestMain".equals(functionName)) {
            return TEST_MAIN;
        }
        for (GoTestFunctionType type : GoTestFunctionType.values()) {
            if (!GoUtil.checkPrefix(functionName, type.myPrefix)) continue;
            return type;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationTextProperty";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/GoTestFunctionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/GoTestFunctionType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

