/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.GoEnvironmentUtil;
import com.goide.GoIcons;
import com.goide.configuration.GoUIUtil;
import com.goide.dlv.DlvDisconnectOption;
import com.goide.execution.DlvRemoteDebugDisconnectOption;
import com.goide.execution.GoRunUtil;
import com.goide.i18n.GoBundle;
import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationSingletonPolicy;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.InetSocketAddress;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.RemoteDebugConfiguration;

public final class GoRemoteDebugConfigurationType
extends ConfigurationTypeBase {
    @NonNls
    private static final String TYPE_ID = "GoRemoteDebugConfigurationType";
    @NonNls
    private static final String FACTORY_ID = "Go Remote";

    public GoRemoteDebugConfigurationType() {
        super(TYPE_ID, GoBundle.message((String)"go.execution.remote.run.configuration.display.name", (Object[])new Object[0]), GoBundle.message((String)"go.execution.remote.run.configuration.description", (Object[])new Object[0]), NotNullLazyValue.lazy(() -> GoIcons.GO_REMOTE_DEBUG_ICON));
        this.addFactory(new ConfigurationFactory((ConfigurationType)this){

            @NotNull
            public String getId() {
                return GoRemoteDebugConfigurationType.FACTORY_ID;
            }

            @NotNull
            public RunConfigurationSingletonPolicy getSingletonPolicy() {
                RunConfigurationSingletonPolicy runConfigurationSingletonPolicy = RunConfigurationSingletonPolicy.SINGLE_INSTANCE_ONLY;
                if (runConfigurationSingletonPolicy == null) {
                    1.$$$reportNull$$$0(0);
                }
                return runConfigurationSingletonPolicy;
            }

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new DlvRemoteDebugConfiguration(project, this, "");
            }

            public boolean isEditableInDumbMode() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/execution/GoRemoteDebugConfigurationType$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSingletonPolicy";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/execution/GoRemoteDebugConfigurationType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "createTemplateConfiguration";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        });
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.dialogs.rundebug.GoRemoteDebugConfigurationType";
    }

    static final class RemoteDebugConfigurationSettingsEditor
    extends SettingsEditor<DlvRemoteDebugConfiguration> {
        private final JTextField hostField = GuiUtils.createUndoableTextField();
        private final PortField portField = new PortField(2345, 1);
        private final JBRadioButton myStopButton;
        private final JBRadioButton myLeaveButton;
        private final JBRadioButton myAskButton;
        private final JEditorPane myHelp = GoUIUtil.createDescriptionPane(true);

        RemoteDebugConfigurationSettingsEditor() {
            this.myHelp.setEditable(false);
            this.setText();
            this.portField.addChangeListener(e -> this.setText());
            JComponent editor = this.portField.getEditor();
            if (editor instanceof JSpinner.NumberEditor) {
                ((JSpinner.NumberEditor)editor).getTextField().getDocument().addDocumentListener(new MyDocumentListener());
            }
            this.myStopButton = new JBRadioButton(GoBundle.message((String)"go.remote.debug.disconnect.delve.option.stop", (Object[])new Object[0]));
            this.myLeaveButton = new JBRadioButton(GoBundle.message((String)"go.remote.debug.disconnect.delve.option.leave", (Object[])new Object[0]));
            this.myAskButton = new JBRadioButton(GoBundle.message((String)"go.remote.debug.disconnect.delve.option.ask", (Object[])new Object[0]));
            ButtonGroup disconnectGroup = new ButtonGroup();
            disconnectGroup.add((AbstractButton)this.myStopButton);
            disconnectGroup.add((AbstractButton)this.myLeaveButton);
            disconnectGroup.add((AbstractButton)this.myAskButton);
        }

        private void setText() {
            String port = this.portField.getValue().toString();
            JComponent editor = this.portField.getEditor();
            if (editor instanceof JSpinner.NumberEditor) {
                Document document = ((JSpinner.NumberEditor)editor).getTextField().getDocument();
                int length = document.getLength();
                try {
                    port = document.getText(0, length);
                }
                catch (BadLocationException e) {
                    Logger.getInstance(GoRemoteDebugConfigurationType.class).error((Throwable)e);
                }
            }
            this.myHelp.setText(GoBundle.message((String)"go.execution.remote.run.configuration.start.delve.text", (Object[])new Object[]{port, port, GoEnvironmentUtil.getBinaryFileNameForPath("demo"), "1.18"}));
        }

        protected void resetEditorFrom(@NotNull DlvRemoteDebugConfiguration configuration) {
            if (configuration == null) {
                RemoteDebugConfigurationSettingsEditor.$$$reportNull$$$0(0);
            }
            this.hostField.setText(StringUtil.notNullize((String)configuration.getHost(), (String)"localhost"));
            this.portField.setNumber(configuration.getPort());
            switch (configuration.getDisconnectOption()) {
                case STOP: {
                    this.myStopButton.setSelected(true);
                    break;
                }
                case LEAVE: {
                    this.myLeaveButton.setSelected(true);
                    break;
                }
                case ASK: {
                    this.myAskButton.setSelected(true);
                }
            }
        }

        protected void applyEditorTo(@NotNull DlvRemoteDebugConfiguration configuration) {
            if (configuration == null) {
                RemoteDebugConfigurationSettingsEditor.$$$reportNull$$$0(1);
            }
            configuration.setHost(this.hostField.getText());
            configuration.setPort(this.portField.getNumber());
            DlvRemoteDebugDisconnectOption option = this.myStopButton.isSelected() ? DlvRemoteDebugDisconnectOption.STOP : (this.myLeaveButton.isSelected() ? DlvRemoteDebugDisconnectOption.LEAVE : DlvRemoteDebugDisconnectOption.ASK);
            configuration.setDisconnectOption(option);
        }

        @NotNull
        protected JComponent createEditor() {
            JPanel result = new JPanel(new BorderLayout());
            JPanel disconnectPanel = new JPanel();
            disconnectPanel.setBorder((Border)JBUI.Borders.empty());
            disconnectPanel.setLayout(new BoxLayout(disconnectPanel, 2));
            disconnectPanel.add((Component)this.myStopButton);
            disconnectPanel.add(Box.createRigidArea(new Dimension(JBUI.scale((int)10), 0)));
            disconnectPanel.add((Component)this.myLeaveButton);
            disconnectPanel.add(Box.createRigidArea(new Dimension(JBUI.scale((int)10), 0)));
            disconnectPanel.add((Component)this.myAskButton);
            result.add((Component)FormBuilder.createFormBuilder().addLabeledComponent(GoBundle.message((String)"go.execution.remote.run.configuration.host.label", (Object[])new Object[0]), (JComponent)this.hostField).addLabeledComponent(GoBundle.message((String)"go.execution.remote.run.configuration.port.label", (Object[])new Object[0]), (JComponent)this.portField).addLabeledComponent(GoBundle.message((String)"go.remote.debug.disconnect.delve.label", (Object[])new Object[0]), (JComponent)disconnectPanel).addComponent((JComponent)this.myHelp).getPanel(), "North");
            JPanel jPanel = result;
            if (jPanel == null) {
                RemoteDebugConfigurationSettingsEditor.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoRemoteDebugConfigurationType$RemoteDebugConfigurationSettingsEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoRemoteDebugConfigurationType$RemoteDebugConfigurationSettingsEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resetEditorFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "applyEditorTo";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        private class MyDocumentListener
        implements DocumentListener {
            private MyDocumentListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RemoteDebugConfigurationSettingsEditor.this.setText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RemoteDebugConfigurationSettingsEditor.this.setText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RemoteDebugConfigurationSettingsEditor.this.setText();
            }
        }
    }

    public static class DlvRemoteDebugConfiguration
    extends RemoteDebugConfiguration {
        public static final int DEFAULT_PORT = 2345;
        private static final String DISCONNECT_OPTION = "disconnect";
        private DlvRemoteDebugDisconnectOption myDisconnectOption;

        public DlvRemoteDebugConfiguration(Project project, @NotNull ConfigurationFactory factory, String name) {
            if (factory == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(0);
            }
            super(project, factory, name, 2345);
            this.myDisconnectOption = DlvRemoteDebugDisconnectOption.ASK;
        }

        @NotNull
        public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
            if (socketAddress == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(1);
            }
            if (session == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(2);
            }
            if (environment == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(3);
            }
            DlvDisconnectOption disconnectOption = DlvDisconnectOption.LEAVE_RUNNING;
            if (this.myDisconnectOption == DlvRemoteDebugDisconnectOption.STOP) {
                disconnectOption = DlvDisconnectOption.DETACH;
            }
            XDebugProcess xDebugProcess = GoRunUtil.createDlvDebugProcess(session, executionResult, socketAddress, true, disconnectOption);
            if (xDebugProcess == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(4);
            }
            return xDebugProcess;
        }

        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditorGroup group = new SettingsEditorGroup();
            group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new RemoteDebugConfigurationSettingsEditor());
            group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
            SettingsEditorGroup settingsEditorGroup = group;
            if (settingsEditorGroup == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(5);
            }
            return settingsEditorGroup;
        }

        public void setDisconnectOption(@Nullable DlvRemoteDebugDisconnectOption disconnectOption) {
            this.myDisconnectOption = disconnectOption != null ? disconnectOption : DlvRemoteDebugDisconnectOption.ASK;
        }

        @NotNull
        public DlvRemoteDebugDisconnectOption getDisconnectOption() {
            DlvRemoteDebugDisconnectOption dlvRemoteDebugDisconnectOption = this.myDisconnectOption;
            if (dlvRemoteDebugDisconnectOption == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(6);
            }
            return dlvRemoteDebugDisconnectOption;
        }

        public void readExternal(@NotNull Element element) throws InvalidDataException {
            if (element == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(7);
            }
            super.readExternal(element);
            this.myDisconnectOption = DlvRemoteDebugConfiguration.readDisconnectOption(element);
        }

        public void writeExternal(@NotNull Element element) throws WriteExternalException {
            if (element == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(8);
            }
            super.writeExternal(element);
            DlvRemoteDebugConfiguration.writeDisconnectOption(element, this.myDisconnectOption);
        }

        @NotNull
        private static DlvRemoteDebugDisconnectOption readDisconnectOption(@NotNull Element element) {
            DlvRemoteDebugDisconnectOption dlvRemoteDebugDisconnectOption;
            String disconnectOption;
            if (element == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(9);
            }
            if (StringUtil.isEmpty((String)(disconnectOption = JDOMExternalizerUtil.readCustomField((Element)element, (String)DISCONNECT_OPTION)))) {
                DlvRemoteDebugDisconnectOption dlvRemoteDebugDisconnectOption2 = DlvRemoteDebugDisconnectOption.ASK;
                if (dlvRemoteDebugDisconnectOption2 == null) {
                    DlvRemoteDebugConfiguration.$$$reportNull$$$0(10);
                }
                return dlvRemoteDebugDisconnectOption2;
            }
            try {
                dlvRemoteDebugDisconnectOption = DlvRemoteDebugDisconnectOption.valueOf(disconnectOption);
            }
            catch (IllegalArgumentException e) {
                DlvRemoteDebugDisconnectOption dlvRemoteDebugDisconnectOption3 = DlvRemoteDebugDisconnectOption.ASK;
                if (dlvRemoteDebugDisconnectOption3 == null) {
                    DlvRemoteDebugConfiguration.$$$reportNull$$$0(12);
                }
                return dlvRemoteDebugDisconnectOption3;
            }
            if (dlvRemoteDebugDisconnectOption == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(11);
            }
            return dlvRemoteDebugDisconnectOption;
        }

        private static void writeDisconnectOption(@NotNull Element element, @NotNull DlvRemoteDebugDisconnectOption disconnectOption) {
            if (element == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(13);
            }
            if (disconnectOption == null) {
                DlvRemoteDebugConfiguration.$$$reportNull$$$0(14);
            }
            if (disconnectOption != DlvRemoteDebugDisconnectOption.ASK) {
                JDOMExternalizerUtil.writeCustomField((Element)element, (String)DISCONNECT_OPTION, (String)disconnectOption.name());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "socketAddress";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoRemoteDebugConfigurationType$DlvRemoteDebugConfiguration";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disconnectOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoRemoteDebugConfigurationType$DlvRemoteDebugConfiguration";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDebugProcess";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisconnectOption";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readDisconnectOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDebugProcess";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "readExternal";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "readDisconnectOption";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "writeDisconnectOption";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }
}

