/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoTypes;
import com.goide.editor.GoParameterInfoHandler;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTypeArgumentsParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GoTypeArguments, Object, GoType>,
DumbAware {
    @Nullable
    public GoTypeArguments findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        GoTypeParameters typeParams;
        GoTypeArguments typeArgs;
        if (context == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((typeArgs = GoTypeArgumentsParameterInfoHandler.getTypeArguments((ParameterInfoContext)context)) == null) {
            return null;
        }
        GoTypeReferenceExpression typeRefExpr = (GoTypeReferenceExpression)ObjectUtils.tryCast((Object)typeArgs.getPrevSibling(), GoTypeReferenceExpression.class);
        if (typeRefExpr == null) {
            return null;
        }
        PsiElement resolvedType = typeRefExpr.resolve();
        GoTypeParameters goTypeParameters = typeParams = resolvedType instanceof GoTypeSpec ? ((GoTypeSpec)resolvedType).getSpecType().getTypeParameters() : null;
        if (typeParams != null) {
            context.setItemsToShow(new Object[]{typeParams});
            return typeArgs;
        }
        return null;
    }

    @Nullable
    private static GoTypeArguments getTypeArguments(@NotNull ParameterInfoContext context) {
        if (context == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(1);
        }
        PsiElement at = context.getFile().findElementAt(context.getOffset());
        return (GoTypeArguments)PsiTreeUtil.getParentOfType((PsiElement)at, GoTypeArguments.class, (boolean)false);
    }

    public void showParameterInfo(@NotNull GoTypeArguments element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (!ArrayUtil.isEmpty((Object[])context.getItemsToShow())) {
            context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
        }
    }

    @Nullable
    public GoTypeArguments findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return GoTypeArgumentsParameterInfoHandler.getTypeArguments((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull GoTypeArguments list, @NotNull UpdateParameterInfoContext context) {
        GoType type;
        if (list == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(6);
        }
        int currentParameter = (type = list.getTypeList()) instanceof GoTypeList ? ParameterInfoUtils.getCurrentParameterIndex((ASTNode)type.getNode(), (int)context.getOffset(), (IElementType)GoTypes.COMMA) : 0;
        context.setCurrentParameter(currentParameter);
    }

    public void updateUI(Object p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(7);
        }
        GoTypeArgumentsParameterInfoHandler.updateUI((GoTypeParameters)ObjectUtils.tryCast((Object)p, GoTypeParameters.class), context);
    }

    public GoType @NotNull [] getActualParameters(@NotNull GoTypeArguments o) {
        if (o == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(8);
        }
        GoType[] goTypeArray = o.getTypes().toArray(new GoType[0]);
        if (goTypeArray == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return goTypeArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = GoTypes.COMMA;
        if (iElementType == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = GoTypes.RBRACE;
        if (iElementType == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(11);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        return new HashSet();
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        return new HashSet();
    }

    @NotNull
    public Class<GoTypeArguments> getArgumentListClass() {
        return GoTypeArguments.class;
    }

    static void updateUI(@Nullable GoTypeParameters typeParams, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if (typeParams == null) {
            context.setUIComponentEnabled(false);
            return;
        }
        List<String> parametersPresentations = GoTypeArgumentsParameterInfoHandler.getTypeParameterPresentations(typeParams, GoPsiImplUtil::getPresentationText, false);
        @NlsContexts.Label StringBuilder builder = new StringBuilder();
        if (!parametersPresentations.isEmpty()) {
            int selected = context.getCurrentParameterIndex();
            for (int i = 0; i < parametersPresentations.size(); ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                String parameter = XmlStringUtil.escapeString((String)parametersPresentations.get(i));
                builder.append((String)(i == selected ? "<b color=" + ColorUtil.toHex((Color)GoParameterInfoHandler.HIGHLIGHTED_COLOR) + ">" + parameter + "</b>" : parameter));
            }
        } else {
            builder.append(XmlStringUtil.escapeString((String)CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0])));
        }
        context.setupRawUIComponentPresentation(builder.toString());
    }

    @NotNull
    public static List<String> getTypeParameterPresentations(@NotNull GoTypeParameters typeParameters, @NotNull Function<? super GoType, String> typePresentationFunction, boolean withoutNames) {
        if (typeParameters == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if (typePresentationFunction == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(14);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (GoTypeParameterDeclaration declaration : typeParameters.getTypeParameterDeclarationList()) {
            String metaType = typePresentationFunction.apply(declaration.getType());
            List<GoTypeParamDefinition> definitions = declaration.getTypeParamDefinitionList();
            for (GoTypeParamDefinition definition : definitions) {
                String name = StringUtil.notNullize((String)definition.getName());
                result.add((String)(withoutNames || name.isEmpty() ? metaType : name + " " + metaType));
            }
            if (!definitions.isEmpty()) continue;
            result.add(metaType);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GoTypeArgumentsParameterInfoHandler.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoTypeArgumentsParameterInfoHandler";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePresentationFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoTypeArgumentsParameterInfoHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterPresentations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArguments";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 7: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterPresentations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 11, 15 -> new IllegalStateException(string);
        };
    }
}

