/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoFileType;
import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.formatter.GoFormatterUtil;
import com.goide.formatter.GoLineCommentBlock;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.fillParagraph.ParagraphFillHandler;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoFillParagraphHandler
extends ParagraphFillHandler {
    public boolean isAvailableForElement(@Nullable PsiElement element) {
        return GoFillParagraphHandler.isAvailable(element);
    }

    public static boolean isAvailable(@Nullable PsiElement element) {
        PsiElement adjusted = GoFillParagraphHandler.adjustElement(element);
        if (GoFillParagraphHandler.isLineComment(adjusted)) {
            return GoFormatterUtil.isFirstElementOnLine(adjusted) && !GoFillParagraphHandler.isDirective(adjusted) && !GoPsiUtil.isBuildTagComment(adjusted);
        }
        return GoFillParagraphHandler.isBlockComment(element) && GoFormatterUtil.isFirstElementOnLine(adjusted) && GoFormatterUtil.isLastElementOnLine(adjusted);
    }

    private static boolean isDirective(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(0);
        }
        GoCodeStyleSettings settings = (file = element.getContainingFile()) != null ? GoCodeStyleSettings.getSettings((PsiFile)file) : null;
        return GoLineCommentBlock.isDirectiveComment(StringUtil.trimStart((String)element.getText(), (String)"//"), settings);
    }

    public void performOnElement(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(2);
        }
        GoFillParagraphHandler.perform(element, editor);
    }

    public static void perform(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(4);
        }
        if (GoFillParagraphHandler.isLineComment(element = GoFillParagraphHandler.adjustElement(element))) {
            GoFillParagraphHandler.handleLineComment(element, editor);
        } else if (GoFillParagraphHandler.isBlockComment(element)) {
            GoFillParagraphHandler.handleBlockComment(element, editor);
        }
    }

    private static String getIndent(@NotNull String text) {
        if (text == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return text.substring(0, i);
        }
        return "";
    }

    private static void handleLineComment(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(7);
        }
        if (GoFillParagraphHandler.isEmptyLineComment(element)) {
            return;
        }
        String indentAfterSlashes = GoFillParagraphHandler.getIndent(StringUtil.trimStart((String)element.getText(), (String)"//"));
        PsiFile file = element.getContainingFile();
        PsiComment firstComment = GoFillParagraphHandler.findFirstCommentInParagraph((PsiComment)element, indentAfterSlashes);
        PsiComment lastComment = GoFillParagraphHandler.findLastCommentInParagraph((PsiComment)element, indentAfterSlashes);
        TextAndCaret paragraphTextAndCaret = GoFillParagraphHandler.extractTextAndCaret(firstComment, lastComment, editor.getCaretModel().getOffset());
        Document document = editor.getDocument();
        String indent = GoFillParagraphHandler.getLineCommentIndent(document, firstComment);
        int paragraphWidth = GoFillParagraphHandler.getParagraphWidth(file, editor, indent, GoFillParagraphHandler.getLineCommentPrefix(file));
        Paragraph paragraph = Paragraph.create(paragraphTextAndCaret, paragraphWidth);
        Object prefixWithSlashes = indentAfterSlashes.isEmpty() ? GoFillParagraphHandler.getLineCommentPrefix(file) : "//" + indentAfterSlashes;
        TextAndCaret indentedParagraph = paragraph.addIndent(indent + (String)prefixWithSlashes);
        int paragraphStart = document.getLineStartOffset(document.getLineNumber(firstComment.getTextRange().getStartOffset()));
        int paragraphEnd = document.getLineEndOffset(document.getLineNumber(lastComment.getTextRange().getEndOffset()));
        if (paragraphEnd < document.getTextLength()) {
            ++paragraphEnd;
        }
        GoFillParagraphHandler.replaceParagraph(element.getProject(), editor, paragraphStart, paragraphEnd, indentedParagraph);
    }

    @NotNull
    private static PsiComment findFirstCommentInParagraph(@NotNull PsiComment currentComment, @NotNull String indent) {
        if (currentComment == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(8);
        }
        if (indent == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(9);
        }
        PsiComment result = currentComment;
        PsiComment e = currentComment;
        while (true) {
            PsiElement prev;
            if ((prev = e.getPrevSibling()) instanceof PsiWhiteSpace) {
                if (StringUtil.countChars((CharSequence)prev.getText(), (char)'\n') > 1) {
                    break;
                }
            } else {
                if (!GoFillParagraphHandler.isLineComment(prev)) break;
                String prevIndent = GoFillParagraphHandler.getIndent(StringUtil.trimStart((String)prev.getText(), (String)"//"));
                if (GoFillParagraphHandler.isEmptyLineComment(prev) || !GoFormatterUtil.isFirstElementOnLine(prev) || GoFillParagraphHandler.isDirective(prev) || !indent.equals(prevIndent)) break;
                result = (PsiComment)prev;
            }
            e = prev;
        }
        PsiComment psiComment = result;
        if (psiComment == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(10);
        }
        return psiComment;
    }

    @NotNull
    private static PsiComment findLastCommentInParagraph(@NotNull PsiComment currentComment, @NotNull String indent) {
        if (currentComment == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(11);
        }
        if (indent == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(12);
        }
        PsiComment result = currentComment;
        PsiComment e = currentComment;
        while (true) {
            PsiElement next;
            if ((next = e.getNextSibling()) instanceof PsiWhiteSpace) {
                if (StringUtil.countChars((CharSequence)next.getText(), (char)'\n') > 1) {
                    break;
                }
            } else {
                if (!GoFillParagraphHandler.isLineComment(next)) break;
                String nextIndent = GoFillParagraphHandler.getIndent(StringUtil.trimStart((String)next.getText(), (String)"//"));
                if (GoFillParagraphHandler.isEmptyLineComment(next) || GoFillParagraphHandler.isDirective(next) || !indent.equals(nextIndent)) break;
                result = (PsiComment)next;
            }
            e = next;
        }
        PsiComment psiComment = result;
        if (psiComment == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(13);
        }
        return psiComment;
    }

    @NotNull
    private static TextAndCaret extractTextAndCaret(@NotNull PsiComment first, @NotNull PsiComment last, int caretInDocument) {
        if (first == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(14);
        }
        if (last == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(15);
        }
        StringBuilder text = new StringBuilder();
        int caretInText = -1;
        PsiComment e = first;
        while (true) {
            if (e instanceof PsiComment) {
                TextRange commentRange = e.getTextRange();
                if (commentRange.contains(caretInDocument)) {
                    int offsetInComment = caretInDocument - commentRange.getStartOffset();
                    caretInText = text.length() + offsetInComment;
                    if (offsetInComment >= 2) {
                        caretInText -= 2;
                    }
                }
                text.append(StringUtil.trimStart((String)e.getText(), (String)"//"));
            } else if (e instanceof PsiWhiteSpace) {
                if (e.getTextRange().contains(caretInDocument)) {
                    caretInText = text.length();
                }
                text.append(" ");
            }
            if (e == last) break;
            e = e.getNextSibling();
        }
        if (caretInText == -1) {
            caretInText = text.length();
        }
        return new TextAndCaret(text.toString(), caretInText);
    }

    @NotNull
    private static String getLineCommentIndent(@NotNull Document document, @NotNull PsiComment comment) {
        if (document == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(16);
        }
        if (comment == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(17);
        }
        int commentStartOffset = comment.getTextRange().getStartOffset();
        int lineStartOffset = document.getLineStartOffset(document.getLineNumber(commentStartOffset));
        String string = document.getText().substring(lineStartOffset, commentStartOffset);
        if (string == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getNormalizedIndent(@NotNull Editor editor, @NotNull String indent) {
        if (editor == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(19);
        }
        if (indent == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(20);
        }
        int tabSize = CodeStyle.getSettings((Editor)editor).getTabSize((FileType)GoFileType.INSTANCE);
        String tabSpaces = StringUtil.repeat((String)" ", (int)tabSize);
        String string = indent.replaceAll("\t", tabSpaces);
        if (string == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String getLineCommentPrefix(@NotNull PsiFile file) {
        if (file == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(22);
        }
        String leadingSpace = ((GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, GoCodeStyleSettings.class)).ADD_LEADING_SPACE_TO_COMMENTS ? " " : "";
        String string = "//" + leadingSpace;
        if (string == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static boolean isEmptyLineComment(@NotNull PsiElement element) {
        if (element == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(24);
        }
        return StringUtil.trimStart((String)element.getText(), (String)"//").trim().isEmpty();
    }

    private static void handleBlockComment(@NotNull PsiElement element, @NotNull Editor editor) {
        if (element == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(25);
        }
        if (editor == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(26);
        }
        PsiFile file = element.getContainingFile();
        Document document = editor.getDocument();
        int caretInDocument = editor.getCaretModel().getOffset();
        int caretLine = document.getLineNumber(caretInDocument);
        int caretLineStart = document.getLineStartOffset(caretLine);
        int caretLineEnd = document.getLineEndOffset(caretLine);
        TextRange commentRange = element.getTextRange();
        String currentLineText = document.getText().substring(caretLineStart, caretLineEnd);
        String currentLineTextTrimmed = currentLineText.trim();
        if (currentLineTextTrimmed.isEmpty() || caretLineStart <= commentRange.getStartOffset() && currentLineTextTrimmed.equals("/*") || caretLineEnd >= commentRange.getEndOffset() && currentLineTextTrimmed.equals("*/")) {
            return;
        }
        String currentLineIndent = GoFillParagraphHandler.getIndent(currentLineText);
        int paragraphStart = GoFillParagraphHandler.getBlockCommentParagraphStartOffset(document, commentRange, caretLine, currentLineIndent);
        int paragraphEnd = GoFillParagraphHandler.getBlockCommentParagraphEndOffset(document, commentRange, caretLine, currentLineIndent);
        String text = document.getText().substring(paragraphStart, paragraphEnd).replace('\n', ' ');
        int caretInText = caretInDocument - paragraphStart;
        String indent = GoFillParagraphHandler.getFirstLineIndent(document, paragraphStart);
        int paragraphWidth = GoFillParagraphHandler.getParagraphWidth(file, editor, indent, "");
        Paragraph paragraph = Paragraph.create(new TextAndCaret(text, caretInText), paragraphWidth);
        TextAndCaret indentedParagraph = paragraph.addIndent(indent);
        GoFillParagraphHandler.replaceParagraph(element.getProject(), editor, paragraphStart, paragraphEnd, indentedParagraph);
    }

    private static int getBlockCommentParagraphStartOffset(@NotNull Document document, @NotNull TextRange commentRange, int caretLine, @NotNull String indent) {
        int prevLineEnd;
        int prevLineStart;
        String prevLineText;
        String prevLineTextTrimmed;
        if (document == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(27);
        }
        if (commentRange == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(28);
        }
        if (indent == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(29);
        }
        String documentText = document.getText();
        int result = document.getLineStartOffset(caretLine);
        for (int prevLine = caretLine - 1; !(prevLine < 0 || result <= commentRange.getStartOffset() || (prevLineTextTrimmed = (prevLineText = documentText.substring(prevLineStart = document.getLineStartOffset(prevLine), prevLineEnd = document.getLineEndOffset(prevLine))).trim()).isEmpty() || prevLineStart <= commentRange.getStartOffset() && prevLineTextTrimmed.equals("/*") || !indent.equals(GoFillParagraphHandler.getIndent(prevLineText))); --prevLine) {
            result = prevLineStart;
        }
        return result;
    }

    private static int getBlockCommentParagraphEndOffset(@NotNull Document document, @NotNull TextRange commentRange, int caretLine, @NotNull String indent) {
        int nextLineEnd;
        int nextLineStart;
        String nextLineText;
        String nextLineTextTrimmed;
        if (document == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(30);
        }
        if (commentRange == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(31);
        }
        if (indent == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(32);
        }
        String documentText = document.getText();
        int lineCount = document.getLineCount();
        int result = document.getLineEndOffset(caretLine);
        int nextLine = caretLine + 1;
        if (nextLine == lineCount) {
            return result;
        }
        while (!(nextLine >= lineCount || (result = document.getLineStartOffset(nextLine)) > commentRange.getEndOffset() || (nextLineTextTrimmed = (nextLineText = documentText.substring(nextLineStart = document.getLineStartOffset(nextLine), nextLineEnd = document.getLineEndOffset(nextLine))).trim()).isEmpty() || nextLineEnd >= commentRange.getEndOffset() && nextLineTextTrimmed.equals("*/") || !indent.equals(GoFillParagraphHandler.getIndent(nextLineText)))) {
            ++nextLine;
        }
        return result;
    }

    @NotNull
    private static String getFirstLineIndent(@NotNull Document document, int indentStart) {
        if (document == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(33);
        }
        String documentText = document.getText();
        int end = indentStart;
        while (StringUtil.isWhiteSpace((char)documentText.charAt(end))) {
            ++end;
        }
        String string = documentText.substring(indentStart, end);
        if (string == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static int getParagraphWidth(@NotNull PsiFile file, @NotNull Editor editor, @NotNull String indent, @NotNull String eachLinePrefix) {
        if (file == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(35);
        }
        if (editor == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(36);
        }
        if (indent == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(37);
        }
        if (eachLinePrefix == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(38);
        }
        int result = ((GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, GoCodeStyleSettings.class)).FILL_PARAGRAPH_WIDTH;
        int rightMargin = CodeStyle.getSettings((Editor)editor).getRightMargin(GoLanguage.INSTANCE);
        int indentWidth = GoFillParagraphHandler.getNormalizedIndent(editor, indent).length();
        if (indentWidth + result > rightMargin) {
            result = rightMargin - indentWidth;
        }
        return result - eachLinePrefix.length();
    }

    private static void replaceParagraph(@NotNull Project project, @NotNull Editor editor, int paragraphStart, int paragraphEnd, @NotNull TextAndCaret indentedParagraph) {
        if (project == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(39);
        }
        if (editor == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(40);
        }
        if (indentedParagraph == null) {
            GoFillParagraphHandler.$$$reportNull$$$0(41);
        }
        Document document = editor.getDocument();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            document.deleteString(paragraphStart, paragraphEnd);
            document.insertString(paragraphStart, (CharSequence)indentedParagraph.getText());
            editor.getCaretModel().moveToOffset(paragraphStart + indentedParagraph.getCaret());
        }, GoBundle.message((String)"action.go.fill.paragraph", (Object[])new Object[0]), null, document);
    }

    @Nullable
    @Contract(value="!null -> !null")
    private static PsiElement adjustElement(@Nullable PsiElement element) {
        PsiElement prev;
        if (element instanceof PsiWhiteSpace && element.textMatches((CharSequence)"\n") && GoFillParagraphHandler.isLineComment(prev = element.getPrevSibling())) {
            return prev;
        }
        return element;
    }

    protected boolean isAvailableForFile(@Nullable PsiFile psiFile) {
        return psiFile instanceof GoFile;
    }

    private static boolean isLineComment(@Nullable PsiElement element) {
        return element instanceof PsiComment && element.getNode().getElementType() == GoParserDefinition.Lazy.LINE_COMMENT;
    }

    private static boolean isBlockComment(@Nullable PsiElement element) {
        return element instanceof PsiComment && element.getNode().getElementType() == GoParserDefinition.Lazy.MULTILINE_COMMENT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 13, 18, 21, 23, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 19: 
            case 26: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentComment";
                break;
            }
            case 9: 
            case 12: 
            case 20: 
            case 29: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indent";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoFillParagraphHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "last";
                break;
            }
            case 16: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentRange";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eachLinePrefix";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentedParagraph";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoFillParagraphHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstCommentInParagraph";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findLastCommentInParagraph";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineCommentIndent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedIndent";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineCommentPrefix";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLineIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDirective";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performOnElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleLineComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFirstCommentInParagraph";
                break;
            }
            case 10: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 34: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findLastCommentInParagraph";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractTextAndCaret";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentIndent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedIndent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLineCommentPrefix";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyLineComment";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleBlockComment";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentParagraphStartOffset";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentParagraphEndOffset";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLineIndent";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParagraphWidth";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "replaceParagraph";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 13, 18, 21, 23, 34 -> new IllegalStateException(string);
        };
    }

    private static final class TextAndCaret
    extends Pair<String, Integer> {
        private TextAndCaret(@NotNull String text, int caretOffsetInText) {
            if (text == null) {
                TextAndCaret.$$$reportNull$$$0(0);
            }
            super((Object)text, (Object)caretOffsetInText);
        }

        @NotNull
        String getText() {
            String string = (String)this.first;
            if (string == null) {
                TextAndCaret.$$$reportNull$$$0(1);
            }
            return string;
        }

        int getCaret() {
            return (Integer)this.second;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/editor/GoFillParagraphHandler$TextAndCaret";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/editor/GoFillParagraphHandler$TextAndCaret";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class Paragraph {
        private final int myDesiredWidth;
        private final int myCaretOffsetInText;
        private final StringBuilder myCurrentLine = new StringBuilder();
        private boolean myCaretInParagraphComputed = false;
        private final List<String> myLines = new ArrayList<String>();
        private int myCaretLine = 0;
        private int myCaretOffsetInLine = 0;

        private Paragraph(int desiredWidth, int caretOffsetInText) {
            this.myDesiredWidth = desiredWidth;
            this.myCaretOffsetInText = caretOffsetInText;
        }

        @NotNull
        private static Paragraph create(@NotNull TextAndCaret textAndCaret, int desiredWidth) {
            if (textAndCaret == null) {
                Paragraph.$$$reportNull$$$0(0);
            }
            Paragraph result = new Paragraph(desiredWidth, textAndCaret.getCaret());
            for (TextRange word : StringUtil.getWordIndicesIn((String)textAndCaret.getText(), Set.of(Character.valueOf(' '), Character.valueOf('\t')))) {
                result.addWord(textAndCaret.getText(), word);
            }
            result.finishParagraph();
            Paragraph paragraph = result;
            if (paragraph == null) {
                Paragraph.$$$reportNull$$$0(1);
            }
            return paragraph;
        }

        private void addWord(@NotNull String text, @NotNull TextRange word) {
            if (text == null) {
                Paragraph.$$$reportNull$$$0(2);
            }
            if (word == null) {
                Paragraph.$$$reportNull$$$0(3);
            }
            boolean needSpace = this.myCurrentLine.length() > 0;
            int lineLengthWithWord = this.myCurrentLine.length() + (needSpace ? 1 : 0) + word.getLength();
            if (lineLengthWithWord <= this.myDesiredWidth || this.isEmpty()) {
                if (needSpace) {
                    this.myCurrentLine.append(' ');
                }
            } else {
                this.myLines.add(this.myCurrentLine.toString());
                this.myCurrentLine.setLength(0);
            }
            if (!this.myCaretInParagraphComputed && this.myCaretOffsetInText < word.getStartOffset()) {
                this.myCaretLine = this.myLines.size();
                this.myCaretOffsetInLine = this.myCurrentLine.length();
                this.myCaretInParagraphComputed = true;
            }
            this.myCurrentLine.append(text, word.getStartOffset(), word.getEndOffset());
            if (!this.myCaretInParagraphComputed && this.myCaretOffsetInText <= word.getEndOffset()) {
                this.myCaretLine = this.myLines.size();
                this.myCaretOffsetInLine = this.myCurrentLine.length() - (word.getEndOffset() - this.myCaretOffsetInText);
                this.myCaretInParagraphComputed = true;
            }
        }

        private void finishParagraph() {
            if (!this.myCaretInParagraphComputed) {
                this.myCaretLine = this.myLines.size();
                this.myCaretOffsetInLine = this.myCurrentLine.length();
            }
            if (this.myCurrentLine.length() > 0) {
                this.myLines.add(this.myCurrentLine.toString());
            }
        }

        private boolean isEmpty() {
            return this.myLines.isEmpty() && this.myCurrentLine.length() == 0;
        }

        @NotNull
        TextAndCaret addIndent(@NotNull String indent) {
            if (indent == null) {
                Paragraph.$$$reportNull$$$0(4);
            }
            StringBuilder indentedParagraph = new StringBuilder();
            int newCaretOffset = 0;
            for (int i = 0; i < this.myLines.size(); ++i) {
                String line = this.myLines.get(i);
                String commentLine = indent + line + "\n";
                if (i == this.myCaretLine) {
                    newCaretOffset += indentedParagraph.length() + indent.length() + this.myCaretOffsetInLine;
                }
                indentedParagraph.append(commentLine);
            }
            return new TextAndCaret(indentedParagraph.toString(), newCaretOffset);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textAndCaret";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/editor/GoFillParagraphHandler$Paragraph";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "word";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/editor/GoFillParagraphHandler$Paragraph";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addWord";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addIndent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

