/*
 * Decompiled with CFR 0.152.
 */
package com.goide.documentation.langspecparser;

import com.goide.documentation.GoKeywordDescription;
import com.goide.documentation.langspecparser.GoKeywordDescriptions;
import com.goide.documentation.langspecparser.KeywordDescriptionGenerator;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u000f\u001a\u00020\u0006H\u0002\u001a\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u001a\u0018\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0005\u001a\u00020\u00068GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"GO_KEYWORD_LIST", "", "OUTPUT_FOLDER", "TESTDATA_OUTPUT_FOLDER", "GENERATED_NOTICE", "goKeywords", "Lcom/goide/documentation/langspecparser/GoKeywordDescriptions;", "getGoKeywords", "()Lcom/goide/documentation/langspecparser/GoKeywordDescriptions;", "goKeywords$delegate", "Lkotlin/Lazy;", "client", "Ljava/net/http/HttpClient;", "getClient", "()Ljava/net/http/HttpClient;", "parseGoKeywordDescriptions", "main", "", "checkFurtherReadingReachability", "keywordDescriptions", "makeHttpRequest", "Ljava/net/http/HttpResponse;", "url", "instantiateKeywordDescriptionGeneratorFromInternet", "Lcom/goide/documentation/langspecparser/KeywordDescriptionGenerator;", "isPrintableASCIIOrSectionSign", "", "c", "", "marshalGoKeywordDescription", "goKeyword", "Lcom/goide/documentation/GoKeywordDescription;", "os", "Ljava/io/OutputStream;", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nLangSpecParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangSpecParser.kt\ncom/goide/documentation/langspecparser/LangSpecParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,169:1\n1863#2,2:170\n1863#2:172\n1863#2,2:173\n1864#2:175\n*S KotlinDebug\n*F\n+ 1 LangSpecParser.kt\ncom/goide/documentation/langspecparser/LangSpecParserKt\n*L\n44#1:170,2\n57#1:172\n58#1:173,2\n57#1:175\n*E\n"})
public final class LangSpecParserKt {
    @NotNull
    private static final String GO_KEYWORD_LIST = "/keywordDescriptions/goKeywords.xml";
    @NotNull
    private static final String OUTPUT_FOLDER = "goland/intellij-go/impl/resources/keywordDescriptions";
    @NotNull
    private static final String TESTDATA_OUTPUT_FOLDER = "goland/intellij-go/impl/testData";
    @NotNull
    private static final String GENERATED_NOTICE = "\n<!-- this file is generated by LangSpecParser.kt, do not modify -->";
    @NotNull
    private static final Lazy goKeywords$delegate = LazyKt.lazy(LangSpecParserKt::goKeywords_delegate$lambda$0);
    @NotNull
    private static final HttpClient client;

    @VisibleForTesting
    @NotNull
    public static final GoKeywordDescriptions getGoKeywords() {
        Lazy lazy = goKeywords$delegate;
        return (GoKeywordDescriptions)lazy.getValue();
    }

    @NotNull
    public static final HttpClient getClient() {
        return client;
    }

    private static final GoKeywordDescriptions parseGoKeywordDescriptions() {
        InputStream inputStream = GoKeywordDescriptions.class.getResourceAsStream(GO_KEYWORD_LIST);
        if (inputStream == null) {
            throw new IllegalStateException("Unable to fetch the Go keyword definitions from local resources");
        }
        InputStream goKeywordDescriptions = inputStream;
        Class[] classArray = new Class[]{GoKeywordDescriptions.class};
        JAXBContext unmarshallerContext = JAXBContext.newInstance((Class[])classArray);
        Object object = unmarshallerContext.createUnmarshaller().unmarshal(goKeywordDescriptions);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.goide.documentation.langspecparser.GoKeywordDescriptions");
        return (GoKeywordDescriptions)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main() {
        LangSpecParserKt.checkFurtherReadingReachability(LangSpecParserKt.getGoKeywords());
        KeywordDescriptionGenerator keywordDescriptionGenerator = LangSpecParserKt.instantiateKeywordDescriptionGeneratorFromInternet();
        List<GoKeywordDescription> list = LangSpecParserKt.getGoKeywords().getGoKeywordDescriptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGoKeywordDescriptions(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GoKeywordDescription goKeyword = (GoKeywordDescription)element$iv;
            boolean bl = false;
            String fileName = goKeyword.getKeyword() + ".xml";
            String outputPath = "goland/intellij-go/impl/resources/keywordDescriptions/" + fileName;
            System.out.println((Object)("Writing " + goKeyword.getKeyword() + " documentation to file " + outputPath));
            Intrinsics.checkNotNull((Object)goKeyword);
            GoKeywordDescription completeGoKeywordDescription = keywordDescriptionGenerator.copyKeywordDescriptionAndAddText(goKeyword);
            Closeable closeable = new FileOutputStream(outputPath);
            Throwable throwable = null;
            try {
                FileOutputStream os = (FileOutputStream)closeable;
                boolean bl2 = false;
                LangSpecParserKt.marshalGoKeywordDescription(completeGoKeywordDescription, os);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    private static final void checkFurtherReadingReachability(GoKeywordDescriptions keywordDescriptions) {
        List<GoKeywordDescription> list = keywordDescriptions.getGoKeywordDescriptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getGoKeywordDescriptions(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GoKeywordDescription keyword = (GoKeywordDescription)element$iv;
            boolean bl = false;
            List<String> list2 = keyword.getFurtherReadingLinks();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getFurtherReadingLinks(...)");
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String furtherReadingLink = (String)element$iv2;
                boolean bl2 = false;
                try {
                    Intrinsics.checkNotNull((Object)furtherReadingLink);
                    LangSpecParserKt.makeHttpRequest(furtherReadingLink);
                }
                catch (Exception e) {
                    throw new IllegalStateException("When downloaded further reading link " + furtherReadingLink + " for keyword " + keyword.getKeyword() + ", ran into exception " + e + ".");
                }
            }
        }
    }

    private static final HttpResponse<String> makeHttpRequest(String url) {
        URI uri = URI.create(url);
        HttpRequest request = HttpRequest.newBuilder(uri).header("accept", "text/html").build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IllegalStateException("Unable to fetch HTTP page at " + url + ": " + response);
        }
        Intrinsics.checkNotNull(response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KeywordDescriptionGenerator instantiateKeywordDescriptionGeneratorFromInternet() {
        String string = LangSpecParserKt.getGoKeywords().getSpecificationURL();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecificationURL(...)");
        HttpResponse<String> response = LangSpecParserKt.makeHttpRequest(string);
        Closeable closeable = new FileOutputStream("goland/intellij-go/impl/testData/go_langspec.html");
        Throwable throwable = null;
        try {
            FileOutputStream os = (FileOutputStream)closeable;
            boolean bl = false;
            String string2 = response.body();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"body(...)");
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            os.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Document doc = Jsoup.parse((String)response.body(), (String)Charsets.UTF_8.name());
        Intrinsics.checkNotNull((Object)doc);
        String string3 = LangSpecParserKt.getGoKeywords().getSpecificationURL();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSpecificationURL(...)");
        return new KeywordDescriptionGenerator(doc, string3);
    }

    @VisibleForTesting
    public static final boolean isPrintableASCIIOrSectionSign(char c) {
        char c2 = c;
        return (' ' <= c2 ? c2 < '\u007f' : false) || c == '\u00a7';
    }

    @VisibleForTesting
    public static final void marshalGoKeywordDescription(@NotNull GoKeywordDescription goKeyword, @NotNull OutputStream os) {
        Intrinsics.checkNotNullParameter((Object)goKeyword, (String)"goKeyword");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Class[] classArray = new Class[]{GoKeywordDescription.class};
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)jAXBContext, (String)"newInstance(...)");
        JAXBContext marshallerContext = jAXBContext;
        Marshaller marshaller = marshallerContext.createMarshaller();
        Intrinsics.checkNotNullExpressionValue((Object)marshaller, (String)"createMarshaller(...)");
        Marshaller mar = marshaller;
        mar.setProperty("jaxb.formatted.output", (Object)true);
        mar.setProperty("com.sun.xml.bind.xmlHeaders", (Object)GENERATED_NOTICE);
        mar.marshal((Object)goKeyword, os);
    }

    public static /* synthetic */ void main(String[] args) {
        LangSpecParserKt.main();
    }

    private static final GoKeywordDescriptions goKeywords_delegate$lambda$0() {
        return LangSpecParserKt.parseGoKeywordDescriptions();
    }

    static {
        HttpClient httpClient = HttpClient.newHttpClient();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"newHttpClient(...)");
        client = httpClient;
    }
}

