/*
 * Decompiled with CFR 0.152.
 */
package com.goide.documentation;

import com.goide.documentation.GoDocumentationProvider;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoSpecType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.presentation.GoPsiPresentationFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoNavigatablePsiPresentationFunction
implements GoPsiPresentationFunction {
    @Nullable
    private final String myContextImportPath;
    @Nullable
    private final String myContextQualifiedName;

    public GoNavigatablePsiPresentationFunction(@Nullable PsiElement context) {
        PsiFile psiFile = context != null ? context.getContainingFile() : null;
        this.myContextImportPath = psiFile instanceof GoFile ? ((GoFile)psiFile).getImportPath(false) : null;
        GoNamedElement namedContext = (GoNamedElement)ObjectUtils.tryCast((Object)context, GoNamedElement.class);
        this.myContextQualifiedName = namedContext != null ? StringUtil.nullize((String)namedContext.getQualifiedName()) : null;
    }

    @Override
    public String apply(PsiElement e) {
        GoNamedElement namedElement;
        if (e instanceof GoSpecType) {
            GoSpecType specType = (GoSpecType)e;
            v0 = specType.getTypeSpec();
        } else {
            v0 = namedElement = (GoNamedElement)ObjectUtils.tryCast((Object)e, GoNamedElement.class);
        }
        if (namedElement != null) {
            String name = namedElement.getName();
            if (e instanceof GoNamedElement && Objects.equals(namedElement.getQualifiedName(), this.myContextQualifiedName)) {
                return name;
            }
            if (StringUtil.isNotEmpty((String)name)) {
                GoFile file = namedElement.getContainingFile();
                String importPath = file.getImportPath(false);
                String packageName = file.getPackageName();
                PsiDirectory directory = file.getContainingDirectory();
                String packageLocalUrl = directory != null ? GoDocumentationProvider.getLocalUrlToElement((PsiElement)directory) : null;
                String localUrl = GoDocumentationProvider.getLocalUrlToElement(namedElement);
                boolean insertQualifier = this.insertQualifier(file, importPath, packageName, namedElement);
                if (StringUtil.isEmpty((String)localUrl)) {
                    return insertQualifier ? GoPsiImplUtil.getFqn(packageName, name) : name;
                }
                if (insertQualifier) {
                    String packageText = packageLocalUrl != null ? String.format("<a href=\"%s%s\">%s</a>", "psi_element://", packageLocalUrl, packageName) : packageName;
                    return String.format("%s.<a href=\"%s%s\">%s</a>", packageText, "psi_element://", localUrl, name);
                }
                return String.format("<a href=\"%s%s\">%s</a>", "psi_element://", localUrl, name);
            }
        }
        return e != null ? e.getText() : "";
    }

    private boolean insertQualifier(@Nullable GoFile file, @Nullable String importPath, @Nullable String packageName, @NotNull GoNamedElement element) {
        if (element == null) {
            GoNavigatablePsiPresentationFunction.$$$reportNull$$$0(0);
        }
        return StringUtil.isNotEmpty((String)packageName) && !(element instanceof GoMethodDeclaration) && !GoPsiImplUtil.isBuiltinFile((PsiFile)file) && !Objects.equals(importPath, this.myContextImportPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/documentation/GoNavigatablePsiPresentationFunction", "insertQualifier"));
    }
}

