/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.renderer;

import com.goide.dlv.DlvXValue;
import com.goide.dlv.renderer.DlvValueRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/goide/dlv/renderer/DlvDurationValueRenderer;", "Lcom/goide/dlv/renderer/DlvValueRenderer;", "<init>", "()V", "getPresentation", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "value", "Lcom/goide/dlv/DlvXValue;", "getNumericValue", "", "formatDuration", "nanoseconds", "", "getFraction", "precision", "intellij.go.impl"})
public final class DlvDurationValueRenderer
implements DlvValueRenderer {
    @Override
    @NotNull
    public Promise<XValuePresentation> getPresentation(@NotNull XValueNode node, @NotNull DlvXValue value) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        Promise promise = value.getTypePresentationAsync(node).then(arg_0 -> DlvDurationValueRenderer.getPresentation$lambda$1(arg_0 -> DlvDurationValueRenderer.getPresentation$lambda$0(this, value, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private final String getNumericValue(String value) {
        return switch (value) {
            case "Nanosecond", "Nanosecond (1)" -> "1";
            case "Microsecond (1000)", "Microsecond" -> "1000";
            case "Millisecond", "Millisecond (1000000)" -> "1000000";
            case "Second", "Second (1000000000)" -> "1000000000";
            case "Minute", "Minute (60000000000)" -> "60000000000";
            case "Hour", "Hour (3600000000000)" -> "3600000000000";
            default -> value;
        };
    }

    private final String formatDuration(long nanoseconds) {
        long hours;
        long ns = nanoseconds;
        if (ns == 0L) {
            return "0s";
        }
        String sign = ns < 0L ? "-" : "";
        if ((ns = Math.abs(ns)) < TimeUnit.MICROSECONDS.toNanos(1L)) {
            return sign + ns + "ns";
        }
        if (ns < TimeUnit.MILLISECONDS.toNanos(1L)) {
            long micros = TimeUnit.NANOSECONDS.toMicros(ns);
            return sign + micros + this.getFraction(ns, TimeUnit.MICROSECONDS.toNanos(1L)) + "\u00b5s";
        }
        if (ns < TimeUnit.SECONDS.toNanos(1L)) {
            long millis = TimeUnit.NANOSECONDS.toMillis(ns);
            return sign + millis + this.getFraction(ns, TimeUnit.MILLISECONDS.toNanos(1L)) + "ms";
        }
        long seconds = TimeUnit.NANOSECONDS.toSeconds(ns);
        String result = seconds % (long)60 + this.getFraction(ns, TimeUnit.SECONDS.toNanos(1L)) + "s";
        long minutes = seconds / (long)60;
        if (minutes > 0L) {
            result = minutes % (long)60 + "m" + result;
        }
        if ((hours = minutes / (long)60) > 0L) {
            result = hours + "h" + result;
        }
        return sign + result;
    }

    private final String getFraction(long value, long precision) {
        long fraction = value - precision * (value / precision);
        if (fraction == 0L) {
            return "";
        }
        String width = String.valueOf((int)Math.log10(precision));
        String string = ".%0" + width + "d";
        Object[] objectArray = new Object[]{fraction};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String string3 = StringUtil.trimTrailing((String)string2, (char)'0');
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trimTrailing(...)");
        return string3;
    }

    private static final XValuePresentation getPresentation$lambda$0(DlvDurationValueRenderer this$0, DlvXValue $value, String type) {
        return new XValuePresentation(this$0, $value, type){
            final /* synthetic */ DlvDurationValueRenderer this$0;
            final /* synthetic */ DlvXValue $value;
            final /* synthetic */ String $type;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                this.$type = $type;
            }

            public void renderValue(XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                String string = this.$value.getVariable().value;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value");
                String numericValue = DlvDurationValueRenderer.access$getNumericValue(this.this$0, string);
                renderer.renderNumericValue(numericValue);
                try {
                    long ns = Long.parseLong(numericValue);
                    renderer.renderSpecialSymbol(" ");
                    renderer.renderComment(DlvDurationValueRenderer.access$formatDuration(this.this$0, ns));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }

            public String getType() {
                return this.$type;
            }
        };
    }

    private static final XValuePresentation getPresentation$lambda$1(Function1 $tmp0, Object p0) {
        return (XValuePresentation)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$getNumericValue(DlvDurationValueRenderer $this, String value) {
        return $this.getNumericValue(value);
    }

    public static final /* synthetic */ String access$formatDuration(DlvDurationValueRenderer $this, long nanoseconds) {
        return $this.formatDuration(nanoseconds);
    }
}

