/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.protocol;

import com.goide.dlv.JsonReaderEx;
import com.google.gson.stream.JsonToken;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.JsonType;
import org.jetbrains.jsonProtocol.Optional;

@JsonType
public interface DlvResponse {
    public int id();

    @Optional
    @Nullable
    public JsonReaderEx result();

    @Optional
    @Nullable
    public ErrorInfo error();

    public static final class M5m
    implements ErrorInfo {
        private static final int _code = -1;
        @Nullable
        private final String _message;

        M5m(@NotNull JsonReaderEx reader) {
            if (reader == null) {
                M5m.$$$reportNull$$$0(0);
            }
            this._message = M5m.nextNullableString(reader);
        }

        @Override
        public int code() {
            return -1;
        }

        @Override
        @NotNull
        public List<String> data() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                M5m.$$$reportNull$$$0(1);
            }
            return list;
        }

        @Override
        @Nullable
        public String message() {
            return this._message;
        }

        private static String nextNullableString(@NotNull JsonReaderEx reader) {
            if (reader == null) {
                M5m.$$$reportNull$$$0(2);
            }
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return reader.nextString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/protocol/DlvResponse$M5m";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/protocol/DlvResponse$M5m";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "nextNullableString";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static final class CommandResponseImpl
    implements DlvResponse {
        @NonNls
        private static final Set<String> INLINE_RESULTS = Set.of("Recorded", "DelveVersion", "Goroutines");
        @NonNls
        private static final String ERROR_ATTRIBUTE_NAME = "error";
        @NonNls
        private static final String ID_ATTRIBUTE_NAME = "id";
        @NonNls
        private static final String RESULT_ATTRIBUTE_NAME = "result";
        @Nullable
        private ErrorInfo _error;
        private int _id;
        @Nullable
        private JsonReaderEx _result;

        public CommandResponseImpl(@NotNull JsonReaderEx reader, @Nullable String name) {
            if (reader == null) {
                CommandResponseImpl.$$$reportNull$$$0(0);
            }
            this._id = -1;
            if (name == null) {
                if (reader.hasNext() && reader.beginObject().hasNext()) {
                    name = reader.nextName();
                } else {
                    return;
                }
            }
            do {
                if (ERROR_ATTRIBUTE_NAME.equals(name)) {
                    this._error = new M5m(reader);
                    continue;
                }
                if (ID_ATTRIBUTE_NAME.equals(name)) {
                    this._id = reader.nextInt();
                    continue;
                }
                if (RESULT_ATTRIBUTE_NAME.equals(name)) {
                    if (reader.nextIsEmptyObject()) {
                        this._result = reader.subReader();
                    } else if (reader.peek() == JsonToken.BEGIN_OBJECT && reader.hasNext()) {
                        JsonReaderEx resultObject = reader.subReader();
                        if (reader.beginObject().hasNext()) {
                            if (reader.peek() == JsonToken.NAME) {
                                String firstNameInResult = reader.nextName();
                                JsonReaderEx jsonReaderEx = this._result = INLINE_RESULTS.contains(firstNameInResult) ? resultObject : reader.subReader();
                            }
                            if (reader.peek() == JsonToken.END_OBJECT) {
                                reader.endObject();
                            }
                        }
                    }
                }
                reader.skipValue();
            } while ((name = reader.nextNameOrNull()) != null);
            reader.endObject();
        }

        @Override
        @Nullable
        public ErrorInfo error() {
            return this._error;
        }

        @Override
        public int id() {
            return this._id;
        }

        @Override
        @Nullable
        public JsonReaderEx result() {
            return this._result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/goide/dlv/protocol/DlvResponse$CommandResponseImpl", "<init>"));
        }
    }

    @JsonType
    public static interface ErrorInfo {
        @Nullable
        public String message();

        @Optional
        @NotNull
        public List<String> data();

        public int code();
    }
}

