/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.protocol;

import com.goide.dlv.DlvSettings;
import com.goide.dlv.protocol.DlvApi;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jsonProtocol.OutMessage;
import org.jetbrains.jsonProtocol.Request;

public abstract class DlvRequest<T>
extends OutMessage
implements Request<T> {
    private static final String PARAMS = "params";
    private static final String ID = "id";
    private boolean argumentsObjectStarted;

    private DlvRequest() {
        try {
            this.getWriter().name("method").value(this.getMethodName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public String getMethodName() {
        Name annotation = ((Object)((Object)this)).getClass().getAnnotation(Name.class);
        String string = "RPCServer." + (annotation != null ? annotation.value() : ((Object)((Object)this)).getClass().getSimpleName());
        if (string == null) {
            DlvRequest.$$$reportNull$$$0(0);
        }
        return string;
    }

    public final void beginArguments() {
        if (!this.argumentsObjectStarted) {
            this.argumentsObjectStarted = true;
            if (this.needObject()) {
                try {
                    this.getWriter().name(PARAMS);
                    this.getWriter().beginArray();
                    this.getWriter().beginObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected boolean needObject() {
        return true;
    }

    public final void finalize(int id) {
        try {
            if (this.argumentsObjectStarted && this.needObject()) {
                this.getWriter().endObject();
                this.getWriter().endArray();
            }
            this.getWriter().name(ID).value((long)id);
            this.getWriter().endObject();
            this.getWriter().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static JsonWriter writeScope(int frameId, long goroutineId, @NotNull JsonWriter jsonWriter) throws IOException {
        void writer;
        if (jsonWriter == null) {
            DlvRequest.$$$reportNull$$$0(1);
        }
        return DlvRequest.writeScope(frameId, goroutineId, (JsonWriter)writer, new DlvLoadConfig(DlvSettings.getInstance()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static JsonWriter writeScope(int frameId, long goroutineId, @NotNull JsonWriter writer, long l) throws IOException {
        void len;
        if (writer == null) {
            DlvRequest.$$$reportNull$$$0(2);
        }
        writer.name("Scope").beginObject().name("GoroutineID").value(goroutineId).name("Frame").value((long)frameId).endObject();
        JsonWriter jsonWriter = DlvRequest.writeLoadConfig(writer, new DlvLoadConfig(DlvSettings.getInstance()).setMaxStringLen((int)len).setMaxArrayValues((int)len));
        if (jsonWriter == null) {
            DlvRequest.$$$reportNull$$$0(3);
        }
        return jsonWriter;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static JsonWriter writeScope(int frameId, long goroutineId, @NotNull JsonWriter writer, @NotNull DlvLoadConfig dlvLoadConfig) throws IOException {
        void config;
        if (writer == null) {
            DlvRequest.$$$reportNull$$$0(4);
        }
        if (dlvLoadConfig == null) {
            DlvRequest.$$$reportNull$$$0(5);
        }
        writer.name("Scope").beginObject().name("GoroutineID").value(goroutineId).name("Frame").value((long)frameId).endObject();
        JsonWriter jsonWriter = DlvRequest.writeLoadConfig(writer, (DlvLoadConfig)config);
        if (jsonWriter == null) {
            DlvRequest.$$$reportNull$$$0(6);
        }
        return jsonWriter;
    }

    private static JsonWriter writeLoadConfig(@NotNull JsonWriter writer, @NotNull DlvLoadConfig config) throws IOException {
        if (writer == null) {
            DlvRequest.$$$reportNull$$$0(7);
        }
        if (config == null) {
            DlvRequest.$$$reportNull$$$0(8);
        }
        return writer.name(config.getName()).beginObject().name("FollowPointers").value(config.isFollowPointer()).name("MaxStructFields").value((long)config.getMaxStructFields()).name("MaxVariableRecurse").value((long)config.getMaxVariableRecurse()).name("MaxStringLen").value(config.getMaxStringLen()).name("MaxArrayValues").value(config.getMaxArrayValues()).endObject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/protocol/DlvRequest";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/protocol/DlvRequest";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeLoadConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 7, 8 -> new IllegalArgumentException(string);
        };
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Name {
        public String value();
    }

    public static final class DlvLoadConfig {
        private String myName;
        private boolean myFollowPointer;
        private int myMaxStructFields;
        private int myMaxVariableRecurse;
        private int myMaxStringLen;
        private int myMaxArrayValues;

        public DlvLoadConfig(@NotNull DlvSettings dlvSettings) {
            if (dlvSettings == null) {
                DlvLoadConfig.$$$reportNull$$$0(0);
            }
            this.myName = "Cfg";
            this.myFollowPointer = true;
            this.myMaxVariableRecurse = 1;
            this.myMaxStructFields = dlvSettings.getMaxStructFields();
            this.myMaxStringLen = dlvSettings.getMaxStringLen();
            this.myMaxArrayValues = dlvSettings.getMaxArrayValues();
        }

        public String getName() {
            return this.myName;
        }

        @NotNull
        public DlvLoadConfig setName(String name) {
            this.myName = name;
            DlvLoadConfig dlvLoadConfig = this;
            if (dlvLoadConfig == null) {
                DlvLoadConfig.$$$reportNull$$$0(1);
            }
            return dlvLoadConfig;
        }

        public boolean isFollowPointer() {
            return this.myFollowPointer;
        }

        @NotNull
        public DlvLoadConfig setFollowPointer(boolean followPointer) {
            this.myFollowPointer = followPointer;
            DlvLoadConfig dlvLoadConfig = this;
            if (dlvLoadConfig == null) {
                DlvLoadConfig.$$$reportNull$$$0(2);
            }
            return dlvLoadConfig;
        }

        public int getMaxStructFields() {
            return this.myMaxStructFields;
        }

        @NotNull
        public DlvLoadConfig setMaxStructFields(int maxStructFields) {
            this.myMaxStructFields = maxStructFields;
            DlvLoadConfig dlvLoadConfig = this;
            if (dlvLoadConfig == null) {
                DlvLoadConfig.$$$reportNull$$$0(3);
            }
            return dlvLoadConfig;
        }

        public int getMaxVariableRecurse() {
            return this.myMaxVariableRecurse;
        }

        @NotNull
        public DlvLoadConfig setMaxVariableRecurse(int maxVariableRecurse) {
            this.myMaxVariableRecurse = maxVariableRecurse;
            DlvLoadConfig dlvLoadConfig = this;
            if (dlvLoadConfig == null) {
                DlvLoadConfig.$$$reportNull$$$0(4);
            }
            return dlvLoadConfig;
        }

        public long getMaxStringLen() {
            return this.myMaxStringLen;
        }

        @NotNull
        public DlvLoadConfig setMaxStringLen(int maxStringLen) {
            this.myMaxStringLen = maxStringLen;
            DlvLoadConfig dlvLoadConfig = this;
            if (dlvLoadConfig == null) {
                DlvLoadConfig.$$$reportNull$$$0(5);
            }
            return dlvLoadConfig;
        }

        public long getMaxArrayValues() {
            return this.myMaxArrayValues;
        }

        @NotNull
        public DlvLoadConfig setMaxArrayValues(int maxArrayValues) {
            this.myMaxArrayValues = maxArrayValues;
            DlvLoadConfig dlvLoadConfig = this;
            if (dlvLoadConfig == null) {
                DlvLoadConfig.$$$reportNull$$$0(6);
            }
            return dlvLoadConfig;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dlvSettings";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/protocol/DlvRequest$DlvLoadConfig";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/protocol/DlvRequest$DlvLoadConfig";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFollowPointer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMaxStructFields";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMaxVariableRecurse";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMaxStringLen";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setMaxArrayValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static final class AttachedToExistingProcess
    extends DlvObjRequest<Boolean> {
        public AttachedToExistingProcess() {
            super(w -> {});
        }
    }

    public static final class IsMulticlient
    extends DlvObjRequest<Boolean> {
        public IsMulticlient() {
            super(w -> {});
        }
    }

    public static final class GetVersion
    extends DlvObjRequest<DlvApi.GetVersion> {
        public GetVersion() {
            super(w -> {});
        }
    }

    @Name(value="Command")
    public static final class Call
    extends DlvObjRequest<DlvApi.DebuggerState> {
        public Call(@NotNull String expr) {
            if (expr == null) {
                Call.$$$reportNull$$$0(0);
            }
            this(expr, false);
        }

        public Call(@NotNull String expr, boolean unsafe) {
            if (expr == null) {
                Call.$$$reportNull$$$0(1);
            }
            super((JsonWriter w) -> {
                w.name("Name").value("call").name("expr").value(expr).name("unsafeCall").value(unsafe);
                DlvSettings dlvSettings = DlvSettings.getInstance();
                DlvRequest.writeLoadConfig(w, new DlvLoadConfig(dlvSettings).setName("ReturnInfoLoadConfig").setMaxStringLen(dlvSettings.getMaxStringLenInCall()));
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/goide/dlv/protocol/DlvRequest$Call", "<init>"));
        }
    }

    @Name(value="Command")
    public static final class ContinueCall
    extends DlvObjRequest<DlvApi.DebuggerState> {
        public ContinueCall() {
            super(w -> {
                w.name("Name").value("continue");
                DlvRequest.writeLoadConfig(w, new DlvLoadConfig(DlvSettings.getInstance()).setName("ReturnInfoLoadConfig"));
            });
        }
    }

    public static final class Set
    extends DlvObjRequest<Object> {
        /*
         * WARNING - void declaration
         */
        public Set(@NotNull String symbol, @NotNull String value, long goroutineId, int n) {
            void frameId;
            if (symbol == null) {
                Set.$$$reportNull$$$0(0);
            }
            if (value == null) {
                Set.$$$reportNull$$$0(1);
            }
            super(arg_0 -> Set.lambda$new$0((int)frameId, goroutineId, value, symbol, arg_0));
        }

        private static /* synthetic */ void lambda$new$0(int frameId, long goroutineId, String value, String symbol, JsonWriter w) throws IOException {
            DlvRequest.writeScope(frameId, goroutineId, w, value.length()).name("Symbol").value(symbol).name("Value").value(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbol";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/goide/dlv/protocol/DlvRequest$Set";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ListGoroutines
    extends DlvObjRequest<DlvApi.ListGoroutinesOut> {
        public ListGoroutines(int start, int count2) {
            super(w -> w.name("Start").value((long)start).name("Count").value((long)count2));
        }
    }

    public static final class Eval
    extends DlvObjRequest<DlvApi.Variable> {
        public Eval(@NotNull String symbol, int frameId, long goroutineId) {
            if (symbol == null) {
                Eval.$$$reportNull$$$0(0);
            }
            super(writer -> DlvRequest.writeScope(frameId, goroutineId, writer).name("Expr").value(symbol));
        }

        /*
         * WARNING - void declaration
         */
        public Eval(@NotNull String symbol, int frameId, long goroutineId, long l) {
            void len;
            if (symbol == null) {
                Eval.$$$reportNull$$$0(1);
            }
            super(arg_0 -> Eval.lambda$new$1(frameId, goroutineId, (long)len, symbol, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        public Eval(@NotNull String symbol, int frameId, long goroutineId, @NotNull DlvLoadConfig dlvLoadConfig) {
            void config;
            if (symbol == null) {
                Eval.$$$reportNull$$$0(2);
            }
            if (dlvLoadConfig == null) {
                Eval.$$$reportNull$$$0(3);
            }
            super(arg_0 -> Eval.lambda$new$2(frameId, goroutineId, (DlvLoadConfig)config, symbol, arg_0));
        }

        private static /* synthetic */ void lambda$new$2(int frameId, long goroutineId, DlvLoadConfig config, String symbol, JsonWriter writer) throws IOException {
            DlvRequest.writeScope(frameId, goroutineId, writer, config).name("Expr").value(symbol);
        }

        private static /* synthetic */ void lambda$new$1(int frameId, long goroutineId, long len, String symbol, JsonWriter writer) throws IOException {
            DlvRequest.writeScope(frameId, goroutineId, writer, len).name("Expr").value(symbol);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbol";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
            }
            objectArray[1] = "com/goide/dlv/protocol/DlvRequest$Eval";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Detach
    extends DlvObjRequest<Object> {
        public Detach(boolean kill) {
            super(w -> w.name("Kill").value(kill));
        }
    }

    @Name(value="Command")
    public static final class SwitchGoroutineCommand
    extends DlvObjRequest<DlvApi.DebuggerState> {
        public SwitchGoroutineCommand(long goroutineId) {
            super(w -> w.name("Name").value("switchGoroutine").name("GoroutineID").value(goroutineId));
        }
    }

    @Name(value="Command")
    public static final class SwitchThreadCommand
    extends DlvObjRequest<DlvApi.DebuggerState> {
        public SwitchThreadCommand(int threadId) {
            super(w -> w.name("Name").value("switchThread").name("ThreadID").value((long)threadId));
        }
    }

    public static final class ListSources
    extends DlvObjRequest<List<String>> {
        public ListSources() {
            super(w -> {});
        }
    }

    public static final class State
    extends DlvObjRequest<DlvApi.DebuggerState> {
        public State() {
            this(false);
        }

        public State(boolean nonBlocking) {
            super(w -> w.name("NonBlocking").value(nonBlocking));
        }
    }

    public static final class Command
    extends DlvObjRequest<DlvApi.DebuggerState> {
        public Command(@NotNull String command) {
            if (command == null) {
                Command.$$$reportNull$$$0(0);
            }
            super((JsonWriter w) -> w.name("Name").value(command));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/goide/dlv/protocol/DlvRequest$Command", "<init>"));
        }
    }

    public static final class ListFunctionArgs
    extends Locals<List<DlvApi.Variable>> {
        public ListFunctionArgs(long goroutineId, int frameId) {
            super(goroutineId, frameId);
        }
    }

    public static final class ListLocalVars
    extends Locals<List<DlvApi.Variable>> {
        public ListLocalVars(long goroutineId, int frameId) {
            super(goroutineId, frameId);
        }
    }

    private static abstract class Locals<T>
    extends DlvObjRequest<T> {
        Locals(long goroutineId, int frameId) {
            super(w -> DlvRequest.writeScope(frameId, goroutineId, w));
        }
    }

    public static final class Stacktrace
    extends DlvObjRequest<List<DlvApi.Location>> {
        public Stacktrace(long goroutineId) {
            super(w -> w.name("Id").value(goroutineId).name("Depth").value((long)DlvSettings.getInstance().getStacktraceDepth()));
        }
    }

    public static final class FindLocation
    extends DlvObjRequest<List<DlvApi.Location>> {
        public FindLocation(@NonNls String location) {
            super((JsonWriter w) -> w.name("Loc").value(location).name("Scope").beginObject().name("GoroutineID").value(-1L).name("Frame").value(0L).endObject());
        }
    }

    public static final class StopRecording
    extends DlvObjRequest<Void> {
    }

    public static final class Recorded
    extends DlvObjRequest<DlvApi.Recorded> {
    }

    public static final class ClearBreakpoint
    extends DlvObjRequest<DlvApi.Breakpoint> {
        public ClearBreakpoint(int id) {
            super(w -> w.name(DlvRequest.ID).value((long)id));
        }
    }

    public static final class ListBreakpoints
    extends DlvObjRequest<List<DlvApi.Breakpoint>> {
    }

    public static final class CreateBreakpoint
    extends DlvObjRequest<DlvApi.Breakpoint> {
        public CreateBreakpoint(@NotNull String path, int line, @Nullable String condition) {
            if (path == null) {
                CreateBreakpoint.$$$reportNull$$$0(0);
            }
            super(w -> w.name("Breakpoint").beginObject().name("file").value(path).name("line").value((long)line).name("Cond").value(condition).endObject());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/goide/dlv/protocol/DlvRequest$CreateBreakpoint", "<init>"));
        }
    }

    public static class DlvObjRequest<T>
    extends DlvRequest<T> {
        public DlvObjRequest() {
            this(null);
        }

        public DlvObjRequest(@Nullable BodyMaker consumer) {
            try {
                JsonWriter writer = this.getWriter();
                writer.name(DlvRequest.PARAMS).beginArray().beginObject();
                if (consumer != null) {
                    consumer.make(writer);
                }
                writer.endObject().endArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected boolean needObject() {
            return false;
        }

        public static interface BodyMaker {
            public void make(JsonWriter var1) throws IOException;
        }
    }
}

