/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.dump;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntTable<T> {
    private final IntTable<T> myBase;
    private final int myBaseSize;
    private final Object2IntMap<T> myIdMap;
    private final List<T> myValues;

    public IntTable(@Nullable IntTable<T> base) {
        this.myBase = base;
        this.myBaseSize = this.myBase != null ? this.myBase.size() : 0;
        this.myIdMap = new Object2IntOpenHashMap();
        this.myValues = new ArrayList<T>();
        this.myValues.add(null);
    }

    public int addIfAbsent(@Nullable T value) {
        if (value == null) {
            return 0;
        }
        int id = this.getExistingId(value);
        if (id != 0) {
            return id;
        }
        int index = this.myValues.size();
        id = index + this.myBaseSize;
        this.myIdMap.put(value, id);
        this.myValues.add(value);
        return id;
    }

    private int getExistingId(@Nullable T value) {
        IntTable<T> table = this;
        while (table != null) {
            int id = table.myIdMap.getInt(value);
            if (id != 0) {
                return id;
            }
            table = table.myBase;
        }
        return 0;
    }

    @Nullable
    public T get(int id) {
        IntTable<T> table = this.findTableForId(id);
        if (table == null) {
            return null;
        }
        int index = id - table.myBaseSize;
        return index >= 0 && index < table.myValues.size() ? (T)table.myValues.get(index) : null;
    }

    @Nullable
    private IntTable<T> findTableForId(int id) {
        IntTable<T> table = this;
        while (table != null) {
            if (id > table.myBaseSize) {
                return table;
            }
            table = table.myBase;
        }
        return null;
    }

    public int size() {
        return this.myBaseSize + this.myIdMap.size();
    }

    @NotNull
    List<T> getOwnValues() {
        List<T> list = this.myValues.subList(1, this.myValues.size());
        if (list == null) {
            IntTable.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    IntTable<T> getBase() {
        return this.myBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/dlv/dump/IntTable", "getOwnValues"));
    }
}

