/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.breakpoint;

import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.dlv.DlvEditorsProvider;
import com.goide.dlv.breakpoint.DlvBreakpointProperties;
import com.goide.i18n.GoBundle;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DlvBreakpointType
extends XLineBreakpointType<DlvBreakpointProperties> {
    @NonNls
    public static final String ID = "DlvLineBreakpoint";

    private DlvBreakpointType() {
        super(ID, GoBundle.message((String)"go.debugger.breakpoint.title", (Object[])new Object[0]));
    }

    @Nullable
    public DlvBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            DlvBreakpointType.$$$reportNull$$$0(0);
        }
        return new DlvBreakpointProperties();
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            DlvBreakpointType.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DlvBreakpointType.$$$reportNull$$$0(2);
        }
        if (line < 0 || LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) != GoLanguage.INSTANCE) {
            return false;
        }
        return DlvBreakpointType.isLineBreakpointAvailable(file, line, project);
    }

    private static boolean isLineBreakpointAvailable(@NotNull VirtualFile file, int line, @NotNull Project project) {
        Document document;
        if (file == null) {
            DlvBreakpointType.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DlvBreakpointType.$$$reportNull$$$0(4);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(file)) == null || document.getLineEndOffset(line) == document.getLineStartOffset(line)) {
            return false;
        }
        Checker canPutAtChecker = new Checker();
        XDebuggerUtil.getInstance().iterateLine(project, document, line, (Processor)canPutAtChecker);
        return canPutAtChecker.isLineBreakpointAvailable();
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<DlvBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            DlvBreakpointType.$$$reportNull$$$0(5);
        }
        if (project == null) {
            DlvBreakpointType.$$$reportNull$$$0(6);
        }
        return new DlvEditorsProvider();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/goide/dlv/breakpoint/DlvBreakpointType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBreakpointProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isLineBreakpointAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditorsProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Checker
    implements Processor<PsiElement> {
        private boolean myIsLineBreakpointAvailable;

        private Checker() {
        }

        public boolean process(@NotNull PsiElement o) {
            IElementType type;
            if (o == null) {
                Checker.$$$reportNull$$$0(0);
            }
            if (GoParserDefinition.Lazy.COMMENTS.contains(type = o.getNode().getElementType()) || GoParserDefinition.Lazy.WHITESPACES.contains(type)) {
                return true;
            }
            this.myIsLineBreakpointAvailable = true;
            return false;
        }

        public boolean isLineBreakpointAvailable() {
            return this.myIsLineBreakpointAvailable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/dlv/breakpoint/DlvBreakpointType$Checker", "process"));
        }
    }
}

