/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv.attach;

import com.goide.actions.tool.GoDownloadableFileAction;
import com.goide.dlv.attach.GoLocalAttachDebuggerRunner;
import com.goide.dlv.attach.GoLocalAttachGroup;
import com.goide.execution.GoWslUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.WslAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public final class GoLocalAttachDebuggerProvider
implements XAttachDebuggerProvider {
    private static final Logger LOG = Logger.getInstance(GoLocalAttachDebuggerProvider.class);
    private static final Key<Boolean> COMPUTED_KEY = Key.create((String)"go.local.processes.computed");
    @NonNls
    private static final String GOPS_EXECUTABLE = "gops";
    @NonNls
    static final String GOPS_PACKAGE = "github.com/google/gops";
    private final List<Integer> myPids = Collections.synchronizedList(new ArrayList());

    @NotNull
    public XAttachPresentationGroup<ProcessInfo> getPresentationGroup() {
        GoLocalAttachGroup goLocalAttachGroup = GoLocalAttachGroup.INSTANCE;
        if (goLocalAttachGroup == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return goLocalAttachGroup;
    }

    public boolean isAttachHostApplicable(@NotNull XAttachHost attachHost) {
        if (attachHost == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        return attachHost instanceof LocalAttachHost || attachHost instanceof WslAttachHost;
    }

    @NotNull
    public List<? extends XAttachDebugger> getAvailableDebuggers(@NotNull Project project, @NotNull XAttachHost attachHost, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        if (project == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        if (attachHost == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        if (processInfo == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(4);
        }
        if (contextHolder == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        if (GoWslUtil.isInWsl(GoSdkService.getInstance(project).getSdk(null)) != attachHost instanceof WslAttachHost) {
            List list = Collections.emptyList();
            if (list == null) {
                GoLocalAttachDebuggerProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (contextHolder.getUserData(COMPUTED_KEY) == null) {
            contextHolder.putUserData(COMPUTED_KEY, (Object)true);
            this.updateProcesses(project);
        }
        if (this.myPids.contains(processInfo.getPid())) {
            List<GoLocalAttachDebuggerRunner> list = Collections.singletonList(new GoLocalAttachDebuggerRunner());
            if (list == null) {
                GoLocalAttachDebuggerProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    private void updateProcesses(@NotNull Project project) {
        if (project == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(9);
        }
        this.myPids.clear();
        VirtualFile gopsFile = GoSdkUtil.findExecutableInGoPath(GOPS_EXECUTABLE, project, null);
        if (gopsFile == null) {
            GoLocalAttachDebuggerProvider.showInstallGopsNotification(project);
            return;
        }
        try {
            Pair outputAndSuccess = (Pair)GoLocalAttachDebuggerProvider.getGopsOutput(project, GoLocalAttachDebuggerProvider.getGoPsPath(project, gopsFile)).blockingGet(10000);
            if (outputAndSuccess == null) {
                return;
            }
            if (!((Boolean)outputAndSuccess.second).booleanValue() && ((String)outputAndSuccess.first).contains("not found")) {
                GoLocalAttachDebuggerProvider.showInstallGopsNotification(project);
                return;
            }
            for (String line : StringUtil.splitByLines((String)((String)outputAndSuccess.first))) {
                char ch;
                if (line.endsWith(" #gosetup")) continue;
                Object pid = "";
                for (int i = 0; i < line.length() && Character.isDigit(ch = line.charAt(i)); ++i) {
                    pid = (String)pid + ch;
                }
                if (((String)pid).isEmpty()) continue;
                this.myPids.add(StringUtil.parseInt((String)pid, (int)-1));
            }
        }
        catch (ExecutionException | TimeoutException e) {
            LOG.warn("Could not obtain list of Go processes", (Throwable)e);
        }
    }

    @NotNull
    private static String getGoPsPath(@NotNull Project project, @NotNull VirtualFile gops) {
        if (project == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(10);
        }
        if (gops == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(11);
        }
        String gopsPath = gops.getPath();
        WSLDistribution wsl = GoWslUtil.getWsl(project);
        if (wsl != null) {
            String pathInWsl = wsl.getWslPath(gops.toNioPath());
            String string = pathInWsl != null ? pathInWsl : gopsPath;
            if (string == null) {
                GoLocalAttachDebuggerProvider.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = gopsPath;
        if (string == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void showInstallGopsNotification(@NotNull Project project) {
        if (project == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(14);
        }
        GoDownloadableFileAction.showDownloadToolNotification(project, null, GoBundle.message((String)"go.debugger.cannot.retrieve.go.processes", (Object[])new Object[0]), GOPS_EXECUTABLE, GOPS_PACKAGE);
    }

    @NotNull
    private static Promise<Pair<String, Boolean>> getGopsOutput(@NotNull Project project, @NotNull String gopsPath) {
        if (project == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(15);
        }
        if (gopsPath == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(16);
        }
        AsyncPromise outputPromise = new AsyncPromise();
        final StringBuffer output2 = new StringBuffer();
        GoExecutor.in(project, null).withExePath(gopsPath).withPtyEnabled(false).withPrintingOutputAsStatus().withProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                output2.append(event.getText());
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                LOG.debug("gops terminated with exit code " + event.getExitCode());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/dlv/attach/GoLocalAttachDebuggerProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).executeWithProgress(execResult -> {
            LOG.debug("gops exec result " + execResult.status);
            outputPromise.setResult((Object)Pair.create((Object)output2.toString(), (Object)(execResult.status == GoExecutor.ExecutionResult.Status.SUCCEEDED ? 1 : 0)));
        });
        AsyncPromise asyncPromise = outputPromise;
        if (asyncPromise == null) {
            GoLocalAttachDebuggerProvider.$$$reportNull$$$0(17);
        }
        return asyncPromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 9, 10, 11, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/attach/GoLocalAttachDebuggerProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachHost";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = GOPS_EXECUTABLE;
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gopsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/attach/GoLocalAttachDebuggerProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPsPath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGopsOutput";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAttachHostApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateProcesses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getGoPsPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showInstallGopsNotification";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGopsOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 9, 10, 11, 14, 15, 16 -> new IllegalArgumentException(string);
        };
    }
}

