/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvCommandProcessor;
import com.goide.dlv.DlvDisconnectOption;
import com.goide.dlv.JsonReaderEx;
import com.goide.dlv.protocol.DlvRequest;
import com.intellij.openapi.diagnostic.Logger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.json.JsonObjectDecoder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DummyBreakpointManager;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;
import org.jetbrains.debugger.StandaloneVmHelper;
import org.jetbrains.debugger.StepAction;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.SuspendContextManagerBase;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.MessageProcessor;

public class DlvVm
extends VmBase
implements StandaloneVmHelper.VmEx {
    public static final Logger LOG = Logger.getInstance(DlvVm.class);
    @NotNull
    private final DlvCommandProcessor commandProcessor;
    @NotNull
    private final StandaloneVmHelper vmHelper;
    @NotNull
    private final DummyBreakpointManager breakpointManager;
    private final DlvDisconnectOption myDisconnectOption;

    public DlvVm(@NotNull DebugEventListener tabListener, @NotNull Channel channel, @NotNull DlvDisconnectOption disconnectOption) {
        if (tabListener == null) {
            DlvVm.$$$reportNull$$$0(0);
        }
        if (channel == null) {
            DlvVm.$$$reportNull$$$0(1);
        }
        if (disconnectOption == null) {
            DlvVm.$$$reportNull$$$0(2);
        }
        super(tabListener);
        this.breakpointManager = new DummyBreakpointManager();
        this.myDisconnectOption = disconnectOption;
        this.commandProcessor = new DlvCommandProcessor(){

            public boolean write(@NotNull Request message) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                ByteBuf content2 = message.getBuffer();
                LOG.debug("OUT: " + content2.toString(StandardCharsets.UTF_8));
                return DlvVm.this.vmHelper.write((Object)content2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/goide/dlv/DlvVm$1", "write"));
            }
        };
        this.vmHelper = new StandaloneVmHelper((Vm)this, (MessageProcessor)this.commandProcessor, channel);
        channel.pipeline().addLast(new ChannelHandler[]{new JsonObjectDecoder(NettyUtil.MAX_CONTENT_LENGTH), new SimpleChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                ctx.close();
            }

            protected void messageReceived(ChannelHandlerContext context, Object message) {
                if (message instanceof ByteBuf) {
                    String string = ((ByteBuf)message).toString(StandardCharsets.UTF_8);
                    LOG.debug("IN: " + string);
                    try (JsonReaderEx ex = new JsonReaderEx(string);){
                        DlvVm.this.getCommandProcessor().processIncomingJson(ex);
                    }
                }
            }
        }});
    }

    @NotNull
    public DlvDisconnectOption getDisconnectOption() {
        DlvDisconnectOption dlvDisconnectOption = this.myDisconnectOption;
        if (dlvDisconnectOption == null) {
            DlvVm.$$$reportNull$$$0(3);
        }
        return dlvDisconnectOption;
    }

    @Nullable
    public Request<?> createDisconnectRequest() {
        return null;
    }

    @NotNull
    public AttachStateManager getAttachStateManager() {
        StandaloneVmHelper standaloneVmHelper = this.vmHelper;
        if (standaloneVmHelper == null) {
            DlvVm.$$$reportNull$$$0(4);
        }
        return standaloneVmHelper;
    }

    @NotNull
    public final DlvCommandProcessor getCommandProcessor() {
        DlvCommandProcessor dlvCommandProcessor = this.commandProcessor;
        if (dlvCommandProcessor == null) {
            DlvVm.$$$reportNull$$$0(5);
        }
        return dlvCommandProcessor;
    }

    @NotNull
    public ScriptManagerBase<ScriptBase> getScriptManager() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public BreakpointManager getBreakpointManager() {
        DummyBreakpointManager dummyBreakpointManager = this.breakpointManager;
        if (dummyBreakpointManager == null) {
            DlvVm.$$$reportNull$$$0(6);
        }
        return dummyBreakpointManager;
    }

    @NotNull
    public SuspendContextManager<CallFrame> getSuspendContextManager() {
        return new SuspendContextManagerBase<SuspendContextBase<CallFrame>, CallFrame>(){

            @NotNull
            public Promise<?> continueVm(@NotNull StepAction stepAction, int stepCount) {
                if (stepAction == null) {
                    3.$$$reportNull$$$0(0);
                }
                Promise promise = DlvVm.this.commandProcessor.send(new DlvRequest.Command("continue"));
                if (promise == null) {
                    3.$$$reportNull$$$0(1);
                }
                return promise;
            }

            @NotNull
            protected DebugEventListener getDebugListener() {
                DebugEventListener debugEventListener = DlvVm.this.getDebugListener();
                if (debugEventListener == null) {
                    3.$$$reportNull$$$0(2);
                }
                return debugEventListener;
            }

            @NotNull
            protected Promise<?> doSuspend() {
                Promise promise = DlvVm.this.commandProcessor.send(new DlvRequest.Command("halt"));
                if (promise == null) {
                    3.$$$reportNull$$$0(3);
                }
                return promise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stepAction";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/dlv/DlvVm$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/dlv/DlvVm$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "continueVm";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDebugListener";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doSuspend";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "continueVm";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabListener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disconnectOption";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvVm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvVm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisconnectOption";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachStateManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

