/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvSettings;
import com.goide.dlv.DlvStackFrame;
import com.goide.dlv.DlvStackFuncName;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.i18n.GoBundle;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.concurrency.Promises;

public class DlvSuspendContext
extends XSuspendContext {
    @NotNull
    private final DlvDebugProcess myProcess;
    @Nullable
    private final DlvExecutionStack myActiveStack;
    private final boolean myShowThreads;

    private DlvSuspendContext(@NotNull DlvDebugProcess process, @Nullable DlvExecutionStack activeStack, boolean showThreads) {
        if (process == null) {
            DlvSuspendContext.$$$reportNull$$$0(0);
        }
        this.myProcess = process;
        this.myActiveStack = activeStack;
        this.myShowThreads = showThreads;
    }

    @RequiresBackgroundThread
    @NotNull
    static Promise<DlvSuspendContext> create(@NotNull DlvDebugProcess process, @Nullable DlvApi.Thread currentThread, @Nullable String err) {
        if (process == null) {
            DlvSuspendContext.$$$reportNull$$$0(1);
        }
        ThreadingAssertions.assertBackgroundThread();
        DlvThreadExecutionStack activeStack = currentThread != null ? new DlvThreadExecutionStack(process, currentThread, DlvSuspendContext.threadLocation(currentThread), true, err) : null;
        Promise promise = Promises.resolvedPromise((Object)((Object)new DlvSuspendContext(process, activeStack, true)));
        if (promise == null) {
            DlvSuspendContext.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @RequiresBackgroundThread
    @NotNull
    static Promise<DlvSuspendContext> create(@NotNull DlvDebugProcess process, @Nullable DlvApi.Goroutine currentGoroutine, @Nullable String err) {
        if (process == null) {
            DlvSuspendContext.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertBackgroundThread();
        DlvGoroutineExecutionStack activeStack = currentGoroutine != null ? new DlvGoroutineExecutionStack(process, currentGoroutine, true, err) : null;
        Promise promise = Promises.resolvedPromise((Object)((Object)new DlvSuspendContext(process, activeStack, false)));
        if (promise == null) {
            DlvSuspendContext.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @Nullable
    public XExecutionStack getActiveExecutionStack() {
        return this.myActiveStack;
    }

    public void computeExecutionStacks(XSuspendContext.XExecutionStackContainer container) {
        if (this.myShowThreads) {
            this.myProcess.send(new DlvRequest.State(true)).thenAsync(state -> this.handleThreads((DlvApi.DebuggerState)state, container));
        } else {
            ArrayList result = new ArrayList();
            this.myProcess.send(new DlvRequest.ListGoroutines(0, DlvSuspendContext.getGoroutinePackSize())).thenAsync(out -> this.handleGoroutines((DlvApi.ListGoroutinesOut)out, result, container));
        }
    }

    @NotNull
    private Promise<?> handleThreads(@NotNull DlvApi.DebuggerState state, @NotNull XSuspendContext.XExecutionStackContainer container) {
        if (state == null) {
            DlvSuspendContext.$$$reportNull$$$0(5);
        }
        if (container == null) {
            DlvSuspendContext.$$$reportNull$$$0(6);
        }
        if (container.isObsolete()) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DlvSuspendContext.$$$reportNull$$$0(7);
            }
            return promise;
        }
        List stacks = ContainerUtil.map(state.threads, it -> this.myActiveStack != null && it.id == this.myActiveStack.myId ? this.myActiveStack : new DlvThreadExecutionStack(this.myProcess, (DlvApi.Thread)it, DlvSuspendContext.threadLocation(it), false, null));
        container.addExecutionStack(ContainerUtil.sorted((Collection)stacks, Comparator.comparingLong(DlvExecutionStack::getId)), true);
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            DlvSuspendContext.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @NotNull
    private Promise<?> handleGoroutines(@NotNull DlvApi.ListGoroutinesOut goroutinesOut, @NotNull List<DlvExecutionStack> result, @NotNull XSuspendContext.XExecutionStackContainer container) {
        if (goroutinesOut == null) {
            DlvSuspendContext.$$$reportNull$$$0(9);
        }
        if (result == null) {
            DlvSuspendContext.$$$reportNull$$$0(10);
        }
        if (container == null) {
            DlvSuspendContext.$$$reportNull$$$0(11);
        }
        if (container.isObsolete()) {
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DlvSuspendContext.$$$reportNull$$$0(12);
            }
            return promise;
        }
        result.addAll(ContainerUtil.map(goroutinesOut.Goroutines, it -> this.myActiveStack != null && it.id == this.myActiveStack.myId ? this.myActiveStack : new DlvGoroutineExecutionStack(this.myProcess, (DlvApi.Goroutine)it, false, null)));
        if (goroutinesOut.Nextg == -1) {
            container.addExecutionStack(ContainerUtil.sorted(result, Comparator.comparingLong(DlvExecutionStack::getId)), true);
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DlvSuspendContext.$$$reportNull$$$0(13);
            }
            return promise;
        }
        if (goroutinesOut.Nextg > DlvSettings.getInstance().getGoroutinesLimit()) {
            container.addExecutionStack(ContainerUtil.sorted(result, Comparator.comparingLong(DlvExecutionStack::getId)), true);
            String message = GoBundle.message((String)"go.debugger.only.first.goroutines.are.shown", (Object[])new Object[]{DlvSettings.getInstance().getGoroutinesLimit()});
            DlvDebugProcess.showNotification(this.myProcess.getSession().getProject(), NotificationType.WARNING, message);
            Promise promise = Promises.resolvedPromise();
            if (promise == null) {
                DlvSuspendContext.$$$reportNull$$$0(14);
            }
            return promise;
        }
        Promise promise = this.myProcess.send(new DlvRequest.ListGoroutines(goroutinesOut.Nextg, DlvSuspendContext.getGoroutinePackSize())).thenAsync(out -> this.handleGoroutines((DlvApi.ListGoroutinesOut)out, result, container));
        if (promise == null) {
            DlvSuspendContext.$$$reportNull$$$0(15);
        }
        return promise;
    }

    private static int getGoroutinePackSize() {
        return Math.min(10000, DlvSettings.getInstance().getGoroutinesLimit());
    }

    @Nullable
    @NlsSafe
    public static String getLabelsString(@NotNull DlvApi.Goroutine goroutine) {
        Map<String, String> labels;
        if (goroutine == null) {
            DlvSuspendContext.$$$reportNull$$$0(16);
        }
        if ((labels = goroutine.labels) == null || labels.isEmpty()) {
            return null;
        }
        return StringUtil.join((Collection)ContainerUtil.map(labels.entrySet(), it -> (String)it.getKey() + ": " + (String)it.getValue()), (String)", ");
    }

    @NotNull
    private static DlvApi.Location threadLocation(@NotNull DlvApi.Thread thread) {
        if (thread == null) {
            DlvSuspendContext.$$$reportNull$$$0(17);
        }
        return new DlvApi.Location(thread.pc, thread.file, thread.line, thread.function);
    }

    @NotNull
    static DlvStackFuncName getStackFuncName(@NotNull DlvDebugProcess process, @NotNull DlvApi.Location loc) {
        DlvApi.Function function;
        String dlvFuncName;
        if (process == null) {
            DlvSuspendContext.$$$reportNull$$$0(18);
        }
        if (loc == null) {
            DlvSuspendContext.$$$reportNull$$$0(19);
        }
        String string = dlvFuncName = (function = loc.function) != null ? function.name : null;
        if (dlvFuncName == null) {
            return new DlvStackFuncName(loc.name(), "");
        }
        DlvStackFuncName dlvStackFuncName = (DlvStackFuncName)ReadAction.compute(() -> process.getSymbolPrettier().prettifyFunc(dlvFuncName));
        if (dlvStackFuncName == null) {
            DlvSuspendContext.$$$reportNull$$$0(20);
        }
        return dlvStackFuncName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7, 8, 12, 13, 14, 15, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvSuspendContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goroutinesOut";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goroutine";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvSuspendContext";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "handleThreads";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "handleGoroutines";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackFuncName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleThreads";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleGoroutines";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLabelsString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "threadLocation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStackFuncName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7, 8, 12, 13, 14, 15, 20 -> new IllegalStateException(string);
        };
    }

    public static abstract class DlvExecutionStack
    extends XExecutionStack {
        private final DlvDebugProcess myProcess;
        private final boolean myIsCurrent;
        private final DlvStackFrame myTopFrame;
        private final DlvApi.Location myGoStatementLocation;
        private final long myStackGoroutineId;
        private final long myId;
        private final String myErr;
        volatile Promise<List<XStackFrame>> cachedFrames;
        private static final PromiseManager<DlvExecutionStack, List<XStackFrame>> CALL_FRAMES_LOADER = new PromiseManager<DlvExecutionStack, List<XStackFrame>>(DlvExecutionStack.class){

            @NotNull
            public Promise<List<XStackFrame>> load(@NotNull DlvExecutionStack stack) {
                if (stack == null) {
                    1.$$$reportNull$$$0(0);
                }
                Promise promise = stack.myProcess.getStacktrace(stack.myStackGoroutineId).then(frames -> {
                    ArrayList<DlvStackFrame> result;
                    if (frames == null) {
                        result = new ArrayList<DlvStackFrame>(1);
                        result.add(stack.myTopFrame);
                    } else {
                        boolean reuseTopFrame;
                        result = frames;
                        DlvStackFrame topFrame = (DlvStackFrame)((Object)((Object)ObjectUtils.tryCast((Object)ContainerUtil.getFirstItem((List)frames), DlvStackFrame.class)));
                        boolean bl = reuseTopFrame = topFrame != null && topFrame.getGoroutineId() == stack.myTopFrame.getGoroutineId() && topFrame.getFrameId() == stack.myTopFrame.getFrameId() && topFrame.getLocation().equals(stack.myTopFrame.getLocation());
                        if (reuseTopFrame) {
                            result.set(0, stack.myTopFrame);
                        } else if (topFrame != null && !topFrame.hasErr() && stack.myErr != null) {
                            topFrame.setErr(stack.myErr);
                        }
                    }
                    DlvApi.Location goStatementLocation = stack.myGoStatementLocation;
                    if (goStatementLocation != null) {
                        DlvStackFuncName stackFuncName = DlvSuspendContext.getStackFuncName(stack.myProcess, goStatementLocation);
                        result.add(new DlvStackFrame(stack.myProcess, goStatementLocation, stackFuncName, stack.myStackGoroutineId, result.size(), null, true));
                    }
                    return result;
                });
                if (promise == null) {
                    1.$$$reportNull$$$0(1);
                }
                return promise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stack";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/goide/dlv/DlvSuspendContext$DlvExecutionStack$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/goide/dlv/DlvSuspendContext$DlvExecutionStack$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "load";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "load";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };

        /*
         * WARNING - void declaration
         */
        protected DlvExecutionStack(@NotNull DlvDebugProcess process, @NotNull @Nls String name, @Nullable @Nls String details, long id, long stackGoroutineId, boolean isCurrent, @NotNull DlvApi.Location topFrameLocation, @NotNull DlvStackFuncName topFuncName, @Nullable DlvApi.Location location, @Nullable String string) {
            void goStatementLocation;
            void err;
            if (process == null) {
                DlvExecutionStack.$$$reportNull$$$0(0);
            }
            if (name == null) {
                DlvExecutionStack.$$$reportNull$$$0(1);
            }
            if (topFrameLocation == null) {
                DlvExecutionStack.$$$reportNull$$$0(2);
            }
            if (topFuncName == null) {
                DlvExecutionStack.$$$reportNull$$$0(3);
            }
            super(name + " " + id + (String)(details != null ? " " + details + ", " : " ") + topFuncName.getFuncName(), isCurrent ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
            this.myProcess = process;
            this.myIsCurrent = isCurrent;
            this.myStackGoroutineId = stackGoroutineId;
            this.myTopFrame = new DlvStackFrame(this.myProcess, topFrameLocation, topFuncName, this.myStackGoroutineId, 0, (String)err, false);
            this.myGoStatementLocation = goStatementLocation;
            this.myId = id;
            this.myErr = err;
        }

        @Nullable
        public XStackFrame getTopFrame() {
            return this.myTopFrame;
        }

        public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
            if (container == null) {
                DlvExecutionStack.$$$reportNull$$$0(4);
            }
            if (container.isObsolete()) {
                return;
            }
            DlvDebugProcess.runInBackground(() -> CALL_FRAMES_LOADER.get((Object)this).onSuccess(frames -> {
                if (!container.isObsolete()) {
                    container.addStackFrames(frames, true);
                }
            }));
        }

        public long getId() {
            return this.myId;
        }

        @NotNull
        abstract DlvRequest.DlvObjRequest<DlvApi.DebuggerState> createSwitchCommand();

        boolean isCurrent() {
            return this.myIsCurrent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topFrameLocation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topFuncName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
            }
            objectArray2[1] = "com/goide/dlv/DlvSuspendContext$DlvExecutionStack";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeStackFrames";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DlvThreadExecutionStack
    extends DlvExecutionStack {
        private static final long CURRENT_THREAD_GOROUTINE_ID = -1L;

        private DlvThreadExecutionStack(@NotNull DlvDebugProcess process, @NotNull DlvApi.Thread thread, @NotNull DlvApi.Location threadLocation, boolean isCurrent, @Nullable String err) {
            if (process == null) {
                DlvThreadExecutionStack.$$$reportNull$$$0(0);
            }
            if (thread == null) {
                DlvThreadExecutionStack.$$$reportNull$$$0(1);
            }
            if (threadLocation == null) {
                DlvThreadExecutionStack.$$$reportNull$$$0(2);
            }
            super(process, GoBundle.message((String)"go.debugger.thread", (Object[])new Object[0]), null, thread.id, -1L, isCurrent, threadLocation, DlvSuspendContext.getStackFuncName(process, DlvSuspendContext.threadLocation(thread)), null, err);
        }

        @Override
        @NotNull
        DlvRequest.DlvObjRequest<DlvApi.DebuggerState> createSwitchCommand() {
            return new DlvRequest.SwitchThreadCommand((int)this.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "process";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thread";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "threadLocation";
                    break;
                }
            }
            objectArray[1] = "com/goide/dlv/DlvSuspendContext$DlvThreadExecutionStack";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DlvGoroutineExecutionStack
    extends DlvExecutionStack {
        private DlvGoroutineExecutionStack(@NotNull DlvDebugProcess process, @NotNull DlvApi.Goroutine goroutine, boolean isCurrent, @Nullable String err) {
            if (process == null) {
                DlvGoroutineExecutionStack.$$$reportNull$$$0(0);
            }
            if (goroutine == null) {
                DlvGoroutineExecutionStack.$$$reportNull$$$0(1);
            }
            super(process, GoBundle.message((String)"go.debugger.goroutine", (Object[])new Object[0]), DlvSuspendContext.getLabelsString(goroutine), goroutine.id, goroutine.id, isCurrent, goroutine.currentLoc, DlvSuspendContext.getStackFuncName(process, goroutine.currentLoc), goroutine.goStatementLoc, err);
        }

        @Override
        @NotNull
        DlvRequest.DlvObjRequest<DlvApi.DebuggerState> createSwitchCommand() {
            return new DlvRequest.SwitchGoroutineCommand(this.getId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "process";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "goroutine";
                    break;
                }
            }
            objectArray[1] = "com/goide/dlv/DlvSuspendContext$DlvGoroutineExecutionStack";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

