/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvStackFrame;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameters;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.presentation.GoPsiPresentationBuilder;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;

public class DlvSmartStepIntoHandler
extends XSmartStepIntoHandler<Variant> {
    private final XDebugSession mySession;

    DlvSmartStepIntoHandler(@NotNull XDebugSession session) {
        if (session == null) {
            DlvSmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        this.mySession = session;
    }

    @NotNull
    public List<Variant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        Document document;
        if (position == null) {
            DlvSmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(position.getFile())) == null) {
            List<Variant> list = Collections.emptyList();
            if (list == null) {
                DlvSmartStepIntoHandler.$$$reportNull$$$0(2);
            }
            return list;
        }
        DlvDebugProcess process = (DlvDebugProcess)((Object)ObjectUtils.tryCast((Object)this.mySession.getDebugProcess(), DlvDebugProcess.class));
        if (process == null) {
            List<Variant> list = Collections.emptyList();
            if (list == null) {
                DlvSmartStepIntoHandler.$$$reportNull$$$0(3);
            }
            return list;
        }
        DlvStackFrame frame = (DlvStackFrame)((Object)ObjectUtils.tryCast((Object)this.mySession.getCurrentStackFrame(), DlvStackFrame.class));
        if (frame == null) {
            List<Variant> list = Collections.emptyList();
            if (list == null) {
                DlvSmartStepIntoHandler.$$$reportNull$$$0(4);
            }
            return list;
        }
        int line = position.getLine();
        int minOffset = document.getLineStartOffset(line);
        CallProcessor processor2 = new CallProcessor(process, document, frame.getGoroutineId(), minOffset, line);
        XDebuggerUtil.getInstance().iterateLine(this.mySession.getProject(), document, line, (Processor)processor2);
        List list = ContainerUtil.sorted(processor2.getVariants());
        if (list == null) {
            DlvSmartStepIntoHandler.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void startStepInto(@NotNull Variant variant, @Nullable XSuspendContext context) {
        if (variant == null) {
            DlvSmartStepIntoHandler.$$$reportNull$$$0(6);
        }
        this.stepInto(variant);
    }

    @Nullable
    Promise<?> stepInto(@NotNull Variant variant) {
        if (variant == null) {
            DlvSmartStepIntoHandler.$$$reportNull$$$0(7);
        }
        return variant.stepInto();
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            DlvSmartStepIntoHandler.$$$reportNull$$$0(8);
        }
        return GoBundle.message((String)"go.debugger.smart.step.into.popup.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvSmartStepIntoHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvSmartStepIntoHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stepInto";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class CallProcessor
    implements Processor<PsiElement> {
        private final DlvDebugProcess myProcess;
        private final Document myDocument;
        private final long myGoroutineId;
        private final int myMinOffset;
        private final Ref<Integer> myMaxLine;
        private final List<Variant> myVariants;
        private final Set<PsiElement> myVisitedCalls;
        private final Set<PsiElement> myVisitedResolves;
        private final Map<PsiElement, InterfaceMethodCallVariant> myInterfaceMethods;
        private boolean myUnhandledCalls;

        /*
         * WARNING - void declaration
         */
        private CallProcessor(@NotNull DlvDebugProcess process, @NotNull Document document, long goroutineId, int minOffset, int n) {
            void line;
            if (process == null) {
                CallProcessor.$$$reportNull$$$0(0);
            }
            if (document == null) {
                CallProcessor.$$$reportNull$$$0(1);
            }
            this.myVariants = new ArrayList<Variant>();
            this.myVisitedCalls = new HashSet<PsiElement>();
            this.myVisitedResolves = new HashSet<PsiElement>();
            this.myInterfaceMethods = new HashMap<PsiElement, InterfaceMethodCallVariant>();
            this.myProcess = process;
            this.myDocument = document;
            this.myGoroutineId = goroutineId;
            this.myMinOffset = minOffset;
            this.myMaxLine = Ref.create((Object)((int)(line + true)));
        }

        public boolean process(PsiElement element) {
            GoCallExpr call = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)element, GoCallExpr.class, (boolean)false);
            GoReferenceExpression expression = (GoReferenceExpression)ObjectUtils.tryCast((Object)(call != null ? call.getExpression() : null), GoReferenceExpression.class);
            if (expression != null && expression.getTextRange().getStartOffset() >= this.myMinOffset && this.myVisitedCalls.add(call)) {
                this.updateMaxLine(call);
                ContainerUtil.addIfNotNull(this.myVariants, (Object)this.getVariant(expression));
                this.process(call.getParent());
                for (GoCallExpr childCall : PsiTreeUtil.findChildrenOfType((PsiElement)call, GoCallExpr.class)) {
                    this.process(childCall);
                }
            }
            return true;
        }

        private void updateMaxLine(@NotNull PsiElement element) {
            int expressionEndLine;
            if (element == null) {
                CallProcessor.$$$reportNull$$$0(2);
            }
            if ((expressionEndLine = this.myDocument.getLineNumber(element.getTextRange().getEndOffset()) + 1) > (Integer)this.myMaxLine.get()) {
                this.myMaxLine.set((Object)expressionEndLine);
            }
        }

        @Nullable
        private Variant getVariant(@NotNull GoReferenceExpression expr) {
            PsiElement resolve;
            if (expr == null) {
                CallProcessor.$$$reportNull$$$0(3);
            }
            if ((resolve = expr.resolve()) instanceof GoFunctionDeclaration) {
                return this.myVisitedResolves.add(resolve) ? this.getFunctionVariant(expr, (GoFunctionDeclaration)resolve) : null;
            }
            if (resolve instanceof GoMethodDeclaration) {
                return this.myVisitedResolves.add(resolve) ? this.getMethodVariant(expr, (GoMethodDeclaration)resolve) : null;
            }
            if (resolve instanceof GoMethodSpec) {
                return this.getInterfaceMethodVariant(expr, (GoMethodSpec)resolve);
            }
            if (resolve instanceof GoParamDefinition || resolve instanceof GoVarDefinition || resolve instanceof GoFieldDefinition) {
                return this.myVisitedResolves.add(resolve) ? this.getFunctionValueVariant(expr, (GoTypeOwner)resolve) : null;
            }
            this.myUnhandledCalls = true;
            return null;
        }

        @Nullable
        private Variant getFunctionVariant(@NotNull GoReferenceExpression expr, @NotNull GoFunctionDeclaration resolved) {
            if (expr == null) {
                CallProcessor.$$$reportNull$$$0(4);
            }
            if (resolved == null) {
                CallProcessor.$$$reportNull$$$0(5);
            }
            return this.createVariant(expr, resolved, (offset, function, packagePath, text) -> new FunctionCallVariant(expr, text, this.myProcess, this.myGoroutineId, this.myMaxLine, packagePath, function));
        }

        @Nullable
        private Variant getMethodVariant(@NotNull GoReferenceExpression expr, @NotNull GoMethodDeclaration resolved) {
            GoType receiverType;
            if (expr == null) {
                CallProcessor.$$$reportNull$$$0(6);
            }
            if (resolved == null) {
                CallProcessor.$$$reportNull$$$0(7);
            }
            if ((receiverType = resolved.getReceiverType()) == null) {
                this.myUnhandledCalls = true;
                return null;
            }
            return this.createVariant(expr, resolved, (offset, function, packagePath, text) -> new MethodCallVariant(expr, text, this.myProcess, this.myGoroutineId, this.myMaxLine, packagePath, receiverType.getText(), function));
        }

        @Nullable
        private Variant getInterfaceMethodVariant(@NotNull GoReferenceExpression expr, @NotNull GoMethodSpec resolved) {
            String interfaceValue;
            GoTypeSpec interfaceType;
            String receiverType;
            if (expr == null) {
                CallProcessor.$$$reportNull$$$0(8);
            }
            if (resolved == null) {
                CallProcessor.$$$reportNull$$$0(9);
            }
            String string = receiverType = (interfaceType = (GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)resolved, GoTypeSpec.class)) != null ? interfaceType.getName() : null;
            if (receiverType == null) {
                this.myUnhandledCalls = true;
                return null;
            }
            GoQualifier qualifier = expr.getQualifier();
            if (!PsiTreeUtil.findChildrenOfType((PsiElement)qualifier, GoCallExpr.class).isEmpty()) {
                this.myUnhandledCalls = true;
                return null;
            }
            String string2 = interfaceValue = qualifier != null ? qualifier.getText() : null;
            if (interfaceValue == null) {
                this.myUnhandledCalls = true;
                return null;
            }
            InterfaceMethodCallVariant existing = this.myInterfaceMethods.get(resolved);
            if (existing != null) {
                existing.addInterfaceValue(interfaceValue);
                return null;
            }
            InterfaceMethodCallVariant variant = this.createVariant(expr, resolved, (offset, function, packagePath, text) -> new InterfaceMethodCallVariant(expr, text, this.myProcess, this.myGoroutineId, this.myMaxLine, function, interfaceValue));
            if (variant != null) {
                this.myInterfaceMethods.put(resolved, variant);
            }
            return variant;
        }

        @Nullable
        private Variant getFunctionValueVariant(@NotNull GoReferenceExpression expr, @NotNull GoTypeOwner resolve) {
            String text;
            GoType type;
            if (expr == null) {
                CallProcessor.$$$reportNull$$$0(10);
            }
            if (resolve == null) {
                CallProcessor.$$$reportNull$$$0(11);
            }
            if ((type = resolve.getGoUnderlyingType(null)) instanceof GoFunctionType && PsiTreeUtil.findChildrenOfType((PsiElement)expr, GoCallExpr.class).isEmpty() && (text = CallProcessor.getVariantText(expr, type)) != null) {
                return new FunctionValueCallVariant(expr, text, this.myProcess, this.myGoroutineId, this.myMaxLine, expr.getText());
            }
            this.myUnhandledCalls = true;
            return null;
        }

        @Nullable
        <T> T createVariant(@NotNull GoReferenceExpression expr, @NotNull GoNamedElement resolved, @NotNull VariantFactory<T> factory) {
            String functionName;
            if (expr == null) {
                CallProcessor.$$$reportNull$$$0(12);
            }
            if (resolved == null) {
                CallProcessor.$$$reportNull$$$0(13);
            }
            if (factory == null) {
                CallProcessor.$$$reportNull$$$0(14);
            }
            if ((functionName = resolved.getName()) == null) {
                this.myUnhandledCalls = true;
                return null;
            }
            String packagePath = CallProcessor.getPackagePath(resolved.getContainingFile());
            if (packagePath == null) {
                this.myUnhandledCalls = true;
                return null;
            }
            String text = CallProcessor.getVariantText(expr, resolved);
            if (text == null) {
                this.myUnhandledCalls = true;
                return null;
            }
            return factory.create(expr.getTextRange().getStartOffset(), functionName, packagePath, text);
        }

        @Nullable
        private static String getVariantText(@NotNull GoReferenceExpression expr, @NotNull PsiElement signatureOwner) {
            GoParameters parameters;
            GoSignature goSignature;
            if (expr == null) {
                CallProcessor.$$$reportNull$$$0(15);
            }
            if (signatureOwner == null) {
                CallProcessor.$$$reportNull$$$0(16);
            }
            if (signatureOwner instanceof GoSignatureOwner) {
                GoSignatureOwner owner = (GoSignatureOwner)signatureOwner;
                goSignature = owner.getSignature();
            } else {
                goSignature = null;
            }
            GoSignature signature = goSignature;
            GoParameters goParameters = parameters = signature != null ? signature.getParameters() : null;
            if (parameters == null) {
                return null;
            }
            Object name = expr.getText();
            if (signatureOwner instanceof GoMethodDeclaration) {
                GoType receiverType = ((GoMethodDeclaration)signatureOwner).getReceiverType();
                if (receiverType == null) {
                    return null;
                }
                name = receiverType.getText() + "." + ((GoMethodDeclaration)signatureOwner).getName();
            }
            if (signatureOwner instanceof GoMethodSpec) {
                GoTypeSpec interfaceType = (GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)signatureOwner, GoTypeSpec.class);
                if (interfaceType == null) {
                    return null;
                }
                name = interfaceType.getName() + "." + ((GoMethodSpec)signatureOwner).getName();
            }
            return (String)name + "(" + CallProcessor.getParametersText(parameters) + ")";
        }

        @NotNull
        private static String getParametersText(@NotNull GoParameters parameters) {
            if (parameters == null) {
                CallProcessor.$$$reportNull$$$0(17);
            }
            String string = GoPsiPresentationBuilder.create().withoutResolve().withoutParameterNames().oneline().build(parameters);
            if (string == null) {
                CallProcessor.$$$reportNull$$$0(18);
            }
            return string;
        }

        @Nullable
        private static String getPackagePath(@NotNull GoFile file) {
            String packageName;
            if (file == null) {
                CallProcessor.$$$reportNull$$$0(19);
            }
            if ("main".equals(packageName = file.getPackageName())) {
                return packageName;
            }
            String importPath = file.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file));
            return importPath != null ? importPath : file.getPackageName();
        }

        @NotNull
        List<Variant> getVariants() {
            List<Variant> list = this.myUnhandledCalls && this.myVariants.size() == 1 ? Collections.emptyList() : this.myVariants;
            if (list == null) {
                CallProcessor.$$$reportNull$$$0(20);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 18, 20 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolved";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolve";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signatureOwner";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 18: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvSmartStepIntoHandler$CallProcessor";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvSmartStepIntoHandler$CallProcessor";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParametersText";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateMaxLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariant";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFunctionVariant";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getMethodVariant";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getInterfaceMethodVariant";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getFunctionValueVariant";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "createVariant";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getVariantText";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getParametersText";
                    break;
                }
                case 18: 
                case 20: {
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackagePath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 18, 20 -> new IllegalStateException(string);
            };
        }

        private static interface VariantFactory<T> {
            @NotNull
            public T create(int var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);
        }
    }

    public static abstract class Variant
    extends XSmartStepIntoVariant
    implements Comparable<Variant> {
        private final PsiElement myHighlightElement;
        private final int myStartOffset;
        private final String myText;
        private final Ref<Integer> myMaxLineNum;
        final DlvDebugProcess myProcess;
        final long myGoroutineId;
        boolean myShouldFail;

        /*
         * WARNING - void declaration
         */
        protected Variant(@NotNull GoReferenceExpression expr, @NotNull String text, @NotNull DlvDebugProcess process, long goroutineId, @NotNull Ref<Integer> ref) {
            void maxLineNum;
            if (expr == null) {
                Variant.$$$reportNull$$$0(0);
            }
            if (text == null) {
                Variant.$$$reportNull$$$0(1);
            }
            if (process == null) {
                Variant.$$$reportNull$$$0(2);
            }
            if (ref == null) {
                Variant.$$$reportNull$$$0(3);
            }
            this.myHighlightElement = expr.getParent();
            this.myStartOffset = expr.getTextRange().getStartOffset();
            this.myText = text;
            this.myProcess = process;
            this.myGoroutineId = goroutineId;
            this.myMaxLineNum = maxLineNum;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return this.myHighlightElement != null ? this.myHighlightElement.getTextRange() : null;
        }

        public String getText() {
            return this.myText;
        }

        @NotNull
        Promise<?> stepInto() {
            Promise<?> promise = this.stepInto((Integer)this.myMaxLineNum.get());
            if (promise == null) {
                Variant.$$$reportNull$$$0(4);
            }
            return promise;
        }

        @NotNull
        abstract Promise<?> stepInto(int var1);

        @Override
        public int compareTo(@NotNull Variant o) {
            if (o == null) {
                Variant.$$$reportNull$$$0(5);
            }
            return Integer.compare(this.myStartOffset, o.myStartOffset);
        }

        @TestOnly
        void setShouldFail(boolean shouldFail) {
            this.myShouldFail = shouldFail;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxLineNum";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvSmartStepIntoHandler$Variant";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvSmartStepIntoHandler$Variant";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stepInto";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FunctionValueCallVariant
    extends Variant {
        private final String myFunctionValue;

        /*
         * WARNING - void declaration
         */
        private FunctionValueCallVariant(@NotNull GoReferenceExpression expr, @NotNull String text, @NotNull DlvDebugProcess process, long goroutineId, @NotNull Ref<Integer> maxLineNum, @NotNull String string) {
            void functionValue;
            if (expr == null) {
                FunctionValueCallVariant.$$$reportNull$$$0(0);
            }
            if (text == null) {
                FunctionValueCallVariant.$$$reportNull$$$0(1);
            }
            if (process == null) {
                FunctionValueCallVariant.$$$reportNull$$$0(2);
            }
            if (maxLineNum == null) {
                FunctionValueCallVariant.$$$reportNull$$$0(3);
            }
            if (string == null) {
                FunctionValueCallVariant.$$$reportNull$$$0(4);
            }
            super(expr, text, process, goroutineId, maxLineNum);
            this.myFunctionValue = functionValue;
        }

        @Override
        @NotNull
        Promise<?> stepInto(int maxLine) {
            String functionValue = this.myShouldFail ? "" : this.myFunctionValue;
            Promise<Void> promise = this.myProcess.getSmartStepInto().smartStepIntoFunctionValue(this.myGoroutineId, maxLine, functionValue);
            if (promise == null) {
                FunctionValueCallVariant.$$$reportNull$$$0(5);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxLineNum";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionValue";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvSmartStepIntoHandler$FunctionValueCallVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvSmartStepIntoHandler$FunctionValueCallVariant";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stepInto";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class InterfaceMethodCallVariant
    extends Variant {
        private final String myFunctionName;
        private final Set<String> myInterfaceValues;

        /*
         * WARNING - void declaration
         */
        private InterfaceMethodCallVariant(@NotNull GoReferenceExpression expr, @NotNull String text, @NotNull DlvDebugProcess process, long goroutineId, @NotNull Ref<Integer> maxLineNum, @NotNull String functionName, @NotNull String string) {
            void interfaceValue;
            if (expr == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(0);
            }
            if (text == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(1);
            }
            if (process == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(2);
            }
            if (maxLineNum == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(3);
            }
            if (functionName == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(4);
            }
            if (string == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(5);
            }
            super(expr, text, process, goroutineId, maxLineNum);
            this.myInterfaceValues = new HashSet<String>();
            this.myFunctionName = functionName;
            this.myInterfaceValues.add((String)interfaceValue);
        }

        @Override
        @NotNull
        Promise<?> stepInto(int maxLine) {
            String functionName = this.myShouldFail ? "" : this.myFunctionName;
            Promise<Void> promise = this.myProcess.getSmartStepInto().smartStepIntoInterfaceMethod(this.myGoroutineId, maxLine, this.myInterfaceValues, functionName);
            if (promise == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(6);
            }
            return promise;
        }

        void addInterfaceValue(@NotNull String interfaceValue) {
            if (interfaceValue == null) {
                InterfaceMethodCallVariant.$$$reportNull$$$0(7);
            }
            this.myInterfaceValues.add(interfaceValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxLineNum";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceValue";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvSmartStepIntoHandler$InterfaceMethodCallVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvSmartStepIntoHandler$InterfaceMethodCallVariant";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stepInto";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addInterfaceValue";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MethodCallVariant
    extends Variant {
        private final String myPackagePath;
        private final String myReceiverType;
        private final String myFunctionName;

        /*
         * WARNING - void declaration
         */
        private MethodCallVariant(@NotNull GoReferenceExpression expr, @NotNull String text, @NotNull DlvDebugProcess process, long goroutineId, @NotNull Ref<Integer> maxLineNum, @NotNull String packagePath, @NotNull String receiverType, @NotNull String string) {
            void functionName;
            if (expr == null) {
                MethodCallVariant.$$$reportNull$$$0(0);
            }
            if (text == null) {
                MethodCallVariant.$$$reportNull$$$0(1);
            }
            if (process == null) {
                MethodCallVariant.$$$reportNull$$$0(2);
            }
            if (maxLineNum == null) {
                MethodCallVariant.$$$reportNull$$$0(3);
            }
            if (packagePath == null) {
                MethodCallVariant.$$$reportNull$$$0(4);
            }
            if (receiverType == null) {
                MethodCallVariant.$$$reportNull$$$0(5);
            }
            if (string == null) {
                MethodCallVariant.$$$reportNull$$$0(6);
            }
            super(expr, text, process, goroutineId, maxLineNum);
            this.myPackagePath = packagePath;
            this.myReceiverType = receiverType;
            this.myFunctionName = functionName;
        }

        @Override
        @NotNull
        Promise<?> stepInto(int maxLine) {
            String functionName = this.myShouldFail ? "" : this.myFunctionName;
            Promise<Void> promise = this.myProcess.getSmartStepInto().smartStepIntoMethod(this.myGoroutineId, maxLine, this.myPackagePath, this.myReceiverType, functionName);
            if (promise == null) {
                MethodCallVariant.$$$reportNull$$$0(7);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxLineNum";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packagePath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiverType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvSmartStepIntoHandler$MethodCallVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvSmartStepIntoHandler$MethodCallVariant";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stepInto";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FunctionCallVariant
    extends Variant {
        private final String myPackagePath;
        private final String myFunctionName;

        /*
         * WARNING - void declaration
         */
        private FunctionCallVariant(@NotNull GoReferenceExpression expr, @NotNull String text, @NotNull DlvDebugProcess process, long goroutineId, @NotNull Ref<Integer> maxLineNum, @NotNull String packagePath, @NotNull String string) {
            void functionName;
            if (expr == null) {
                FunctionCallVariant.$$$reportNull$$$0(0);
            }
            if (text == null) {
                FunctionCallVariant.$$$reportNull$$$0(1);
            }
            if (process == null) {
                FunctionCallVariant.$$$reportNull$$$0(2);
            }
            if (maxLineNum == null) {
                FunctionCallVariant.$$$reportNull$$$0(3);
            }
            if (packagePath == null) {
                FunctionCallVariant.$$$reportNull$$$0(4);
            }
            if (string == null) {
                FunctionCallVariant.$$$reportNull$$$0(5);
            }
            super(expr, text, process, goroutineId, maxLineNum);
            this.myPackagePath = packagePath;
            this.myFunctionName = functionName;
        }

        @Override
        @NotNull
        Promise<?> stepInto(int maxLine) {
            String functionName = this.myShouldFail ? "" : this.myFunctionName;
            Promise<Void> promise = this.myProcess.getSmartStepInto().smartStepIntoFunction(this.myGoroutineId, maxLine, this.myPackagePath, functionName);
            if (promise == null) {
                FunctionCallVariant.$$$reportNull$$$0(6);
            }
            return promise;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "maxLineNum";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packagePath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionName";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dlv/DlvSmartStepIntoHandler$FunctionCallVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dlv/DlvSmartStepIntoHandler$FunctionCallVariant";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stepInto";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }
}

