/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dfa.translator;

import com.goide.dataflow.GoDataFlowUtil;
import com.goide.dfa.translator.GoDereferenceKind;
import com.goide.dfa.translator.GoDfaUtilsKt;
import com.goide.dfa.translator.GoFunctionPsiToIrTranslator;
import com.goide.dfa.translator.GoPsiMapper;
import com.goide.inspections.GoNilnessInspection;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.util.GoStdlibUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.cfg.IrCfgRegionBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J,\u0010\u001a\u001a\u00020\u000b*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010\u001a\u001a\u00020\u000b*\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/goide/dfa/translator/GoExpressionVisitor;", "Lcom/goide/psi/GoVisitor;", "cfgBuilder", "Lcom/intellij/rml/dfa/ir/cfg/IrCfgRegionBuilder;", "mapper", "Lcom/goide/dfa/translator/GoPsiMapper;", "recursive", "", "<init>", "(Lcom/intellij/rml/dfa/ir/cfg/IrCfgRegionBuilder;Lcom/goide/dfa/translator/GoPsiMapper;Z)V", "visitElement", "", "o", "Lcom/intellij/psi/PsiElement;", "visitUnaryExpr", "expr", "Lcom/goide/psi/GoUnaryExpr;", "visitReferenceExpression", "ref", "Lcom/goide/psi/GoReferenceExpression;", "visitCallExpr", "callExpr", "Lcom/goide/psi/GoCallExpr;", "visitFunctionLit", "function", "Lcom/goide/psi/GoFunctionLit;", "addDereference", "Lcom/goide/psi/GoResolvable;", "loc", "requireNotNullAfterDereference", "kind", "Lcom/goide/dfa/translator/GoDereferenceKind;", "variable", "Lcom/goide/psi/GoNamedElement;", "intellij.go.dfa"})
@SourceDebugExtension(value={"SMAP\nGoExpressionTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoExpressionTranslator.kt\ncom/goide/dfa/translator/GoExpressionVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
final class GoExpressionVisitor
extends GoVisitor {
    @NotNull
    private final IrCfgRegionBuilder cfgBuilder;
    @NotNull
    private final GoPsiMapper mapper;
    private final boolean recursive;

    public GoExpressionVisitor(@NotNull IrCfgRegionBuilder cfgBuilder, @NotNull GoPsiMapper mapper, boolean recursive) {
        Intrinsics.checkNotNullParameter((Object)cfgBuilder, (String)"cfgBuilder");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.cfgBuilder = cfgBuilder;
        this.mapper = mapper;
        this.recursive = recursive;
    }

    public void visitElement(@NotNull PsiElement o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (this.recursive) {
            o.acceptChildren((PsiElementVisitor)this);
        }
    }

    @Override
    public void visitUnaryExpr(@NotNull GoUnaryExpr expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this.visitElement(expr);
        GoExpression operand = expr.getExpression();
        if (operand != null) {
            if (expr.getArrow() != null || expr.getMul() != null) {
                GoNamedElement variable = GoDfaUtilsKt.getVariableOrParameterOrReceiverDefinition(operand);
                if (variable != null) {
                    this.addDereference(this.cfgBuilder, variable, (PsiElement)expr, true, GoDereferenceKind.POINTER_DEREFERENCE);
                }
            } else if (expr.getBitAnd() != null) {
                GoNamedElement varOrParam;
                GoExpression goExpression = expr.getExpression();
                if (goExpression != null) {
                    GoExpression it = goExpression;
                    boolean bl = false;
                    v1 = GoDfaUtilsKt.getVariableOrParameterOrReceiverDefinition(it);
                } else {
                    v1 = varOrParam = null;
                }
                if (varOrParam != null) {
                    this.cfgBuilder.addUncontrolledVarStmt(this.mapper.getVarID(varOrParam), this.mapper.getLocation(expr));
                }
            }
        }
    }

    @Override
    public void visitReferenceExpression(@NotNull GoReferenceExpression ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.visitElement(ref);
        PsiElement resolve = ref.resolve();
        if (!(resolve instanceof GoFieldDefinition) && !(resolve instanceof GoAnonymousFieldDefinition)) {
            return;
        }
        GoResolvable goResolvable = ref.getResolvableQualifier();
        if (goResolvable == null) {
            return;
        }
        GoResolvable qualifier = goResolvable;
        this.addDereference(this.cfgBuilder, qualifier, (PsiElement)qualifier, true, GoDereferenceKind.FIELD_ACCESS);
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr callExpr) {
        PsiElement method;
        GoReferenceExpression methodRef;
        Intrinsics.checkNotNullParameter((Object)callExpr, (String)"callExpr");
        this.visitElement(callExpr);
        for (GoExpression argument : callExpr.getArgumentList().getExpressionList()) {
            Intrinsics.checkNotNull((Object)argument);
            GoNamedElement def = GoDfaUtilsKt.getVariableOrParameterOrReceiverDefinition(argument);
            if (def == null || !GoStdlibUtil.implementsError(def.getGoType(null), def)) continue;
            this.cfgBuilder.addVarInvalidationStmt(this.mapper.getVarID(def), this.mapper.getLocation(callExpr));
        }
        GoReferenceExpression goReferenceExpression = methodRef = GoPsiUtil.getCallReference(callExpr);
        Object object = method = goReferenceExpression != null ? goReferenceExpression.resolve() : null;
        if (!(method instanceof GoMethodDeclaration) && !(method instanceof GoMethodSpec)) {
            return;
        }
        GoResolvable goResolvable = methodRef.getResolvableQualifier();
        if (goResolvable == null) {
            return;
        }
        GoResolvable receiverRef = goResolvable;
        boolean isNilReceiverAllowed = GoNilnessInspection.allowsNilReceiver(method instanceof GoMethodDeclaration ? (GoMethodDeclaration)method : null);
        GoDereferenceKind kind = isNilReceiverAllowed ? GoDereferenceKind.METHOD_CALL_NULLABLE_RECEIVER : GoDereferenceKind.METHOD_CALL_NULL_NOT_RECEIVER;
        this.addDereference(this.cfgBuilder, receiverRef, (PsiElement)callExpr, !isNilReceiverAllowed, kind);
    }

    @Override
    public void visitFunctionLit(@NotNull GoFunctionLit function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        for (GoNamedElement varOrParameter : GoDataFlowUtil.findUnpredictableVars(function)) {
            Intrinsics.checkNotNull((Object)varOrParameter);
            this.cfgBuilder.addUncontrolledVarStmt(this.mapper.getVarID(varOrParameter), this.mapper.getLocation(function));
        }
    }

    private final void addDereference(IrCfgRegionBuilder $this$addDereference, GoResolvable ref, PsiElement loc, boolean requireNotNullAfterDereference, GoDereferenceKind kind) {
        GoNamedElement goNamedElement = GoNilnessInspection.tryCastToVariableOrParameterDefinition(ref.resolve());
        if (goNamedElement == null) {
            return;
        }
        GoNamedElement v = goNamedElement;
        this.addDereference($this$addDereference, v, loc, requireNotNullAfterDereference, kind);
    }

    private final void addDereference(IrCfgRegionBuilder $this$addDereference, GoNamedElement variable, PsiElement loc, boolean requireNotNullAfterDereference, GoDereferenceKind kind) {
        IrVarID varID = this.mapper.getVarID(variable);
        IrLocation usageAttr = this.mapper.getLocation(loc);
        usageAttr.putUserData(GoFunctionPsiToIrTranslator.Companion.getDEREFERENCE_KIND(), (Object)kind);
        $this$addDereference.addVarDereferenceStmt(varID, requireNotNullAfterDereference, usageAttr);
    }
}

