/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dataflow;

import com.goide.controlflow.instructions.GoAssignmentStatementInstruction;
import com.goide.controlflow.instructions.GoExpressionInstruction;
import com.goide.controlflow.instructions.GoRecvStatementInstruction;
import com.goide.controlflow.instructions.GoShortVarDeclarationInstruction;
import com.goide.controlflow.instructions.GoVarDeclarationInstruction;
import com.goide.dataflow.GoDataFlow;
import com.goide.dataflow.GoDataFlowFunction;
import com.goide.dataflow.GoDataFlowUtil;
import com.goide.dataflow.GoNilness;
import com.goide.dataflow.GoNilnessDataFlow;
import com.goide.dataflow.GoVarsAndErrorsDataFlow;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoVarsAndErrorsFunction
implements GoDataFlowFunction {
    private final GoDataFlow myDataFlow;
    private final GoVarsAndErrorsDataFlow myVarsAndErrorsDataFlow;

    public GoVarsAndErrorsFunction(@NotNull GoDataFlow dataFlow) {
        if (dataFlow == null) {
            GoVarsAndErrorsFunction.$$$reportNull$$$0(0);
        }
        this.myDataFlow = dataFlow;
        this.myVarsAndErrorsDataFlow = dataFlow.getVarsAndErrorsDataFlow();
    }

    @Override
    @NotNull
    public GoDataFlow getDataFlow() {
        GoDataFlow goDataFlow = this.myDataFlow;
        if (goDataFlow == null) {
            GoVarsAndErrorsFunction.$$$reportNull$$$0(1);
        }
        return goDataFlow;
    }

    @Override
    public boolean recalculate(@NotNull Instruction instruction) {
        if (instruction == null) {
            GoVarsAndErrorsFunction.$$$reportNull$$$0(2);
        }
        boolean recalculated = this.mergeDataFlowOfPreviousInstructions(instruction);
        InstructionProcessor processor2 = new InstructionProcessor(this.myVarsAndErrorsDataFlow.getVarsAndErrors(instruction));
        return recalculated |= processor2.process(instruction);
    }

    private boolean mergeDataFlowOfPreviousInstructions(@NotNull Instruction instruction) {
        if (instruction == null) {
            GoVarsAndErrorsFunction.$$$reportNull$$$0(3);
        }
        HashMap merged = new HashMap();
        GoNilnessDataFlow nilnessDataFlow = this.myDataFlow.getNilnessDataFlow();
        for (Instruction prev : instruction.allPred()) {
            if (this.myDataFlow.isUnreachable(prev)) continue;
            Map<GoNamedElement, Set<GoNamedElement>> varsAndErrors = this.myVarsAndErrorsDataFlow.getVarsAndErrors(prev);
            Map nilnessMap = (Map)ObjectUtils.notNull(nilnessDataFlow.getNilnessMap(prev), Collections.emptyMap());
            varsAndErrors.forEach((var, errors) -> {
                List maybeNotNilErrors = ContainerUtil.filter((Collection)errors, e -> GoVarsAndErrorsFunction.maybeNotNil((GoNilness)((Object)((Object)((Object)nilnessMap.get(e))))));
                Set mergedErrors = (Set)merged.get(var);
                if (mergedErrors == null) {
                    merged.put(var, new HashSet(maybeNotNilErrors));
                } else {
                    mergedErrors.addAll(maybeNotNilErrors);
                }
            });
        }
        boolean recalculated = false;
        Map<GoNamedElement, Set<GoNamedElement>> varsAndErrors = this.myVarsAndErrorsDataFlow.getVarsAndErrors(instruction);
        if (!merged.equals(varsAndErrors)) {
            varsAndErrors.clear();
            varsAndErrors.putAll(merged);
            recalculated = true;
        }
        return recalculated;
    }

    private static boolean maybeNotNil(@Nullable GoNilness nilness) {
        return nilness == GoNilness.NOT_NIL || nilness == GoNilness.MAYBE_NIL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFlow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dataflow/GoVarsAndErrorsFunction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dataflow/GoVarsAndErrorsFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recalculate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeDataFlowOfPreviousInstructions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class InstructionProcessor {
        private final Map<GoNamedElement, Set<GoNamedElement>> varsAndErrors;

        InstructionProcessor(@NotNull Map<GoNamedElement, Set<GoNamedElement>> varsAndErrors) {
            if (varsAndErrors == null) {
                InstructionProcessor.$$$reportNull$$$0(0);
            }
            this.varsAndErrors = varsAndErrors;
        }

        public boolean process(@NotNull Instruction instruction) {
            if (instruction == null) {
                InstructionProcessor.$$$reportNull$$$0(1);
            }
            if (instruction instanceof GoExpressionInstruction) {
                return this.processExpression((GoExpression)((GoExpressionInstruction)instruction).getPsi());
            }
            if (instruction instanceof GoVarDeclarationInstruction) {
                GoVarDeclaration varDeclaration = (GoVarDeclaration)((GoVarDeclarationInstruction)instruction).getPsi();
                boolean recalculated = false;
                for (GoVarSpec varSpec : varDeclaration.getVarSpecList()) {
                    recalculated |= this.processVarDefinitions(varSpec);
                }
                return recalculated;
            }
            if (instruction instanceof GoShortVarDeclarationInstruction) {
                GoShortVarDeclaration declaration = (GoShortVarDeclaration)((GoShortVarDeclarationInstruction)instruction).getPsi();
                return this.processShortVarDefinitions(declaration);
            }
            if (instruction instanceof GoAssignmentStatementInstruction) {
                GoAssignmentStatement assignment = (GoAssignmentStatement)((GoAssignmentStatementInstruction)instruction).getPsi();
                return this.processAssignments(assignment.getLeftHandExprList().getExpressionList(), assignment.getExpressionList());
            }
            if (instruction instanceof GoRecvStatementInstruction) {
                GoRecvStatement statement = (GoRecvStatement)((GoRecvStatementInstruction)instruction).getPsi();
                if (statement.getAssign() != null) {
                    return this.processAssignments(statement.getLeftExpressionsList(), statement.getRightExpressionsList());
                }
                return false;
            }
            return false;
        }

        private boolean processExpression(@NotNull GoExpression expression) {
            if (expression == null) {
                InstructionProcessor.$$$reportNull$$$0(2);
            }
            boolean updated = false;
            for (GoNamedElement var : GoDataFlowUtil.findUnpredictableVars(expression)) {
                updated |= this.varsAndErrors.remove(var) != null;
            }
            return updated;
        }

        private boolean processVarDefinitions(@NotNull GoVarSpec varSpec) {
            List<GoVarDefinition> definitions;
            GoVarDefinition errorVariable;
            if (varSpec == null) {
                InstructionProcessor.$$$reportNull$$$0(3);
            }
            if ((errorVariable = GoDataFlowUtil.findLastErrorInMultiValueAssignment(definitions = varSpec.getDefinitionList(), varSpec.getRightExpressionsList())) == null) {
                return false;
            }
            Set<GoNamedElement> otherVariables = InstructionProcessor.remove(definitions, errorVariable);
            this.updateVarsAndErrorsMapping(errorVariable, otherVariables);
            return true;
        }

        private boolean processAssignments(@NotNull List<GoExpression> leftExpressions, @NotNull List<GoExpression> rightExpressions) {
            if (leftExpressions == null) {
                InstructionProcessor.$$$reportNull$$$0(4);
            }
            if (rightExpressions == null) {
                InstructionProcessor.$$$reportNull$$$0(5);
            }
            List definitions = ContainerUtil.mapNotNull(leftExpressions, GoDataFlowUtil::findVarDefinition);
            GoNamedElement errorVariable = GoDataFlowUtil.findVarDefinition(GoDataFlowUtil.findLastErrorInMultiValueAssignment(leftExpressions, rightExpressions));
            return this.processAssignments(definitions, errorVariable);
        }

        private boolean processShortVarDefinitions(@NotNull GoShortVarDeclaration declaration) {
            if (declaration == null) {
                InstructionProcessor.$$$reportNull$$$0(6);
            }
            List definitions = ContainerUtil.mapNotNull(declaration.getDefinitionList(), GoInspectionUtil::getPrimaryDefinition);
            GoNamedElement errorVariable = (GoNamedElement)GoDataFlowUtil.findLastErrorInMultiValueAssignment(definitions, declaration.getRightExpressionsList());
            return this.processAssignments(definitions, errorVariable);
        }

        private boolean processAssignments(@NotNull List<GoNamedElement> allVariables, @Nullable GoNamedElement errorVariable) {
            if (allVariables == null) {
                InstructionProcessor.$$$reportNull$$$0(7);
            }
            if (errorVariable != null) {
                Set<GoNamedElement> otherVariables = InstructionProcessor.remove(allVariables, errorVariable);
                this.updateVarsAndErrorsMapping(errorVariable, otherVariables);
                return true;
            }
            return this.removeVariables(allVariables);
        }

        private void updateVarsAndErrorsMapping(@NotNull GoNamedElement errorVariable, @NotNull Set<GoNamedElement> otherVariables) {
            if (errorVariable == null) {
                InstructionProcessor.$$$reportNull$$$0(8);
            }
            if (otherVariables == null) {
                InstructionProcessor.$$$reportNull$$$0(9);
            }
            this.varsAndErrors.forEach((var, errors) -> errors.remove(errorVariable));
            otherVariables.forEach(var -> this.varsAndErrors.put((GoNamedElement)var, ContainerUtil.newHashSet((Object[])new GoNamedElement[]{errorVariable})));
        }

        private boolean removeVariables(@NotNull List<GoNamedElement> variables) {
            if (variables == null) {
                InstructionProcessor.$$$reportNull$$$0(10);
            }
            boolean recalculated = false;
            for (GoNamedElement goNamedElement : variables) {
                recalculated |= this.varsAndErrors.remove(goNamedElement) != null;
            }
            for (Set set : this.varsAndErrors.values()) {
                recalculated |= set.removeAll(variables);
            }
            return recalculated;
        }

        @NotNull
        private static Set<GoNamedElement> remove(@NotNull List<? extends GoNamedElement> definitions, @NotNull GoNamedElement definition) {
            if (definitions == null) {
                InstructionProcessor.$$$reportNull$$$0(11);
            }
            if (definition == null) {
                InstructionProcessor.$$$reportNull$$$0(12);
            }
            HashSet<GoNamedElement> otherVariables = new HashSet<GoNamedElement>(definitions);
            otherVariables.remove(definition);
            HashSet<GoNamedElement> hashSet = otherVariables;
            if (hashSet == null) {
                InstructionProcessor.$$$reportNull$$$0(13);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varsAndErrors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instruction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varSpec";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leftExpressions";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rightExpressions";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allVariables";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorVariable";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherVariables";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definitions";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definition";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/dataflow/GoVarsAndErrorsFunction$InstructionProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/dataflow/GoVarsAndErrorsFunction$InstructionProcessor";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "remove";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processVarDefinitions";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processAssignments";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processShortVarDefinitions";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updateVarsAndErrorsMapping";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "removeVariables";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 13 -> new IllegalStateException(string);
            };
        }
    }
}

