/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.GoTypes;
import com.goide.completion.GoKeywordCompletionContributor;
import com.goide.completion.GoKeywordCompletionProvider;
import com.goide.editor.template.GoErrorVariableMacro;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBlock;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoZeroValue;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoReturnCompletionContributor
extends CompletionContributor {
    private static final GoKeywordCompletionProvider KEYWORD_COMPLETION_PROVIDER = new GoKeywordCompletionProvider(35, "return");

    public GoReturnCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)GoKeywordCompletionContributor.insideBlockPattern(GoTypes.IDENTIFIER), new ReturnCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(GoReferenceExpression.class)).withSuperParent(2, GoReturnStatement.class), new GoReturnZeroValueCompletionProvider());
    }

    private static void addReturnErrorElements(@NotNull CompletionResultSet result, @NotNull String lookupElementPrefix, @NotNull List<String> allReturnValues, @NotNull List<String> errorExpressions, boolean isInErrorCheckingBlock) {
        if (result == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(0);
        }
        if (lookupElementPrefix == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(1);
        }
        if (allReturnValues == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(2);
        }
        if (errorExpressions == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(3);
        }
        int priority = 40 + (isInErrorCheckingBlock ? 5 : 0);
        List valuesExceptLast = CollectionsKt.dropLast(allReturnValues, (int)1);
        String commonPrefix = lookupElementPrefix + StringUtil.join((Collection)valuesExceptLast, (String)", ");
        if (!valuesExceptLast.isEmpty()) {
            commonPrefix = commonPrefix + ", ";
        }
        for (String expression : errorExpressions) {
            @NonNls String lookupElement = commonPrefix + expression;
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)lookupElement), (double)priority));
        }
    }

    @NotNull
    public static List<String> getReturnValues(@NotNull List<GoType> returnTypes) {
        if (returnTypes == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(4);
        }
        SmartList result = new SmartList();
        for (GoType t : returnTypes) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)GoReturnCompletionContributor.getZeroValue(t));
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @Nullable
    private static String getZeroValue(@NotNull GoType type) {
        GoZeroValue zeroValue;
        if (type == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(6);
        }
        if ((zeroValue = GoZeroValue.of(type)) == GoZeroValue.EMPTY_LITERAL) {
            GoArrayOrSliceType arrayType;
            GoType underlyingType = type.getContextlessUnderlyingType();
            if (underlyingType instanceof GoStructType) {
                return type.getText() + "{}";
            }
            if (GoTypeUtil.isArray(underlyingType, null) && (arrayType = (GoArrayOrSliceType)ObjectUtils.tryCast((Object)underlyingType, GoArrayOrSliceType.class)) != null) {
                GoType elementType = arrayType.getType();
                return String.format("[%d]%s{}", arrayType.getLength(), elementType.getText());
            }
            return "nil";
        }
        return zeroValue.getText();
    }

    @NotNull
    private static Pair<List<String>, Boolean> getErrorVariants(@NotNull GoSignatureOwner function, @Nullable GoStatement statement, @NotNull GoType type) {
        GoReferenceExpression left;
        GoBinaryExpr condition;
        GoExpression goExpression;
        GoIfStatement ifStatement;
        if (function == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(7);
        }
        if (type == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(8);
        }
        ArrayList<String> errors = new ArrayList<String>();
        GoBlock block = statement != null ? (GoBlock)ObjectUtils.tryCast((Object)statement.getParent(), GoBlock.class) : null;
        GoIfStatement goIfStatement = ifStatement = block != null ? (GoIfStatement)ObjectUtils.tryCast((Object)block.getParent(), GoIfStatement.class) : null;
        if (ifStatement != null && (goExpression = ifStatement.getCondition()) instanceof GoBinaryExpr && GoExpressionUtil.getOperatorType(condition = (GoBinaryExpr)goExpression) == GoTypes.NOT_EQ && GoExpressionUtil.isNil(condition.getRight()) && (left = (GoReferenceExpression)ObjectUtils.tryCast((Object)condition.getLeft(), GoReferenceExpression.class)) != null && left.getQualifier() == null && GoTypeUtil.isError(left.getGoType(null), statement)) {
            errors.add(left.getText());
            errors.addAll(GoReturnCompletionContributor.getErrorVarNamesInScope(statement, type, block));
            Pair pair = Pair.create(errors, (Object)true);
            if (pair == null) {
                GoReturnCompletionContributor.$$$reportNull$$$0(9);
            }
            return pair;
        }
        if (statement != null) {
            String uniqueErrorInFunction = (String)ContainerUtil.getOnlyItem(GoReturnCompletionContributor.getErrorVarNamesInScope(statement, type, function));
            ContainerUtil.addIfNotNull(errors, (Object)uniqueErrorInFunction);
        }
        Pair pair = Pair.create(errors, (Object)false);
        if (pair == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(10);
        }
        return pair;
    }

    @NotNull
    private static List<String> getErrorVarNamesInScope(@NotNull PsiElement at, @NotNull GoType type, @NotNull PsiElement scope) {
        if (at == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(11);
        }
        if (type == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(13);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (GoNamedElement name : GoErrorVariableMacro.getErrorsInScope(at, scope, type)) {
            ContainerUtil.addIfNotNull(result, (Object)name.getName());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GoReturnCompletionContributor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 9, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElementPrefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allReturnValues";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorExpressions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTypes";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoReturnCompletionContributor";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "at";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoReturnCompletionContributor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnValues";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorVariants";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorVarNamesInScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addReturnErrorElements";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReturnValues";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getZeroValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getErrorVariants";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getErrorVarNamesInScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 9, 10, 14 -> new IllegalStateException(string);
        };
    }

    private static class ReturnCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private ReturnCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            GoType lastType;
            GoReferenceExpression reference;
            GoSignatureOwner function;
            GoType fnType;
            if (parameters == null) {
                ReturnCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ReturnCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                ReturnCompletionProvider.$$$reportNull$$$0(2);
            }
            GoType goType = fnType = (function = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), GoSignatureOwner.class)) != null ? function.getResultType() : null;
            if (fnType == null) {
                KEYWORD_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
                return;
            }
            List<GoType> types = GoTypeUtil.getListOfTypesFromTypeList(fnType);
            List<String> values = GoReturnCompletionContributor.getReturnValues(types);
            if (!values.isEmpty()) {
                KEYWORD_COMPLETION_PROVIDER.addCompletions(parameters, context, result);
            }
            if ((reference = (GoReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), GoReferenceExpression.class)) != null && !values.isEmpty() && GoTypeUtil.isError(lastType = (GoType)ContainerUtil.getLastItem(types), parameters.getPosition())) {
                GoStatement statement = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, GoStatement.class);
                Pair<List<String>, Boolean> errorVariants = GoReturnCompletionContributor.getErrorVariants(function, statement, lastType);
                GoReturnCompletionContributor.addReturnErrorElements(result, "return ", values, (List)errorVariants.first, (Boolean)errorVariants.second);
                if (!((List)errorVariants.first).isEmpty() && ((Boolean)errorVariants.second).booleanValue()) {
                    return;
                }
            }
            String text = "return" + (values.isEmpty() ? "" : " ") + String.join((CharSequence)", ", values);
            LookupElementBuilder builder = LookupElementBuilder.create((String)text);
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder, (double)35.0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoReturnCompletionContributor$ReturnCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GoReturnZeroValueCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private GoReturnZeroValueCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            GoType fnType;
            GoReferenceExpression reference;
            if (parameters == null) {
                GoReturnZeroValueCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                GoReturnZeroValueCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                GoReturnZeroValueCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((reference = (GoReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), GoReferenceExpression.class)) == null || reference.getQualifier() != null) {
                return;
            }
            GoReturnStatement returnStatement = (GoReturnStatement)ObjectUtils.tryCast((Object)reference.getParent(), GoReturnStatement.class);
            GoSignatureOwner function = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, GoSignatureOwner.class);
            GoType goType = fnType = function != null ? function.getResultType() : null;
            if (fnType != null) {
                GoType lastType;
                GoType type;
                String zeroValue;
                List<GoType> types = GoTypeUtil.getListOfTypesFromTypeList(fnType);
                List<GoExpression> returnExpressions = returnStatement.getExpressionList();
                int index = returnExpressions.indexOf(reference);
                if (!(0 > index || index >= types.size() || (zeroValue = GoReturnCompletionContributor.getZeroValue(type = types.get(index))) == null || "nil".equals(zeroValue) || "false".equals(zeroValue) || "true".equals(zeroValue))) {
                    int priority = 40;
                    result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)zeroValue), (double)priority));
                }
                GoReturnStatement originalReturnStatement = (GoReturnStatement)CompletionUtil.getOriginalOrSelf((PsiElement)returnStatement);
                if (index == 0 && types.size() > 1 && originalReturnStatement.getExpressionList().isEmpty() && GoTypeUtil.isError(lastType = (GoType)ContainerUtil.getLastItem(types), parameters.getPosition())) {
                    GoStatement statement = (GoStatement)PsiTreeUtil.getParentOfType((PsiElement)reference, GoStatement.class);
                    Pair<List<String>, Boolean> errorVariants = GoReturnCompletionContributor.getErrorVariants(function, statement, lastType);
                    List errors = (List)errorVariants.first;
                    if (!errors.isEmpty()) {
                        GoReturnCompletionContributor.addReturnErrorElements(result, "", GoReturnCompletionContributor.getReturnValues(types), errors, (Boolean)errorVariants.second);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/goide/completion/GoReturnCompletionContributor$GoReturnZeroValueCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

