/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.GoLanguage;
import com.goide.completion.GoPackageProximityWeigher;
import com.goide.execution.testing.GoTestFinder;
import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPackageUsageWeigher
extends CompletionWeigher {
    private static final Key<Map<String, Integer>> IMPORT_PATH_USAGE_COUNT = Key.create((String)"go.package.usage.weigher.import.path.usage.count");
    private static final Key<Ref<GlobalSearchScope>> IMPORT_PATH_USAGE_SCOPE = Key.create((String)"go.package.usage.weigher.import.path.usage.scope");

    public Comparable<?> weigh(@NotNull LookupElement element, @NotNull CompletionLocation location) {
        Integer usageCount;
        PsiElement position;
        if (element == null) {
            GoPackageUsageWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            GoPackageUsageWeigher.$$$reportNull$$$0(1);
        }
        if ((position = location.getCompletionParameters().getPosition()).getLanguage() != GoLanguage.INSTANCE) {
            return null;
        }
        String importPath = GoPackageProximityWeigher.getImportPath(element.getPsiElement());
        if (StringUtil.isEmpty((String)importPath)) {
            return null;
        }
        HashMap<String, Integer> usages = (HashMap<String, Integer>)location.getUserData(IMPORT_PATH_USAGE_COUNT);
        if (usages == null) {
            usages = new HashMap<String, Integer>();
            location.putUserData(IMPORT_PATH_USAGE_COUNT, usages);
        }
        if ((usageCount = (Integer)usages.get(importPath)) != null) {
            return usageCount != 0 ? usageCount : null;
        }
        usageCount = GoPackageUsageWeigher.getUsageCount(location, importPath);
        usages.put(importPath, usageCount);
        return usageCount != 0 ? usageCount : null;
    }

    private static int getUsageCount(@NotNull CompletionLocation location, String importPath) {
        GlobalSearchScope scope;
        if (location == null) {
            GoPackageUsageWeigher.$$$reportNull$$$0(2);
        }
        return (scope = GoPackageUsageWeigher.getSearchScope(location)) != null ? GoImportPathToAliasIndexKt.getImportPathUsageCount(scope, importPath) : 0;
    }

    @Nullable
    private static GlobalSearchScope getSearchScope(@NotNull CompletionLocation location) {
        GlobalSearchScope scope;
        Ref scopeRef;
        if (location == null) {
            GoPackageUsageWeigher.$$$reportNull$$$0(3);
        }
        if ((scopeRef = (Ref)location.getUserData(IMPORT_PATH_USAGE_SCOPE)) != null) {
            return (GlobalSearchScope)scopeRef.get();
        }
        PsiElement position = location.getCompletionParameters().getOriginalPosition();
        Module module = position != null ? GoUtil.module(position.getOriginalElement()) : null;
        GlobalSearchScope globalSearchScope = scope = module != null ? module.getModuleContentScope() : null;
        if (scope != null && !GoTestFinder.isTestFile(position.getContainingFile())) {
            scope = scope.intersectWith((GlobalSearchScope)new GoUtil.ExceptTestsScope(scope));
        }
        location.putUserData(IMPORT_PATH_USAGE_SCOPE, (Object)Ref.create((Object)scope));
        return scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/goide/completion/GoPackageUsageWeigher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "weigh";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsageCount";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSearchScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

