/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.GoLanguage;
import com.goide.completion.GoCompletionUtil;
import com.goide.psi.GoFile;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPackageProximityWeigher
extends ProximityWeigher {
    private static final Key<String> CURRENT_IMPORT_PATH = Key.create((String)"current import path");

    public Comparable weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        PsiElement position;
        Language language;
        if (element == null) {
            GoPackageProximityWeigher.$$$reportNull$$$0(0);
        }
        if (location == null) {
            GoPackageProximityWeigher.$$$reportNull$$$0(1);
        }
        Language language2 = language = (position = location.getPosition()) != null ? position.getLanguage() : null;
        if (language != GoLanguage.INSTANCE) {
            return null;
        }
        String currentImportPath = GoPackageProximityWeigher.getImportPath((UserDataHolder)location, location.getPosition());
        if (currentImportPath.isEmpty()) {
            return null;
        }
        String importPath = GoPackageProximityWeigher.getImportPath(CompletionUtil.getOriginalOrSelf((PsiElement)element));
        if (StringUtil.isNotEmpty((String)currentImportPath) && StringUtil.isNotEmpty((String)importPath)) {
            return Integer.valueOf(GoCompletionUtil.calculatePackagePriority(importPath, currentImportPath));
        }
        return null;
    }

    @NotNull
    static String getImportPath(@NotNull UserDataHolder dataHolder, @Nullable PsiElement position) {
        String currentImportPath;
        if (dataHolder == null) {
            GoPackageProximityWeigher.$$$reportNull$$$0(2);
        }
        if ((currentImportPath = (String)dataHolder.getUserData(CURRENT_IMPORT_PATH)) == null) {
            currentImportPath = StringUtil.notNullize((String)GoPackageProximityWeigher.getImportPath(position));
            dataHolder.putUserData(CURRENT_IMPORT_PATH, (Object)currentImportPath);
        }
        String string = currentImportPath;
        if (string == null) {
            GoPackageProximityWeigher.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    static String getImportPath(@Nullable PsiElement position) {
        PsiFile file = position != null ? position.getContainingFile() : null;
        return file instanceof GoFile ? ((GoFile)CompletionUtil.getOriginalOrSelf((PsiElement)((GoFile)file))).getImportPath(false) : null;
    }

    public String toString() {
        return "goPackageProximity";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoPackageProximityWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoPackageProximityWeigher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "weigh";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImportPath";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

