/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.completion.GoCompletionCandidateCollector;
import com.goide.completion.GoReferenceCompletionCandidate;
import com.goide.completion.GoReferenceCompletionScopeProcessor;
import com.goide.psi.impl.GoScopeProcessor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class GoCompletionContext
implements AutoCloseable {
    @NotNull
    private final GoReferenceCompletionScopeProcessor processor;
    @NotNull
    private final GoScopeProcessor collector;
    private final int threadCount;
    @NotNull
    private final BlockingQueue<GoReferenceCompletionCandidate> candidates;
    @NotNull
    private final CountDownLatch done;

    private GoCompletionContext(@NotNull GoReferenceCompletionScopeProcessor processor2, @NotNull GoScopeProcessor collector, int threadCount, @NotNull BlockingQueue<GoReferenceCompletionCandidate> candidates, @NotNull CountDownLatch done) {
        if (processor2 == null) {
            GoCompletionContext.$$$reportNull$$$0(0);
        }
        if (collector == null) {
            GoCompletionContext.$$$reportNull$$$0(1);
        }
        if (candidates == null) {
            GoCompletionContext.$$$reportNull$$$0(2);
        }
        if (done == null) {
            GoCompletionContext.$$$reportNull$$$0(3);
        }
        this.processor = processor2;
        this.collector = collector;
        this.threadCount = threadCount;
        this.candidates = candidates;
        this.done = done;
    }

    @NotNull
    static GoCompletionContext create(@NotNull GoReferenceCompletionScopeProcessor processor2, @NotNull CompletionParameters parameters) {
        if (processor2 == null) {
            GoCompletionContext.$$$reportNull$$$0(4);
        }
        if (parameters == null) {
            GoCompletionContext.$$$reportNull$$$0(5);
        }
        int threadCount = Math.max(2, Runtime.getRuntime().availableProcessors() - 2);
        LinkedBlockingQueue<GoReferenceCompletionCandidate> q = new LinkedBlockingQueue<GoReferenceCompletionCandidate>();
        GoCompletionCandidateCollector collector = new GoCompletionCandidateCollector(q, parameters);
        processor2.setCollectElementsFromImports(false);
        CountDownLatch done = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                        try {
                            while (true) {
                                GoReferenceCompletionCandidate c;
                                if ((c = (GoReferenceCompletionCandidate)q.poll(30L, TimeUnit.MILLISECONDS)) == null) {
                                    continue;
                                }
                                if (!c.isSentinel) {
                                    processor2.processCompletionCandidate(c.element, c.state, c.qualifier);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            throw new ProcessCanceledException((Throwable)e);
                        }
                    });
                }
                finally {
                    done.countDown();
                }
            });
        }
        return new GoCompletionContext(processor2, collector, threadCount, q, done);
    }

    @NotNull
    GoScopeProcessor getProcessor() {
        GoScopeProcessor goScopeProcessor = this.collector;
        if (goScopeProcessor == null) {
            GoCompletionContext.$$$reportNull$$$0(6);
        }
        return goScopeProcessor;
    }

    @Override
    public void close() {
        GoReferenceCompletionCandidate c;
        for (int i = 0; i < this.threadCount + 1; ++i) {
            this.candidates.add(GoReferenceCompletionCandidate.createSentinel());
        }
        while ((c = (GoReferenceCompletionCandidate)this.candidates.poll()) != null && !c.isSentinel) {
            this.processor.processCompletionCandidate(c.element, c.state, c.qualifier);
        }
        try {
            this.done.await();
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "done";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoCompletionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoCompletionContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

