/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.codeInsight.imports.GoImportPackageQuickFix;
import com.goide.completion.GoCompletionUtil;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoTypeSpec;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoAutoImportInsertHandler<T extends GoNamedElement>
implements InsertHandler<LookupElement> {
    @Nullable
    private final InsertHandler<LookupElement> myDelegate;
    @Nullable
    private final Class<T> myClass;

    private GoAutoImportInsertHandler(@Nullable InsertHandler<LookupElement> delegate, @Nullable Class<T> clazz) {
        this.myDelegate = delegate;
        this.myClass = clazz;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        PsiElement element;
        if (context == null) {
            GoAutoImportInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            GoAutoImportInsertHandler.$$$reportNull$$$0(1);
        }
        if ((element = item.getPsiElement()) instanceof GoNamedElement) {
            if (this.myClass != null && this.myDelegate != null && this.myClass.isInstance(element)) {
                this.myDelegate.handleInsert(context, item);
            }
            GoAutoImportInsertHandler.autoImport(context, (GoNamedElement)element);
        }
    }

    private static void autoImport(@NotNull InsertionContext context, @NotNull GoNamedElement element) {
        PsiElement referenceElement;
        if (context == null) {
            GoAutoImportInsertHandler.$$$reportNull$$$0(2);
        }
        if (element == null) {
            GoAutoImportInsertHandler.$$$reportNull$$$0(3);
        }
        PsiFile file = context.getFile();
        String importPath = element.getContainingFile().getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file));
        if (StringUtil.isEmpty((String)importPath)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
        PsiReference reference = file.findReferenceAt(context.getStartOffset());
        PsiElement psiElement = referenceElement = reference != null ? reference.getElement() : null;
        if (referenceElement != null && referenceElement.isValid()) {
            String qualifierText = reference.getCanonicalText();
            String filePackageName = element.getContainingFile().getPackageName();
            String alias = GoImportPackageQuickFix.isRequireAlias(importPath, filePackageName, qualifierText) ? qualifierText : null;
            GoImportPackageQuickFix fix = new GoImportPackageQuickFix(referenceElement, importPath, alias, ThreeState.UNSURE);
            fix.invoke(context.getProject(), file, context.getEditor(), referenceElement, referenceElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/goide/completion/GoAutoImportInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "autoImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Lazy {
        public static final InsertHandler<LookupElement> SIMPLE_TYPE_INSERT_HANDLER = new GoAutoImportInsertHandler<GoNamedElement>(GoCompletionUtil.Lazy.TYPE_INSERT_HANDLER, GoNamedElement.class);
        public static final InsertHandler<LookupElement> TYPED_EXPRESSION_INSERT_HANDLER = new GoAutoImportInsertHandler<GoTypeSpec>(GoCompletionUtil.Lazy.TYPED_EXPRESSION_INSERT_HANDLER, GoTypeSpec.class);
        public static final InsertHandler<LookupElement> VARIABLE_OR_FUNCTION_INSERT_HANDLER = new GoAutoImportInsertHandler<GoFunctionDeclaration>(GoCompletionUtil.Lazy.VARIABLE_OR_FUNCTION_INSERT_HANDLER, GoFunctionDeclaration.class);
    }
}

