/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.GoNotifications;
import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.codeInsight.imports.GoObsoleteImportsSettings;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoUnsortedImportInspection;
import com.intellij.application.options.CodeStyle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="GoImports", storages={@Storage(value="go.imports.xml")})
public final class GoImportsSettingsStorage
implements PersistentStateComponent<GoObsoleteImportsSettings> {
    private static final Logger LOG = Logger.getInstance(GoImportsSettingsStorage.class);
    @NonNls
    private static final String PROJECT_SETTINGS_MIGRATED = "go.import.settings.migrated";
    @NonNls
    private static final String IDE_SCHEME_MIGRATED_PREFIX = "go.import.settings.migrated.";
    @NonNls
    private static final String SHOW_OBSOLETE_SETTINGS_NOTIFICATION = "go.show.obsolete.import.settings.notification";
    private final Project myProject;
    private GoObsoleteImportsSettings mySettings;

    public GoImportsSettingsStorage(@NotNull Project project) {
        if (project == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(0);
        }
        this.mySettings = new GoObsoleteImportsSettings();
        this.myProject = project;
    }

    public static GoImportsSettingsStorage getInstance(Project project) {
        return (GoImportsSettingsStorage)project.getService(GoImportsSettingsStorage.class);
    }

    @Nullable
    public GoObsoleteImportsSettings getState() {
        return this.mySettings;
    }

    public GoImportsSettings getSettings() {
        return this.mySettings;
    }

    public void loadState(@NotNull GoObsoleteImportsSettings state) {
        if (state == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(1);
        }
        this.mySettings = state;
        this.migrateCodeStyleSettings(state);
    }

    public void noStateLoaded() {
        GoImportsSettingsStorage.setImportSettingsMigrated(this.myProject);
    }

    private void migrateCodeStyleSettings(@NotNull GoObsoleteImportsSettings state) {
        GoObsoleteImportsSettings.MigrationResult migrationResult;
        if (state == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(2);
        }
        if (GoImportsSettingsStorage.isImportSettingsMigrated(this.myProject)) {
            return;
        }
        GoCodeStyleSettings codeStyle = (GoCodeStyleSettings)CodeStyle.getSettings((Project)this.myProject).getCustomSettings(GoCodeStyleSettings.class);
        if (CodeStyle.usesOwnSettings((Project)this.myProject)) {
            migrationResult = state.migrateToCodeStyle(codeStyle);
        } else {
            CodeStyleScheme scheme = CodeStyleSchemes.getInstance().getCurrentScheme();
            if (GoImportsSettingsStorage.isImportSettingsMigrated(scheme)) {
                migrationResult = state.sameSettingsAs(codeStyle) ? GoObsoleteImportsSettings.MigrationResult.NOT_NEEDED : GoObsoleteImportsSettings.MigrationResult.REJECTED;
            } else {
                migrationResult = state.migrateToCodeStyle(codeStyle);
                GoImportsSettingsStorage.setImportSettingsMigrated(scheme);
            }
        }
        LOG.debug("Obsolete imports code style settings migration result: " + migrationResult);
        GoImportsSettingsStorage.setImportSettingsMigrated(this.myProject);
        if (migrationResult == GoObsoleteImportsSettings.MigrationResult.REJECTED && !CodeStyle.usesOwnSettings((Project)this.myProject) && GoImportsSettingsStorage.isNotificationEnabled()) {
            GoNotifications.getGeneralGroup().createNotification(GoBundle.message((String)"go.notification.obsolete.imports.code.style.detected.title", (Object[])new Object[0]), NotificationType.INFORMATION).addAction((AnAction)new NotificationAction(GoBundle.message((String)"go.notification.review.code.style.settings.action.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (GoImportsSettingsStorage.this.myProject.isDisposed()) {
                        return;
                    }
                    notification.expire();
                    GoUnsortedImportInspection.openImportCodeStyleSettings(GoImportsSettingsStorage.this.myProject);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/goide/codeInsight/imports/GoImportsSettingsStorage$2";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).addAction((AnAction)new NotificationAction(GoBundle.message((String)"go.notification.do.not.show.action.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (GoImportsSettingsStorage.this.myProject.isDisposed()) {
                        return;
                    }
                    notification.expire();
                    GoImportsSettingsStorage.disableNotification();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/goide/codeInsight/imports/GoImportsSettingsStorage$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).notify(this.myProject);
        }
    }

    private static boolean isNotificationEnabled() {
        return PropertiesComponent.getInstance().getBoolean(SHOW_OBSOLETE_SETTINGS_NOTIFICATION, true);
    }

    private static void disableNotification() {
        PropertiesComponent.getInstance().setValue(SHOW_OBSOLETE_SETTINGS_NOTIFICATION, "false");
    }

    public static boolean isImportSettingsMigrated(@NotNull Project project) {
        if (project == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(3);
        }
        return PropertiesComponent.getInstance((Project)project).getBoolean(PROJECT_SETTINGS_MIGRATED);
    }

    private static void setImportSettingsMigrated(@NotNull Project project) {
        if (project == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(4);
        }
        PropertiesComponent.getInstance((Project)project).setValue(PROJECT_SETTINGS_MIGRATED, "true");
    }

    private static boolean isImportSettingsMigrated(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(5);
        }
        return PropertiesComponent.getInstance().getBoolean(GoImportsSettingsStorage.getSchemeMigratedKey(scheme));
    }

    private static void setImportSettingsMigrated(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(6);
        }
        PropertiesComponent.getInstance().setValue(GoImportsSettingsStorage.getSchemeMigratedKey(scheme), true);
    }

    private static String getSchemeMigratedKey(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(7);
        }
        return IDE_SCHEME_MIGRATED_PREFIX + scheme.getName();
    }

    @TestOnly
    public static void resetProjectMigratedMark(@NotNull Project project) {
        if (project == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(8);
        }
        PropertiesComponent.getInstance((Project)project).unsetValue(PROJECT_SETTINGS_MIGRATED);
    }

    @TestOnly
    public static void resetIdeSchemeMigratedMark(@NotNull CodeStyleScheme scheme) {
        if (scheme == null) {
            GoImportsSettingsStorage.$$$reportNull$$$0(9);
        }
        PropertiesComponent.getInstance().unsetValue(GoImportsSettingsStorage.getSchemeMigratedKey(scheme));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
        }
        objectArray2[1] = "com/goide/codeInsight/imports/GoImportsSettingsStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateCodeStyleSettings";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isImportSettingsMigrated";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setImportSettingsMigrated";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchemeMigratedKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resetProjectMigratedMark";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "resetIdeSchemeMigratedMark";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

