/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.GoIcons;
import com.goide.GoNotifications;
import com.goide.GoTypes;
import com.goide.codeInsight.imports.GoImport;
import com.goide.codeInsight.imports.GoImportConfigurable;
import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.codeInsight.imports.GoImportsWeigher;
import com.goide.codeInsight.imports.GoOptimizedImportsTracker;
import com.goide.completion.CancellableCollectProcessor;
import com.goide.completion.GoCompletionUtil;
import com.goide.execution.testing.GoTestFinder;
import com.goide.i18n.GoBundle;
import com.goide.index.GoAliasToImportPathIndexKt;
import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReference;
import com.goide.psi.impl.GoTypeReference;
import com.goide.sdk.GoPackageUtil;
import com.goide.stubs.index.GoAllPrivateNamesIndex;
import com.goide.stubs.index.GoAllPublicNamesIndex;
import com.goide.stubs.index.GoPackagesIndex;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoImportPackageQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HintAction,
HighPriorityAction {
    @NotNull
    private final String myPackageName;
    @Nullable
    private Pair<List<GoImport>, Boolean> myPackagesToImport;
    private volatile long myImportSettingsModCount;
    private final ThreeState extensionsAllowToChangeFileSilently;

    public GoImportPackageQuickFix(@NotNull PsiElement element, @NotNull String importPath, @Nullable String alias, @NotNull ThreeState canChangeFileSilently) {
        if (element == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(0);
        }
        if (importPath == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(1);
        }
        if (canChangeFileSilently == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(2);
        }
        this(element, "", (Pair<List<GoImport>, Boolean>)Pair.create(Collections.singletonList(new GoImport(importPath, alias)), (Object)true), GoImportsSettings.getInstance(element.getProject()).getModificationCount(), canChangeFileSilently);
    }

    public GoImportPackageQuickFix(@NotNull PsiReference reference) {
        if (reference == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(3);
        }
        this(reference.getElement(), reference.getCanonicalText(), null, 0L, GoImportPackageQuickFix.canChangeFileSilently(reference.getElement()));
    }

    /*
     * WARNING - void declaration
     */
    private GoImportPackageQuickFix(@NotNull PsiElement element, @NotNull String packageName, @Nullable Pair<List<GoImport>, Boolean> packagesToImport, long importSettingsModCount, @NotNull ThreeState threeState) {
        void canChangeFileSilently;
        if (element == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(5);
        }
        if (threeState == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(6);
        }
        super(element);
        this.myPackageName = packageName;
        this.myImportSettingsModCount = importSettingsModCount;
        this.myPackagesToImport = packagesToImport;
        this.extensionsAllowToChangeFileSilently = canChangeFileSilently;
    }

    @NotNull
    public static ThreeState canChangeFileSilently(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(7);
        }
        ThreeState threeState = (virtualFile = element.getContainingFile().getVirtualFile()) == null ? ThreeState.UNSURE : SilentChangeVetoer.extensionsAllowToChangeFileSilently((Project)element.getProject(), (VirtualFile)virtualFile);
        if (threeState == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(8);
        }
        return threeState;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Nullable
    public static PsiReference getReference(PsiElement element) {
        if (element != null && element.isValid()) {
            for (PsiReference reference : element.getReferences()) {
                if (!GoImportPackageQuickFix.isSupportedReference(reference)) continue;
                return reference;
            }
        }
        return null;
    }

    private static boolean isSupportedReference(@Nullable PsiReference reference) {
        return reference instanceof GoReference || reference instanceof GoTypeReference;
    }

    public boolean showHint(@NotNull Editor editor) {
        PsiFile file;
        PsiElement element;
        if (editor == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(10);
        }
        if ((element = this.getStartElement()) == null || !element.isValid()) {
            return false;
        }
        Project project = element.getProject();
        if (!this.canAddUnambiguousImportsOnTheFly(project, file = element.getContainingFile())) {
            return false;
        }
        return this.doAutoImportOrShowHint(editor, true);
    }

    @NotNull
    public String getText() {
        PsiElement element = this.getStartElement();
        if (element != null) {
            List packagesToImport = ContainerUtil.map(this.getImportPathVariantsToImport(element), GoImportPackageQuickFix::getImportPresentation);
            if (packagesToImport.isEmpty()) {
                String string = GoBundle.message((String)"go.import.package.fix.text.no.variants", (Object[])new Object[0]);
                if (string == null) {
                    GoImportPackageQuickFix.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (packagesToImport.size() == 1) {
                String string = GoBundle.message((String)"go.import.package.fix.text.single.variant", (Object[])new Object[]{packagesToImport.get(0)});
                if (string == null) {
                    GoImportPackageQuickFix.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = GoBundle.message((String)"go.import.package.fix.text.many.variants", (Object[])new Object[]{packagesToImport.get(0)});
            if (string == null) {
                GoImportPackageQuickFix.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = GoBundle.message((String)"go.import.package.fix.text", (Object[])new Object[0]);
        if (string == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.import.package.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(16);
        }
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(17);
        }
        if (startElement == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(18);
        }
        if (endElement == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(19);
        }
        this.perform(this.getImportPathVariantsToImport(startElement), file, editor);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(20);
        }
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(21);
        }
        if (startElement == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(22);
        }
        if (endElement == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(23);
        }
        PsiReference reference = GoImportPackageQuickFix.getReference(startElement);
        return file instanceof GoFile && GoUtil.isInProject(file) && (!(file instanceof GoCodeFragment) || ((GoCodeFragment)file).supportsImports()) && reference != null && reference.resolve() == null && !GoImportPackageQuickFix.isAlreadyImportsPackageName((GoFile)file, this.myPackageName) && !this.getImportPathVariantsToImport(startElement).isEmpty();
    }

    private static boolean isAlreadyImportsPackageName(@NotNull GoFile file, @NotNull String packageName) {
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(24);
        }
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(25);
        }
        GoFile originalFile = (GoFile)((Object)ObjectUtils.notNull((Object)((Object)((GoFile)((Object)ObjectUtils.tryCast((Object)file.getOriginalFile(), GoFile.class)))), (Object)((Object)file)));
        return originalFile.getImportMap().containsKey((Object)packageName);
    }

    @Nullable
    private static PsiElement getIdentifierElement(@NotNull PsiElement element) {
        PsiElement next;
        if (element == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(26);
        }
        return (next = PsiTreeUtil.nextVisibleLeaf((PsiElement)element)) != null && next.textMatches((CharSequence)".") ? next.getNextSibling() : null;
    }

    private static boolean isQualifier(@Nullable PsiElement e) {
        if (!(e instanceof GoReferenceExpression) && !(e instanceof GoTypeReferenceExpression)) {
            return false;
        }
        ASTNode nextSibling = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)e.getNode());
        return nextSibling != null && nextSibling.getElementType() == GoTypes.DOT;
    }

    @NotNull
    private List<GoImport> getImportPathVariantsToImport(@NotNull PsiElement element) {
        if (element == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(27);
        }
        List list = (List)this.getImportPathVariants((PsiElement)element).first;
        if (list == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private Pair<List<GoImport>, Boolean> getImportPathVariants(@NotNull PsiElement element) {
        if (element == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(29);
        }
        long modCount = GoImportsSettings.getInstance(element.getProject()).getModificationCount();
        if (this.myPackagesToImport == null || this.myImportSettingsModCount != modCount) {
            this.myImportSettingsModCount = modCount;
            this.myPackagesToImport = GoImportPackageQuickFix.getImportPathVariants(this.myPackageName, element);
        }
        Pair<List<GoImport>, Boolean> pair = this.myPackagesToImport;
        if (pair == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(30);
        }
        return pair;
    }

    @NotNull
    public static List<GoImport> getImportPathVariantsToImport(@NotNull String packageName, @NotNull PsiElement context) {
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(31);
        }
        if (context == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(32);
        }
        Pair<List<GoImport>, Boolean> variants = GoImportPackageQuickFix.getImportPathVariants(packageName, context);
        List list = (Boolean)variants.second != false ? (List)variants.first : ContainerUtil.emptyList();
        if (list == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(33);
        }
        return list;
    }

    @NotNull
    private static Pair<List<GoImport>, Boolean> getImportPathVariants(@NotNull String packageName, @NotNull PsiElement context) {
        String identifierName;
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(34);
        }
        if (context == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(35);
        }
        PsiElement element = GoImportPackageQuickFix.isQualifier(context) && GoPsiUtil.notQualified(context) ? GoImportPackageQuickFix.getIdentifierElement(context) : null;
        String string = identifierName = element != null ? element.getText() : null;
        if (identifierName == null) {
            Pair pair = Pair.create((Object)ContainerUtil.emptyList(), (Object)false);
            if (pair == null) {
                GoImportPackageQuickFix.$$$reportNull$$$0(36);
            }
            return pair;
        }
        PsiFile contextFile = context.getContainingFile();
        Set<String> imported = GoImportPackageQuickFix.alreadyImportedPackagesPaths(contextFile);
        PsiFile originalFile = contextFile.getOriginalFile();
        Project project = context.getProject();
        Module module = GoUtil.module((PsiElement)originalFile);
        boolean vendoringEnabled = GoVendoringUtil.isVendoringEnabled(module);
        Predicate<GoFile> canBeImportedPredicate = GoImportPackageQuickFix.createCanBeImportedPredicate(contextFile, originalFile, module, vendoringEnabled);
        List<GoFile> files = GoImportPackageQuickFix.getFilesWithPackage(packageName, contextFile, project, canBeImportedPredicate);
        List<GoFile> filtered = GoImportPackageQuickFix.filterByName(files, packageName, identifierName, project);
        filtered.addAll(GoImportPackageQuickFix.getFilesByImportAlias((PsiElement)originalFile, packageName, identifierName, project, module, canBeImportedPredicate));
        HashMap<String, GoFile> importMap = new HashMap<String, GoFile>();
        if (filtered.isEmpty() && !"C".equals(packageName)) {
            List pathsUnresolved = ((StreamEx)GoImportPackageQuickFix.getDistinctPaths(files, imported, vendoringEnabled, packageName, importMap).sorted((Comparator)new MyImportsComparator(context, vendoringEnabled, Collections.emptySet(), importMap))).toList();
            Pair pair = Pair.create((Object)pathsUnresolved, (Object)false);
            if (pair == null) {
                GoImportPackageQuickFix.$$$reportNull$$$0(37);
            }
            return pair;
        }
        StreamEx pathsResolved = GoImportPackageQuickFix.getDistinctPaths(filtered, imported, vendoringEnabled, packageName, importMap);
        if ("C".equals(packageName)) {
            pathsResolved = pathsResolved.append((Object)new GoImport("C"));
        }
        Set<GoImport> previouslyOptimized = GoOptimizedImportsTracker.getOptimizedImports(originalFile);
        Pair pair = Pair.create((Object)((StreamEx)pathsResolved.sorted((Comparator)new MyImportsComparator(context, vendoringEnabled, previouslyOptimized, importMap))).toList(), (Object)true);
        if (pair == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(38);
        }
        return pair;
    }

    @NotNull
    private static List<GoFile> getFilesWithPackage(@NotNull String packageName, @NotNull PsiFile contextFile, @NotNull Project project, final @NotNull Predicate<GoFile> canBeImportedPredicate) {
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(39);
        }
        if (contextFile == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(40);
        }
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(41);
        }
        if (canBeImportedPredicate == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(42);
        }
        ArrayList<GoFile> files = new ArrayList<GoFile>();
        CancellableCollectProcessor<GoFile> processor2 = new CancellableCollectProcessor<GoFile>(files){

            protected boolean accept(GoFile file) {
                return canBeImportedPredicate.test(file);
            }
        };
        GlobalSearchScope scope = GoUtil.goPathResolveScope((PsiElement)contextFile);
        StubIndex.getInstance().processElements(GoPackagesIndex.KEY, (Object)packageName, project, scope, GoFile.class, (Processor)processor2);
        ArrayList<GoFile> arrayList = files;
        if (arrayList == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    @NotNull
    private static List<GoFile> filterByName(@NotNull List<GoFile> files, @NotNull String packageName, @NotNull String identifierName, @NotNull Project project) {
        if (files == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(44);
        }
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(45);
        }
        if (identifierName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(46);
        }
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(47);
        }
        StubIndexKey<String, GoNamedElement> index = StringUtil.isCapitalized((String)identifierName) ? GoAllPublicNamesIndex.ALL_PUBLIC_NAMES : GoAllPrivateNamesIndex.ALL_PRIVATE_NAMES;
        ArrayList<GoFile> filtered = new ArrayList<GoFile>();
        Processor processor2 = element -> {
            if (GoPsiUtil.isTopLevelDeclaration(element)) {
                filtered.add(element.getContainingFile());
            }
            return true;
        };
        String fqn = packageName + "." + identifierName;
        GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, (Collection)ContainerUtil.map(files, PsiFileImpl::getVirtualFile));
        StubIndex.getInstance().processElements(index, (Object)fqn, project, scope, GoNamedElement.class, processor2);
        ArrayList<GoFile> arrayList = filtered;
        if (arrayList == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    @NotNull
    private static Predicate<GoFile> createCanBeImportedPredicate(@NotNull PsiFile contextFile, @NotNull PsiFile originalFile, @Nullable Module module, boolean vendoringEnabled) {
        if (contextFile == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(49);
        }
        if (originalFile == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(50);
        }
        PsiDirectory parentDirectory = originalFile.getParent();
        String testTargetPackage = GoTestFinder.getTestTargetPackage(contextFile);
        Predicate<GoFile> predicate = file -> {
            if (parentDirectory != null && parentDirectory.isEquivalentTo((PsiElement)file.getParent()) && (testTargetPackage == null || !testTargetPackage.equals(file.getPackageName()))) {
                return false;
            }
            return GoPsiImplUtil.canBeAutoImported(file, false, module, vendoringEnabled);
        };
        if (predicate == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(51);
        }
        return predicate;
    }

    @NotNull
    private static List<GoFile> getFilesByImportAlias(@NotNull PsiElement context, @NotNull String alias, @NotNull String identifier, @NotNull Project project, @Nullable Module module, @NotNull Predicate<GoFile> canBeImportedPredicate) {
        if (context == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(52);
        }
        if (alias == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(53);
        }
        if (identifier == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(54);
        }
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(55);
        }
        if (canBeImportedPredicate == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(56);
        }
        Set<String> importPaths = GoAliasToImportPathIndexKt.getImportPathsByAlias(GlobalSearchScope.projectScope((Project)project), alias);
        for (GoImport goImport : GoOptimizedImportsTracker.getOptimizedImports(context.getContainingFile())) {
            if (!alias.equals(goImport.getAlias())) continue;
            importPaths.add(goImport.getImportPath());
        }
        ArrayList<GoFile> result = new ArrayList<GoFile>();
        ResolveState resolveState = GoPsiImplUtil.createContextOnElement(context);
        HashSet<String> processedImportPaths = new HashSet<String>();
        StubIndexKey<String, GoNamedElement> index = StringUtil.isCapitalized((String)identifier) ? GoAllPublicNamesIndex.ALL_PUBLIC_NAMES : GoAllPrivateNamesIndex.ALL_PRIVATE_NAMES;
        for (String importPath : importPaths) {
            if (!processedImportPaths.add(importPath)) continue;
            for (GoPackage pkg : GoPackageUtil.findByImportPath(importPath, project, module, resolveState)) {
                String packageName = pkg.getName();
                if (packageName.equals(alias)) continue;
                ArrayList<VirtualFile> canBeImported = new ArrayList<VirtualFile>();
                for (PsiFile file : pkg.files()) {
                    if (!(file instanceof GoFile) || !canBeImportedPredicate.test((GoFile)file)) continue;
                    canBeImported.add(file.getVirtualFile());
                }
                if (canBeImported.isEmpty()) continue;
                String fqn = packageName + "." + identifier;
                GlobalSearchScope scope = GlobalSearchScope.filesScope((Project)project, canBeImported);
                StubIndex.getInstance().processElements(index, (Object)fqn, project, scope, GoNamedElement.class, element -> {
                    if (GoPsiUtil.isTopLevelDeclaration(element)) {
                        result.add(element.getContainingFile());
                        return false;
                    }
                    return true;
                });
            }
        }
        ArrayList<GoFile> arrayList = result;
        if (arrayList == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @NotNull
    private static StreamEx<GoImport> getDistinctPaths(@NotNull List<GoFile> files, @NotNull Set<String> imported, boolean vendoringEnabled, @NotNull String packageName, @NotNull Map<String, GoFile> importMap) {
        if (files == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(58);
        }
        if (imported == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(59);
        }
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(60);
        }
        if (importMap == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(61);
        }
        ArrayList<GoImport> result = new ArrayList<GoImport>();
        for (GoFile file : files) {
            String filePackageName = file.getPackageName();
            for (String importPath : file.getAllImportPaths(vendoringEnabled)) {
                if (imported.contains(importPath) || importMap.putIfAbsent(importPath, file) != null) continue;
                String alias = GoImportPackageQuickFix.isRequireAlias(importPath, filePackageName, packageName) ? packageName : null;
                result.add(new GoImport(importPath, alias));
            }
        }
        StreamEx streamEx = StreamEx.of(result);
        if (streamEx == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(62);
        }
        return streamEx;
    }

    public static boolean isRequireAlias(@NotNull String importPath, @Nullable String packageName, @NotNull String qualifier) {
        if (importPath == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(63);
        }
        if (qualifier == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(64);
        }
        return !qualifier.equals(packageName) || !qualifier.equals(GoImportOptimizer.getAssumedPackageName(importPath));
    }

    @Nullable
    public static String getImportAlias(@NotNull String importPath, @NotNull String packageName) {
        if (importPath == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(65);
        }
        if (packageName == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(66);
        }
        return !packageName.equals(GoImportOptimizer.getAssumedPackageName(importPath)) ? packageName : null;
    }

    @NotNull
    private static Set<String> alreadyImportedPackagesPaths(@Nullable PsiFile file) {
        if (file instanceof GoCodeFragment) {
            HashSet<String> result = new HashSet<String>(((GoCodeFragment)file).getImportedPackagesMap().keySet());
            GoFile contextFile = ((GoCodeFragment)file).getContextFile();
            if (contextFile != null) {
                result.addAll(contextFile.getImportedPackagesMap().keySet());
            }
            HashSet<String> hashSet = result;
            if (hashSet == null) {
                GoImportPackageQuickFix.$$$reportNull$$$0(67);
            }
            return hashSet;
        }
        if (file instanceof GoFile) {
            Set<String> set = ((GoFile)file).getImportedPackagesMap().keySet();
            if (set == null) {
                GoImportPackageQuickFix.$$$reportNull$$$0(68);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(69);
        }
        return set;
    }

    public boolean doAutoImportOrShowHint(@NotNull Editor editor, boolean showHint) {
        PsiElement element;
        if (editor == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(70);
        }
        if ((element = this.getStartElement()) == null || !element.isValid()) {
            return false;
        }
        Project project = element.getProject();
        PsiFile file = element.getContainingFile();
        if (!(GoImportPackageQuickFix.isAddGoImportsOnTheFlyEnabled(project) || showHint && GoImportPackageQuickFix.canShowImportPopup(project))) {
            return false;
        }
        PsiReference reference = GoImportPackageQuickFix.getReference(element);
        if (reference == null || reference.resolve() != null) {
            return false;
        }
        Pair<List<GoImport>, Boolean> variants = this.getImportPathVariants(element);
        boolean imported = this.doAutoImportSinglePackageSilently(editor, file, variants);
        if (imported) {
            return true;
        }
        if (showHint && GoImportPackageQuickFix.canShowImportPopup(project)) {
            TextRange referenceRange = reference.getRangeInElement().shiftRight(element.getTextRange().getStartOffset());
            List packagesToImport = (List)variants.first;
            String importPaths = (String)ContainerUtil.getFirstItem((List)ContainerUtil.map((Collection)packagesToImport, GoImportPackageQuickFix::getImportPresentation));
            if (importPaths != null) {
                HintManager.getInstance().showQuestionHint(editor, ShowAutoImportPass.getMessage((packagesToImport.size() > 1 ? 1 : 0) != 0, (String)GoBundle.message((String)"go.terms.package", (Object[])new Object[0]), (String)importPaths), referenceRange.getStartOffset(), referenceRange.getEndOffset(), () -> {
                    if (file.isValid() && !editor.isDisposed()) {
                        this.perform(packagesToImport, file, editor);
                    }
                    return true;
                });
            }
            return true;
        }
        return false;
    }

    public boolean doAutoImportSinglePackageSilently(@NotNull Editor editor) {
        PsiElement element;
        if (editor == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(71);
        }
        if ((element = this.getStartElement()) == null || !element.isValid()) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        PsiReference reference = GoImportPackageQuickFix.getReference(element);
        if (reference == null || reference.resolve() != null) {
            return false;
        }
        Pair<List<GoImport>, Boolean> variants = this.getImportPathVariants(element);
        return this.doAutoImportSinglePackageSilently(editor, file, variants);
    }

    private boolean doAutoImportSinglePackageSilently(@NotNull Editor editor, PsiFile file, Pair<List<GoImport>, Boolean> variants) {
        List packagesToImport;
        if (editor == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(72);
        }
        if ((packagesToImport = (List)variants.first).isEmpty()) {
            return false;
        }
        boolean canPerformAutoImport = (Boolean)variants.second;
        if (canPerformAutoImport && file instanceof GoFile) {
            GoFile goFile = (GoFile)file;
            GoImportList importList = goFile.getImportList();
            canPerformAutoImport = importList == null || !importList.getTextRange().contains(editor.getCaretModel().getOffset());
            canPerformAutoImport = canPerformAutoImport && !GoImportPackageQuickFix.hasImportErrors(file, importList);
        }
        GoImport onlyPackageToImport = (GoImport)((Object)ContainerUtil.getOnlyItem((Collection)packagesToImport));
        if (canPerformAutoImport && onlyPackageToImport != null) {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
            CommandProcessor.getInstance().runUndoTransparentAction(() -> this.perform(file, onlyPackageToImport));
            return true;
        }
        return false;
    }

    private static boolean hasImportErrors(@NotNull PsiFile file, @Nullable GoImportList importList) {
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(73);
        }
        if (importList != null && PsiTreeUtil.hasErrorElements((PsiElement)importList)) {
            return true;
        }
        for (PsiElement child : file.getChildren()) {
            if (child instanceof LeafPsiElement && child.getNode().getElementType() == GoTypes.IMPORT) {
                return true;
            }
            if (!(child instanceof PsiErrorElement) || !((PsiErrorElement)child).getErrorDescription().contains("'import'")) continue;
            return true;
        }
        return false;
    }

    public boolean canAddUnambiguousImportsOnTheFly(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(74);
        }
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(75);
        }
        return GoImportPackageQuickFix.isAddGoImportsOnTheFlyEnabled(project) && !LaterInvocator.isInModalContext() && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently((PsiFileSystemItem)file, (boolean)true, (ThreeState)this.extensionsAllowToChangeFileSilently));
    }

    private static boolean isAddGoImportsOnTheFlyEnabled(@NotNull Project project) {
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(76);
        }
        return GoImportsSettings.getInstance(project).isAddUnambiguousImportsOnTheFly();
    }

    private static boolean canShowImportPopup(@NotNull Project project) {
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(77);
        }
        return !ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true) && GoImportsSettings.getInstance(project).isShowImportPopup();
    }

    private void perform(@NotNull List<GoImport> packagesToImport, @NotNull PsiFile file, @Nullable Editor editor) {
        if (packagesToImport == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(78);
        }
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(79);
        }
        LOG.assertTrue(editor != null || packagesToImport.size() == 1, (Object)"Cannot invoke fix with ambiguous imports on null editor");
        if (packagesToImport.size() > 1 && editor != null) {
            Map indexByImportPath = ContainerUtil.map2Map(packagesToImport, it -> Pair.create((Object)GoImportPackageQuickFix.getImportPresentation(it), (Object)it));
            List list = ContainerUtil.map(packagesToImport, it -> GoImportPackageQuickFix.getImportPresentation(it));
            JBPopup popup = this.createImportPopup(file, indexByImportPath, list);
            popup.showInBestPositionFor(editor);
        } else if (packagesToImport.size() == 1) {
            this.perform(file, (GoImport)((Object)ContainerUtil.getFirstItem(packagesToImport)));
        } else {
            String packages = StringUtil.join(packagesToImport, (String)",");
            throw new IncorrectOperationException(GoBundle.message((String)"go.import.package.cannot.invoke.fix.with.ambiguous.imports.error", (Object[])new Object[]{editor, packages}));
        }
    }

    @NotNull
    private JBPopup createImportPopup(final @NotNull PsiFile file, final Map<String, GoImport> indexByImportPath, List<String> list) {
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(80);
        }
        final Project project = file.getProject();
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(GoBundle.message((String)"go.import.package.popup.title", (Object[])new Object[0]), list){

            public boolean isAutoSelectionEnabled() {
                return false;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public boolean hasSubstep(String selectedValue) {
                return true;
            }

            public Icon getIconFor(String value) {
                return GoIcons.PACKAGE;
            }

            @Nullable
            public PopupStep<?> onChosen(String importPath, boolean finalChoice) {
                if (importPath == null) {
                    return FINAL_CHOICE;
                }
                if (finalChoice) {
                    return this.doFinalStep(() -> GoImportPackageQuickFix.this.perform(file, (GoImport)((Object)((Object)indexByImportPath.get(importPath)))));
                }
                return GoImportPackageQuickFix.getExcludesStep(project, importPath);
            }
        };
        ListPopup result = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        result.setRequestFocus(true);
        ListPopup listPopup = result;
        if (listPopup == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(81);
        }
        return listPopup;
    }

    @Nullable
    private static PopupStep<?> getExcludesStep(final @NotNull Project project, @Nullable String importPath) {
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(82);
        }
        if (importPath == null) {
            return PopupStep.FINAL_CHOICE;
        }
        ArrayList<String> toExclude = new ArrayList<String>();
        String path = importPath;
        while (true) {
            toExclude.add(path);
            int slashIndex = path.lastIndexOf(47);
            if (slashIndex == -1) break;
            path = path.substring(0, slashIndex);
        }
        return new BaseListPopupStep<String>(null, toExclude){

            @NotNull
            public String getTextFor(String importPath) {
                String string = GoBundle.message((String)"action.go.exclude.package.from.import.and.completion", (Object[])new Object[]{importPath});
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep<?> onChosen(String importPath, boolean finalChoice) {
                GoImportsSettings.getInstance(project).excludePath(importPath);
                GoImportPackageQuickFix.notifyExcluded(project, importPath);
                return super.onChosen((Object)importPath, finalChoice);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/codeInsight/imports/GoImportPackageQuickFix$3", "getTextFor"));
            }
        };
    }

    private void perform(@NotNull PsiFile file, @Nullable GoImport goImport) {
        if (file == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(83);
        }
        if (file instanceof GoFile && goImport != null) {
            Project project = file.getProject();
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                if (!this.isAvailable()) {
                    return;
                }
                if (GoImportPackageQuickFix.alreadyImportedPackagesPaths(file).contains(goImport.getImportPath())) {
                    GoOptimizedImportsTracker.removeOptimizedImport(file, goImport);
                    return;
                }
                if ("C".equals(goImport.getImportPath())) {
                    GoImportList importList = ((GoFile)file).getImportList();
                    if (importList != null) {
                        GoImportDeclaration importC = GoElementFactory.createImportDeclaration(project, "\"C\"");
                        importList.getParent().addBefore((PsiElement)importC, (PsiElement)importList);
                    }
                } else {
                    ((GoFile)file).addImport(goImport.getImportPath(), goImport.getAlias());
                    GoOptimizedImportsTracker.removeOptimizedImport(file, goImport);
                }
            }), GoBundle.message((String)"go.add.import.command.name", (Object[])new Object[0]), null);
        }
    }

    static void notifyExcluded(@NotNull Project project, @NotNull String importPath) {
        if (project == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(84);
        }
        if (importPath == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(85);
        }
        String message = GoBundle.message((String)"go.notification.package.was.excluded", (Object[])new Object[]{importPath});
        Notification notification = GoNotifications.getGeneralGroup().createNotification(message, NotificationType.INFORMATION);
        notification.addAction((AnAction)new NotificationAction(GoBundle.message((String)"go.notification.open.imports.settings", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                Project project;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    4.$$$reportNull$$$0(1);
                }
                if ((project = e.getProject()) == null || project.isDisposed()) {
                    return;
                }
                notification.expire();
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, GoImportConfigurable.class);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/goide/codeInsight/imports/GoImportPackageQuickFix$4";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @NotNull
    public static String getImportPresentation(@NotNull GoImport goImport) {
        String alias;
        if (goImport == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(86);
        }
        if (StringUtil.isNotEmpty((String)(alias = goImport.getAlias()))) {
            String string = GoBundle.message((String)"go.add.import.with.alias.presentation", (Object[])new Object[]{goImport.getImportPath(), alias});
            if (string == null) {
                GoImportPackageQuickFix.$$$reportNull$$$0(87);
            }
            return string;
        }
        String string = goImport.getImportPath();
        if (string == null) {
            GoImportPackageQuickFix.$$$reportNull$$$0(88);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12, 13, 14, 15, 28, 30, 33, 36, 37, 38, 43, 48, 51, 57, 62, 67, 68, 69, 81, 87, 88 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 63: 
            case 65: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canChangeFileSilently";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: 
            case 25: 
            case 31: 
            case 34: 
            case 39: 
            case 45: 
            case 60: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 48: 
            case 51: 
            case 57: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 81: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/codeInsight/imports/GoImportPackageQuickFix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 10: 
            case 70: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 20: 
            case 41: 
            case 47: 
            case 55: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 21: 
            case 24: 
            case 73: 
            case 75: 
            case 79: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 32: 
            case 35: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 42: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canBeImportedPredicate";
                break;
            }
            case 44: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifierName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imported";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importMap";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagesToImport";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/codeInsight/imports/GoImportPackageQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "canChangeFileSilently";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 28: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPathVariantsToImport";
                break;
            }
            case 30: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPathVariants";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithPackage";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByName";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createCanBeImportedPredicate";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByImportAlias";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistinctPaths";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "alreadyImportedPackagesPaths";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportPopup";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canChangeFileSilently";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 43: 
            case 48: 
            case 51: 
            case 57: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 81: 
            case 87: 
            case 88: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyImportsPackageName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierElement";
                break;
            }
            case 27: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getImportPathVariantsToImport";
                break;
            }
            case 29: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getImportPathVariants";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithPackage";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "filterByName";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createCanBeImportedPredicate";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByImportAlias";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getDistinctPaths";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isRequireAlias";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getImportAlias";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "doAutoImportOrShowHint";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "doAutoImportSinglePackageSilently";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "hasImportErrors";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "canAddUnambiguousImportsOnTheFly";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isAddGoImportsOnTheFlyEnabled";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "canShowImportPopup";
                break;
            }
            case 78: 
            case 79: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "createImportPopup";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getExcludesStep";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "notifyExcluded";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getImportPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 12, 13, 14, 15, 28, 30, 33, 36, 37, 38, 43, 48, 51, 57, 62, 67, 68, 69, 81, 87, 88 -> new IllegalStateException(string);
        };
    }

    private static class MyImportsComparator
    implements Comparator<GoImport> {
        private final Project myProject;
        private final GlobalSearchScope myScope;
        private final PsiElement myContext;
        @Nullable
        private final String myContextImportPath;
        private final Set<GoImport> myPreviouslyUsedImports;
        private final Map<String, Integer> myUsageCountCache;
        private final UserDataHolder myDataHolder;
        private final Map<String, GoFile> myImportMap;

        MyImportsComparator(@NotNull PsiElement context, boolean vendoringEnabled, @NotNull Set<GoImport> previouslyUsedImports, @NotNull Map<String, GoFile> importMap) {
            if (context == null) {
                MyImportsComparator.$$$reportNull$$$0(0);
            }
            if (previouslyUsedImports == null) {
                MyImportsComparator.$$$reportNull$$$0(1);
            }
            if (importMap == null) {
                MyImportsComparator.$$$reportNull$$$0(2);
            }
            this.myUsageCountCache = new HashMap<String, Integer>();
            this.myProject = context.getProject();
            Module module = GoUtil.module((PsiElement)context.getContainingFile());
            this.myScope = module != null ? module.getModuleContentScope() : null;
            this.myContext = context;
            this.myContextImportPath = GoCompletionUtil.getContextImportPath(context, vendoringEnabled);
            this.myPreviouslyUsedImports = previouslyUsedImports;
            this.myDataHolder = new UserDataHolderBase();
            this.myImportMap = importMap;
        }

        @Override
        public int compare(@NotNull GoImport s1, @NotNull GoImport s2) {
            int w2;
            int count2;
            int count1;
            if (s1 == null) {
                MyImportsComparator.$$$reportNull$$$0(3);
            }
            if (s2 == null) {
                MyImportsComparator.$$$reportNull$$$0(4);
            }
            boolean prev1 = this.myPreviouslyUsedImports.contains((Object)s1);
            boolean prev2 = this.myPreviouslyUsedImports.contains((Object)s2);
            if (prev1 && !prev2) {
                return -1;
            }
            if (prev2 && !prev1) {
                return 1;
            }
            if (this.myScope != null && (count1 = this.getUsageCount(s1)) != (count2 = this.getUsageCount(s2))) {
                return Integer.compare(count2, count1);
            }
            int w1 = GoImportsWeigher.getWeight(this.myProject, this.myContext, (PsiFile)this.myImportMap.get(s1.getImportPath()), this.myDataHolder);
            if (w1 != (w2 = GoImportsWeigher.getWeight(this.myProject, this.myContext, (PsiFile)this.myImportMap.get(s2.getImportPath()), this.myDataHolder))) {
                return Integer.compare(w2, w1);
            }
            int result = Integer.compare(GoCompletionUtil.calculatePackagePriority(s2.getImportPath(), this.myContextImportPath), GoCompletionUtil.calculatePackagePriority(s1.getImportPath(), this.myContextImportPath));
            return result != 0 ? result : Comparing.compare((Comparable)((Object)s1.getImportPath()), (Comparable)((Object)s2.getImportPath()));
        }

        private int getUsageCount(@NotNull GoImport goImport) {
            if (goImport == null) {
                MyImportsComparator.$$$reportNull$$$0(5);
            }
            String importPath = goImport.getImportPath();
            return this.myUsageCountCache.computeIfAbsent(importPath, it -> GoImportPathToAliasIndexKt.getImportPathUsageCount(this.myScope, it));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previouslyUsedImports";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importMap";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s2";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "goImport";
                    break;
                }
            }
            objectArray2[1] = "com/goide/codeInsight/imports/GoImportPackageQuickFix$MyImportsComparator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUsageCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

