/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.execution.testing.ui.GoPackageFieldCompletionProvider;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoImportConfigurable
implements SearchableConfigurable,
Disposable {
    private JCheckBox myCbShowImportPopup;
    private JCheckBox myCbAddUnambiguousImports;
    private JCheckBox myCbOptimizeImportsOnTheFly;
    private JBList<String> myExcludePackagesList;
    private DefaultListModel<String> myExcludePackagesModel;
    @NotNull
    private final GoImportsSettings myImportsSettings;
    @NotNull
    private final Project myProject;
    private final boolean myIsDialog;

    public GoImportConfigurable(@NotNull Project project) {
        if (project == null) {
            GoImportConfigurable.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    public GoImportConfigurable(@NotNull Project project, boolean dialogMode) {
        if (project == null) {
            GoImportConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myImportsSettings = GoImportsSettings.getInstance(project);
        this.myIsDialog = dialogMode;
    }

    @Nullable
    public JComponent createComponent() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addComponent((JComponent)this.createAutoImportPanel());
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)builder.getPanel(), "North");
        if (this.myIsDialog) {
            Dimension preferredSize = result.getPreferredSize();
            result.setPreferredSize(new Dimension(Math.max(preferredSize.width, JBUI.scale((int)400)), Math.max(preferredSize.height, -1)));
        }
        return result;
    }

    private JPanel createAutoImportPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        this.myCbShowImportPopup = new JCheckBox(ApplicationBundle.message((String)"checkbox.show.import.popup", (Object[])new Object[0]));
        this.myCbAddUnambiguousImports = new JCheckBox(ApplicationBundle.message((String)"checkbox.add.unambiguous.imports.on.the.fly", (Object[])new Object[0]));
        this.myCbOptimizeImportsOnTheFly = new JCheckBox(ApplicationBundle.message((String)"checkbox.optimize.imports.on.the.fly", (Object[])new Object[0]));
        builder.addComponent((JComponent)this.myCbShowImportPopup);
        builder.addComponent((JComponent)this.myCbAddUnambiguousImports);
        builder.addComponent((JComponent)this.myCbOptimizeImportsOnTheFly);
        this.myExcludePackagesList = new JBList();
        builder.addLabeledComponent(ApplicationBundle.message((String)"exclude.from.completion.group", (Object[])new Object[0]), (JComponent)ToolbarDecorator.createDecorator(this.myExcludePackagesList).setAddAction((AnActionButtonRunnable)new AddImportExclusionAction()).disableUpDownActions().createPanel(), 12, true);
        JPanel panel = builder.getPanel();
        panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)GoBundle.message((String)"go.auto.import.and.completion.title", (Object[])new Object[0]), (boolean)true));
        return panel;
    }

    public void focusList() {
        this.myExcludePackagesList.setSelectedIndex(0);
        this.myExcludePackagesList.requestFocus();
    }

    private String[] getExcludedPackages() {
        Object[] excludedPackages = new String[this.myExcludePackagesModel.size()];
        for (int i = 0; i < this.myExcludePackagesModel.size(); ++i) {
            excludedPackages[i] = this.myExcludePackagesModel.elementAt(i);
        }
        Arrays.sort(excludedPackages);
        return excludedPackages;
    }

    public boolean isModified() {
        return this.myImportsSettings.isShowImportPopup() != this.myCbShowImportPopup.isSelected() || this.myImportsSettings.isAddUnambiguousImportsOnTheFly() != this.myCbAddUnambiguousImports.isSelected() || this.myImportsSettings.isOptimizeImportsOnTheFly() != this.myCbOptimizeImportsOnTheFly.isSelected() || !Arrays.equals(this.getExcludedPackages(), this.myImportsSettings.getExcludedPackages());
    }

    public void apply() {
        this.myImportsSettings.setShowImportPopup(this.myCbShowImportPopup.isSelected());
        this.myImportsSettings.setAddUnambiguousImportsOnTheFly(this.myCbAddUnambiguousImports.isSelected());
        this.myImportsSettings.setOptimizeImportsOnTheFly(this.myCbOptimizeImportsOnTheFly.isSelected());
        this.myImportsSettings.setExcludedPackages(this.getExcludedPackages());
    }

    public void reset() {
        this.myCbShowImportPopup.setSelected(this.myImportsSettings.isShowImportPopup());
        this.myCbAddUnambiguousImports.setSelected(this.myImportsSettings.isAddUnambiguousImportsOnTheFly());
        this.myCbOptimizeImportsOnTheFly.setSelected(this.myImportsSettings.isOptimizeImportsOnTheFly());
        this.myExcludePackagesModel = new DefaultListModel();
        for (String name : this.myImportsSettings.getExcludedPackages()) {
            this.myExcludePackagesModel.add(this.myExcludePackagesModel.size(), name);
        }
        this.myExcludePackagesList.setModel(this.myExcludePackagesModel);
    }

    @NotNull
    public String getId() {
        return "go.autoimport";
    }

    @Nls
    public String getDisplayName() {
        return GoBundle.message((String)"go.settings.imports.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "Creating_and_Optimizing_Imports";
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        UIUtil.dispose((Component)this.myCbShowImportPopup);
        UIUtil.dispose((Component)this.myCbAddUnambiguousImports);
        UIUtil.dispose((Component)this.myCbOptimizeImportsOnTheFly);
        UIUtil.dispose(this.myExcludePackagesList);
        this.myCbShowImportPopup = null;
        this.myCbAddUnambiguousImports = null;
        this.myCbOptimizeImportsOnTheFly = null;
        this.myExcludePackagesList = null;
        if (this.myExcludePackagesModel != null) {
            this.myExcludePackagesModel.removeAllElements();
            this.myExcludePackagesModel = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/goide/codeInsight/imports/GoImportConfigurable", "<init>"));
    }

    private class AddImportExclusionAction
    implements AnActionButtonRunnable {
        private AddImportExclusionAction() {
        }

        public void run(AnActionButton button) {
            AddImportExclusionDialog dialog = new AddImportExclusionDialog(GoImportConfigurable.this.myProject);
            if (dialog.showAndGet()) {
                this.addExcludedPackage(dialog.getImportPath());
            }
        }

        private void addExcludedPackage(@Nullable @NlsSafe String packageName) {
            if (StringUtil.isEmpty((String)packageName)) {
                return;
            }
            int index = -Arrays.binarySearch(GoImportConfigurable.this.myExcludePackagesModel.toArray(), packageName) - 1;
            if (index >= 0) {
                GoImportConfigurable.this.myExcludePackagesModel.add(index, packageName);
                ScrollingUtil.ensureIndexIsVisible(GoImportConfigurable.this.myExcludePackagesList, (int)index, (int)0);
            }
            GoImportConfigurable.this.myExcludePackagesList.clearSelection();
            GoImportConfigurable.this.myExcludePackagesList.setSelectedValue((Object)packageName, true);
            GoImportConfigurable.this.myExcludePackagesList.requestFocus();
        }
    }

    private static class AddImportExclusionDialog
    extends DialogWrapper {
        private final Project myProject;
        private EditorTextField myField;

        protected AddImportExclusionDialog(@Nullable Project project) {
            super(project, false);
            this.myProject = project;
            this.setTitle(GoBundle.message((String)"go.exclude.import.path.dialog.title", (Object[])new Object[0]));
            this.init();
        }

        @NotNull
        public String getImportPath() {
            return this.myField != null ? this.myField.getText() : "";
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myField;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            this.myField = new GoPackageFieldCompletionProvider((NotNullProducer<? extends Collection<Module>>)((NotNullProducer)() -> GoSdkUtil.getGoModules(this.myProject)), false, true).createEditor(this.myProject);
            return FormBuilder.createFormBuilder().addLabeledComponent(GoBundle.message((String)"go.auto.import.and.completion.add.exclude.label", (Object[])new Object[0]), (JComponent)this.myField, true).getPanel();
        }

        @Nullable
        protected ValidationInfo doValidate() {
            return this.myField != null && this.myField.getText().trim().isEmpty() ? new ValidationInfo(GoBundle.message((String)"go.exclude.import.path.dialog.empty.path.validation.message", (Object[])new Object[0])) : super.doValidate();
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return ((Object)((Object)this)).getClass().getName();
        }
    }
}

