/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.i18n.GoBundle;
import com.goide.util.GoGetPackageUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoGetPackageFix
implements LocalQuickFix,
HighPriorityAction {
    @NlsSafe
    private static final String PRESENTABLE_NAME_PREFIX = "go get -t ";
    @NotNull
    @NlsSafe
    private final String myPackage;

    public GoGetPackageFix(@NotNull String packageName) {
        if (packageName == null) {
            GoGetPackageFix.$$$reportNull$$$0(0);
        }
        this.myPackage = packageName;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            GoGetPackageFix.$$$reportNull$$$0(1);
        }
        if (previewDescriptor == null) {
            GoGetPackageFix.$$$reportNull$$$0(2);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            GoGetPackageFix.$$$reportNull$$$0(3);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    public String getName() {
        String string = PRESENTABLE_NAME_PREFIX + this.myPackage + "/...";
        if (string == null) {
            GoGetPackageFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.get.package.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            GoGetPackageFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            GoGetPackageFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            GoGetPackageFix.$$$reportNull$$$0(7);
        }
        if ((element = descriptor.getPsiElement()) != null && element.isValid()) {
            String containingDir = element.getContainingFile().getContainingDirectory().getVirtualFile().getPath();
            GoGetPackageUtil.goGetPackage(project, GoUtil.module(element), containingDir, this.myPackage);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/codeInsight/imports/GoGetPackageFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/codeInsight/imports/GoGetPackageFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

