/*
 * Decompiled with CFR 0.152.
 */
package com.goide.codeInsight.imports;

import com.goide.codeInsight.imports.GoImportConfigurable;
import com.goide.codeInsight.imports.GoImportPackageQuickFix;
import com.goide.codeInsight.imports.GoImportsSettings;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GoExcludePathLookupActionProvider
implements LookupActionProvider {
    public void fillActions(@NotNull LookupElement element, @NotNull Lookup lookup, @NotNull @NotNull Consumer<? super @NotNull LookupElementAction> consumer) {
        PsiElement psiElement;
        PsiFile file;
        if (element == null) {
            GoExcludePathLookupActionProvider.$$$reportNull$$$0(0);
        }
        if (lookup == null) {
            GoExcludePathLookupActionProvider.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            GoExcludePathLookupActionProvider.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = file = (psiElement = element.getPsiElement()) != null && psiElement.isValid() ? psiElement.getContainingFile() : null;
        if (file instanceof GoFile) {
            Project project = psiElement.getProject();
            for (String importPath : ((GoFile)file).getAllImportPaths(false)) {
                for (String path : GoExcludePathLookupActionProvider.getPaths(importPath)) {
                    consumer.consume((Object)new ExcludePathAction(project, path));
                }
                consumer.consume((Object)new EditExcludedAction(project));
            }
        }
    }

    private static List<String> getPaths(String importPath) {
        int i;
        SmartList result = new SmartList((Object)importPath);
        while ((i = importPath.lastIndexOf(47)) > 0) {
            importPath = importPath.substring(0, i);
            result.add(importPath);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lookup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/goide/codeInsight/imports/GoExcludePathLookupActionProvider";
        objectArray[2] = "fillActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ExcludePathAction
    extends LookupElementAction {
        private final Project myProject;
        private final String myImportPath;

        protected ExcludePathAction(@NotNull Project project, @NotNull String importPath) {
            if (project == null) {
                ExcludePathAction.$$$reportNull$$$0(0);
            }
            if (importPath == null) {
                ExcludePathAction.$$$reportNull$$$0(1);
            }
            super(AllIcons.General.Remove, GoBundle.message((String)"go.exclude.import.path.from.completion.action.name", (Object[])new Object[]{importPath}));
            this.myProject = project;
            this.myImportPath = importPath;
        }

        public LookupElementAction.Result performLookupAction() {
            GoImportsSettings.getInstance(this.myProject).excludePath(this.myImportPath);
            GoImportPackageQuickFix.notifyExcluded(this.myProject, this.myImportPath);
            return LookupElementAction.Result.HIDE_LOOKUP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "importPath";
                    break;
                }
            }
            objectArray[1] = "com/goide/codeInsight/imports/GoExcludePathLookupActionProvider$ExcludePathAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EditExcludedAction
    extends LookupElementAction {
        @NotNull
        final Project myProject;

        protected EditExcludedAction(@NotNull Project project) {
            if (project == null) {
                EditExcludedAction.$$$reportNull$$$0(0);
            }
            super(AllIcons.Actions.Edit, GoBundle.message((String)"go.edit.auto.import.settings.action.name", (Object[])new Object[0]));
            this.myProject = project;
        }

        public LookupElementAction.Result performLookupAction() {
            ApplicationManager.getApplication().invokeLater(() -> {
                GoImportConfigurable configurable = new GoImportConfigurable(this.myProject, true);
                ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)configurable, configurable::focusList);
            });
            return LookupElementAction.Result.HIDE_LOOKUP;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/goide/codeInsight/imports/GoExcludePathLookupActionProvider$EditExcludedAction", "<init>"));
        }
    }
}

