/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.tool;

import com.goide.GoNotifications;
import com.goide.actions.tool.GoExternalToolsAction;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoExecutor;
import com.goide.util.GoGetPackageUtil;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.function.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoDownloadableFileAction
extends GoExternalToolsAction {
    @NotNull
    private final String myGoGetImportPath;
    @NotNull
    private final String myExecutableName;

    GoDownloadableFileAction(@NonNls @NotNull String executableName, @NonNls @NotNull String goGetImportPath) {
        if (executableName == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(0);
        }
        if (goGetImportPath == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(1);
        }
        this.myExecutableName = executableName;
        this.myGoGetImportPath = goGetImportPath;
    }

    @Override
    protected boolean doSomething(@NotNull Collection<VirtualFile> files, @Nullable Module module, @NotNull Project project, @NotNull String title, boolean startInBackground, @NotNull Consumer<? super GoExecutor.ExecutionResult> consumer) {
        if (files == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(3);
        }
        if (title == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(5);
        }
        return this.downloadIfNeeded(module, project, title) && super.doSomething(files, module, project, title, startInBackground, consumer);
    }

    @Override
    protected boolean doSomething(@NotNull Collection<VirtualFile> files, @Nullable Module module, @NotNull Project project, @NotNull String title) {
        if (files == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(6);
        }
        if (project == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(7);
        }
        if (title == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(8);
        }
        return this.downloadIfNeeded(module, project, title) && super.doSomething(files, module, project, title);
    }

    private boolean downloadIfNeeded(@Nullable Module module, @NotNull Project project, @NotNull @NlsContexts.NotificationTitle String title) {
        VirtualFile executable;
        if (project == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(9);
        }
        if (title == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(10);
        }
        if ((executable = this.getExecutable(project, module)) == null) {
            GoDownloadableFileAction.showDownloadToolNotification(project, module, title, this.myExecutableName, this.myGoGetImportPath);
            return false;
        }
        return true;
    }

    public static void showDownloadToolNotification(@NotNull Project project, @Nullable Module module, @NotNull @NlsContexts.NotificationTitle String title, @NotNull @NonNls String executableName, @NotNull @NonNls String importPath) {
        if (project == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(11);
        }
        if (title == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(12);
        }
        if (executableName == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(13);
        }
        if (importPath == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(14);
        }
        String message = GoBundle.message((String)"go.notification.go.tool.is.missing.run.go.get.text", (Object[])new Object[]{executableName});
        GoNotifications.getGeneralGroup().createNotification(title, message, NotificationType.WARNING).addAction((AnAction)NotificationAction.createSimpleExpiring((String)GoBundle.message((String)"go.notification.go.tool.is.missing.run.go.get.invoke.go.get.action.text", (Object[])new Object[]{executableName}), () -> GoGetPackageUtil.installTool(project, module, null, importPath))).notify(project);
    }

    @Nullable
    protected VirtualFile getExecutable(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            GoDownloadableFileAction.$$$reportNull$$$0(15);
        }
        return GoSdkUtil.findExecutableInGoPath(this.myExecutableName, project, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goGetImportPath";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
        }
        objectArray2[1] = "com/goide/actions/tool/GoDownloadableFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doSomething";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "downloadIfNeeded";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "showDownloadToolNotification";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

