/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.file;

import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.psi.GoImportList;
import com.goide.psi.GoPackageClause;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.IOException;
import java.util.HashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GoScratchFileCreationHelper
extends ScratchFileCreationHelper {
    @NonNls
    private static final String CARET_MARKER = "CARET_MARKER";

    public boolean prepareText(@NotNull Project project, @NotNull ScratchFileCreationHelper.Context context, @NotNull DataContext dataContext) {
        GoImportList importList;
        String importText;
        GoPackageClause packageClause;
        String packageText;
        String headerText;
        String targetFileText;
        PsiFile targetFile;
        if (project == null) {
            GoScratchFileCreationHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GoScratchFileCreationHelper.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            GoScratchFileCreationHelper.$$$reportNull$$$0(2);
        }
        if (context.text.isEmpty()) {
            String text = GoScratchFileCreationHelper.reformat((Project)project, (Language)context.language, (String)GoScratchFileCreationHelper.createMainFile(project));
            int caretMakerOffset = text.indexOf(CARET_MARKER);
            if (caretMakerOffset >= 0) {
                context.caretOffset = caretMakerOffset;
                context.text = text.substring(0, context.caretOffset) + text.substring(context.caretOffset + CARET_MARKER.length());
            } else {
                context.text = text;
            }
            return true;
        }
        PsiFile sourceFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (sourceFile != null && (targetFile = GoScratchFileCreationHelper.parseHeader((Project)project, (Language)context.language, (String)(targetFileText = (headerText = (packageText = (packageClause = (GoPackageClause)PsiTreeUtil.findChildOfType((PsiElement)sourceFile, GoPackageClause.class)) != null ? packageClause.getText() : "package main") + "\n\n" + (importText = (importList = (GoImportList)PsiTreeUtil.findChildOfType((PsiElement)sourceFile, GoImportList.class)) != null ? importList.getText() : "") + (importText.isEmpty() ? "" : "\n\n")) + StringUtil.trimLeading((String)StringUtil.trimStart((String)context.text, (String)packageText))))) != null) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(new GoImportOptimizer().processFile(targetFile)));
            context.caretOffset = targetFile.getTextRange().getEndOffset();
            PsiElement anchor = PsiTreeUtil.getChildOfType((PsiElement)targetFile, GoImportList.class);
            if (anchor != null) {
                PsiElement next = anchor.getNextSibling();
                if (next instanceof PsiWhiteSpace) {
                    next = next.getNextSibling();
                }
                if (next != null) {
                    context.caretOffset = next.getTextRange().getStartOffset();
                }
            }
            context.text = targetFile.getText();
            return true;
        }
        return false;
    }

    @NonNls
    @NotNull
    private static String createMainFile(@NotNull Project project) {
        String string;
        if (project == null) {
            GoScratchFileCreationHelper.$$$reportNull$$$0(3);
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        FileTemplate template = templateManager.getInternalTemplate("Go Scratch.go");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("GO_PACKAGE_NAME", "main");
        try {
            string = template.getText(attributes).replaceFirst("\\$END\\$", CARET_MARKER);
        }
        catch (IOException e) {
            return "package main\n\nfunc main(){\n\tCARET_MARKER\n}";
        }
        if (string == null) {
            GoScratchFileCreationHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/file/GoScratchFileCreationHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/file/GoScratchFileCreationHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createMainFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareText";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMainFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

