/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.file;

import com.goide.GoIcons;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.NewFileActionWithCategory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCreateFileAction
extends CreateFileFromTemplateAction
implements DumbAware,
NewFileActionWithCategory {
    @NonNls
    private static final String FILE_TEMPLATE = "Go File";
    @NonNls
    private static final String APPLICATION_TEMPLATE = "Go Application";
    @NonNls
    private static final String DEFAULT_GO_TEMPLATE_PROPERTY = "DefaultGoTemplateProperty";

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        if (project == null) {
            GoCreateFileAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            GoCreateFileAction.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            GoCreateFileAction.$$$reportNull$$$0(2);
        }
        builder.setTitle(GoBundle.message((String)"go.create.new.file.dialog.title", (Object[])new Object[0])).addKind(GoBundle.message((String)"go.create.new.file.empty.file.kind.name", (Object[])new Object[0]), GoIcons.ICON, FILE_TEMPLATE).addKind(GoBundle.message((String)"go.create.new.file.simple.application.kind.name", (Object[])new Object[0]), GoIcons.ICON, APPLICATION_TEMPLATE);
    }

    @Nullable
    protected String getDefaultTemplateProperty() {
        return DEFAULT_GO_TEMPLATE_PROPERTY;
    }

    @NotNull
    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            GoCreateFileAction.$$$reportNull$$$0(3);
        }
        String string = GoBundle.message((String)"go.create.new.file.action.command.name", (Object[])new Object[]{newName});
        if (string == null) {
            GoCreateFileAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void postProcess(@NotNull PsiFile createdElement, String templateName, Map<String, String> customProperties) {
        if (createdElement == null) {
            GoCreateFileAction.$$$reportNull$$$0(5);
        }
        if (createdElement instanceof GoFile) {
            GoPackageClause packageClause = ((GoFile)createdElement).getPackage();
            if (packageClause == null) {
                return;
            }
            Project project = createdElement.getProject();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            VirtualFile virtualFile = createdElement.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            if (FileDocumentManager.getInstance().getDocument(virtualFile) == editor.getDocument()) {
                editor.getCaretModel().moveToOffset(packageClause.getTextRange().getEndOffset());
            }
        }
    }

    @NotNull
    public String getCategory() {
        return "Go";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/file/GoCreateFileAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/file/GoCreateFileAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildDialog";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

