/*
 * Decompiled with CFR 0.152.
 */
package com.goide.actions.debugger;

import com.goide.GoOsManager;
import com.goide.dlv.DlvDisconnectOption;
import com.goide.dlv.attach.DlvDebugSessionStarter;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoRunningState;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.i18n.GoBundle;
import com.goide.util.GoExecutor;
import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugProcessStarter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoReplayTraceAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final String RECENT_TRACE_KEY = "GoReplayTraceAction.RECENT_TRACE_KEY";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GoReplayTraceAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GoReplayTraceAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(GoOsManager.isLinux() && e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GoReplayTraceAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        final TraceDirDialog dialog = new TraceDirDialog(project);
        if (dialog.showAndGet()) {
            RecentsManager.getInstance((Project)project).registerRecentEntry(RECENT_TRACE_KEY, dialog.getTrace());
            try {
                new DlvDebugSessionStarter(project){

                    @Override
                    @NotNull
                    protected GoRunningState<GoRunConfigurationBase<?>> createState(@NotNull InetSocketAddress address, @NotNull ExecutionEnvironment env, @NotNull GoApplicationConfiguration configuration) {
                        if (address == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (env == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (configuration == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return new GoReplayTraceState(address, env, configuration, dialog.getTrace());
                    }

                    @Override
                    @NotNull
                    protected String getSessionName() {
                        String string = GoBundle.message((String)"go.mozilla.rr.session.name", (Object[])new Object[]{dialog.getTrace()});
                        if (string == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return string;
                    }

                    @Override
                    @NotNull
                    protected XDebugProcessStarter createDebugProcessStarter(@NotNull InetSocketAddress address, @NotNull ExecutionResult executionResult) {
                        if (address == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        if (executionResult == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        XDebugProcessStarter xDebugProcessStarter = GoRunUtil.createDelveXDebugStarter(address, executionResult, DlvDisconnectOption.KILL, true);
                        if (xDebugProcessStarter == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        return xDebugProcessStarter;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 3, 6 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "address";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "env";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "configuration";
                                break;
                            }
                            case 3: 
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/goide/actions/debugger/GoReplayTraceAction$1";
                                break;
                            }
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "executionResult";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/goide/actions/debugger/GoReplayTraceAction$1";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getSessionName";
                                break;
                            }
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createDebugProcessStarter";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createState";
                                break;
                            }
                            case 3: 
                            case 6: {
                                break;
                            }
                            case 4: 
                            case 5: {
                                objectArray = objectArray;
                                objectArray[2] = "createDebugProcessStarter";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 3, 6 -> new IllegalStateException(string);
                        };
                    }
                }.start();
            }
            catch (Exception ex) {
                Messages.showErrorDialog((Project)project, (String)GoBundle.message((String)"go.mozilla.rr.failed.to.start.error.message", (Object[])new Object[]{dialog.getTrace(), ex.getMessage()}), (String)CommonBundle.getErrorTitle());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/actions/debugger/GoReplayTraceAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/actions/debugger/GoReplayTraceAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class TraceDirDialog
    extends DialogWrapper {
        private final Project myProject;
        private final TextFieldWithHistoryWithBrowseButton myTrace;

        protected TraceDirDialog(@NotNull Project project) {
            if (project == null) {
                TraceDirDialog.$$$reportNull$$$0(0);
            }
            super(project, false);
            this.myProject = project;
            this.myTrace = this.createPathField(RecentsManager.getInstance((Project)project).getRecentEntries(GoReplayTraceAction.RECENT_TRACE_KEY));
            this.init();
        }

        @NotNull
        public String getTrace() {
            String string = this.myTrace.getText();
            if (string == null) {
                TraceDirDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myTrace;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel result = new JPanel(new BorderLayout());
            result.setPreferredSize((Dimension)JBUI.size((int)500, (int)0));
            result.add((Component)FormBuilder.createFormBuilder().addLabeledComponent(GoBundle.message((String)"go.mozilla.rr.dialog.trace.directory.label", (Object[])new Object[0]), (JComponent)this.myTrace).getPanel(), "North");
            return result;
        }

        @NotNull
        protected List<ValidationInfo> doValidateAll() {
            if (StringUtil.isEmptyOrSpaces((String)this.getTrace())) {
                List<ValidationInfo> list = Collections.singletonList(new ValidationInfo(GoBundle.message((String)"go.mozilla.rr.dialog.specify.trace.directory.validation.message", (Object[])new Object[0]), (JComponent)this.myTrace));
                if (list == null) {
                    TraceDirDialog.$$$reportNull$$$0(2);
                }
                return list;
            }
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TraceDirDialog.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        private TextFieldWithHistoryWithBrowseButton createPathField(@Nullable List<String> history) {
            TextFieldWithHistoryWithBrowseButton result = new TextFieldWithHistoryWithBrowseButton();
            GoRunUtil.installDirectoryChooser(this.myProject, result);
            if (history != null) {
                ((TextFieldWithHistory)result.getChildComponent()).setHistory(history);
            }
            result.setText((String)ContainerUtil.getFirstItem(history, (Object)TraceDirDialog.getLatestTracePath()));
            TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = result;
            if (textFieldWithHistoryWithBrowseButton == null) {
                TraceDirDialog.$$$reportNull$$$0(4);
            }
            return textFieldWithHistoryWithBrowseButton;
        }

        @NonNls
        @NotNull
        private static String getLatestTracePath() {
            Object traceDir = EnvironmentUtil.getValue((String)"_RR_TRACE_DIR");
            if (StringUtil.isEmptyOrSpaces((String)traceDir)) {
                traceDir = StringUtil.trimTrailing((String)SystemProperties.getUserHome(), (char)'/') + "/.local/share/rr";
            }
            String string = StringUtil.trimTrailing((String)traceDir, (char)'/') + "/latest-trace";
            if (string == null) {
                TraceDirDialog.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        protected String getHelpId() {
            return "Debugging_with_Mozilla_rr";
        }

        @Nullable
        protected String getDimensionServiceKey() {
            return TraceDirDialog.class.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/actions/debugger/GoReplayTraceAction$TraceDirDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/actions/debugger/GoReplayTraceAction$TraceDirDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTrace";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidateAll";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPathField";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLatestTracePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class GoReplayTraceState
    extends GoRunningState<GoRunConfigurationBase<?>> {
        private final String myTrace;
        private final InetSocketAddress myDebugAddress;

        public GoReplayTraceState(@NotNull InetSocketAddress debugAddress, @NotNull ExecutionEnvironment env, @NotNull GoRunConfigurationBase<?> configuration, @NotNull String trace) {
            if (debugAddress == null) {
                GoReplayTraceState.$$$reportNull$$$0(0);
            }
            if (env == null) {
                GoReplayTraceState.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                GoReplayTraceState.$$$reportNull$$$0(2);
            }
            if (trace == null) {
                GoReplayTraceState.$$$reportNull$$$0(3);
            }
            super(env, ((GoModuleBasedConfiguration)configuration.getConfigurationModule()).getModule(), configuration);
            this.myDebugAddress = debugAddress;
            this.myTrace = trace;
        }

        @Override
        @NotNull
        public InetSocketAddress getDebugServerAddress() {
            InetSocketAddress inetSocketAddress = this.myDebugAddress;
            if (inetSocketAddress == null) {
                GoReplayTraceState.$$$reportNull$$$0(4);
            }
            return inetSocketAddress;
        }

        @Override
        protected GoExecutor createRunExecutor() throws ExecutionException {
            return this.createDelveExecutor().withParameters("--backend=rr", "replay", this.myTrace, "--");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugAddress";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trace";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/actions/debugger/GoReplayTraceAction$GoReplayTraceState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/actions/debugger/GoReplayTraceAction$GoReplayTraceState";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugServerAddress";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

