/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.jsx;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeValueImpl;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.types.JSXmlAttributeElementType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u00020\u000e2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH$J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH$J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/intellij/idea/lang/javascript/intention/jsx/JSXChangeAttributeValueIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "<init>", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "isAcceptableAttributeValueElement", "getNewAttributeValue", "", "oldAttribute", "isAttributeValuePlace", "getAttributeValueElement", "updateAttributeValue", "findAttributeValueInStatement", "Lcom/intellij/lang/ASTNode;", "statementNode", "intellij.javascript.intentions"})
@SourceDebugExtension(value={"SMAP\nJSXChangeAttributeValueIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSXChangeAttributeValueIntention.kt\norg/intellij/idea/lang/javascript/intention/jsx/JSXChangeAttributeValueIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public abstract class JSXChangeAttributeValueIntention
extends JavaScriptIntention
implements HighPriorityAction {
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.getAttributeValueElement(element);
        if (psiElement == null) {
            return;
        }
        PsiElement attributeValue = psiElement;
        this.updateAttributeValue(attributeValue);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return super.isAvailable(project, editor, element) && this.isAttributeValuePlace(element);
    }

    protected abstract boolean isAcceptableAttributeValueElement(@Nullable PsiElement var1);

    @NotNull
    protected abstract String getNewAttributeValue(@NotNull PsiElement var1);

    private final boolean isAttributeValuePlace(PsiElement element) {
        return this.isAcceptableAttributeValueElement(this.getAttributeValueElement(element));
    }

    private final PsiElement getAttributeValueElement(PsiElement element) {
        if (!(element.getContainingFile() instanceof JSFile) || !DialectDetector.isJSX((PsiElement)element)) {
            return null;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, JSXmlAttributeValueImpl.class);
    }

    private final void updateAttributeValue(PsiElement oldAttribute) {
        String value = this.getNewAttributeValue(oldAttribute);
        ASTNode aSTNode = JSChangeUtil.createStatementFromTextWithContext((String)("<div attr=" + value + " />"), (PsiElement)oldAttribute);
        if (aSTNode == null) {
            return;
        }
        ASTNode statementNode = aSTNode;
        ASTNode aSTNode2 = this.findAttributeValueInStatement(statementNode);
        if (aSTNode2 == null) {
            return;
        }
        ASTNode newAttributeValue = aSTNode2;
        ASTNode oldAttributeNode = oldAttribute.getNode();
        oldAttributeNode.getTreeParent().replaceChild(oldAttributeNode, newAttributeValue);
    }

    private final ASTNode findAttributeValueInStatement(ASTNode statementNode) {
        Object object;
        block2: {
            ASTNode firstChildNode = statementNode.getFirstChildNode();
            ASTNode[] aSTNodeArray = firstChildNode.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
            for (Object object2 : (Object[])aSTNodeArray) {
                ASTNode it = (ASTNode)object2;
                boolean bl = false;
                if (!(it.getElementType() instanceof JSXmlAttributeElementType)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        ASTNode aSTNode = (ASTNode)object;
        if (aSTNode == null) {
            return null;
        }
        ASTNode attribute = aSTNode;
        return attribute.findChildByType(XmlElementType.XML_ATTRIBUTE_VALUE);
    }
}

