/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grpc.restClient.execution;

import com.intellij.grpc.restClient.execution.GrpcRequest;
import com.intellij.grpc.restClient.execution.GrpcRequestExecutionSupportKt;
import com.intellij.grpc.restClient.url.GrpcRequestUtilsKt;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.openapi.project.Project;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"assembleRequestInput", "Lcom/intellij/grpc/restClient/execution/GrpcRequest;", "requestPsi", "Lcom/intellij/httpClient/http/request/psi/HttpRequest;", "substitutor", "Lcom/intellij/httpClient/http/request/HttpRequestVariableSubstitutor;", "parseUrl", "Lcom/intellij/util/Url;", "substitutedUrl", "", "parseAuthority", "Lkotlin/Pair;", "", "url", "isSecureHint", "", "intellij.grpc"})
@SourceDebugExtension(value={"SMAP\nGrpcRequestConversionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrpcRequestConversionUtils.kt\ncom/intellij/grpc/restClient/execution/GrpcRequestConversionUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1187#2,2:44\n1261#2,4:46\n1#3:50\n*S KotlinDebug\n*F\n+ 1 GrpcRequestConversionUtils.kt\ncom/intellij/grpc/restClient/execution/GrpcRequestConversionUtilsKt\n*L\n21#1:44,2\n21#1:46,4\n*E\n"})
public final class GrpcRequestConversionUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GrpcRequest assembleRequestInput(@NotNull HttpRequest requestPsi, @NotNull HttpRequestVariableSubstitutor substitutor) {
        void $this$associateTo$iv$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)requestPsi, (String)"requestPsi");
        Intrinsics.checkNotNullParameter((Object)substitutor, (String)"substitutor");
        String substitutedUrl = requestPsi.getHttpUrl(substitutor);
        Url effectiveUrl = GrpcRequestConversionUtilsKt.parseUrl(substitutedUrl);
        Object object = effectiveUrl;
        if (object == null || (object = object.getScheme()) == null) {
            object = "grpc";
        }
        Object scheme = object;
        boolean isSecureHint = GrpcRequestExecutionSupportKt.getSECURE_GRPC_SCHEMES_TRIMMED().contains(scheme);
        Pair<String, Integer> pair = GrpcRequestConversionUtilsKt.parseAuthority(effectiveUrl, isSecureHint);
        String host = (String)pair.component1();
        int port = ((Number)pair.component2()).intValue();
        Object object2 = effectiveUrl;
        if ((object2 != null && (object2 = object2.getPath()) != null ? GrpcRequestUtilsKt.prepareFqn((String)object2) : (string = null)) == null) {
            string = "";
        }
        String methodFqn = string;
        HttpRequestBody httpRequestBody = requestPsi.getRequestBody();
        String string2 = httpRequestBody != null ? httpRequestBody.getText() : null;
        if (string2 == null) {
            string2 = "";
        }
        String requestBodyText = string2;
        String string3 = HttpRequestPsiConverter.fillVariables((String)requestBodyText, (HttpRequestVariableSubstitutor)substitutor, (Project)requestPsi.getProject(), null);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fillVariables(...)");
        String payload = string3;
        List list = requestPsi.getHeaderFieldList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHeaderFieldList(...)");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            HttpHeaderField it = (HttpHeaderField)element$iv$iv;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)it.getName(), (Object)it.getValue(substitutor));
            map.put(pair2.getFirst(), pair2.getSecond());
        }
        Map metadata = destination$iv$iv;
        return new GrpcRequest(substitutedUrl, (String)scheme, host, port, methodFqn, payload, metadata);
    }

    private static final Url parseUrl(String substitutedUrl) {
        if (substitutedUrl == null) {
            return null;
        }
        String fakeSchemePrefix = StringsKt.contains$default((CharSequence)substitutedUrl, (CharSequence)"://", (boolean)false, (int)2, null) ? "" : "grpc://";
        String effectiveUrl = fakeSchemePrefix + substitutedUrl;
        return Urls.parse((String)effectiveUrl, (boolean)false);
    }

    private static final Pair<String, Integer> parseAuthority(Url url, boolean isSecureHint) {
        Object object;
        Object object2;
        List list;
        String string;
        if (url != null && (string = url.getAuthority()) != null && (list = StringsKt.split$default((CharSequence)string, (String[])(object2 = new String[]{":"}), (boolean)false, (int)0, (int)6, null)) != null) {
            Object it = object2 = list;
            boolean bl = false;
            object = it.size() <= 2 ? object2 : null;
        } else {
            object = null;
        }
        String authorityParts = object;
        boolean bl = false;
        int defaultPort = isSecureHint ? 443 : 80;
        String string2 = authorityParts;
        if (string2 == null || (string2 = (String)CollectionsKt.getOrNull(string2, (int)0)) == null) {
            string2 = "localhost";
        }
        String effectiveHost = string2;
        Object object3 = authorityParts;
        int effectivePort = object3 != null && (object3 = (String)CollectionsKt.getOrNull((List)object3, (int)1)) != null && (object3 = StringsKt.toIntOrNull((String)object3)) != null ? (Integer)object3 : defaultPort;
        return TuplesKt.to((Object)effectiveHost, (Object)effectivePort);
    }
}

