/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rml.dfa.impl.ui.Task;
import com.intellij.rml.dfa.impl.ui.ThreadCallback;
import com.intellij.rml.dfa.impl.ui.UICallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class ConsoleUI
implements UICallback {
    private static final int STATE_TASK_FINISHED_OK = 0;
    private static final int STATE_TASK_FINISHED_FAILED = 1;
    private static final int STATE_TASK_RUNNING = 2;
    private int taskState = 0;
    private final ThreadCallback threadCallback = new ThreadCallback(){

        @Override
        public void informProgress(int completed, int total, String message) {
            System.out.println(message + "... " + completed * 100 / total + "% completed");
        }

        @Override
        public void informProgress(String message) {
            System.out.println(message);
        }

        @Override
        public void checkCancelled() {
        }
    };
    private boolean myOnlyWarningsOrErrors;

    public ConsoleUI() {
    }

    public ConsoleUI(boolean onlyWarningsOrErrors) {
        this.myOnlyWarningsOrErrors = onlyWarningsOrErrors;
    }

    @Override
    public void showMessage(String message) {
        if (!this.myOnlyWarningsOrErrors) {
            System.out.println("RML>" + message);
        }
    }

    @Override
    public void showWarningMessage(String message) {
        System.err.println("RML WARNING>" + message);
    }

    @Override
    public void showErrorMessage(String message, boolean isFatal) {
        System.err.println("RML ERROR>" + message);
    }

    @Override
    public void showWarning(String message) {
        System.err.println("RML WARNING>" + message);
    }

    @Override
    public void showWarning(String message, Throwable exception) {
        System.err.println("RML WARNING>" + message);
        exception.printStackTrace();
    }

    @Override
    public void showError(String message, Throwable exception, boolean isFatal) {
        System.err.println("RML ERROR>" + message);
        exception.printStackTrace();
    }

    @Override
    public void showError(String message, boolean isFatal) {
        System.err.println("RML ERROR>" + message);
    }

    @Override
    public void showErrorWithMessage(String message, boolean isFatal) {
        System.err.println("RML ERROR>" + message);
    }

    @Override
    public void showErrorMessageWithHelp(String message, int helpContextNumber, boolean isFatal) {
        System.err.println("RML ERROR>" + message);
    }

    @Override
    public void showErrorWithMessage(String message, Throwable exception, boolean isFatal) {
        System.err.println("RML ERROR>" + message);
        exception.printStackTrace();
    }

    @Override
    public void showException(Throwable e, boolean isFatal) {
        System.err.println("RML EXCEPTION>" + e.getMessage());
        e.printStackTrace();
    }

    @Override
    public boolean askConfirm(String message) {
        System.out.println("RML input>" + message + "[y/n]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            String line = reader.readLine();
            return StringUtil.toLowerCase((String)line).equals("y");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int askConfirmWithCancel(String message) {
        System.out.println("RML input>" + message + "[y/n/c]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            String line = reader.readLine();
            if (StringUtil.toLowerCase((String)line).equals("y")) {
                return 1;
            }
            if (StringUtil.toLowerCase((String)line).equals("n")) {
                return 0;
            }
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public boolean askWarningConfirm(String message) {
        System.out.println("RML WARNING>" + message + "[y/n]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            String line = reader.readLine();
            return StringUtil.toLowerCase((String)line).equals("y");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean askWarningConfirm(String message, String yesButtonCaption, String noButtonCaption) {
        System.out.println("RML WARNING>" + message + "[" + yesButtonCaption + "(y)/" + noButtonCaption + "(n)]");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            String line = reader.readLine();
            return StringUtil.toLowerCase((String)line).equals("y");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String input(String message, String defaultInput) {
        BufferedReader reader;
        System.out.println("RML input>" + message + ": ");
        if (defaultInput.length() != 0) {
            System.out.print(defaultInput + " [y/n]");
            try {
                reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                String line = reader.readLine();
                if (StringUtil.toLowerCase((String)line).equals("y")) {
                    return defaultInput;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
        try {
            reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
            return reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return defaultInput;
        }
    }

    public void runAsyncThread(Task task, boolean isSystem) {
        new Thread(() -> {
            try {
                this.taskState = 2;
                if (!isSystem) {
                    System.out.println(task.getName());
                }
                task.run(this.threadCallback);
                this.taskState = 0;
            }
            catch (Throwable e) {
                this.taskState = 1;
                this.showException(e, true);
            }
        }, "console ui").start();
    }

    public void runAllAsyncThreads(final Task[] tasks, String groupName) {
        if (tasks == null) {
            return;
        }
        System.out.println(groupName);
        new Thread("console ui async"){

            @Override
            public void run() {
                try {
                    ConsoleUI.this.taskState = 2;
                    for (Task task : tasks) {
                        System.out.println(task.getName());
                        task.run(ConsoleUI.this.threadCallback);
                    }
                    ConsoleUI.this.taskState = 0;
                }
                catch (Throwable e) {
                    ConsoleUI.this.taskState = 1;
                    ConsoleUI.this.showException(e, true);
                }
            }
        }.start();
    }
}

