/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.profiler;

import com.intellij.rml.dfa.impl.bdd.BddManager;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.profiler.GlobalProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.tree.IProfileNode;
import com.intellij.rml.dfa.impl.rml.profiler.tree.ProfileData;
import com.intellij.rml.dfa.impl.rml.profiler.tree.ProfileNode;
import com.intellij.rml.dfa.impl.rml.profiler.tree.ProfilerNodeMetadata;
import com.intellij.rml.dfa.utils.MetaInfo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J=\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010JS\u0010\u0011\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J6\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0014\u0010\u000e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0004\u0012\u00020\u00190\u001dH\u0016J!\u0010!\u001a\u00020\u00192\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0006H\u0016J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0)H\u0002J\u0010\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0001H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/rml/dfa/impl/rml/profiler/GlobalProfileManagerImpl;", "Lcom/intellij/rml/dfa/impl/rml/profiler/GlobalProfileManager;", "<init>", "()V", "nodeStack", "Ljava/util/Stack;", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/IProfileNode;", "withTimeProfiling", "T", "name", "", "metadata", "", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfilerNodeMetadata;", "block", "Lkotlin/Function0;", "(Ljava/lang/String;[Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfilerNodeMetadata;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withTimeAndBddOpsProfiling", "bddManager", "Lcom/intellij/rml/dfa/impl/bdd/BddManager;", "additionalInfo", "", "Lcom/intellij/rml/dfa/utils/MetaInfo;", "(Ljava/lang/String;Lcom/intellij/rml/dfa/impl/bdd/BddManager;Lkotlin/jvm/functions/Function0;Ljava/util/List;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withRmlScriptProfiling", "", "scriptName", "rootNode", "Lcom/intellij/rml/dfa/impl/rml/ast/QueryNode;", "Lkotlin/Function1;", "Lcom/intellij/rml/dfa/impl/rml/profiler/RmlProfileManager;", "totalTime", "", "startProfilingSession", "([Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfilerNodeMetadata;)V", "finishProfilingSession", "enterNode", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfileNode;", "id", "", "metaInfo", "", "exitNode", "data", "Lcom/intellij/rml/dfa/impl/rml/profiler/tree/ProfileData;", "addChildProfiler", "profileManager", "intellij.rml.dfa.impl"})
public final class GlobalProfileManagerImpl
implements GlobalProfileManager {
    @NotNull
    private final Stack<IProfileNode> nodeStack = new Stack();
    private long totalTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withTimeProfiling(@NotNull String name, @NotNull ProfilerNodeMetadata[] metadata, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long timeBegin = System.currentTimeMillis();
        this.enterNode(name, ArraysKt.toSet((Object[])metadata));
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            long time = System.currentTimeMillis() - timeBegin;
            this.exitNode(new ProfileData(name, time, null, null, null, null, 60, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withTimeAndBddOpsProfiling(@NotNull String name, @NotNull BddManager bddManager, @NotNull Function0<? extends List<MetaInfo>> additionalInfo, @NotNull List<? extends ProfilerNodeMetadata> metadata, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bddManager, (String)"bddManager");
        Intrinsics.checkNotNullParameter(additionalInfo, (String)"additionalInfo");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long timeBegin = System.currentTimeMillis();
        long opsBegin = bddManager.getOperationsCnt();
        long memBegin = bddManager.getMemoryStat().getAmortizedTotalBytes();
        this.enterNode(name, CollectionsKt.toSet((Iterable)metadata));
        try {
            Object object = block.invoke();
            return (T)object;
        }
        finally {
            long time = System.currentTimeMillis() - timeBegin;
            long ops = bddManager.getOperationsCnt() - opsBegin;
            long mem = bddManager.getMemoryStat().getAmortizedTotalBytes() - memBegin;
            IProfileNode node = this.exitNode(new ProfileData(name, time, ops, mem, null, null, 48, null));
            node.getProfileData().getAdditionalData().addAll((Collection)additionalInfo.invoke());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withRmlScriptProfiling(@NotNull String scriptName, @NotNull BddManager bddManager, @NotNull QueryNode rootNode, @NotNull Function1<? super RmlProfileManager, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        Intrinsics.checkNotNullParameter((Object)bddManager, (String)"bddManager");
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        RmlProfileManager manager = new RmlProfileManager(rootNode);
        long timeBegin = System.currentTimeMillis();
        long opsBegin = bddManager.getOperationsCnt();
        long memBegin = bddManager.getMemoryStat().getAmortizedTotalBytes();
        GlobalProfileManagerImpl.enterNode$default(this, scriptName, null, 2, null);
        try {
            block.invoke((Object)manager);
        }
        finally {
            long timeMiddle = System.currentTimeMillis();
            long ops = bddManager.getOperationsCnt() - opsBegin;
            long mem = bddManager.getMemoryStat().getAmortizedTotalBytes() - memBegin;
            List<IProfileNode> children = manager.buildProfileTree();
            long timeEnd = System.currentTimeMillis();
            IProfileNode node = this.exitNode(new ProfileData(scriptName, timeEnd - timeBegin, ops, mem, null, null, 48, null));
            node.getChildren().addAll((Collection<IProfileNode>)children);
            String overheadTitle = "Profiler overhead";
            ProfileNode overheadNode = new ProfileNode(overheadTitle, null, null, 6, null);
            overheadNode.setProfileData(new ProfileData(overheadTitle, timeEnd - timeMiddle, 0L, 0L, null, null, 48, null));
            node.getChildren().add(overheadNode);
        }
    }

    @Override
    public void startProfilingSession(ProfilerNodeMetadata ... metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.totalTime = System.currentTimeMillis();
        this.enterNode("ROOT", ArraysKt.toSet((Object[])metadata));
    }

    @Override
    @NotNull
    public IProfileNode finishProfilingSession() {
        return this.exitNode(new ProfileData("ROOT", System.currentTimeMillis() - this.totalTime, null, null, null, null, 60, null));
    }

    private final ProfileNode enterNode(Object id, Set<? extends ProfilerNodeMetadata> metaInfo) {
        ProfileNode node = new ProfileNode(id, null, metaInfo, 2, null);
        if (!this.nodeStack.empty()) {
            this.nodeStack.peek().getChildren().add(node);
        }
        this.nodeStack.push(node);
        return node;
    }

    static /* synthetic */ ProfileNode enterNode$default(GlobalProfileManagerImpl globalProfileManagerImpl, Object object, Set set, int n, Object object2) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return globalProfileManagerImpl.enterNode(object, set);
    }

    private final IProfileNode exitNode(ProfileData data) {
        IProfileNode top = this.nodeStack.pop();
        top.setProfileData(data);
        Intrinsics.checkNotNull((Object)top);
        return top;
    }

    @Override
    public void addChildProfiler(@NotNull GlobalProfileManager profileManager2) {
        Intrinsics.checkNotNullParameter((Object)profileManager2, (String)"profileManager");
        IProfileNode node = profileManager2.finishProfilingSession();
        if (!this.nodeStack.empty()) {
            List<IProfileNode> list = this.nodeStack.peek().getChildren();
            IProfileNode iProfileNode = node;
            Intrinsics.checkNotNull((Object)iProfileNode);
            list.addAll((Collection<IProfileNode>)iProfileNode.getChildren());
        }
    }
}

