/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.Expr;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtTransformer;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;

public class StmtAssign
extends Stmt {
    private final String varname;
    private final Expr expr;

    public StmtAssign(String varname, Expr expr, Context context) {
        super(context, new QueryNode[0]);
        this.varname = varname;
        this.expr = expr;
    }

    @Override
    public void accept(StmtVisitor visitor) {
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        return this;
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        cancellation.checkCancelled();
        variablesManager.storeVariable(this.varname, this.expr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable));
    }

    @Override
    public String toLongString() {
        return "StmtAssign{varname='" + this.varname + "', expr=" + this.expr.toLongString() + "}";
    }
}

