/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.relations.dump;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.providers.RMLMutableInstancesProvider;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.RelationSignature;
import com.intellij.rml.dfa.impl.relations.dump.Dump;
import com.intellij.rml.dfa.impl.relations.dump.RelationHandle;
import com.intellij.rml.dfa.impl.repositories.MutableRelationsRepository;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.utils.Cancellation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RelationDump
implements Dump,
Serializable {
    private static final long serialVersionUID = -8370122741507692261L;
    private List<String> relnames;
    private List<RelationHandleImpl> relations;
    private final SymbolTable symTab;
    private final IRelationsManager relationsManager;

    public RelationDump(RMLMutableInstancesProvider provider) {
        this.symTab = provider.getSymbolTable();
        this.relations = new ArrayList<RelationHandleImpl>();
        this.relnames = new ArrayList<String>();
        this.relationsManager = provider.getRelationsManager();
    }

    @Override
    public RelationHandle addRelation(RelationSignature signature) {
        RelationHandleImpl relation = new RelationHandleImpl(signature, this.relations.size());
        this.relations.add(relation);
        this.relnames.add(signature.getName());
        return relation;
    }

    public void unite(RelationDump dump, Cancellation cancellation) {
        if (this.relations.size() == 0) {
            this.relnames = dump.relnames;
            this.relations = new ArrayList<RelationHandleImpl>();
            for (int i = 0; i < dump.relations.size(); ++i) {
                this.relations.add(new RelationHandleImpl(dump.relations.get(i), i));
            }
            return;
        }
        if (this.relations.size() != dump.relations.size()) {
            throw new DfaInternalException(Messages.getString(RelationDump.class.getName() + "-0"));
        }
        for (int i = 0; i < this.relations.size(); ++i) {
            IRelation rel1 = this.relations.get((int)i).relation;
            IRelation rel2 = dump.relations.get((int)i).relation;
            this.relations.get((int)i).relation = rel1.unite(rel2, cancellation);
            rel1.kill();
        }
    }

    public void copyToRepository(MutableRelationsRepository relationsRepository) {
        for (RelationHandleImpl handle : this.relations) {
            relationsRepository.addRelation(handle.getName(), handle.relation);
        }
    }

    public RelationDump incrementalize(RelationDump addDump, RelationDump subDump) {
        for (int i = 0; i < this.relations.size(); ++i) {
            RelationHandleImpl base = this.relations.get(i);
            IRelation baseRelation = base.relation;
            IRelation addRelation = addDump.relations.isEmpty() ? this.relationsManager.makeEmptyRelation(baseRelation.getDomains()) : addDump.relations.get((int)i).relation;
            IRelation subRelation = subDump.relations.isEmpty() ? this.relationsManager.makeEmptyRelation(baseRelation.getDomains()) : subDump.relations.get((int)i).relation;
            IRelation relation = this.relationsManager.makeSubIncrementalRelation(baseRelation, addRelation, subRelation, null);
            this.relations.set(i, new RelationHandleImpl(base.getName(), relation, i));
        }
        return this;
    }

    public IRelation[] getSerializeableRelations() {
        IRelation[] rels = new IRelation[this.relations.size()];
        for (int i = 0; i < rels.length; ++i) {
            rels[i] = this.relations.get((int)i).relation;
        }
        return rels;
    }

    public void serialize(ObjectOutputStream out) throws IOException {
        out.writeObject(this.relnames);
        for (RelationHandleImpl relation : this.relations) {
            out.writeObject(relation.getName());
        }
    }

    public static RelationDump deserialize(ObjectInputStream in, IRelation[] relationsBuffer, int pos, RMLMutableInstancesProvider provider) throws IOException, ClassNotFoundException {
        RelationDump result = new RelationDump(provider);
        result.relnames = (List)in.readObject();
        for (int i = 0; i < result.relnames.size(); ++i) {
            String name = (String)in.readObject();
            List<RelationHandleImpl> list = result.relations;
            RelationDump relationDump = result;
            Objects.requireNonNull(relationDump);
            list.add(relationDump.new RelationHandleImpl(name, relationsBuffer[pos++], i));
        }
        return result;
    }

    private class RelationHandleImpl
    extends RelationHandle {
        IRelation relation;
        DomainType[] types;
        int index;

        RelationHandleImpl(RelationSignature signature, int index) {
            super(signature.getName());
            this.index = index;
            this.types = signature.getTypes();
            this.relation = RelationDump.this.relationsManager.makeEmptyRelation(this.types);
        }

        RelationHandleImpl(RelationHandleImpl handle, int index) {
            super(handle.getName());
            this.index = index;
            this.types = handle.types;
            this.relation = handle.relation;
        }

        RelationHandleImpl(String name, IRelation relation, int index) {
            super(name);
            this.index = index;
            this.relation = relation;
            this.types = relation.getDomainTypes();
        }

        @Override
        public void addTuple(String[] elems) {
            if (elems.length != this.types.length) {
                throw new DfaInternalException(Messages.getString(RelationDump.class.getName() + "-1"));
            }
            int[] attrs = new int[elems.length];
            for (int i = 0; i < attrs.length; ++i) {
                attrs[i] = this.types[i].isIntegerType() ? Integer.parseInt(elems[i]) : RelationDump.this.symTab.getAttributeInt(this.types[i], elems[i]);
            }
            IRelation oldRelation = this.relation;
            this.relation = this.relation.addTuple(attrs);
            oldRelation.kill();
        }
    }
}

