/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransformBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tJ\r\u0010\u0018\u001a\u00020\u0015H \u00a2\u0006\u0002\b\u0019J\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010\r\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\tJ\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\tR\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/ComponentTransientState;", "", "viewBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "dataBounds", "getDataBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "<set-?>", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "offset", "getOffset", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "scale", "getScale", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "transform", "getTransform", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "getViewBounds", "applyDelta", "", "scaleDelta", "offsetDelta", "repaint", "repaint$plot_builder", "reset", "transformView", "translate", "plot-builder"})
public abstract class ComponentTransientState {
    @NotNull
    private final DoubleRectangle viewBounds;
    @NotNull
    private DoubleVector scale;
    @NotNull
    private DoubleVector offset;
    @NotNull
    private SvgTransform transform;

    public ComponentTransientState(@NotNull DoubleRectangle viewBounds) {
        Intrinsics.checkNotNullParameter((Object)viewBounds, (String)"viewBounds");
        this.viewBounds = viewBounds;
        this.scale = new DoubleVector(1.0, 1.0);
        this.offset = DoubleVector.Companion.getZERO();
        this.transform = new SvgTransformBuilder().build();
    }

    @NotNull
    public final DoubleRectangle getViewBounds() {
        return this.viewBounds;
    }

    @NotNull
    public final DoubleVector getScale() {
        return this.scale;
    }

    @NotNull
    public final DoubleVector getOffset() {
        return this.offset;
    }

    @NotNull
    public final SvgTransform getTransform() {
        return this.transform;
    }

    @NotNull
    public abstract DoubleRectangle getDataBounds();

    public final void scale(@NotNull DoubleVector scale) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        this.transformView(scale, this.offset);
    }

    public final void translate(@NotNull DoubleVector offset2) {
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        this.transformView(this.scale, offset2);
    }

    public final void applyDelta(@NotNull DoubleVector scaleDelta, @NotNull DoubleVector offsetDelta) {
        Intrinsics.checkNotNullParameter((Object)scaleDelta, (String)"scaleDelta");
        Intrinsics.checkNotNullParameter((Object)offsetDelta, (String)"offsetDelta");
        DoubleVector offset2 = new DoubleVector(this.offset.getX() + offsetDelta.getX() / this.scale.getX(), this.offset.getY() + offsetDelta.getY() / this.scale.getY());
        DoubleVector scale = new DoubleVector(this.scale.getX() * scaleDelta.getX(), this.scale.getY() * scaleDelta.getY());
        this.transformView(scale, offset2);
    }

    public final void reset() {
        this.transformView(new DoubleVector(1.0, 1.0), DoubleVector.Companion.getZERO());
    }

    public void transformView(@NotNull DoubleVector scale, @NotNull DoubleVector offset2) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        this.scale = scale;
        this.offset = offset2;
        this.transform = new SvgTransformBuilder().scale(scale.getX(), scale.getY()).translate(offset2).build();
        this.repaint$plot_builder();
    }

    public abstract void repaint$plot_builder();
}

