/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/PointDimensionsUtil;", "", "()V", "dimensionSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "sizeAes", "resolution", "plot-base"})
public final class PointDimensionsUtil {
    @NotNull
    public static final PointDimensionsUtil INSTANCE = new PointDimensionsUtil();

    private PointDimensionsUtil() {
    }

    @Nullable
    public final DoubleSpan dimensionSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, @NotNull Aes<Double> sizeAes2, double resolution) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        Intrinsics.checkNotNullParameter(sizeAes2, (String)"sizeAes");
        Double loc = p.get(coordAes);
        Double size2 = p.get(sizeAes2);
        if (SeriesUtil.INSTANCE.allFinite(loc, size2)) {
            Intrinsics.checkNotNull((Object)loc);
            Double d = size2;
            Intrinsics.checkNotNull((Object)d);
            double expand = resolution * d / (double)2;
            doubleSpan = new DoubleSpan(loc - expand, loc + expand);
        } else {
            doubleSpan = null;
        }
        return doubleSpan;
    }
}

